/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.tasks.ModeledPropertyInterface;
import com.sas.tools.webappconfig.util.Logger;
import java.util.HashMap;
import org.apache.tools.ant.Task;

public class ModeledPropertyFactory {
    private static HashMap classNames = new HashMap();

    public static ModeledPropertyInterface getInstance(String className) {
        return ModeledPropertyFactory.getInstance(className, null);
    }

    public static ModeledPropertyInterface getInstance(String className, Task task) {
        ModeledPropertyInterface s = (ModeledPropertyInterface)classNames.get(className);
        if (s == null) {
            Class<?> myClass;
            try {
                myClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                Logger.log(0, task, "ModeledClass " + className + " could not be found.");
                return null;
            }
            try {
                Object o = myClass.newInstance();
                if (o instanceof ModeledPropertyInterface) {
                    s = (ModeledPropertyInterface)myClass.newInstance();
                    classNames.put(className, s);
                }
            }
            catch (InstantiationException e) {
                Logger.log(0, task, "ModeledClass " + className + " could not be instantiated.");
                return null;
            }
            catch (IllegalAccessException e) {
                Logger.log(0, task, "ModeledClass " + className + " could not be found.");
                return null;
            }
        }
        return s;
    }

    public void destroy() {
        classNames.clear();
        classNames = null;
    }
}

