/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.IServer;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Tree;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import com.sas.util.Strings;
import com.sas.workspace.Repository;
import com.sas.workspace.mgmt.RepositoryUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.omg.CORBA.StringHolder;

public class MetadatasrvMigrate
extends TaskImpl {
    private static File adminUsersFile = null;
    private static File rposLocFile = null;
    private static File rposMgrFile = null;
    private static MdFactory mdFactory;
    private static String adminUsersPath;
    private static String processLogPath;
    private static String rposMgrPath;
    private static String rposLocPath;
    private static String sasInstallPath;
    private static String sourceMachineType;
    private static String sourceSasVersion;
    private static String targetMachineType;
    private static String targetOsType;
    private static String targetSasVersion;
    private static String fileEncoding;
    private static String sasEncoding;
    private static Project project;
    private static Repository foundationRepository;
    private static Repository[] repositoryArray;
    private static String administratorGroupId;
    private static String administratorGroupName;
    private static String unrestrictedGroupId;
    private static String unrestrictedGroupName;
    private static String adminUserId;
    private static String demoUserId;
    private static String trustedUserId;
    private static String sasAccountId;
    private static String unrestrictedCharacter;
    private static String m_host;
    private static String m_port;
    private static String m_user;
    private static String m_password;
    private static String m_phase;
    private static final String MIGRATE_PHASE = "Migrate";
    private static IOMI omiConnection;
    private static MdOMRConnection metadataWorkspace;
    private static final String LOCALHOST = "localhost";
    private static final int RETURN_CODE_SUCCESS = 0;
    private static final int RETURN_CODE_WARNING = 1;
    private static final int RETURN_CODE_ERROR = 2;
    private static final int JAVA_PROCESS = 1;
    private static final int SAS_PROCESS = 2;
    private static int returnCode;
    private static String errorMessage;
    private static String exceptionMessage;
    private static boolean sdwDebugMode;

    @Override
    public boolean doWork() throws WebAppConfigException {
        int logLevel = 2;
        String logMessage = null;
        project = this.getProject();
        sdwDebugMode = project.getProperty("wizard.debug.mode").equalsIgnoreCase("true");
        sourceMachineType = project.getProperty("config.migration.os.original.type");
        targetMachineType = project.getProperty("os.localhost.machine.type");
        targetOsType = project.getProperty("os.localhost.type");
        sasInstallPath = project.getProperty("sasinstall.install.dir");
        sourceSasVersion = project.getProperty("config.migration.sas.version");
        targetSasVersion = project.getProperty("sasinstall.version");
        fileEncoding = project.getProperty("file.encoding");
        sasEncoding = project.getProperty("zos.sasinputs.encoding");
        unrestrictedCharacter = project.getProperty("iomsrv.metadatasrv.admin.unrestricted.char");
        if (rposMgrPath == null) {
            rposMgrPath = project.getProperty("metadatasrv.rposmgr.dir");
        }
        if (!(rposMgrFile = new File(rposMgrPath)).exists()) {
            Logger.log(0, this, ErrorHandling.generateRposMgrPathErrorMessage(this));
            project.setProperty("metadatasrv.migrate.completion.status", returnCode != 2 ? "success" : "fail");
            return false;
        }
        if (rposLocPath == null) {
            rposLocPath = project.getProperty("metadatasrv.repository.root.dir");
        }
        if (!(rposLocFile = new File(rposLocPath)).exists()) {
            Logger.log(0, this, ErrorHandling.generateRepositoryLocationErrorMessage(this, rposLocPath));
            project.setProperty("metadatasrv.migrate.completion.status", returnCode != 2 ? "success" : "fail");
            return false;
        }
        try {
            mdFactory = new MdFactoryImpl(false);
            mdFactory.setDebug(true);
            mdFactory.setLoggingEnabled(false);
            mdFactory.getUtil().setOutputStream((OutputStream)System.out);
            metadataWorkspace = mdFactory.getConnection();
            logLevel = 3;
            logMessage = ErrorHandling.generateMetadataServerWorkspaceInfoMessage(this);
        }
        catch (Exception e) {
            errorMessage = e.getLocalizedMessage();
            logLevel = 0;
            logMessage = errorMessage != null ? errorMessage : ErrorHandling.generateMetadataServerWorkspaceErrorMessage(this);
            returnCode = 2;
        }
        Logger.log(logLevel, this, logMessage);
        if (m_host == null) {
            m_host = project.getProperty("iomsrv.metadatasrv.host");
        }
        if (m_port == null) {
            m_port = project.getProperty("iomsrv.metadatasrv.port");
        }
        if (m_user == null) {
            m_user = project.getProperty("oma.person.bootstrap.login.userid");
        }
        if (m_password == null) {
            m_password = project.getProperty("oma.person.bootstrap.login.passwd");
        }
        try {
            omiConnection = metadataWorkspace.makeOMRConnection(m_host, m_port, m_user, m_password);
            if (omiConnection != null) {
                Logger.log(3, this, ErrorHandling.generateMetadataServerConnectionInfoMessage(this, m_host, m_port, m_user));
                returnCode = m_phase.equalsIgnoreCase(MIGRATE_PHASE) ? MetadatasrvMigrate.performServerMigration(this) : MetadatasrvMigrate.performServerCleanUp(this);
                switch (returnCode) {
                    case 1: {
                        logLevel = 1;
                        logMessage = errorMessage != null ? errorMessage : ErrorHandling.generateMetadataServerMigrationWarningMessage(this);
                        break;
                    }
                    case 2: {
                        logLevel = 0;
                        logMessage = errorMessage != null ? errorMessage : ErrorHandling.generateMetadataServerMigrationErrorMessage(this);
                        break;
                    }
                    default: {
                        logLevel = 3;
                        logMessage = ErrorHandling.generateMetadataServerMigrationInfoMessage(this);
                        break;
                    }
                }
            } else {
                logLevel = 0;
                logMessage = ErrorHandling.generateIOMServerConnectionErrorMessage(this);
                returnCode = 2;
            }
        }
        catch (Exception e) {
            errorMessage = e.getLocalizedMessage();
            logLevel = 0;
            logMessage = ErrorHandling.generateOMRServerConnectionErrorMessage(this);
            logMessage = logMessage + (errorMessage != null ? ": " + errorMessage : ".");
            returnCode = 2;
        }
        Logger.log(logLevel, this, logMessage);
        try {
            metadataWorkspace.closeOMRConnection();
            mdFactory.dispose();
            logLevel = 3;
            logMessage = ErrorHandling.generateMetadataServerCloseConnectionInfoMessage(this);
        }
        catch (RemoteException re) {
            errorMessage = re.getLocalizedMessage();
            logMessage = errorMessage != null ? errorMessage : ErrorHandling.generateMetadataServerConnectionErrorMessage(this);
        }
        Logger.log(logLevel, this, logMessage);
        project.setProperty("metadatasrv.migrate.completion.status", returnCode != 2 ? "success" : "fail");
        return returnCode != 2;
    }

    public void setHost(String host) {
        m_host = host;
    }

    public void setPort(String port) {
        m_port = port;
    }

    public void setUser(String user) {
        m_user = user;
    }

    public void setPassword(String password) {
        m_password = password;
    }

    public void setPhase(String phase) {
        m_phase = phase;
    }

    public void setRpmgrdir(String rposMgrDir) {
        rposMgrPath = rposMgrDir;
    }

    public void setReposdir(String reposDir) {
        rposLocPath = reposDir;
    }

    private static int performServerMigration(MetadatasrvMigrate task) {
        String priorHost;
        int hostIndex;
        String runasDemoUser;
        boolean modelChange;
        int rc = 0;
        int serverModelVersion = 0;
        int repositoryModelVersion = 0;
        try {
            float floatModelVersion = Float.parseFloat(metadataWorkspace.getServerModelVersion());
            serverModelVersion = (int)floatModelVersion;
            Logger.log(2, task, ErrorHandling.generateMetadataServerVersionInfoMessage(task, serverModelVersion));
            repositoryModelVersion = RepositoryUtil.getRepositoryFormatVersion((MdFactory)mdFactory, (String)"A0000001.A0000001");
            Logger.log(2, task, ErrorHandling.generateRepositoryManagerVersionInfoMessage(task, repositoryModelVersion));
        }
        catch (RemoteException rx) {
            exceptionMessage = rx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            errorMessage = ErrorHandling.generateServerControlRemoteXcptErrorMessage(task) + "  " + exceptionMessage;
            return 2;
        }
        catch (MdException mx) {
            exceptionMessage = mx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            errorMessage = ErrorHandling.generateServerControlMdXcptErrorMessage(task) + "  " + exceptionMessage;
            return 2;
        }
        catch (Exception e) {
            errorMessage = e.getLocalizedMessage();
            if (errorMessage == null) {
                errorMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            errorMessage = ErrorHandling.generateGenericErrorMessage(task) + "  " + exceptionMessage;
            return 2;
        }
        boolean bl = repositoryModelVersion != 0 && serverModelVersion != 0 ? repositoryModelVersion < serverModelVersion : (modelChange = !sourceSasVersion.equalsIgnoreCase(targetSasVersion));
        if (modelChange || !sourceMachineType.equalsIgnoreCase(targetMachineType)) {
            try {
                String replicateMetadataOptions = !sourceMachineType.equalsIgnoreCase(targetMachineType) ? "<FORCEUPGRADE/>" : "<INPLACEUPGRADE/>";
                String replicateRepositoryManagerXML = "<ReplicateMetadata><Metadata><RepositoryBase Name=\"rposmgr\" ID=\"A0000001.A0000001\"><CopyTarget><RepositoryBase Name=\"rposmgr\" Path=\"rposmgr\" Options=\"\"/></CopyTarget></RepositoryBase></Metadata><Ns>REPOS</Ns><Flags>268435456</Flags><Options>" + replicateMetadataOptions + "</Options></ReplicateMetadata>";
                mdFactory.getOMIUtil().DoRequest(replicateRepositoryManagerXML, false);
                Logger.log(3, task, ErrorHandling.generateRepositoryManagerMigrationInfoMessage(task));
            }
            catch (RemoteException rx) {
                exceptionMessage = rx.getLocalizedMessage();
                if (exceptionMessage == null) {
                    exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
                }
                errorMessage = ErrorHandling.generateRposMgrMigrationRemoteXcptErrorMessage(task) + "  " + exceptionMessage;
                return 2;
            }
            catch (MdException mx) {
                exceptionMessage = mx.getLocalizedMessage();
                if (exceptionMessage == null) {
                    exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
                }
                errorMessage = ErrorHandling.generateRposMgrMigrationMdXcptErrorMessage(task) + "  " + exceptionMessage;
                return 2;
            }
        }
        repositoryArray = null;
        try {
            repositoryArray = Repository.getRepositories((MdFactory)mdFactory);
            if (repositoryArray != null) {
                for (int i = 0; i < repositoryArray.length; ++i) {
                    Repository repository = repositoryArray[i];
                    String repositoryType = repository.getType();
                    if (!repositoryType.equalsIgnoreCase("FOUNDATION")) continue;
                    foundationRepository = repository;
                }
            }
        }
        catch (Exception e) {
            errorMessage = e.getLocalizedMessage();
            if (errorMessage == null) {
                errorMessage = ErrorHandling.generateGetRepositoriesErrorMessage(task);
            }
            return 2;
        }
        String adhocBackupName = project.getProperty("metadatasrv.migrated.adhoc.backup.name");
        if (repositoryArray != null && adhocBackupName == null) {
            int repcount = repositoryArray.length;
            String rposRelPath = project.getProperty("iomsrv.metadatasrv.repository.dir");
            Logger.log(2, task, ErrorHandling.generateRepositoryLocationInfoMessage(task, rposLocPath));
            for (int i = 0; i < repcount; ++i) {
                Repository repository = repositoryArray[i];
                String repositoryType = repository.getType();
                StringHolder outXML = new StringHolder();
                String repositoryName = repository.getName();
                String repositoryDirectory = MetadatasrvMigrate.detoxifyDirectory(task, repositoryName);
                StringBuffer migratePathTagBuffer = new StringBuffer("<RepositoryBase ");
                migratePathTagBuffer.append(" ID=\"" + repository.getFQID() + "\" Path=\"" + rposRelPath + File.separator + repositoryDirectory + "\"/>");
                String migratePathTag = migratePathTagBuffer.toString();
                try {
                    omiConnection.UpdateMetadata(migratePathTag, outXML, "REPOS", 0x10000000, "");
                    Logger.log(2, task, ErrorHandling.generateRepositoryPathMigrationInfoMessage(task, repositoryName, rposRelPath + File.separator + repositoryDirectory));
                    continue;
                }
                catch (Exception ex1) {
                    errorMessage = ErrorHandling.generateRepositoryPathErrorMessage(task, repository.getName(), rposRelPath + File.separator + repository.getName());
                    Logger.log(0, task, errorMessage);
                    if (repositoryType.equalsIgnoreCase("FOUNDATION")) {
                        return 2;
                    }
                    String deleteCommand = "<RepositoryBase ID=\"" + repository.getFQID() + "\"/>";
                    try {
                        omiConnection.DeleteMetadata(deleteCommand, outXML, "REPOS", 0x10000000, "");
                        Logger.log(3, task, ErrorHandling.generateRepositoryDeleteInformMessage(task, repository.getName()));
                        continue;
                    }
                    catch (Exception ex2) {
                        errorMessage = ex2.getLocalizedMessage();
                        if (errorMessage == null) {
                            errorMessage = ErrorHandling.generateRepositoryDeleteErrorMessage(task, repository.getName());
                        }
                        Logger.log(0, task, errorMessage);
                    }
                }
            }
            Logger.log(3, task, ErrorHandling.generateRepositoryPathsUpdatedInfoMessage(task));
        }
        try {
            IServer iserverConnection = metadataWorkspace.MakeIServerConnection();
            iserverConnection.Refresh("<RPOSMGR ACCESS=\"ONLINE\"/>");
            Logger.log(3, task, ErrorHandling.generateRepositoryManagerOnlineInfoMessage(task));
        }
        catch (RemoteException rx) {
            exceptionMessage = rx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            errorMessage = ErrorHandling.generateServerControlRemoteXcptErrorMessage(task) + "  " + exceptionMessage;
            return 2;
        }
        catch (MdException mx) {
            exceptionMessage = mx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            errorMessage = ErrorHandling.generateServerControlMdXcptErrorMessage(task) + "  " + exceptionMessage;
            return 2;
        }
        catch (GenericError ge) {
            exceptionMessage = ge.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            errorMessage = ErrorHandling.generateGenericErrorMessage(task) + "  " + exceptionMessage;
            return 2;
        }
        if (rc != 2) {
            rc = task.upgradeMetadata();
        }
        if (sourceSasVersion.startsWith("9.1.3") && rc != 2) {
            rc = MetadatasrvMigrate.reinitializeProjectRepositories(task);
        }
        if (rc != 2) {
            rc = MetadatasrvMigrate.migrateMetadataServerDefinition(task);
        }
        if (sourceSasVersion.startsWith("9.1.3") && rc != 2) {
            rc = MetadatasrvMigrate.assignAdminUsersMembership(task);
        }
        if (rc != 2) {
            String adminUsersFileName = project.getProperty("iomsrv.metadatasrv.adminusers.file.name");
            rc = MetadatasrvMigrate.upgradeAdminAndTrustedUsersFiles(task, adminUsersFileName);
        }
        if (rc != 2) {
            String trustedUsersFileName = project.getProperty("iomsrv.metadatasrv.trustedusers.file.name");
            rc = MetadatasrvMigrate.upgradeAdminAndTrustedUsersFiles(task, trustedUsersFileName);
        }
        if (rc != 2) {
            rc = MetadatasrvMigrate.upgradeUser(task, "admin");
            adminUserId = sasAccountId;
            sasAccountId = "";
        }
        if (rc != 2) {
            rc = MetadatasrvMigrate.upgradeUser(task, "trustusr");
            trustedUserId = sasAccountId;
            sasAccountId = "";
        }
        if (rc != 2 && (runasDemoUser = project.getProperty("server.runas_demouser")) != null && runasDemoUser.equalsIgnoreCase("true")) {
            rc = MetadatasrvMigrate.upgradeUser(task, "demo");
            demoUserId = sasAccountId;
            sasAccountId = "";
        }
        String priorHostName = (hostIndex = (priorHost = project.getProperty("metadatasrv.migrated.object.configobj.prior.host")).indexOf(".")) > 0 ? priorHost.substring(0, hostIndex) : priorHost;
        project.setProperty("metadatasrv.prior.host.name", priorHostName);
        return rc;
    }

    private static int performServerCleanUp(MetadatasrvMigrate task) {
        int rc = 0;
        String runasDemoUser = project.getProperty("server.runas_demouser");
        rc = MetadatasrvMigrate.summarizeSasUserAccountLogins(task, "admin");
        if (runasDemoUser == null || runasDemoUser.equalsIgnoreCase("false")) {
            project.setProperty("metadatasrv.instructions.details.demo.name", "");
            project.setProperty("metadatasrv.instructions.details.demo.sdwlogin", "");
            project.setProperty("metadatasrv.instructions.details.demo.loginlist", "");
        } else {
            rc = MetadatasrvMigrate.summarizeSasUserAccountLogins(task, "demo");
        }
        rc = MetadatasrvMigrate.summarizeSasUserAccountLogins(task, "trustusr");
        rc = MetadatasrvMigrate.cleanupBackupRestoreJobs(task);
        int methRc = MetadatasrvMigrate.cleanupMetadataServerDefinitions(task);
        if (methRc > rc) {
            rc = methRc;
        }
        return rc;
    }

    private int upgradeMetadata() {
        String portCommand;
        int rc;
        processLogPath = project.getProperty("config.lev.logs.configure.dir");
        String commandPath = project.getProperty("platfmltypes.install.dir") + File.separator + "tools" + File.separator + "admin" + File.separator;
        String scriptSuffix = targetOsType.equalsIgnoreCase("mvs") || targetOsType.equalsIgnoreCase("zos") ? ".rexx" : "";
        String standardOptions = " -log \"" + project.getProperty("config.lev.logs.configure.dir") + "\" -user " + project.getProperty("oma.person.bootstrap.login.userid") + " -password " + project.getProperty("oma.person.bootstrap.login.passwd") + " -host localhost -port " + project.getProperty("iomsrv.metadatasrv.port");
        String sourceMachineType2 = sourceMachineType;
        String targetMachineType2 = targetMachineType;
        if (!sourceSasVersion.startsWith("9.1") && !sourceSasVersion.startsWith("9.2")) {
            if (sourceMachineType.equalsIgnoreCase("win")) {
                sourceMachineType2 = "wx6";
            }
            if (targetMachineType.equalsIgnoreCase("win")) {
                targetMachineType2 = "wx6";
            }
        }
        if (!sourceMachineType2.equalsIgnoreCase(targetMachineType2) && (rc = this.executeRuntimeProcessString(portCommand = commandPath + "sas-port-metadata" + scriptSuffix + standardOptions, 1)) >= 2) {
            return rc;
        }
        String upgradeCommand = commandPath + "sas-upgrade-metadata" + scriptSuffix + standardOptions;
        return this.executeRuntimeProcessString(upgradeCommand, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int executeRuntimeProcessString(String sasCommand, int processType) {
        int n;
        String logMessage;
        int rc = 0;
        BufferedInputStream bis = null;
        BufferedInputStream bes = null;
        BufferedReader bir = null;
        BufferedReader ber = null;
        InputStreamReader bisr = null;
        InputStreamReader besr = null;
        String objectName = "";
        String commandLine = sasCommand;
        this.log(ErrorHandling.generateExecutingRuntimeProcessInfoMessage(this, commandLine), 2);
        try {
            int inchar;
            StringBuffer outbuffer;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(sasCommand);
            bis = new BufferedInputStream(process.getInputStream());
            bisr = targetOsType.equalsIgnoreCase("mvs") || targetOsType.equalsIgnoreCase("zos") ? new InputStreamReader((InputStream)bis, "IBM-1047") : new InputStreamReader(bis);
            bir = new BufferedReader(bisr);
            bes = new BufferedInputStream(process.getErrorStream());
            besr = targetOsType.equalsIgnoreCase("mvs") || targetOsType.equalsIgnoreCase("zos") ? new InputStreamReader((InputStream)bes, "IBM-1047") : new InputStreamReader(bes);
            ber = new BufferedReader(besr);
            if (processType == 1) {
                objectName = bir.toString();
                String standardOutputRecord = bir.readLine();
                while (standardOutputRecord != null) {
                    this.log("[UpgradeMetadataServer] " + standardOutputRecord + System.getProperty("line.separator"), 2);
                    standardOutputRecord = bir.readLine();
                }
            }
            int processCode = process.waitFor();
            switch (processType) {
                case 1: {
                    rc = MetadatasrvMigrate.javaPostProcess(this, processCode);
                    if (rc != 2) break;
                    int n2 = 2;
                    return n2;
                }
                case 2: {
                    rc = MetadatasrvMigrate.sasPostProcess(this, processCode, commandLine);
                    if (rc != 2) break;
                    int n3 = 2;
                    return n3;
                }
                default: {
                    int n4 = 2;
                    return n4;
                }
            }
            if (bis.available() > 0) {
                outbuffer = new StringBuffer();
                objectName = bir.toString();
                inchar = bir.read();
                while (inchar != -1) {
                    outbuffer.append((char)inchar);
                    inchar = bir.read();
                }
                this.log(outbuffer.toString(), 2);
            }
            if (bes.available() <= 0) return rc;
            outbuffer = new StringBuffer();
            objectName = ber.toString();
            inchar = ber.read();
            while (inchar != -1) {
                outbuffer.append((char)inchar);
                inchar = ber.read();
            }
            int msgLevel = targetOsType.equalsIgnoreCase("mvs") || targetOsType.equalsIgnoreCase("zos") ? 1 : 0;
            this.log(outbuffer.toString(), msgLevel);
            return rc;
        }
        catch (IOException iox) {
            logMessage = iox.getLocalizedMessage();
            if (logMessage == null) {
                logMessage = ErrorHandling.generateIOExceptionErrorMessage(this, objectName);
            }
            this.log(logMessage, 0);
            n = 2;
            return n;
        }
        catch (InterruptedException ntx) {
            logMessage = ntx.getLocalizedMessage();
            if (logMessage == null) {
                logMessage = ErrorHandling.generateRuntimeProcessInterruptXcptErrorMessage(this);
            }
            this.log(logMessage, 0);
            n = 2;
            return n;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception e) {
                logMessage = e.getLocalizedMessage();
                if (logMessage == null) {
                    logMessage = ErrorHandling.generateRuntimeProcessLogExceptionMessage(this);
                }
                this.log(logMessage, 0);
                n = 2;
                return n;
            }
        }
        finally {
            if (ber != null) {
                try {
                    ber.close();
                }
                catch (IOException iOException) {}
            }
            if (bir != null) {
                try {
                    bir.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static int javaPostProcess(MetadatasrvMigrate task, int returnCodeValue) {
        int rc = 0;
        File processLogFile = new File(processLogPath);
        if (processLogFile.exists() && processLogFile.isDirectory()) {
            File[] logFiles = processLogFile.listFiles();
            for (int i = 0; i < logFiles.length; ++i) {
                String fileName = logFiles[i].getName().toLowerCase();
                if (!fileName.startsWith("upgrademetadata")) continue;
                processLogPath = logFiles[i].getAbsolutePath();
                break;
            }
        }
        switch (returnCodeValue) {
            case 0: {
                task.log(ErrorHandling.generateUpgradeRepositoriesCompleteMessage(task), 2);
                rc = 0;
                break;
            }
            case 4: {
                task.log(ErrorHandling.generateUpgradeRepositoriesWarningMessage(task, processLogPath), 1);
                rc = 1;
                break;
            }
            case 8: {
                task.log(ErrorHandling.generateUpgradeRepositoriesErrorMessage(task, returnCodeValue, processLogPath), 0);
                rc = 1;
                break;
            }
            default: {
                errorMessage = ErrorHandling.generateUpgradeRepositoriesFatalMessage(task, returnCodeValue, processLogPath);
                task.log(errorMessage, 0);
                rc = 2;
            }
        }
        return rc;
    }

    private static int sasPostProcess(MetadatasrvMigrate task, int returnCodeValue, String command) {
        if (returnCodeValue != 0) {
            task.log(ErrorHandling.generateRuntimeProcessExecutionErrorMessage(task, command), 0);
            return 2;
        }
        try {
            File processLogFile = new File(processLogPath);
            FileReader processLogReader = new FileReader(processLogFile);
            StringBuffer buffer = new StringBuffer();
            int inchar = processLogReader.read();
            while (inchar != -1) {
                buffer.append((char)inchar);
                if ((char)inchar == '\n') {
                    task.log(buffer.toString(), 4);
                    buffer.setLength(0);
                }
                inchar = processLogReader.read();
            }
        }
        catch (IOException iox) {
            String logMessage = iox.getLocalizedMessage();
            if (logMessage == null) {
                logMessage = ErrorHandling.generateIOExceptionErrorMessage(task, processLogPath);
            }
            task.log(logMessage, 0);
            return 2;
        }
        return 0;
    }

    private static int reinitializeProjectRepositories(MetadatasrvMigrate task) {
        int rc = 0;
        repositoryArray = null;
        try {
            repositoryArray = Repository.getRepositories((MdFactory)mdFactory);
        }
        catch (Exception e) {
            errorMessage = e.getLocalizedMessage();
            if (errorMessage == null) {
                errorMessage = ErrorHandling.generateGetRepositoriesErrorMessage(task);
            }
            return 2;
        }
        if (repositoryArray != null) {
            for (Repository repository : repositoryArray) {
                if (!repository.getType().equalsIgnoreCase("PROJECT")) continue;
                boolean invalidOwner = false;
                boolean nonexistentOwner = false;
                Identity ownerIdentity = null;
                List extensionList = null;
                String logMessage = null;
                StringBuffer inXMLBuffer = new StringBuffer("<UndoCheckoutLogical>");
                inXMLBuffer.append("  <Metadata/>");
                inXMLBuffer.append("  <ProjectReposId>" + repository.getFQID() + "</ProjectReposId>");
                inXMLBuffer.append("  <Ns>SAS</Ns>");
                inXMLBuffer.append("  <Flags>1</Flags>");
                inXMLBuffer.append("  <Options/>");
                inXMLBuffer.append("</UndoCheckoutLogical>");
                boolean changeManaged = repository.getIsChangeManaged();
                int accessMode = repository.getExtendedAccess();
                String repositoryId = repository.getFQID();
                String repositoryName = repository.getName();
                try {
                    extensionList = RepositoryUtil.findProjectRepositoryExtensions((MdFactory)mdFactory, (String)repositoryId);
                    if (extensionList != null && extensionList.size() > 0) {
                        ownerIdentity = RepositoryUtil.determineProjectOwner((MdFactory)mdFactory, (String)repositoryId, (List)extensionList);
                        invalidOwner = ownerIdentity instanceof IdentityGroup;
                        logMessage = invalidOwner ? ErrorHandling.generateProjectRepositoryGroup(task, repositoryName, ownerIdentity.getName()) : ErrorHandling.generateProjectRepositoryOwner(task, repositoryName, ownerIdentity.getName());
                        task.log(logMessage, 2);
                    } else {
                        task.log(ErrorHandling.generateProjectRepositoryNoOwner(task, repositoryName), 2);
                        nonexistentOwner = true;
                    }
                }
                catch (Exception ex) {
                    logMessage = ex.getLocalizedMessage();
                    if (logMessage == null) {
                        logMessage = ErrorHandling.generateProjectRepositoryOwnerXcpt(task, repositoryName);
                    }
                    task.log(logMessage, 0);
                    rc = 2;
                }
                try {
                    if (!nonexistentOwner && !invalidOwner) {
                        task.log(ErrorHandling.generateProjectRepositoryUnlock(task, repositoryName), 2);
                        mdFactory.getOMIUtil().DoRequest(inXMLBuffer.toString());
                    }
                }
                catch (MdException mx) {
                    exceptionMessage = mx.getLocalizedMessage();
                    if (exceptionMessage == null) {
                        exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
                    }
                    logMessage = ErrorHandling.generateProjectRepositoryUnlockMdXcpt(task, repositoryName) + "  " + exceptionMessage;
                    task.log(logMessage, 0);
                    rc = 2;
                }
                catch (RemoteException rx) {
                    exceptionMessage = rx.getLocalizedMessage();
                    if (exceptionMessage == null) {
                        exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
                    }
                    logMessage = ErrorHandling.generateProjectRepositoryUnlockRmXcpt(task, repositoryName) + "  " + exceptionMessage;
                    task.log(logMessage, 0);
                    rc = 2;
                }
                try {
                    if (nonexistentOwner || invalidOwner) {
                        task.log(ErrorHandling.generateProjectRepositoryDelete(task, repositoryName), 2);
                        repository.deleteRepository(repositoryName, repositoryId, 32);
                    } else {
                        task.log(ErrorHandling.generateProjectRepositoryReinit(task, repositoryName), 2);
                        repository.deleteRepository(repositoryName, repositoryId, 0x200000);
                    }
                }
                catch (Exception ex) {
                    logMessage = ex.getLocalizedMessage();
                    if (logMessage == null) {
                        logMessage = nonexistentOwner || invalidOwner ? ErrorHandling.generateProjectRepositoryDeleteExcept(task, repositoryName) : ErrorHandling.generateProjectRepositoryReinitExcept(task, repositoryName);
                    }
                    task.log(logMessage, 0);
                    rc = 2;
                }
                if (nonexistentOwner || invalidOwner) continue;
                try {
                    task.log(ErrorHandling.generateProjectRepositoryUpgrade(task, repositoryName), 2);
                    boolean createdACTS = RepositoryUtil.createRepositoryACTs((MdFactory)mdFactory, (Repository)repository);
                    RepositoryUtil.applyAdminACT((MdFactory)mdFactory, (Repository)repository);
                    String upgradeRelease = RepositoryUtil.getUpgradeReleaseBasedonServerVersion((MdFactory)mdFactory, (String)repositoryId);
                    String upgradeFixPack = RepositoryUtil.getUpgradeFixpackBasedonServerVersion((MdFactory)mdFactory, (String)repositoryId);
                    RepositoryUtil.createUpdateRecord((MdFactory)mdFactory, (Repository)repository, (String)upgradeRelease, (String)upgradeFixPack);
                    RepositoryUtil.removeConnectedIdentityFromRepositoryACT((MdFactory)mdFactory, (String)repositoryId);
                    RepositoryUtil.associateIdentityToProjectRepos((MdFactory)mdFactory, (String)repositoryId, (Identity)ownerIdentity);
                    if (extensionList != null && extensionList.size() > 0) {
                        RepositoryUtil.deleteProjectRepositoryExtensions((MdFactory)mdFactory, (List)extensionList);
                    }
                }
                catch (Exception ex) {
                    exceptionMessage = ex.getLocalizedMessage();
                    if (exceptionMessage == null) {
                        exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
                    }
                    logMessage = ErrorHandling.generateProjectRepositoryUpgradeXcpt(task, repositoryName) + "  " + exceptionMessage;
                    rc = 2;
                    task.log(logMessage, 0);
                }
                repository.setIsChangeManaged(changeManaged);
                repository.setExtendedAccess(accessMode);
            }
        }
        return rc;
    }

    private static int migrateMetadataServerDefinition(MetadatasrvMigrate task) {
        String targetServerContext;
        int rc = 0;
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<String> valueList = new ArrayList<String>();
        List logicalList = null;
        List serverList = null;
        String sourceServerContext = project.getProperty("metadatasrv.migrated.servercontext.name");
        if (!sourceServerContext.equalsIgnoreCase(targetServerContext = project.getProperty("iomsrv.metadatasrv.servercontext.name"))) {
            return rc;
        }
        String metadataServerHost = project.getProperty("iomsrv.metadatasrv.host");
        String metadataServerPort = project.getProperty("iomsrv.metadatasrv.port");
        String previousServerHost = project.getProperty("metadatasrv.migrated.metadata.prior.host");
        if (previousServerHost == null) {
            previousServerHost = project.getProperty("metadatasrv.migrated.object.configobj.prior.host");
        }
        String previousServerPort = project.getProperty("metadatasrv.migrated.object.configobj.prior.iomsrv.metadatasrv.port");
        if (sdwDebugMode) {
            task.log("TRACE:  metadataServerHost = " + metadataServerHost);
            task.log("TRACE:  metadataServerPort = " + metadataServerPort);
            task.log("TRACE:  previousServerHost = " + previousServerHost);
            task.log("TRACE:  previousServerPort = " + previousServerPort);
        }
        String repositoryId = foundationRepository.getFQID();
        String xmlSelect = "<XMLSELECT search=\"ServerComponent[@ClassIdentifier='0217e202-b560-11db-ad91-001083ff6836'][UsedByComponents/LogicalServer/UsedByComponents/ServerContext[@Name='" + project.getProperty("metadatasrv.migrated.servercontext.name") + "']]\"/>";
        String xmlTemplate = "<TEMPLATES><ServerComponent Id=\"\" Major=\"\" Minor=\"\" Name=\"\" SoftwareVersion=\"\"/></TEMPLATES>";
        String xmlOptions = xmlSelect + xmlTemplate;
        serverList = MetadatasrvMigrate.getMetadataAttributes(task, "ServerComponent", repositoryId, xmlOptions);
        for (int i = 0; i < serverList.size(); ++i) {
            boolean migrateServerDefinition = false;
            Map serverComponentMap = (Map)serverList.get(i);
            String serverComponentId = (String)serverComponentMap.get("Id");
            String metadataServerName = (String)serverComponentMap.get("Name");
            xmlSelect = "<XMLSELECT search=\"TCPIPConnection[Source/ServerComponent[@Id='" + serverComponentId + "']]\"/>";
            xmlTemplate = "<TEMPLATES><TCPIPConnection Id=\"\" HostName=\"\" Port=\"\"/></TEMPLATES>";
            xmlOptions = xmlSelect + xmlTemplate;
            List tcpipList = MetadatasrvMigrate.getMetadataAttributes(task, "TCPIPConnection", repositoryId, xmlOptions);
            if (tcpipList.size() == 1) {
                Map tcpipMap = (Map)tcpipList.get(0);
                String tcpipConnectionObjectId = (String)tcpipMap.get("Id");
                String tcpipConnectionHost = (String)tcpipMap.get("HostName");
                String tcpipConnectionPort = (String)tcpipMap.get("Port");
                if (MetadatasrvMigrate.areHostsEqual(tcpipConnectionHost, previousServerHost)) {
                    migrateServerDefinition = true;
                    if (!tcpipConnectionHost.equalsIgnoreCase(metadataServerHost)) {
                        nameList.add("HostName");
                        valueList.add(metadataServerHost);
                    }
                    if (tcpipConnectionPort.equalsIgnoreCase(previousServerPort) && !tcpipConnectionPort.equalsIgnoreCase(metadataServerPort)) {
                        nameList.add("Port");
                        valueList.add(metadataServerPort);
                    }
                    if (nameList.size() > 0) {
                        rc = MetadatasrvMigrate.updateMetadataAttributes(task, "TCPIPConnection", tcpipConnectionObjectId, nameList, valueList);
                        if (rc != 0) {
                            task.log(ErrorHandling.generateServerPortWarning(task, metadataServerPort, metadataServerName), 1);
                            rc = 1;
                        } else {
                            task.log(ErrorHandling.generateAssignedServerPort(task, metadataServerPort, metadataServerName), 2);
                        }
                        valueList.clear();
                        nameList.clear();
                    }
                }
            } else {
                rc = 1;
            }
            if (!migrateServerDefinition) continue;
            xmlSelect = "<XMLSELECT search=\"Machine[DeployedComponents/ServerComponent[@Id='" + serverComponentId + "']]\"/>";
            xmlTemplate = "<TEMPLATES><Machine Id=\"\" Name=\"\"/></TEMPLATES>";
            xmlOptions = xmlSelect + xmlTemplate;
            List machineList = MetadatasrvMigrate.getMetadataAttributes(task, "Machine", repositoryId, xmlOptions);
            if (machineList.size() != 0) {
                Map machineMap = (Map)machineList.get(0);
                String machineId = (String)machineMap.get("Id");
                String machineName = (String)machineMap.get("Name");
                if (!MetadatasrvMigrate.areHostsEqual(machineName, metadataServerHost) || !machineName.equalsIgnoreCase(metadataServerHost)) {
                    task.log(ErrorHandling.generateMigrateServerDefinition(task), 2);
                    rc = MetadatasrvMigrate.updateMachineAssociation(task, serverComponentId, metadataServerName, machineId, machineName);
                    if (rc != 0) {
                        rc = 1;
                    }
                }
            } else {
                String missingMachine = "";
                rc = MetadatasrvMigrate.updateMachineAssociation(task, serverComponentId, metadataServerName, missingMachine, missingMachine);
                if (rc != 0) {
                    rc = 1;
                }
            }
            String sasClientConnectionName = project.getProperty("metadataserver.sasclientconnection.name");
            xmlSelect = "<XMLSELECT search=\"SASClientConnection[@Name='" + sasClientConnectionName + "'][Source/ServerComponent[@Id='" + serverComponentId + "']]\"/>";
            xmlTemplate = "<TEMPLATES><SASClientConnection Id=\"\" Port=\"\" RemoteAddress=\"\"/></TEMPLATES>";
            xmlOptions = xmlSelect + xmlTemplate;
            List sasccList = MetadatasrvMigrate.getMetadataAttributes(task, "SASClientConnection", repositoryId, xmlOptions);
            if (sasccList.size() == 0) {
                StringBuffer addMetadataBuffer = new StringBuffer("<SASClientConnection Name=\"" + sasClientConnectionName + "\" ApplicationProtocol=\"SBIP\" AuthenticationType=\"user/password\" CommunicationProtocol=\"TCP\" RemoteAddress=\"" + metadataServerHost + "\" Port=\"" + metadataServerPort + "\"><Source><ServerComponent ObjRef=\"" + serverComponentId + "\"/></Source></SASClientConnection>");
                String addMetadataXML = addMetadataBuffer.toString();
                rc = MetadatasrvMigrate.addMetadataObject(task, repositoryId, addMetadataXML);
                if (rc != 0) {
                    task.log(ErrorHandling.generateClientConnectionWarning(task, sasClientConnectionName, metadataServerName), 1);
                    rc = 1;
                } else {
                    task.log(ErrorHandling.generateAssignedClientConnection(task, sasClientConnectionName, metadataServerName), 2);
                }
            } else {
                Map sasClientConnectionMap = (Map)sasccList.get(0);
                String sasClientConnectionObjectId = (String)sasClientConnectionMap.get("Id");
                String sasClientConnectionHost = (String)sasClientConnectionMap.get("RemoteAddress");
                String sasClientConnectionPort = (String)sasClientConnectionMap.get("Port");
                if (!sasClientConnectionPort.equalsIgnoreCase(metadataServerPort)) {
                    nameList.add("Port");
                    valueList.add(metadataServerPort);
                }
                if (!sasClientConnectionHost.equalsIgnoreCase(metadataServerHost)) {
                    nameList.add("RemoteAddress");
                    valueList.add(metadataServerHost);
                }
                if (nameList.size() > 0) {
                    rc = MetadatasrvMigrate.updateMetadataAttributes(task, "SASClientConnection", sasClientConnectionObjectId, nameList, valueList);
                    if (rc != 0) {
                        task.log(ErrorHandling.generateConnectionPortWarning(task, metadataServerPort, sasClientConnectionName), 1);
                        rc = 1;
                    } else {
                        task.log(ErrorHandling.generateAssignedConnectionPort(task, metadataServerPort, sasClientConnectionName), 2);
                    }
                    valueList.clear();
                    nameList.clear();
                }
            }
            String targetComponentMajor = project.getProperty("oma.server.major.version");
            String targetComponentMinor = project.getProperty("oma.server.minor.version");
            String targetComponentVersion = project.getProperty("oma.server.softwareversion.version");
            String serverComponentMajor = (String)serverComponentMap.get("Major");
            String serverComponentMinor = (String)serverComponentMap.get("Minor");
            String serverComponentVersion = (String)serverComponentMap.get("SoftwareVersion");
            if (!serverComponentMajor.equalsIgnoreCase(targetComponentMajor)) {
                nameList.add("Major");
                valueList.add(targetComponentMajor);
            }
            if (!serverComponentMinor.equalsIgnoreCase(targetComponentMinor)) {
                nameList.add("Minor");
                valueList.add(targetComponentMinor);
            }
            if (!serverComponentVersion.equalsIgnoreCase(targetComponentVersion)) {
                nameList.add("SoftwareVersion");
                valueList.add(targetComponentVersion);
            }
            if (nameList.size() > 0) {
                String serverComponentObjectId = (String)serverComponentMap.get("Id");
                rc = MetadatasrvMigrate.updateMetadataAttributes(task, "ServerComponent", serverComponentObjectId, nameList, valueList);
                if (rc != 0) {
                    task.log(ErrorHandling.generateServerDefinitionWarning(task, metadataServerName), 1);
                    rc = 1;
                } else {
                    task.log(ErrorHandling.generateUpgradedServerDefinition(task, metadataServerName), 2);
                }
                valueList.clear();
                nameList.clear();
            }
            xmlSelect = "<XMLSELECT search=\"LogicalServer[@ClassIdentifier='0217e202-b560-11db-ad91-001083ff6836'][UsingComponents/ServerComponent[@Id='" + serverComponentId + "']]\"/>";
            xmlTemplate = "<TEMPLATES><LogicalServer Id=\"\" Major=\"\" Minor=\"\" Name=\"\" SoftwareVersion=\"\"/></TEMPLATES>";
            xmlOptions = xmlSelect + xmlTemplate;
            logicalList = MetadatasrvMigrate.getMetadataAttributes(task, "LogicalServer", repositoryId, xmlOptions);
            if (logicalList.size() != 1) continue;
            task.log(ErrorHandling.generateMigrateLogicalServer(task), 2);
            Map logicalServerMap = (Map)logicalList.get(0);
            String logicalServerId = (String)logicalServerMap.get("Id");
            String logicalServerName = (String)logicalServerMap.get("Name");
            String logicalServerMajor = (String)logicalServerMap.get("Major");
            String logicalServerMinor = (String)logicalServerMap.get("Minor");
            String logicalServerVersion = (String)logicalServerMap.get("SoftwareVersion");
            if (!logicalServerMajor.equalsIgnoreCase(targetComponentMajor)) {
                nameList.add("Major");
                valueList.add(targetComponentMajor);
            }
            if (!logicalServerMinor.equalsIgnoreCase(targetComponentMinor)) {
                nameList.add("Minor");
                valueList.add(targetComponentMinor);
            }
            if (!logicalServerVersion.equalsIgnoreCase(targetComponentVersion)) {
                nameList.add("SoftwareVersion");
                valueList.add(targetComponentVersion);
            }
            if (nameList.size() > 0) {
                rc = MetadatasrvMigrate.updateMetadataAttributes(task, "LogicalServer", logicalServerId, nameList, valueList);
                if (rc != 0) {
                    task.log(ErrorHandling.generateLogicalServerWarning(task, logicalServerName), 1);
                    rc = 1;
                } else {
                    task.log(ErrorHandling.generateUpgradedLogicalServer(task, logicalServerName), 2);
                }
            }
            String transformationName = "Load Balancing Transformation";
            xmlSelect = "<XMLSELECT search=\"Transformation[@Name='" + transformationName + "'][DeployedComponents/LogicalServer[@Id='" + logicalServerId + "']]\"/>";
            xmlTemplate = "<TEMPLATES><Transformation Id=\"\" Name=\"\"></Transformation></TEMPLATES>";
            xmlOptions = xmlSelect + xmlTemplate;
            List transformationList = MetadatasrvMigrate.getMetadataAttributes(task, "Transformation", repositoryId, xmlOptions);
            if (transformationList.size() != 0) continue;
            StringBuffer addMetadataBuffer = new StringBuffer("<Transformation Name=\"" + transformationName + "\" TransformRole=\"Load Balancing\"><Properties><Property Name=\"Load.Balancing.Algorithm\" DefaultValue=\"" + project.getProperty("metadatasrv.cluster.load.balance.algorithm") + "\" PropertyName=\"BalancingAlgorithm\"/><Property Name=\"Load.Balancing.Peer.Object\" DefaultValue=\"" + project.getProperty("metadatasrv.cluster.load.balance.peer") + "\" PropertyName=\"PeerObject\"/><Property Name=\"Load.Balancing.Cluster.Timeout\" DefaultValue=\"" + project.getProperty("metadatasrv.cluster.load.balance.timeout") + "\" PropertyName=\"LBClusterTimeout\"/></Properties><DeployedComponents><LogicalServer ObjRef=\"" + logicalServerId + "\"/></DeployedComponents></Transformation>");
            String addMetadataXML = addMetadataBuffer.toString();
            rc = MetadatasrvMigrate.addMetadataObject(task, repositoryId, addMetadataXML);
            if (rc != 0) {
                task.log(ErrorHandling.generateLbTransformationWarning(task, transformationName, logicalServerName), 1);
                rc = 1;
                continue;
            }
            task.log(ErrorHandling.generateAssignedLbTransformation(task, transformationName, logicalServerName), 2);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int cleanupBackupRestoreJobs(MetadatasrvMigrate task) {
        String logMessage;
        int rc = 0;
        int omiFlags = 8581;
        MdObjectStore backupRestoreJobStore = null;
        String repositoryId = foundationRepository.getFQID();
        String xmlSelect = "<XMLSELECT search=\"Job[@TransformRole='Backup' OR @TransformRole='Restore'][Trees/Tree[@Name='Administration']/ParentTree/Tree[@Name='System']]\"/>";
        String xmlTemplate = "<TEMPLATES><Job Id=\"\" Name=\"\" TransformRole=\"\"><ComputeLocations/><Trees/></Job><Tree Id=\"\" Name=\"\"><ParentTree/><SoftwareComponents/></Tree><ServerContext Id=\"\" Name=\"\"/><SoftwareComponent Id=\"\" Name=\"\"/></TEMPLATES>";
        String xmlOptions = xmlSelect + xmlTemplate;
        task.log(ErrorHandling.generateBackupRestoreCleanUp(task), 2);
        try {
            backupRestoreJobStore = mdFactory.createObjectStore(null, "MdObjectStore::cleanupBackupRestoreJobs");
            List oldBackupRestoreJobList = mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)backupRestoreJobStore, repositoryId, "Job", omiFlags, xmlOptions);
            int oldBackupRestoreJobListSize = oldBackupRestoreJobList.size();
            for (int i = 0; i < oldBackupRestoreJobListSize; ++i) {
                Job oldBackupRestoreJob = (Job)oldBackupRestoreJobList.get(i);
                String oldBackupRestoreJobId = oldBackupRestoreJob.getFQID();
                rc = MetadatasrvMigrate.deleteMetadataObject(task, "Job", oldBackupRestoreJobId);
                if (rc != 0) continue;
                String oldBackupRestoreJobName = oldBackupRestoreJob.getName();
                task.log(ErrorHandling.generateMetadataObjectDeleted(task, "Job", oldBackupRestoreJobName, oldBackupRestoreJobId), 2);
            }
        }
        catch (MdException mx) {
            exceptionMessage = mx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            int n = 2;
            return n;
        }
        catch (RemoteException rx) {
            exceptionMessage = rx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            String logMessage2 = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
            task.log(logMessage2, 0);
            int n = 2;
            return n;
        }
        finally {
            try {
                if (backupRestoreJobStore != null) {
                    backupRestoreJobStore.dispose();
                }
            }
            catch (RemoteException rx) {
                exceptionMessage = rx.getLocalizedMessage();
                if (exceptionMessage == null) {
                    exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
                }
                logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
                task.log(logMessage, 0);
                return 1;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int cleanupMetadataServerDefinitions(MetadatasrvMigrate task) {
        boolean foundNewServer = false;
        int rc = 0;
        List clientConnectionList = null;
        List serverComponentList = null;
        String metadataServerHost = project.getProperty("iomsrv.metadatasrv.host");
        String metadataServerPort = project.getProperty("iomsrv.metadatasrv.port");
        String repositoryId = foundationRepository.getFQID();
        int omiFlags = 388;
        String xmlSelect = "<XMLSELECT search=\"ServerComponent[@ClassIdentifier='0217E202-B560-11DB-AD91-001083FF6836'][UsedByComponents/LogicalServer/UsedByComponents/ServerContext[@Name='" + project.getProperty("iomsrv.metadatasrv.servercontext.name") + "']][SourceConnections/TCPIPConnection[(@HostName='" + metadataServerHost + "' and @Port='" + metadataServerPort + "')]]\"/>";
        String xmlTemplate = "<TEMPLATES><ServerComponent Id=\"\" Name=\"\"/></TEMPLATES>";
        String xmlOptions = xmlSelect + xmlTemplate;
        MdObjectStore serverComponentStore = null;
        String newClientConnectionId = null;
        String newClientConnectionName = null;
        String newServerComponentId = null;
        String newServerComponentName = null;
        SASClientConnection newClientConnection = null;
        ServerComponent newServerComponent = null;
        try {
            serverComponentStore = mdFactory.createObjectStore(null, "MdObjectStore::cleanupMetadataServerDefinitions");
            serverComponentList = mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)serverComponentStore, repositoryId, "ServerComponent", omiFlags, xmlOptions);
            if (serverComponentList.size() == 1) {
                newServerComponent = (ServerComponent)serverComponentList.get(0);
                newServerComponentId = newServerComponent.getFQID();
                newServerComponentName = newServerComponent.getName();
                String sasClientConnectionName = project.getProperty("metadataserver.sasclientconnection.name");
                omiFlags = 388;
                xmlSelect = "<XMLSELECT search=\"SASClientConnection[@Name='" + sasClientConnectionName + "'][Source/ServerComponent[@Id='" + newServerComponentId + "']]\"/>";
                xmlTemplate = "<TEMPLATES><SASClientConnection Id=\"\" Name=\"\"/></TEMPLATES>";
                xmlOptions = xmlSelect + xmlTemplate;
                clientConnectionList = mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)serverComponentStore, repositoryId, "SASClientConnection", omiFlags, xmlOptions);
                if (clientConnectionList.size() == 1) {
                    newClientConnection = (SASClientConnection)clientConnectionList.get(0);
                    newClientConnectionId = newClientConnection.getFQID();
                    newClientConnectionName = newClientConnection.getName();
                    foundNewServer = true;
                }
            }
        }
        catch (MdException mx) {
            exceptionMessage = mx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            String logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            return 2;
        }
        catch (RemoteException rx) {
            exceptionMessage = rx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            String logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            return 2;
        }
        if (foundNewServer) {
            String logMessage;
            task.log(ErrorHandling.generateCleanupServerDefinitions(task), 2);
            task.log(ErrorHandling.generateTargetServerComponent(task, "ServerComponent", newServerComponentName, newServerComponentId), 2);
            String oldServerHost = project.getProperty("metadatasrv.migrated.object.configobj.prior.host");
            String oldServerPort = project.getProperty("metadatasrv.migrated.object.configobj.prior.iomsrv.metadatasrv.port");
            try {
                omiFlags = 8581;
                xmlSelect = "<XMLSELECT search=\"ServerComponent[@ClassIdentifier='0217E202-B560-11DB-AD91-001083FF6836']\"/>";
                xmlTemplate = "<TEMPLATES><ServerComponent Id=\"\" Name=\"\"><SourceConnections/></ServerComponent><SASClientConnection Id=\"\" Port=\"\" RemoteAddress=\"\"><Libraries/></SASClientConnection><SASLibrary Id=\"\" Name=\"\"><LibraryConnection/></SASLibrary><TCPIPConnection Id=\"\" HostName=\"\" Port=\"\"/></TEMPLATES>";
                xmlOptions = xmlSelect + xmlTemplate;
                List oldServerComponentList = mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)serverComponentStore, repositoryId, "ServerComponent", omiFlags, xmlOptions);
                Object[] oldServerComponentsArray = oldServerComponentList.toArray();
                for (int i = 0; i < oldServerComponentsArray.length; ++i) {
                    boolean cleanupServerDefinition = false;
                    ServerComponent oldServerComponent = (ServerComponent)oldServerComponentsArray[i];
                    String oldServerComponentId = oldServerComponent.getFQID();
                    String oldServerComponentName = oldServerComponent.getName();
                    if (newServerComponentId.equalsIgnoreCase(oldServerComponentId)) {
                        String rwServerComponentName;
                        String dsServerComponentName;
                        ServerComponent dsServerComponent;
                        String dsServerComponentId;
                        omiFlags = 388;
                        xmlSelect = "<XMLSELECT search=\"ServerComponent[@ClassIdentifier='e20e54b3-e5f4-47ed-b21d-03109bf9a4b8'][UsedByComponents/LogicalServer/UsedByComponents/ServerContext[@Name='" + project.getProperty("iomsrv.metadatasrv.servercontext.name") + "']]\"/>";
                        xmlTemplate = "<TEMPLATES><ServerComponent Id=\"\" Name=\"\"/></TEMPLATES>";
                        xmlOptions = xmlSelect + xmlTemplate;
                        List dataStepServerList = mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)serverComponentStore, repositoryId, "ServerComponent", omiFlags, xmlOptions);
                        if (dataStepServerList.size() == 1 && (rc = MetadatasrvMigrate.cleanupLogicalServerDefinitions(task, serverComponentStore, dsServerComponentId = (dsServerComponent = (ServerComponent)dataStepServerList.get(0)).getFQID(), dsServerComponentName = dsServerComponent.getName())) == 2) {
                            int n = rc;
                            return n;
                        }
                        xmlSelect = "<XMLSELECT search=\"ServerComponent[@ClassIdentifier='440196D4-90F0-11D0-9F41-00A024BB830C'][UsedByComponents/LogicalServer/UsedByComponents/ServerContext[@Name='" + project.getProperty("iomsrv.metadatasrv.servercontext.name") + "']]\"/>";
                        xmlOptions = xmlSelect + xmlTemplate;
                        List replWkspServerList = mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)serverComponentStore, repositoryId, "ServerComponent", omiFlags, xmlOptions);
                        if (replWkspServerList.size() != 1) continue;
                        ServerComponent rwServerComponent = (ServerComponent)replWkspServerList.get(0);
                        String rwServerComponentId = rwServerComponent.getFQID();
                        rc = MetadatasrvMigrate.cleanupLogicalServerDefinitions(task, serverComponentStore, rwServerComponentId, rwServerComponentName = rwServerComponent.getName());
                        if (rc != 2) continue;
                        int rx = rc;
                        return rx;
                    }
                    if (sdwDebugMode) {
                        task.log("TRACE:  oldServerComponentName = \"" + oldServerComponentName + "\" oldServerComponentId = " + oldServerComponentId);
                        task.log("TRACE:  cleanupServerDefinition = " + cleanupServerDefinition);
                    }
                    Object[] oldSourceConnectionsArray = oldServerComponent.getSourceConnections().toArray();
                    for (int j = 0; j < oldSourceConnectionsArray.length; ++j) {
                        CMetadata connectionObject = (CMetadata)oldSourceConnectionsArray[j];
                        if (connectionObject instanceof TCPIPConnection) {
                            TCPIPConnection tcpipConnection = (TCPIPConnection)connectionObject;
                            String oldTcpipConnectionHost = tcpipConnection.getHostName();
                            String oldTcpipConnectionPort = Integer.toString(tcpipConnection.getPort());
                            if (sdwDebugMode) {
                                task.log("TRACE:  TCPIPConnection oldTcpipConnectionHost = \"" + oldTcpipConnectionHost + "\", oldTcpipConnectionPort = " + oldTcpipConnectionPort);
                            }
                            if (!cleanupServerDefinition) {
                                cleanupServerDefinition = true;
                                if (sdwDebugMode) {
                                    task.log("TRACE:  cleanupServerDefinition = " + cleanupServerDefinition);
                                }
                                task.log(ErrorHandling.generateServerComponentReplacement(task, "ServerComponent", oldServerComponentName, oldServerComponentId, newServerComponentName), 2);
                            }
                            omiFlags = 404;
                            xmlSelect = "<XMLSELECT search=\"ServerComponent[@Id='" + oldServerComponentId + "']\"/>";
                            xmlTemplate = "<TEMPLATES><ServerComponent><DataPackages/></ServerComponent><DeployedDataPackage Id=\"\" Name=\"\"><DeployedComponents/></DeployedDataPackage></TEMPLATES>";
                            xmlOptions = xmlSelect + xmlTemplate;
                            repositoryId = "A0000001." + oldServerComponentId.substring(0, oldServerComponentId.indexOf("."));
                            List thisServerComponentList = mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)serverComponentStore, repositoryId, "ServerComponent", omiFlags, xmlOptions);
                            if (thisServerComponentList.size() != 1) continue;
                            ServerComponent serverComponent = (ServerComponent)thisServerComponentList.get(0);
                            Object[] dataPackagesArray = serverComponent.getDataPackages().toArray();
                            for (int k = 0; k < dataPackagesArray.length; ++k) {
                                DeployedDataPackage deployedDataPackage = (DeployedDataPackage)dataPackagesArray[k];
                                String oldDeployedDataPackageId = deployedDataPackage.getFQID();
                                String oldDeployedDataPackageName = deployedDataPackage.getName();
                                String oldDeployedDataPackageType = deployedDataPackage.getCMetadataType();
                                if (sdwDebugMode) {
                                    task.log("TRACE:  " + oldDeployedDataPackageType + " oldDeployedDataPackageName = \"" + oldDeployedDataPackageName + "\" oldDeployedDataPackageId = " + oldDeployedDataPackageId);
                                }
                                AssociationList deployedComponentsList = deployedDataPackage.getDeployedComponents();
                                for (int l = 0; l < deployedComponentsList.size(); ++l) {
                                    ServerComponent associatedServerComponent;
                                    CMetadata deployedComponent = (CMetadata)deployedComponentsList.get(l);
                                    if (!(deployedComponent instanceof ServerComponent) || !(associatedServerComponent = (ServerComponent)deployedComponent).getFQID().equalsIgnoreCase(oldServerComponentId)) continue;
                                    deployedComponentsList.set(l, (Object)newServerComponent);
                                }
                                deployedDataPackage.setDeployedComponents(deployedComponentsList);
                                task.log(ErrorHandling.generateParentObjectChanged(task, oldDeployedDataPackageType, oldDeployedDataPackageName, oldDeployedDataPackageId, newServerComponentName), 2);
                            }
                            continue;
                        }
                        if (!(connectionObject instanceof SASClientConnection)) continue;
                        SASClientConnection sasClientConnection = (SASClientConnection)connectionObject;
                        String oldClientConnectionHost = sasClientConnection.getRemoteAddress();
                        String oldClientConnectionPort = Integer.toString(sasClientConnection.getPort());
                        if (sdwDebugMode) {
                            task.log("TRACE:  SASClientConnection oldClientConnectionHost = \"" + oldClientConnectionHost + "\" oldClientConnectionPort = " + oldClientConnectionPort);
                        }
                        if (!cleanupServerDefinition) {
                            cleanupServerDefinition = true;
                            if (sdwDebugMode) {
                                task.log("TRACE:  cleanupServerDefinition = " + cleanupServerDefinition);
                            }
                            task.log(ErrorHandling.generateServerComponentReplacement(task, "ServerComponent", oldServerComponentName, oldServerComponentId, newServerComponentName), 2);
                        }
                        SASClientConnection oldClientConnection = (SASClientConnection)connectionObject;
                        String oldClientConnectionId = oldClientConnection.getFQID();
                        String oldClientConnectionName = oldClientConnection.getName();
                        Object[] libraryArray = oldClientConnection.getLibraries().toArray();
                        for (int k = 0; k < libraryArray.length; ++k) {
                            SASLibrary sasLibrary = (SASLibrary)libraryArray[k];
                            String oldSasLibraryId = sasLibrary.getFQID();
                            String oldSasLibraryName = sasLibrary.getName();
                            String oldSasLibraryType = sasLibrary.getCMetadataType();
                            SASClientConnection sasLibraryConnection = sasLibrary.getLibraryConnection();
                            if (sasLibraryConnection != null) {
                                String saslibraryConnectionHost = sasLibraryConnection.getRemoteAddress();
                                String saslibraryConnectionPort = Integer.toString(sasLibraryConnection.getPort());
                                if (sdwDebugMode) {
                                    task.log("TRACE:  SASClientConnection saslibraryConnectionHost = \"" + saslibraryConnectionHost + "\" saslibraryConnectionPort = " + saslibraryConnectionPort);
                                }
                                if (!oldServerPort.equalsIgnoreCase(saslibraryConnectionPort) || !saslibraryConnectionHost.equalsIgnoreCase(LOCALHOST) && !MetadatasrvMigrate.areHostsEqual(oldServerHost, saslibraryConnectionHost)) continue;
                            }
                            if (sdwDebugMode) {
                                task.log("TRACE:  " + oldSasLibraryType + " oldSasLibraryName = \"" + oldSasLibraryName + "\" oldSasLibraryId = " + oldSasLibraryId);
                            }
                            sasLibrary.setLibraryConnection(newClientConnection);
                            task.log(ErrorHandling.generateParentObjectChanged(task, oldSasLibraryType, oldSasLibraryName, oldSasLibraryId, newClientConnectionName), 2);
                        }
                    }
                    if (!cleanupServerDefinition || (rc = MetadatasrvMigrate.cleanupLogicalServerDefinitions(task, serverComponentStore, oldServerComponentId, oldServerComponentName)) != 2) continue;
                    int n = rc;
                    return n;
                }
                serverComponentStore.updatedMetadataAll();
            }
            catch (MdException mx) {
                exceptionMessage = mx.getLocalizedMessage();
                if (exceptionMessage == null) {
                    exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
                }
                logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
                task.log(logMessage, 0);
                int n = 2;
                return n;
            }
            catch (RemoteException rx) {
                exceptionMessage = rx.getLocalizedMessage();
                if (exceptionMessage == null) {
                    exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
                }
                String logMessage2 = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
                task.log(logMessage2, 0);
                int n = 2;
                return n;
            }
            finally {
                try {
                    serverComponentStore.dispose();
                }
                catch (RemoteException rx) {
                    exceptionMessage = rx.getLocalizedMessage();
                    if (exceptionMessage == null) {
                        exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
                    }
                    logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
                    task.log(logMessage, 0);
                    return 1;
                }
            }
        }
        return rc;
    }

    private static int cleanupLogicalServerDefinitions(MetadatasrvMigrate task, MdObjectStore serverComponentStore, String serverComponentId, String serverComponentName) {
        int rc = 0;
        int omiFlags = 4;
        ArrayList emptySimpleAttributeList = new ArrayList(0);
        ArrayList emptyComplexObjectList = new ArrayList(0);
        String xmlTemplate = "<TEMPLATES><ServerComponent Id=\"\" Name=\"\"><UsedByComponents/></ServerComponent><LogicalServer Id=\"\" Name=\"\"><UsedByComponents/><UsingComponents/></LogicalServer><ServerContext Id=\"\" Name=\"\"><UsingComponents/></ServerContext></TEMPLATES>";
        try {
            ServerComponent serverComponent = (ServerComponent)mdFactory.getOMIUtil().getMetadataAllDepths((MdStore)serverComponentStore, "ServerComponent", serverComponentId, emptySimpleAttributeList, emptyComplexObjectList, xmlTemplate, omiFlags);
            AssociationList logicalServerList = serverComponent.getUsedByComponents();
            rc = MetadatasrvMigrate.deleteMetadataObject(task, "ServerComponent", serverComponentId);
            if (rc == 0) {
                task.log(ErrorHandling.generateMetadataObjectDeleted(task, "ServerComponent", serverComponentName, serverComponentId), 2);
                if (logicalServerList.size() == 1) {
                    LogicalServer logicalServer = (LogicalServer)logicalServerList.get(0);
                    String oldLogicalServerId = logicalServer.getFQID();
                    AssociationList usingComponentsList = logicalServer.getUsingComponents();
                    if (usingComponentsList.size() == 1) {
                        AssociationList serverContextList = logicalServer.getUsedByComponents();
                        rc = MetadatasrvMigrate.deleteMetadataObject(task, "LogicalServer", oldLogicalServerId);
                        if (rc == 0) {
                            String oldLogicalServerName = logicalServer.getName();
                            task.log(ErrorHandling.generateMetadataObjectDeleted(task, "LogicalServer", oldLogicalServerName, oldLogicalServerId), 2);
                            if (serverContextList.size() == 1) {
                                ServerContext serverContext = (ServerContext)serverContextList.get(0);
                                String oldServerContextId = serverContext.getFQID();
                                usingComponentsList = serverContext.getUsingComponents();
                                if (usingComponentsList.size() == 1) {
                                    String oldServerContextName = serverContext.getName();
                                    task.log(ErrorHandling.generateOrphanContextWarning(task, "ServerContext", oldServerContextName, oldServerContextId), 2);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (MdException mx) {
            exceptionMessage = mx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            String logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            return 2;
        }
        catch (RemoteException rx) {
            exceptionMessage = rx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            String logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            return 2;
        }
        return rc;
    }

    private static boolean areHostsEqual(String host1, String host2) {
        boolean result = false;
        if (host1 == null || host2 == null) {
            return false;
        }
        if (host1.equalsIgnoreCase(host2)) {
            return true;
        }
        String ipHostAddress1 = MetadatasrvMigrate.convertToIPAddress(host1);
        String ipHostAddress2 = MetadatasrvMigrate.convertToIPAddress(host2);
        if (ipHostAddress1 == null || ipHostAddress2 == null) {
            int index1 = host1.indexOf(".");
            int index2 = host2.indexOf(".");
            if (index1 < 0 || index2 < 0) {
                String shortHost1 = index1 >= 0 ? host1.substring(0, index1) : host1;
                String shortHost2 = index2 >= 0 ? host2.substring(0, index2) : host2;
                result = shortHost1.equalsIgnoreCase(shortHost2);
            } else {
                result = host1.equalsIgnoreCase(host2);
            }
        } else {
            result = ipHostAddress1.equals(ipHostAddress2);
        }
        return result;
    }

    private static String convertToIPAddress(String host) {
        String ipHostAddress = null;
        try {
            if (!MetadatasrvMigrate.isEmpty(host)) {
                InetAddress address;
                boolean islocalHost = Strings.equal((String)host, (String)LOCALHOST, (boolean)false, (boolean)true);
                if (islocalHost) {
                    address = InetAddress.getLocalHost();
                } else {
                    address = InetAddress.getByName(host);
                    if (address.isLoopbackAddress()) {
                        address = InetAddress.getLocalHost();
                    }
                }
                ipHostAddress = address.getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ipHostAddress;
    }

    public static boolean isEmpty(String str) {
        boolean isEmpty = false;
        if (str == null) {
            isEmpty = true;
        } else if (str.length() <= 0) {
            isEmpty = true;
        }
        return isEmpty;
    }

    private static int assignAdminUsersMembership(MetadatasrvMigrate task) {
        int rc = 0;
        adminUsersPath = project.getProperty("metadatasrv.config.dir") + File.separator + project.getProperty("iomsrv.metadatasrv.adminusers.file.name");
        adminUsersFile = new File(adminUsersPath);
        if (adminUsersFile.exists()) {
            List objectList = null;
            String adminUsersRecord = "";
            String logMessage = null;
            String repositoryId = foundationRepository.getFQID();
            String xmlSelect = "<XMLSELECT search=\"IdentityGroup[@Name='META: Unrestricted Users Role' OR @Name='SASAdministrators']\"/>";
            String xmlTemplate = "<TEMPLATES><IdentityGroup DisplayName=\"\" Id=\"\" Name=\"\"/></TEMPLATES>";
            String xmlOptions = xmlSelect + xmlTemplate;
            objectList = MetadatasrvMigrate.getMetadataAttributes(task, "IdentityGroup", repositoryId, xmlOptions);
            for (int i = 0; i < objectList.size(); ++i) {
                Map identityGroupMap = (Map)objectList.get(i);
                String identityGroupName = (String)identityGroupMap.get("Name");
                if (identityGroupName.equals("SASAdministrators")) {
                    administratorGroupId = (String)identityGroupMap.get("Id");
                    administratorGroupName = (String)identityGroupMap.get("DisplayName");
                    continue;
                }
                unrestrictedGroupId = (String)identityGroupMap.get("Id");
                unrestrictedGroupName = (String)identityGroupMap.get("DisplayName");
            }
            try {
                BufferedInputStream adminBufferedInputStream = new BufferedInputStream(new FileInputStream(adminUsersFile));
                InputStreamReader adminInputStreamReader = !targetOsType.equalsIgnoreCase("mvs") && !targetOsType.equalsIgnoreCase("zos") ? new InputStreamReader(adminBufferedInputStream) : new InputStreamReader((InputStream)adminBufferedInputStream, sasEncoding);
                String adminEncoding = adminInputStreamReader.getEncoding();
                if (sdwDebugMode) {
                    task.log("TRACE:  File encoding = " + fileEncoding + (targetOsType.equalsIgnoreCase("mvs") || targetOsType.equalsIgnoreCase("zos") ? ".  SAS Session encoding = " + sasEncoding : "") + ".  getEncoding() = " + adminEncoding);
                }
                BufferedReader adminUsersReader = new BufferedReader(adminInputStreamReader);
                task.log(ErrorHandling.generateGroupMemberAssignment(task), 2);
                while ((adminUsersRecord = adminUsersReader.readLine()) != null) {
                    boolean unrestrictedUserFlag;
                    String administratorUserId;
                    if ((adminUsersRecord = adminUsersRecord.trim()).startsWith(";") || (administratorUserId = adminUsersRecord.substring((unrestrictedUserFlag = adminUsersRecord.startsWith(unrestrictedCharacter)) ? 1 : 0, adminUsersRecord.length())).length() <= 0) continue;
                    rc = MetadatasrvMigrate.assignAdminUserRoles(task, administratorUserId, unrestrictedUserFlag);
                }
                if (adminUsersReader != null) {
                    try {
                        adminUsersReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (FileNotFoundException fnfx) {
                logMessage = fnfx.getLocalizedMessage();
                if (logMessage == null) {
                    logMessage = ErrorHandling.generateFileNotFoundMessage(task, adminUsersFile.getAbsolutePath());
                }
                task.log(logMessage, 1);
                rc = 1;
            }
            catch (IOException iox) {
                logMessage = iox.getLocalizedMessage();
                if (logMessage == null) {
                    logMessage = ErrorHandling.generateIOExceptionErrorMessage(task, adminUsersFile.getAbsolutePath());
                }
                task.log(logMessage, 1);
                rc = 1;
            }
        }
        return rc;
    }

    private static int assignAdminUserRoles(MetadatasrvMigrate task, String adminUser, boolean unrestrictedUserFlag) {
        int rc = 0;
        String idDomain = null;
        String idUserId = null;
        int idseparator = adminUser.indexOf(File.separatorChar);
        int idseparator2 = adminUser.indexOf(64);
        if (idseparator != -1) {
            idDomain = adminUser.substring(0, idseparator);
            idUserId = adminUser.substring(idseparator + 1, adminUser.length());
        } else if (idseparator2 != -1) {
            idDomain = adminUser.substring(idseparator2 + 1, adminUser.length());
            idUserId = adminUser.substring(0, idseparator2);
        } else {
            idDomain = null;
            idUserId = adminUser;
        }
        String repositoryId = foundationRepository.getFQID();
        String xmlSelect = "<XMLSELECT search=\"Person[Logins/Login[" + (idDomain == null ? "@UserID='" + adminUser + "'" : "@UserID='" + idDomain + File.separatorChar + idUserId + "' OR @UserID='" + idUserId + "@" + idDomain + "'") + "]]\"/>";
        String xmlTemplate = "<TEMPLATES><Person DisplayName=\"\" Id=\"\" Name=\"\"><Logins/></Person><Login UserID=\"\"/></TEMPLATES>";
        String xmlOptions = xmlSelect + xmlTemplate;
        List externList = MetadatasrvMigrate.getMetadataAttributes(task, "Person", repositoryId, xmlOptions);
        xmlSelect = "<XMLSELECT search=\"Person[InternalLoginInfo/InternalLogin]\"/>";
        xmlTemplate = "<TEMPLATES><Person DisplayName=\"\" Id=\"\" Name=\"\"/></TEMPLATES>";
        xmlOptions = xmlSelect + xmlTemplate;
        List internList = MetadatasrvMigrate.getMetadataAttributes(task, "Person", repositoryId, xmlOptions);
        if (externList.size() == 1 || internList.size() > 0) {
            String updateIdentityGroupsXML;
            Map personMap = externList.size() == 1 ? (Map)externList.get(0) : (Map)internList.get(0);
            String adminPersonId = (String)personMap.get("Id");
            String adminPersonName = sourceSasVersion.startsWith("9.1.3") ? (String)personMap.get("Name") : (String)personMap.get("DisplayName");
            xmlSelect = "<XMLSELECT search=\"Person[@Id='" + adminPersonId + "'][IdentityGroups/IdentityGroup[@Id='" + administratorGroupId + "']]\"/>";
            xmlTemplate = "<TEMPLATES><Person Id=\"\"><IdentityGroups/></Person><IdentityGroup Id=\"\"/></TEMPLATES>";
            xmlOptions = xmlSelect + xmlTemplate;
            List testList = MetadatasrvMigrate.getMetadataAttributes(task, "Person", repositoryId, xmlOptions);
            if (testList.size() == 0) {
                updateIdentityGroupsXML = "<Person Id='" + adminPersonId + "'><IdentityGroups><IdentityGroup ObjRef='" + administratorGroupId + "'/></IdentityGroups></Person>";
                rc = MetadatasrvMigrate.updateMetadataAssociations(task, updateIdentityGroupsXML);
                if (rc == 0) {
                    task.log(ErrorHandling.generateAssignedGroupMember(task, adminPersonName, administratorGroupName), 2);
                } else {
                    task.log(ErrorHandling.generateGroupMemberWarning(task, adminPersonName, administratorGroupName), 2);
                }
            } else {
                task.log(ErrorHandling.generateExistingGroupMember(task, adminPersonName, administratorGroupName), 2);
            }
            if (unrestrictedUserFlag) {
                xmlSelect = "<XMLSELECT search=\"Person[@Id='" + adminPersonId + "'][IdentityGroups/IdentityGroup[@Id='" + unrestrictedGroupId + "']]\"/>";
                xmlOptions = xmlSelect + xmlTemplate;
                testList = MetadatasrvMigrate.getMetadataAttributes(task, "Person", repositoryId, xmlOptions);
                if (testList.size() == 0) {
                    updateIdentityGroupsXML = "<Person Id='" + adminPersonId + "'><IdentityGroups><IdentityGroup ObjRef='" + unrestrictedGroupId + "'/></IdentityGroups></Person>";
                    rc = MetadatasrvMigrate.updateMetadataAssociations(task, updateIdentityGroupsXML);
                    if (rc == 0) {
                        task.log(ErrorHandling.generateAssignedGroupMember(task, adminPersonName, unrestrictedGroupName), 2);
                    } else {
                        task.log(ErrorHandling.generateGroupMemberWarning(task, adminPersonName, unrestrictedGroupName), 2);
                    }
                } else {
                    task.log(ErrorHandling.generateExistingGroupMember(task, adminPersonName, unrestrictedGroupName), 2);
                }
            } else {
                task.log(ErrorHandling.generateAdminUserNotUnrestricted(task, adminPersonName), 2);
            }
        } else {
            task.log(ErrorHandling.generateAdminUserNotInMetadata(task, adminUser), 2);
        }
        return rc;
    }

    private static int upgradeAdminAndTrustedUsersFiles(MetadatasrvMigrate task, String atFileName) {
        String fqFileName;
        File adminTrustedUsersFile;
        String sasDemoUser92;
        int rc = 0;
        int recordCount = 0;
        int updateCount = 0;
        int commentCount = 1;
        String atFilePath = project.getProperty("metadatasrv.config.dir");
        String sasAdministratorUser913 = project.getProperty("metadatasrv.old.admin.login.userid");
        if (sasAdministratorUser913 == null) {
            sasAdministratorUser913 = "";
        }
        String sasAdministratorUser92 = project.getProperty("oma.person.admin.login.userid");
        String sasTrustedUser913 = project.getProperty("metadatasrv.old.trustusr.login.userid");
        if (sasTrustedUser913 == null) {
            sasTrustedUser913 = "";
        }
        String sasTrustedUser92 = project.getProperty("oma.person.trustusr.login.userid");
        String sasDemoUser913 = project.getProperty("metadatasrv.old.demo.login.userid");
        if (sasDemoUser913 == null) {
            sasDemoUser913 = "";
        }
        if ((sasDemoUser92 = project.getProperty("oma.person.demo.login.userid")) == null) {
            sasDemoUser92 = sasDemoUser913;
        }
        if ((adminTrustedUsersFile = new File(fqFileName = atFilePath + File.separator + atFileName)).exists()) {
            String atUsersRecord = "";
            String logMessage = null;
            LinkedHashMap<String, String> atUsersMap = new LinkedHashMap<String, String>();
            try {
                BufferedInputStream atBufferedInputStream = new BufferedInputStream(new FileInputStream(adminTrustedUsersFile));
                InputStreamReader atInputStreamReader = !targetOsType.equalsIgnoreCase("mvs") && !targetOsType.equalsIgnoreCase("zos") ? new InputStreamReader(atBufferedInputStream) : new InputStreamReader((InputStream)atBufferedInputStream, sasEncoding);
                String getEncoding = atInputStreamReader.getEncoding();
                if (sdwDebugMode) {
                    task.log("TRACE:  File encoding = " + fileEncoding + (targetOsType.equalsIgnoreCase("mvs") || targetOsType.equalsIgnoreCase("zos") ? ".  SAS Session encoding = " + sasEncoding : "") + ".  getEncoding() = " + getEncoding);
                }
                BufferedReader atUsersReader = new BufferedReader(atInputStreamReader);
                task.log(ErrorHandling.generateReadFileMembers(task, atFileName), 2);
                while ((atUsersRecord = atUsersReader.readLine()) != null) {
                    if (!(atUsersRecord = atUsersRecord.trim()).startsWith(";")) {
                        boolean unresUserFlag = atUsersRecord.startsWith(unrestrictedCharacter);
                        String atUsersId = atUsersRecord.substring(unresUserFlag ? 1 : 0, atUsersRecord.length());
                        if (atUsersId.length() <= 0) continue;
                        ++recordCount;
                        if (atUsersId.equalsIgnoreCase(sasAdministratorUser913)) {
                            if (MetadatasrvMigrate.isUniqueEntry(atUsersMap, sasAdministratorUser92)) {
                                atUsersMap.put(sasAdministratorUser92, unresUserFlag ? unrestrictedCharacter : "restricted");
                                if (atUsersId.equals(sasAdministratorUser92)) continue;
                                task.log(ErrorHandling.generateUpdateFileMember(task, atUsersId, sasAdministratorUser92, atFileName), 2);
                                ++updateCount;
                                continue;
                            }
                            if (unresUserFlag) {
                                atUsersMap.put(sasAdministratorUser92, unrestrictedCharacter);
                            }
                            task.log(ErrorHandling.generateDuplicateMemberWarning(task, sasAdministratorUser92, atFileName), 1);
                            continue;
                        }
                        if (atUsersId.equalsIgnoreCase(sasTrustedUser913)) {
                            if (MetadatasrvMigrate.isUniqueEntry(atUsersMap, sasTrustedUser92)) {
                                atUsersMap.put(sasTrustedUser92, unresUserFlag ? unrestrictedCharacter : "restricted");
                                if (atUsersId.equals(sasTrustedUser92)) continue;
                                task.log(ErrorHandling.generateUpdateFileMember(task, atUsersId, sasTrustedUser92, atFileName), 2);
                                ++updateCount;
                                continue;
                            }
                            if (unresUserFlag) {
                                atUsersMap.put(sasTrustedUser92, unrestrictedCharacter);
                            }
                            task.log(ErrorHandling.generateDuplicateMemberWarning(task, sasTrustedUser92, atFileName), 1);
                            continue;
                        }
                        if (atUsersId.equalsIgnoreCase(sasDemoUser913)) {
                            if (MetadatasrvMigrate.isUniqueEntry(atUsersMap, sasDemoUser92)) {
                                atUsersMap.put(sasDemoUser92, unresUserFlag ? unrestrictedCharacter : "restricted");
                                if (atUsersId.equals(sasDemoUser92)) continue;
                                task.log(ErrorHandling.generateUpdateFileMember(task, atUsersId, sasDemoUser92, atFileName), 2);
                                ++updateCount;
                                continue;
                            }
                            if (unresUserFlag) {
                                atUsersMap.put(sasDemoUser92, unrestrictedCharacter);
                            }
                            task.log(ErrorHandling.generateDuplicateMemberWarning(task, sasDemoUser92, atFileName), 1);
                            continue;
                        }
                        if (targetOsType.equalsIgnoreCase("win")) {
                            String updatedUsersRecord = MetadatasrvMigrate.updateUserRecord(atUsersId);
                            if (updatedUsersRecord != null) {
                                if (MetadatasrvMigrate.isUniqueEntry(atUsersMap, updatedUsersRecord)) {
                                    atUsersMap.put(updatedUsersRecord, unresUserFlag ? unrestrictedCharacter : "restricted");
                                    if (atUsersId.equalsIgnoreCase(updatedUsersRecord)) continue;
                                    task.log(ErrorHandling.generateUpdateFileMember(task, atUsersId, updatedUsersRecord, atFileName), 2);
                                    ++updateCount;
                                    continue;
                                }
                                if (unresUserFlag) {
                                    atUsersMap.put(updatedUsersRecord, unrestrictedCharacter);
                                }
                                task.log(ErrorHandling.generateDuplicateMemberWarning(task, updatedUsersRecord, atFileName), 1);
                                continue;
                            }
                            if (MetadatasrvMigrate.isUniqueEntry(atUsersMap, atUsersId)) {
                                atUsersMap.put(atUsersId, unresUserFlag ? unrestrictedCharacter : "restricted");
                                continue;
                            }
                            if (unresUserFlag) {
                                atUsersMap.put(atUsersId, unrestrictedCharacter);
                            }
                            task.log(ErrorHandling.generateDuplicateMemberWarning(task, atUsersId, atFileName), 1);
                            continue;
                        }
                        if (MetadatasrvMigrate.isUniqueEntry(atUsersMap, atUsersId)) {
                            atUsersMap.put(atUsersId, unresUserFlag ? unrestrictedCharacter : "restricted");
                            continue;
                        }
                        if (unresUserFlag) {
                            atUsersMap.put(atUsersId, unrestrictedCharacter);
                        }
                        task.log(ErrorHandling.generateDuplicateMemberWarning(task, atUsersId, atFileName), 1);
                        continue;
                    }
                    String commentKey = "comment" + commentCount++;
                    atUsersMap.put(commentKey, atUsersRecord);
                }
                if (atUsersReader != null) {
                    try {
                        atUsersReader.close();
                    }
                    catch (IOException commentKey) {
                        // empty catch block
                    }
                }
                BufferedOutputStream atBufferedOutputStream = new BufferedOutputStream(new FileOutputStream(adminTrustedUsersFile));
                BufferedWriter atUsersWriter = new BufferedWriter(!targetOsType.equalsIgnoreCase("mvs") && !targetOsType.equalsIgnoreCase("zos") ? new OutputStreamWriter(atBufferedOutputStream) : new OutputStreamWriter((OutputStream)atBufferedOutputStream, sasEncoding));
                if (sdwDebugMode) {
                    task.log("TRACE:  File encoding = " + fileEncoding + (targetOsType.equalsIgnoreCase("mvs") || targetOsType.equalsIgnoreCase("zos") ? ".  SAS Session encoding = " + sasEncoding : ""));
                }
                task.log(ErrorHandling.generateWriteFileMembers(task, atFileName), 2);
                if (updateCount > 0) {
                    task.log(ErrorHandling.generateUpdateFileMemberCount(task, updateCount, recordCount, atFileName), 2);
                }
                for (String idKey : atUsersMap.keySet()) {
                    String unrestrictedValue;
                    String auEntry = null;
                    auEntry = idKey.startsWith("comment") ? (String)atUsersMap.get(idKey) : ((unrestrictedValue = (String)atUsersMap.get(idKey)).equalsIgnoreCase(unrestrictedCharacter) ? unrestrictedValue + idKey : idKey);
                    atUsersWriter.write(auEntry);
                    atUsersWriter.newLine();
                }
                if (atUsersWriter != null) {
                    try {
                        atUsersWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (FileNotFoundException fnfx) {
                logMessage = fnfx.getLocalizedMessage();
                if (logMessage == null) {
                    logMessage = ErrorHandling.generateFileNotFoundMessage(task, adminTrustedUsersFile.getAbsolutePath());
                }
                task.log(logMessage, 1);
                rc = 1;
            }
            catch (IOException iox) {
                logMessage = iox.getLocalizedMessage();
                if (logMessage == null) {
                    logMessage = ErrorHandling.generateIOExceptionErrorMessage(task, adminTrustedUsersFile.getAbsolutePath());
                }
                task.log(logMessage, 1);
                rc = 1;
            }
        }
        return rc;
    }

    private static int appendToAdminAndTrustedUsersFiles(MetadatasrvMigrate task, String userSubstring, String sdwUserId) {
        int rc;
        block20: {
            rc = 0;
            String logMessage = null;
            try {
                String userFileName = project.getProperty("iomsrv.metadatasrv." + (userSubstring.equalsIgnoreCase("admin") ? "adminusers" : "trustedusers") + ".file.name");
                String newFileName = "new." + userFileName;
                String usersPath = project.getProperty("metadatasrv.config.dir") + File.separator + userFileName;
                String usersRecord = "";
                File usersFile = new File(usersPath);
                if (!usersFile.exists()) break block20;
                boolean appendNecessary = true;
                String newUsersPath = project.getProperty("metadatasrv.config.dir") + File.separator + newFileName;
                File newUsersFile = new File(newUsersPath);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(usersFile));
                InputStreamReader inputStreamReader = !targetOsType.equalsIgnoreCase("mvs") && !targetOsType.equalsIgnoreCase("zos") ? new InputStreamReader(bufferedInputStream) : new InputStreamReader((InputStream)bufferedInputStream, sasEncoding);
                String getEncoding = inputStreamReader.getEncoding();
                if (sdwDebugMode) {
                    task.log("TRACE:  File encoding = " + fileEncoding + (targetOsType.equalsIgnoreCase("mvs") || targetOsType.equalsIgnoreCase("zos") ? ".  SAS Session encoding = " + sasEncoding : "") + ".  getEncoding() = " + getEncoding);
                }
                BufferedReader usersBufferedReader = new BufferedReader(inputStreamReader);
                BufferedOutputStream newBufferedOutputStream = new BufferedOutputStream(new FileOutputStream(newUsersFile));
                BufferedWriter usersBufferedWriter = new BufferedWriter(!targetOsType.equalsIgnoreCase("mvs") && !targetOsType.equalsIgnoreCase("zos") ? new OutputStreamWriter(newBufferedOutputStream) : new OutputStreamWriter((OutputStream)newBufferedOutputStream, sasEncoding));
                if (sdwDebugMode) {
                    task.log("TRACE:  File encoding = " + fileEncoding + (targetOsType.equalsIgnoreCase("mvs") || targetOsType.equalsIgnoreCase("zos") ? ".  SAS Session encoding = " + sasEncoding : ""));
                }
                while ((usersRecord = usersBufferedReader.readLine()) != null) {
                    if (appendNecessary) {
                        appendNecessary = userSubstring.equalsIgnoreCase("admin") ? !usersRecord.equalsIgnoreCase(unrestrictedCharacter + sdwUserId) : !usersRecord.equalsIgnoreCase(sdwUserId);
                    }
                    usersBufferedWriter.write(usersRecord);
                    usersBufferedWriter.newLine();
                }
                if (appendNecessary) {
                    if (userSubstring.equalsIgnoreCase("admin")) {
                        usersBufferedWriter.append(unrestrictedCharacter + sdwUserId);
                    } else {
                        usersBufferedWriter.append(sdwUserId);
                    }
                }
                if (usersBufferedReader != null) {
                    try {
                        usersBufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (usersBufferedWriter != null) {
                    try {
                        usersBufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                usersFile.delete();
                newUsersFile.renameTo(usersFile);
            }
            catch (FileNotFoundException fnfx) {
                logMessage = fnfx.getLocalizedMessage();
                if (logMessage == null) {
                    logMessage = ErrorHandling.generateFileNotFoundMessage(task, adminUsersFile.getAbsolutePath());
                }
                task.log(logMessage, 1);
                rc = 1;
            }
            catch (IOException iox) {
                logMessage = iox.getLocalizedMessage();
                if (logMessage == null) {
                    logMessage = ErrorHandling.generateIOExceptionErrorMessage(task, adminUsersFile.getAbsolutePath());
                }
                task.log(logMessage, 1);
                rc = 1;
            }
            catch (Exception ex) {
                logMessage = ex.getLocalizedMessage();
                if (logMessage == null) {
                    logMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
                }
                logMessage = ErrorHandling.generateMigrationGenericException(task) + "  " + logMessage;
                task.log(logMessage, 1);
            }
        }
        return rc;
    }

    private static boolean isUniqueEntry(Map entryMap, String userEntry) {
        if (entryMap.isEmpty()) {
            return true;
        }
        for (String idKey : entryMap.keySet()) {
            if (!userEntry.equalsIgnoreCase(idKey)) continue;
            return false;
        }
        return true;
    }

    private static String detoxifyDirectory(MetadatasrvMigrate task, String directory) {
        String repositoryDirectory = directory;
        repositoryDirectory = repositoryDirectory.replace('\\', '_');
        repositoryDirectory = repositoryDirectory.replace('/', '_');
        repositoryDirectory = repositoryDirectory.replace('\"', '_');
        repositoryDirectory = repositoryDirectory.replace('\'', '_');
        repositoryDirectory = repositoryDirectory.replace('[', '_');
        repositoryDirectory = repositoryDirectory.replace(']', '_');
        repositoryDirectory = repositoryDirectory.replace('*', '_');
        repositoryDirectory = repositoryDirectory.replace('?', '_');
        repositoryDirectory = repositoryDirectory.replace('<', '_');
        repositoryDirectory = repositoryDirectory.replace('>', '_');
        repositoryDirectory = repositoryDirectory.replace(':', '_');
        repositoryDirectory = repositoryDirectory.replace('|', '_');
        return repositoryDirectory;
    }

    private static String updateUserRecord(String userId) {
        String host913 = project.getProperty("metadatasrv.migrated.object.configobj.prior.host");
        int domainIndex = host913.indexOf(".");
        String domain913 = domainIndex > 0 ? host913.substring(0, domainIndex) : host913;
        String host92 = project.getProperty("metadatasrv.migrated.object.configobj.host");
        domainIndex = host92.indexOf(".");
        String domain92 = domainIndex > 0 ? host92.substring(0, domainIndex) : host92;
        String idDomain = null;
        String idUserId = null;
        int idseparator = userId.indexOf(File.separatorChar);
        int idseparator2 = userId.indexOf(64);
        if (idseparator != -1) {
            idDomain = userId.substring(0, idseparator);
            idUserId = userId.substring(idseparator + 1, userId.length());
        } else if (idseparator2 != -1) {
            idDomain = userId.substring(idseparator2 + 1, userId.length());
            idUserId = userId.substring(0, idseparator2);
        } else {
            return null;
        }
        if (idDomain.equalsIgnoreCase(domain913)) {
            StringBuffer updatedUsersRecordBuffer = new StringBuffer();
            if (idseparator != -1) {
                updatedUsersRecordBuffer.append(domain92);
                updatedUsersRecordBuffer.append(File.separator);
                updatedUsersRecordBuffer.append(idUserId);
                String updatedUsersRecord = updatedUsersRecordBuffer.toString();
                return updatedUsersRecord;
            }
            if (idseparator2 != -1) {
                updatedUsersRecordBuffer.append(idUserId);
                updatedUsersRecordBuffer.append("@");
                updatedUsersRecordBuffer.append(domain92);
                String updatedUsersRecord = updatedUsersRecordBuffer.toString();
                return updatedUsersRecord;
            }
            return null;
        }
        return null;
    }

    private static int upgradeUser(MetadatasrvMigrate task, String userSubstring) {
        int personListSize = 0;
        int rc = 0;
        List loginList = null;
        List personList = null;
        String xmlOptions = "";
        String xmlSelect = "";
        String xmlTemplate = "";
        String repositoryId = foundationRepository.getFQID();
        String sdwDispNm = project.getProperty("oma.person." + userSubstring + ".person.display.name");
        String sdwUserNm = project.getProperty("oma.person." + userSubstring + ".person.name");
        String sdwUserId = project.getProperty("oma.person." + userSubstring + ".login.userid");
        String sdwPasswd = project.getProperty("oma.person." + userSubstring + ".login.passwd");
        String smuDispNm = project.getProperty("metadatasrv.old." + userSubstring + ".person.display.name");
        String usrAcctTp = project.getProperty("user.account.type");
        if (smuDispNm == null || smuDispNm.length() <= 0) {
            String objUserNm = sourceSasVersion.startsWith("9.1.3") ? sdwDispNm : sdwUserNm;
            xmlSelect = "<XMLSELECT search=\"Person[@Name='" + objUserNm + "']\"/>";
            xmlTemplate = "<TEMPLATES><Person Id=\"\" DisplayName=\"\" Name=\"\"/></TEMPLATES>";
            xmlOptions = xmlSelect + xmlTemplate;
            personList = MetadatasrvMigrate.getMetadataAttributes(task, "Person", repositoryId, xmlOptions);
            personListSize = personList.size();
            if (personListSize < 1) {
                if (usrAcctTp.equalsIgnoreCase("external") || userSubstring.equalsIgnoreCase("demo")) {
                    String defDomain = project.getProperty("iomsrv.metadatasrv.authdomain");
                    xmlSelect = "<XMLSELECT search=\"Login[@UserID='" + sdwUserId + "'][Domain/AuthenticationDomain[@Name='" + defDomain + "']]\"/>";
                    xmlTemplate = "<TEMPLATES><Login Id=\"\" UserID=\"\" Password=\"\"><Domain/></Login><AuthenticationDomain Id=\"\" Name=\"\"/></TEMPLATES>";
                    xmlOptions = xmlSelect + xmlTemplate;
                    loginList = MetadatasrvMigrate.getMetadataAttributes(task, "Login", repositoryId, xmlOptions);
                    int loginListSize = loginList.size();
                    if (loginListSize < 1) {
                        rc = MetadatasrvMigrate.assignLoginToUser(task, userSubstring, "", sdwDispNm, sdwUserNm);
                        if (rc == 0) {
                            task.log(ErrorHandling.generateUserAddedInformation(task, sdwDispNm), 2);
                        } else {
                            task.log(ErrorHandling.generateUserAddedError(task, sdwDispNm), 0);
                            rc = 2;
                        }
                    } else {
                        task.log(ErrorHandling.generateDuplicateLoginError(task, sdwDispNm, sdwUserId), 0);
                        rc = 2;
                    }
                } else {
                    StringBuffer addMetadataBuffer = new StringBuffer("<Person DisplayName=\"" + sdwDispNm + "\" Name=\"" + sdwUserNm + "\"></Person>");
                    String addMetadataXML = addMetadataBuffer.toString();
                    rc = MetadatasrvMigrate.addMetadataObject(task, repositoryId, addMetadataXML);
                    if (rc == 0) {
                        task.log(ErrorHandling.generateUserAddedInformation(task, sdwDispNm), 2);
                        rc = MetadatasrvMigrate.createInternalAccount(task, sdwDispNm, sdwUserNm, sdwPasswd);
                        if (rc != 0) {
                            rc = 2;
                        }
                    } else {
                        task.log(ErrorHandling.generateUserAddedError(task, sdwDispNm), 0);
                        rc = 2;
                    }
                }
                if (userSubstring.equalsIgnoreCase("admin") && (rc = MetadatasrvMigrate.assignAdminUsersMembership(task)) != 0) {
                    rc = 2;
                }
                if (!userSubstring.equalsIgnoreCase("demo") && (rc = MetadatasrvMigrate.appendToAdminAndTrustedUsersFiles(task, userSubstring, sdwUserId)) != 0) {
                    rc = 2;
                }
            } else if (personListSize == 1) {
                Map personMap = (Map)personList.get(0);
                String personObjectId = (String)personMap.get("Id");
                boolean dupAccount = adminUserId.equalsIgnoreCase(personObjectId) || demoUserId.equalsIgnoreCase(personObjectId) || trustedUserId.equalsIgnoreCase(personObjectId);
                sasAccountId = personObjectId;
                String personObjectName = (String)personMap.get("Name");
                String personObjectDispName = (String)personMap.get("DisplayName");
                if (!(dupAccount || personObjectName.compareTo(sdwUserNm) == 0 && personObjectDispName.compareTo(sdwDispNm) == 0)) {
                    MetadatasrvMigrate.updatePersonObject(task, sdwDispNm, sdwUserNm, personObjectId);
                    if (rc != 0) {
                        return 2;
                    }
                } else {
                    if (dupAccount) {
                        task.log(ErrorHandling.generatePersonAlreadyUpdated(task, sdwDispNm), 2);
                        return 0;
                    }
                    task.log(ErrorHandling.generatePersonUpdateUnnecessary(task, sdwDispNm), 2);
                }
                xmlSelect = "<XMLSELECT search=\"Login[AssociatedIdentity/Person[@Id='" + personObjectId + "']]\"/>";
                xmlTemplate = "<TEMPLATES><Login Id=\"\" UserID=\"\" Password=\"\"/></TEMPLATES>";
                xmlOptions = xmlSelect + xmlTemplate;
                List externList = MetadatasrvMigrate.getMetadataAttributes(task, "Login", repositoryId, xmlOptions);
                xmlSelect = "<XMLSELECT search=\"InternalLogin[ForIdentity/Person[@Id='" + personObjectId + "']]\"/>";
                xmlTemplate = "<TEMPLATES><InternalLogin Id=\"\" Name=\"\"/></TEMPLATES>";
                xmlOptions = xmlSelect + xmlTemplate;
                List internList = MetadatasrvMigrate.getMetadataAttributes(task, "InternalLogin", repositoryId, xmlOptions);
                if (internList.size() > 0 && (rc = MetadatasrvMigrate.deleteInternalAccount(task, sdwDispNm, sdwUserNm)) != 0) {
                    return 2;
                }
                if (usrAcctTp.equalsIgnoreCase("internal") && !userSubstring.equalsIgnoreCase("demo")) {
                    if (externList.size() > 0) {
                        Map loginMap = (Map)externList.get(0);
                        String loginObjectId = (String)loginMap.get("Id");
                        String loginUserId = (String)loginMap.get("UserID");
                        rc = MetadatasrvMigrate.deleteMetadataObject(task, "Login", loginObjectId);
                        if (rc != 0) {
                            task.log(ErrorHandling.generateLoginDeletedError(task, sdwDispNm, loginUserId), 0);
                            rc = 2;
                        } else {
                            task.log(ErrorHandling.generateLoginDeletedInformation(task, sdwDispNm, loginUserId), 2);
                        }
                    }
                    if ((rc = MetadatasrvMigrate.createInternalAccount(task, sdwDispNm, sdwUserNm, sdwPasswd)) != 0) {
                        rc = 2;
                    }
                } else {
                    rc = MetadatasrvMigrate.locateUserLogin(task, userSubstring, personObjectId, sdwUserId);
                    if (rc != 0) {
                        rc = 2;
                    }
                }
                if (userSubstring.equalsIgnoreCase("admin") && (rc = MetadatasrvMigrate.assignAdminUsersMembership(task)) != 0) {
                    rc = 2;
                }
                if (!userSubstring.equalsIgnoreCase("demo") && (rc = MetadatasrvMigrate.appendToAdminAndTrustedUsersFiles(task, userSubstring, sdwUserId)) != 0) {
                    rc = 2;
                }
            } else {
                task.log(ErrorHandling.generateCandidatePersonError(task, sdwDispNm, sdwUserNm), 1);
                rc = 2;
            }
        } else {
            xmlSelect = "<XMLSELECT search=\"Person[@Name='" + sdwDispNm + "' OR @Name='" + sdwUserNm + "']\"/>";
            xmlTemplate = "<TEMPLATES><Person Id=\"\" DisplayName=\"\" Name=\"\"/></TEMPLATES>";
            xmlOptions = xmlSelect + xmlTemplate;
            personList = MetadatasrvMigrate.getMetadataAttributes(task, "Person", repositoryId, xmlOptions);
            personListSize = personList.size();
            if (personListSize == 1) {
                Map personMap = (Map)personList.get(0);
                String personObjectId = (String)personMap.get("Id");
                boolean dupAccount = adminUserId.equalsIgnoreCase(personObjectId) || demoUserId.equalsIgnoreCase(personObjectId) || trustedUserId.equalsIgnoreCase(personObjectId);
                sasAccountId = personObjectId;
                String personObjectName = (String)personMap.get("Name");
                String personObjectDispName = (String)personMap.get("DisplayName");
                if (!(dupAccount || personObjectName.compareTo(sdwUserNm) == 0 && personObjectDispName.compareTo(sdwDispNm) == 0)) {
                    MetadatasrvMigrate.updatePersonObject(task, sdwDispNm, sdwUserNm, personObjectId);
                    if (rc != 0) {
                        return 2;
                    }
                } else {
                    if (dupAccount) {
                        task.log(ErrorHandling.generatePersonAlreadyUpdated(task, sdwDispNm), 2);
                        return 0;
                    }
                    task.log(ErrorHandling.generatePersonUpdateUnnecessary(task, sdwDispNm), 2);
                }
                String smuUserId = project.getProperty("metadatasrv.old." + userSubstring + ".login.userid");
                xmlSelect = "<XMLSELECT search=\"Login[@UserID='" + smuUserId + "'][AssociatedIdentity/Person[@Id='" + personObjectId + "']]\"/>";
                xmlTemplate = "<TEMPLATES><Login Id=\"\" UserID=\"\" Password=\"\"/></TEMPLATES>";
                xmlOptions = xmlSelect + xmlTemplate;
                List externList = MetadatasrvMigrate.getMetadataAttributes(task, "Login", repositoryId, xmlOptions);
                xmlSelect = "<XMLSELECT search=\"InternalLogin[ForIdentity/Person[@Id='" + personObjectId + "']]\"/>";
                xmlTemplate = "<TEMPLATES><InternalLogin Id=\"\" Name=\"\"/></TEMPLATES>";
                xmlOptions = xmlSelect + xmlTemplate;
                List internList = MetadatasrvMigrate.getMetadataAttributes(task, "InternalLogin", repositoryId, xmlOptions);
                if (internList.size() > 0 && (rc = MetadatasrvMigrate.deleteInternalAccount(task, sdwDispNm, sdwUserNm)) != 0) {
                    return 2;
                }
                if (usrAcctTp.equalsIgnoreCase("internal") && !userSubstring.equalsIgnoreCase("demo")) {
                    if (externList.size() > 0) {
                        Map loginMap = (Map)externList.get(0);
                        String loginObjectId = (String)loginMap.get("Id");
                        String loginUserId = (String)loginMap.get("UserID");
                        rc = MetadatasrvMigrate.deleteMetadataObject(task, "Login", loginObjectId);
                        if (rc != 0) {
                            task.log(ErrorHandling.generateLoginDeletedError(task, sdwDispNm, loginUserId), 0);
                            rc = 2;
                        } else {
                            task.log(ErrorHandling.generateLoginDeletedInformation(task, sdwDispNm, loginUserId), 2);
                        }
                    }
                    if ((rc = MetadatasrvMigrate.createInternalAccount(task, sdwDispNm, sdwUserNm, sdwPasswd)) != 0) {
                        rc = 2;
                    }
                } else {
                    rc = MetadatasrvMigrate.locateUserLogin(task, userSubstring, personObjectId, smuUserId);
                    if (rc != 0) {
                        rc = 2;
                    }
                }
            } else {
                task.log(ErrorHandling.generateMultiplePersonError(task, sdwDispNm), 0);
                rc = 2;
            }
        }
        return rc;
    }

    private static int createInternalAccount(MetadatasrvMigrate task, String displayName, String userName, String password) {
        int rc = 0;
        String logMessage = null;
        try {
            ISecurity_1_1 isecurityConnection = metadataWorkspace.MakeISecurityConnection();
            isecurityConnection.SetInternalPassword(userName, password);
            isecurityConnection.SetInternalLoginUserOptions(userName, false, false, true, true, 0, true, false, false, 0L);
            task.log(ErrorHandling.generateInternalAccountCreatedInformation(task, displayName), 2);
        }
        catch (GenericError ge) {
            logMessage = ge.getLocalizedMessage();
            task.log(logMessage, 0);
            rc = 2;
        }
        catch (MdException mx) {
            exceptionMessage = mx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            logMessage = ErrorHandling.generateMigrationMdException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            rc = 2;
        }
        catch (RemoteException rx) {
            exceptionMessage = rx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            rc = 2;
        }
        return rc;
    }

    private static int deleteInternalAccount(MetadatasrvMigrate task, String displayName, String userName) {
        int rc = 0;
        String logMessage = null;
        try {
            ISecurity_1_1 isecurityConnection = metadataWorkspace.MakeISecurityConnection();
            isecurityConnection.DeleteInternalLogin(userName);
            task.log(ErrorHandling.generateInternalAccountDeletedInformation(task, displayName), 2);
        }
        catch (GenericError ge) {
            exceptionMessage = ge.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            errorMessage = ErrorHandling.generateGenericErrorMessage(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            rc = 2;
        }
        catch (MdException mx) {
            exceptionMessage = mx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            logMessage = ErrorHandling.generateMigrationMdException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            rc = 2;
        }
        catch (RemoteException rx) {
            exceptionMessage = rx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            rc = 2;
        }
        return rc;
    }

    private static int locateUserLogin(MetadatasrvMigrate task, String userSubstring, String personObjectId, String theUserId) {
        int rc = 0;
        String xmlOptions = "";
        String xmlSelect = "";
        String xmlTemplate = "";
        String repositoryId = foundationRepository.getFQID();
        String theDispNm = project.getProperty("oma.person." + userSubstring + ".person.display.name");
        String theUserNm = project.getProperty("oma.person." + userSubstring + ".person.name");
        String sdwUserId = project.getProperty("oma.person." + userSubstring + ".login.userid");
        String defDomain = project.getProperty("iomsrv.metadatasrv.authdomain");
        if (theDispNm == null || theDispNm.length() <= 0) {
            xmlSelect = "<XMLSELECT search=\"Person[@Id='" + personObjectId + "']\"/>";
            xmlTemplate = "<TEMPLATES><Person DisplayName=\"\" Id=\"\" Name=\"\"/></TEMPLATES>";
            xmlOptions = xmlSelect + xmlTemplate;
            List personList = MetadatasrvMigrate.getMetadataAttributes(task, "Person", repositoryId, xmlOptions);
            if (personList.size() == 1) {
                Map personMap = (Map)personList.get(0);
                String string = theDispNm = sourceSasVersion.startsWith("9.1.3") ? (String)personMap.get("Name") : (String)personMap.get("DisplayName");
                theUserNm = sourceSasVersion.startsWith("9.1.3") ? (userSubstring.equalsIgnoreCase("admin") ? "sasadm" : (userSubstring.equalsIgnoreCase("demo") ? "sasdemo" : "sastrust")) : (String)personMap.get("Name");
            }
        }
        xmlSelect = "<XMLSELECT search=\"Login" + (!theUserId.contentEquals("") ? "[@UserID='" + theUserId + "']" : "") + "[AssociatedIdentity/Person[@Id='" + personObjectId + "']][Domain/AuthenticationDomain[@Name='" + defDomain + "']]\"/>";
        xmlTemplate = "<TEMPLATES><Login Id=\"\" UserID=\"\" Password=\"\"><Domain/></Login><AuthenticationDomain Id=\"\" Name=\"\"/></TEMPLATES>";
        xmlOptions = xmlSelect + xmlTemplate;
        List loginList = MetadatasrvMigrate.getMetadataAttributes(task, "Login", repositoryId, xmlOptions);
        String loginObjectId = "";
        if (loginList.size() == 1) {
            Map loginMap = (Map)loginList.get(0);
            loginObjectId = (String)loginMap.get("Id");
            rc = MetadatasrvMigrate.updateLoginObject(task, !userSubstring.equalsIgnoreCase("demo"), sdwUserId, "", theDispNm, loginObjectId);
            if (rc != 0) {
                rc = 2;
            }
        } else {
            rc = MetadatasrvMigrate.assignLoginToUser(task, userSubstring, personObjectId, theDispNm, theUserNm);
        }
        return rc;
    }

    private static int summarizeSasUserAccountLogins(MetadatasrvMigrate task, String userSubstring) {
        int rc = 0;
        String docpartMessage = "";
        String loginAuthDomainMessage = "";
        String xmlOptions = "";
        String xmlSelect = "";
        String xmlTemplate = "";
        String userAccountType = project.getProperty("user.account.type");
        String localizedDocpartFragmentLogin = project.getProperty("instructions_metadatasrv_details_login.txt");
        String localizedDocpartFragmentDomain = project.getProperty("instructions_metadatasrv_details_auth_domain.txt");
        String repositoryId = foundationRepository.getFQID();
        String sdwDispNm = project.getProperty("oma.person." + userSubstring + ".person.display.name");
        String extDispNm = sdwDispNm == null || sdwDispNm.length() <= 0 ? project.getProperty("oma.person." + userSubstring + (userAccountType.equalsIgnoreCase("external") ? ".person.display.name.external" : ".person.display.name.internal")) : sdwDispNm;
        String sdwUserNm = project.getProperty("oma.person." + userSubstring + ".person.name");
        String extUserNm = sdwUserNm == null || sdwUserNm.length() <= 0 ? project.getProperty("oma.person." + userSubstring + ".person.name.external") : sdwUserNm;
        String sdwUserId = project.getProperty("oma.person." + userSubstring + ".login.userid");
        String defDomain = userAccountType.equalsIgnoreCase("external") || userSubstring.equalsIgnoreCase("demo") ? project.getProperty("iomsrv.metadatasrv.authdomain") : "";
        xmlSelect = "<XMLSELECT search=\"Person[@Name='" + extUserNm + "']\"/>";
        xmlTemplate = "<TEMPLATES><Person Id=\"\" DisplayName=\"\" Name=\"\"/></TEMPLATES>";
        xmlOptions = xmlSelect + xmlTemplate;
        List personList = MetadatasrvMigrate.getMetadataAttributes(task, "Person", repositoryId, xmlOptions);
        if (personList.size() == 1) {
            Map personMap = (Map)personList.get(0);
            String personObjectId = (String)personMap.get("Id");
            xmlSelect = "<XMLSELECT search=\"Login[@UserID='" + sdwUserId + "'][AssociatedIdentity/Person[@Id='" + personObjectId + "']][Domain/AuthenticationDomain[@Name='" + defDomain + "']]\"/>";
            xmlTemplate = "<TEMPLATES><Login Id=\"\" UserID=\"\" Password=\"\"><Domain/></Login><AuthenticationDomain Id=\"\" Name=\"\"/></TEMPLATES>";
            xmlOptions = xmlSelect + xmlTemplate;
            List externList = MetadatasrvMigrate.getMetadataAttributes(task, "Login", repositoryId, xmlOptions);
            xmlSelect = "<XMLSELECT search=\"InternalLogin[ForIdentity/Person[@Id='" + personObjectId + "']]\"/>";
            xmlTemplate = "<TEMPLATES><InternalLogin Id=\"\" Name=\"\"/></TEMPLATES>";
            xmlOptions = xmlSelect + xmlTemplate;
            List internList = MetadatasrvMigrate.getMetadataAttributes(task, "InternalLogin", repositoryId, xmlOptions);
            if (externList.size() == 1 || internList.size() > 0) {
                task.log(userSubstring.equalsIgnoreCase("admin") ? ErrorHandling.generateAdminAccountSummary(task, extDispNm, sdwUserId, defDomain) : (userSubstring.equalsIgnoreCase("demo") ? ErrorHandling.generateDemoAccountSummary(task, extDispNm, sdwUserId, defDomain) : ErrorHandling.generateTrustedAccountSummary(task, extDispNm, sdwUserId, defDomain)), 2);
                Map loginMap = externList.size() == 1 ? (Map)externList.get(0) : (Map)internList.get(0);
                String loginObjectId = (String)loginMap.get("Id");
                xmlSelect = "<XMLSELECT search=\"Login[AssociatedIdentity/Person[@Id='" + personObjectId + "']]\"/>";
                xmlTemplate = "<TEMPLATES><Login Id=\"\" UserID=\"\" Password=\"\"><Domain/></Login><AuthenticationDomain Id=\"\" Name=\"\"/></TEMPLATES>";
                xmlOptions = xmlSelect + xmlTemplate;
                List docpartList = MetadatasrvMigrate.getMetadataAttributes(task, "Login", repositoryId, xmlOptions);
                for (int i = 0; i < docpartList.size(); ++i) {
                    String authDomainName;
                    Map docpartMap = (Map)docpartList.get(i);
                    String docpartLoginObjectId = (String)docpartMap.get("Id");
                    if (loginObjectId.length() > 0 && loginObjectId.equalsIgnoreCase(docpartLoginObjectId)) continue;
                    String loginUserId = (String)docpartMap.get("UserID");
                    List domainList = (List)docpartMap.get("Domain");
                    if (domainList != null && domainList.size() > 0) {
                        Map domainMap = (Map)domainList.get(0);
                        authDomainName = (String)domainMap.get("Name");
                    } else {
                        authDomainName = "";
                    }
                    if (docpartMessage.length() == 0) {
                        docpartMessage = "<ol> ${line.separator}";
                        task.log(ErrorHandling.generateAccountLoginListSummary(task), 2);
                    }
                    loginAuthDomainMessage = ErrorHandling.generateAccountDocpartFragmentLogin(task, localizedDocpartFragmentLogin, loginUserId);
                    if (authDomainName.length() > 0 && !authDomainName.equalsIgnoreCase("")) {
                        loginAuthDomainMessage = loginAuthDomainMessage + ErrorHandling.generateAccountDocpartFragmentAuthDomain(task, localizedDocpartFragmentDomain, authDomainName);
                    }
                    docpartMessage = docpartMessage + "<li>" + loginAuthDomainMessage + "</li> ${line.separator}";
                    loginAuthDomainMessage = ErrorHandling.generateAccountDocpartLoginList(task, loginUserId, authDomainName);
                    task.log(loginAuthDomainMessage, 2);
                }
            }
        }
        String propertyName = "metadatasrv.instructions.details." + userSubstring + ".name";
        project.setProperty(propertyName, extDispNm);
        loginAuthDomainMessage = ErrorHandling.generateAccountDocpartFragmentLogin(task, localizedDocpartFragmentLogin, sdwUserId);
        if (defDomain.length() > 0 && !defDomain.equalsIgnoreCase("")) {
            loginAuthDomainMessage = loginAuthDomainMessage + ErrorHandling.generateAccountDocpartFragmentAuthDomain(task, localizedDocpartFragmentDomain, defDomain);
        }
        propertyName = "metadatasrv.instructions.details." + userSubstring + ".sdwlogin";
        project.setProperty(propertyName, loginAuthDomainMessage);
        docpartMessage = docpartMessage + (docpartMessage.length() > 0 ? "</ol></li> ${line.separator}" : "");
        propertyName = "metadatasrv.instructions.details." + userSubstring + ".loginlist";
        project.setProperty(propertyName, docpartMessage);
        return rc;
    }

    private static int addLoginObject(MetadatasrvMigrate task, String displayName, String userId) {
        String domainAttribute;
        int rc = 0;
        String repositoryId = foundationRepository.getFQID();
        String defDomain = project.getProperty("iomsrv.metadatasrv.authdomain");
        String xmlSelect = "<XMLSELECT search=\"AuthenticationDomain[@Name='" + defDomain + "']]\"/>";
        String xmlTemplate = "<TEMPLATES><AuthenticationDomain Id=\"\" Name=\"\"/></TEMPLATES>";
        String xmlOptions = xmlSelect + xmlTemplate;
        List domainList = MetadatasrvMigrate.getMetadataAttributes(task, "AuthenticationDomain", repositoryId, xmlOptions);
        if (domainList.size() == 1) {
            Map domainMap = (Map)domainList.get(0);
            String domainObjectId = (String)domainMap.get("Id");
            domainAttribute = "ObjRef='" + domainObjectId;
        } else {
            domainAttribute = "Name='" + defDomain;
        }
        String addMetadataXML = "<Login Name='Login." + displayName + "' UserId='" + userId + "'><Domain><AuthenticationDomain " + domainAttribute + "'/></Domain></Login>";
        rc = MetadatasrvMigrate.addMetadataObject(task, repositoryId, addMetadataXML);
        if (rc != 0) {
            task.log(ErrorHandling.generateLoginAddedError(task, displayName, userId), 0);
            rc = 2;
        } else {
            task.log(ErrorHandling.generateLoginAddedInformation(task, displayName, userId), 2);
        }
        return rc;
    }

    private static int assignLoginToUser(MetadatasrvMigrate task, String userSubstring, String personObjectId, String displayName, String objectName) {
        int rc = 0;
        String sdwUserId = project.getProperty("oma.person." + userSubstring + ".login.userid");
        rc = MetadatasrvMigrate.addLoginObject(task, displayName, sdwUserId);
        if (rc == 0) {
            String repositoryId = foundationRepository.getFQID();
            String defDomain = project.getProperty("iomsrv.metadatasrv.authdomain");
            String xmlSelect = "<XMLSELECT search=\"Login[@UserID='" + sdwUserId + "'][Domain/AuthenticationDomain[@Name='" + defDomain + "']]\"/>";
            String xmlTemplate = "<TEMPLATES><Login Id=\"\" UserID=\"\" Password=\"\"><Domain/></Login><AuthenticationDomain Id=\"\" Name=\"\"/></TEMPLATES>";
            String xmlOptions = xmlSelect + xmlTemplate;
            List loginList = MetadatasrvMigrate.getMetadataAttributes(task, "Login", repositoryId, xmlOptions);
            if (loginList.size() == 1) {
                Map loginMap = (Map)loginList.get(0);
                String loginObjectId = (String)loginMap.get("Id");
                String updateLoginXML = "<Login Id='" + loginObjectId + "'><AssociatedIdentity><Person " + (personObjectId == null || personObjectId.length() <= 0 ? "DisplayName='" + displayName + "' Name='" + objectName : "ObjRef='" + personObjectId) + "'/></AssociatedIdentity></Login>";
                rc = MetadatasrvMigrate.updateMetadataAssociations(task, updateLoginXML);
                if (personObjectId == null || personObjectId.length() <= 0) {
                    if (rc != 0) {
                        task.log(ErrorHandling.generateLoginUpdatedError(task, displayName, sdwUserId), 0);
                    } else {
                        task.log(ErrorHandling.generateLoginUpdatedInformation(task, displayName, sdwUserId), 2);
                    }
                }
                if (rc != 0) {
                    rc = 2;
                }
            }
        } else {
            task.log(ErrorHandling.generateLoginAddedError(task, displayName, sdwUserId), 0);
            rc = 2;
        }
        return rc;
    }

    private static int updateLoginObject(MetadatasrvMigrate task, boolean setPasswordFlag, String userId, String password, String displayName, String loginObjectId) {
        int rc = 0;
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<String> valueList = new ArrayList<String>();
        Object logMessage = null;
        nameList.add("UserID");
        valueList.add(userId);
        rc = MetadatasrvMigrate.updateMetadataAttributes(task, "Login", loginObjectId, nameList, valueList);
        if (rc != 0) {
            task.log(ErrorHandling.generateLoginUpdatedError(task, displayName, userId), 0);
            rc = 2;
        } else {
            task.log(ErrorHandling.generateLoginUpdatedInformation(task, displayName, userId), 2);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int updateMachineAssociation(MetadatasrvMigrate task, String serverComponentId, String serverComponentName, String sourceMachineId, String sourceMachineName) {
        int rc = 0;
        String repositoryId = foundationRepository.getFQID();
        String metadataServerHost = project.getProperty("iomsrv.metadatasrv.host");
        String xmlSelect = "<XMLSELECT search=\"Machine[@Name='" + metadataServerHost + "']\"/>";
        String xmlTemplate = "<TEMPLATES><Machine Id=\"\" Name=\"\"/></TEMPLATES>";
        String xmlOptions = xmlSelect + xmlTemplate;
        List machineList = MetadatasrvMigrate.getMetadataAttributes(task, "Machine", repositoryId, xmlOptions);
        if (machineList.size() != 0 && !sourceMachineId.equalsIgnoreCase("")) {
            Map machineMap = (Map)machineList.get(0);
            String machineId = (String)machineMap.get("Id");
            String machineName = (String)machineMap.get("Name");
            String updateAssociatedMachineXML = "<ServerComponent Id='" + serverComponentId + "'><AssociatedMachine function='Replace'><Machine ObjRef='" + machineId + "'/></AssociatedMachine></ServerComponent>";
            rc = MetadatasrvMigrate.updateMetadataAssociations(task, updateAssociatedMachineXML);
            if (rc != 0) {
                task.log(ErrorHandling.generateServerHostWarning(task, metadataServerHost, serverComponentName), 1);
                rc = 1;
            } else {
                task.log(ErrorHandling.generateAssignedServerHost(task, metadataServerHost, serverComponentName), 2);
            }
        } else {
            if (sourceMachineId.equalsIgnoreCase("")) {
                StringBuffer addMetadataBuffer = new StringBuffer("<Machine Name=\"" + metadataServerHost + "\"><DeployedComponents><ServerComponent ObjRef=\"" + serverComponentId + "\"/></DeployedComponents></Machine>");
                String addMetadataXML = addMetadataBuffer.toString();
                rc = MetadatasrvMigrate.addMetadataObject(task, repositoryId, addMetadataXML);
            } else {
                String updateAssociatedMachineXML = "<ServerComponent Id='" + serverComponentId + "'><AssociatedMachine function='Replace'><Machine Name='" + metadataServerHost + "'/></AssociatedMachine></ServerComponent>";
                rc = MetadatasrvMigrate.updateMetadataAssociations(task, updateAssociatedMachineXML);
            }
            if (rc != 0) {
                task.log(ErrorHandling.generateServerHostWarning(task, metadataServerHost, serverComponentName), 1);
                rc = 1;
            } else {
                task.log(ErrorHandling.generateAssignedServerHost(task, metadataServerHost, serverComponentName), 2);
            }
        }
        if (!sourceMachineId.equalsIgnoreCase("")) {
            String logMessage;
            MdObjectStore machineStore = null;
            try {
                AssociationList deployedComponentsList;
                int deployedComponentsListSize;
                machineStore = mdFactory.createObjectStore(null, "MdObjectStore::updateMachineAssociation");
                ArrayList emptySimpleAttributeList = new ArrayList(0);
                ArrayList emptyComplexObjectList = new ArrayList(0);
                xmlTemplate = "<TEMPLATES><Machine Id=\"\" Name=\"\"><DeployedComponents/><Trees/></Machine><Tree Id=\"\" Name=\"\"/></TEMPLATES>";
                int omiFlags = 4;
                Machine machine = (Machine)mdFactory.getOMIUtil().getMetadataAllDepths((MdStore)machineStore, "Machine", sourceMachineId, emptySimpleAttributeList, emptyComplexObjectList, xmlTemplate, omiFlags);
                boolean deleteMachine = true;
                AssociationList treesList = machine.getTrees();
                int treesListSize = treesList.size();
                if (treesListSize > 0) {
                    for (int i = 0; i < treesList.size(); ++i) {
                        Tree tree = (Tree)treesList.get(i);
                        if (!tree.getName().equalsIgnoreCase("MachineGroup")) continue;
                        deleteMachine = false;
                        break;
                    }
                }
                if ((deployedComponentsListSize = (deployedComponentsList = machine.getDeployedComponents()).size()) == 0 && deleteMachine && (rc = MetadatasrvMigrate.deleteMetadataObject(task, "Machine", sourceMachineId)) == 0) {
                    task.log(ErrorHandling.generateMetadataObjectDeleted(task, "Machine", sourceMachineName, sourceMachineId), 2);
                }
            }
            catch (MdException mx) {
                exceptionMessage = mx.getLocalizedMessage();
                if (exceptionMessage == null) {
                    exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
                }
                logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
                task.log(logMessage, 0);
                int n = 2;
                return n;
            }
            catch (RemoteException rx) {
                exceptionMessage = rx.getLocalizedMessage();
                if (exceptionMessage == null) {
                    exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
                }
                logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
                task.log(logMessage, 0);
                int n = 2;
                return n;
            }
            finally {
                try {
                    if (machineStore != null) {
                        machineStore.dispose();
                    }
                }
                catch (RemoteException rx) {
                    exceptionMessage = rx.getLocalizedMessage();
                    if (exceptionMessage == null) {
                        exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
                    }
                    logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
                    task.log(logMessage, 0);
                    return 1;
                }
            }
        }
        return rc;
    }

    private static int updatePersonObject(MetadatasrvMigrate task, String displayName, String objectName, String personObjectId) {
        int rc = 0;
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<String> valueList = new ArrayList<String>();
        nameList.add("DisplayName");
        valueList.add(displayName);
        nameList.add("Name");
        valueList.add(objectName);
        rc = MetadatasrvMigrate.updateMetadataAttributes(task, "Person", personObjectId, nameList, valueList);
        if (rc != 0) {
            task.log(ErrorHandling.generatePersonUpdatedError(task, displayName), 0);
            rc = 2;
        }
        task.log(ErrorHandling.generatePersonUpdatedInformation(task, displayName), 2);
        return rc;
    }

    private static int addMetadataObject(MetadatasrvMigrate task, String repositoryId, String inXML) {
        int omiFlags = 0x10000000;
        int rc = 0;
        String logMessage = null;
        StringHolder outXML = new StringHolder();
        int repositoryIndex = repositoryId.indexOf(".");
        String shortRepositoryId = repositoryIndex > 0 ? repositoryId.substring(repositoryIndex + 1, repositoryId.length()) : repositoryId;
        try {
            rc = mdFactory.getOMIUtil().addMetadata(inXML, shortRepositoryId, outXML, omiFlags);
        }
        catch (MdException mx) {
            exceptionMessage = mx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            logMessage = ErrorHandling.generateMigrationMdException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            rc = 2;
        }
        catch (RemoteException rx) {
            exceptionMessage = rx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            rc = 2;
        }
        return rc;
    }

    private static int deleteMetadataObject(MetadatasrvMigrate task, String metadataType, String objectId) {
        int rc = 0;
        String logMessage = null;
        try {
            mdFactory.getOMIUtil().deleteMetadataObject(metadataType, objectId);
        }
        catch (MdException mx) {
            exceptionMessage = mx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            logMessage = ErrorHandling.generateMigrationMdException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            rc = 2;
        }
        catch (RemoteException rx) {
            exceptionMessage = rx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            rc = 2;
        }
        return rc;
    }

    private static List getMetadataAttributes(MetadatasrvMigrate task, String metadataType, String repositoryId, String xmlOptions) {
        int omiFlags = 388;
        List objectList = MetadatasrvMigrate.getMetadataObjectsUncached(task, metadataType, repositoryId, xmlOptions, omiFlags);
        return objectList;
    }

    private static List getMetadataObjectsUncached(MetadatasrvMigrate task, String metadataType, String repositoryId, String xmlOptions, int omiFlags) {
        List objectList = null;
        String logMessage = null;
        int localFlags = metadataType.equalsIgnoreCase("Root") ? omiFlags | 0x10 : omiFlags;
        try {
            objectList = mdFactory.getOMIUtil().getMetadataObjectsNoCache(metadataType, repositoryId, xmlOptions, localFlags);
        }
        catch (MdException mx) {
            exceptionMessage = mx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            logMessage = ErrorHandling.generateMigrationMdException(task) + "  " + exceptionMessage;
            task.log(logMessage, 1);
        }
        catch (RemoteException rx) {
            exceptionMessage = rx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
            task.log(logMessage, 1);
        }
        catch (Exception ex) {
            exceptionMessage = ex.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            logMessage = ErrorHandling.generateMigrationQueryException(task) + "  " + exceptionMessage;
            task.log(logMessage, 1);
        }
        return objectList;
    }

    private static int updateMetadataAttributes(MetadatasrvMigrate task, String metadataType, String objectId, List attributes, List values) {
        int rc = 0;
        String logMessage = null;
        try {
            mdFactory.getOMIUtil().updateMetadataSimple(metadataType, objectId, attributes, values);
        }
        catch (MdException mx) {
            exceptionMessage = mx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            logMessage = ErrorHandling.generateMigrationMdException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            rc = 2;
        }
        catch (RemoteException rx) {
            exceptionMessage = rx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            rc = 2;
        }
        return rc;
    }

    private static int updateMetadataAssociations(MetadatasrvMigrate task, String inXML) {
        int iFlags = 0;
        int rc = 0;
        String logMessage = null;
        StringHolder outXML = new StringHolder();
        try {
            rc = mdFactory.getOMIUtil().updateMetadata(inXML, outXML, iFlags);
        }
        catch (MdException mx) {
            exceptionMessage = mx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            logMessage = ErrorHandling.generateMigrationMdException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            rc = 2;
        }
        catch (RemoteException rx) {
            exceptionMessage = rx.getLocalizedMessage();
            if (exceptionMessage == null) {
                exceptionMessage = ErrorHandling.generateMigrationExceptionDisclaimer(task);
            }
            logMessage = ErrorHandling.generateMigrationRemoteException(task) + "  " + exceptionMessage;
            task.log(logMessage, 0);
            rc = 2;
        }
        return rc;
    }

    static {
        adminUsersPath = null;
        processLogPath = null;
        rposMgrPath = null;
        rposLocPath = null;
        sasInstallPath = null;
        sourceMachineType = null;
        sourceSasVersion = null;
        targetMachineType = null;
        targetOsType = null;
        targetSasVersion = null;
        fileEncoding = null;
        sasEncoding = null;
        foundationRepository = null;
        repositoryArray = null;
        administratorGroupId = "";
        administratorGroupName = "";
        unrestrictedGroupId = "";
        unrestrictedGroupName = "";
        adminUserId = "";
        demoUserId = "";
        trustedUserId = "";
        sasAccountId = "";
        unrestrictedCharacter = "";
        m_host = null;
        m_port = null;
        m_user = null;
        m_password = null;
        m_phase = null;
        omiConnection = null;
        metadataWorkspace = null;
        returnCode = 0;
        errorMessage = null;
        exceptionMessage = null;
        sdwDebugMode = false;
    }
}

