/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.util.AbstractFileTransformer;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import org.apache.tools.ant.Task;

public class LoggerPropertiesExpander
extends AbstractFileTransformer {
    @Override
    public void transformFile(Task task, String source, String destination) throws WebAppConfigException {
        BufferedReader infile = this.openInputFile(task, source);
        BufferedWriter outfile = this.openOutputFile(task, destination, infile);
        try {
            String line = null;
            while (null != (line = infile.readLine())) {
                line = CommonUtils.replaceAll(line, "\\", "\\\\");
                outfile.write(line);
                outfile.newLine();
            }
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotProcessSubstitutionsErrorMessage(task, source, destination), e);
        }
        finally {
            CommonUtils.closeWriter(outfile);
            CommonUtils.closeReader(infile);
        }
    }
}

