/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.Logger;
import java.io.BufferedWriter;
import java.io.IOException;
import org.apache.tools.ant.Task;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

final class LoggerPropertiesEditorHandler
extends DefaultHandler
implements LexicalHandler {
    private static final String _TAB = "    ";
    private static final String _ROOT_LOGGING_CONTEXT_ELEMENT_NAME = "RootLoggingContext";
    private static final String _OPEN_COMMENT = "<!--";
    private static final String _CLOSE_COMMENT = "-->";
    private static final String _OPEN_START_ELEMENT = "<";
    private static final String _OPEN_END_ELEMENT = "</";
    private static final String _CLOSE_ELEMENT = ">";
    private static final String _EQUALS_QUOTE = "=\"";
    private static final String _QUOTE = "\"";
    private static final String _SPACE = " ";
    private static final String _XML_VERSION_1_0_ENCODING_UTF_8 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private Task _task;
    private int _suppressOutput;
    private BufferedWriter _writer;
    private int _indentLevel;

    LoggerPropertiesEditorHandler(Task task) {
        this._task = task;
        this._suppressOutput = 0;
        this._writer = null;
        this._indentLevel = 0;
    }

    @Override
    public void startDocument() throws SAXException {
        this.writeBOL();
        this.writeString(_XML_VERSION_1_0_ENCODING_UTF_8);
        this.writeEOL();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.detectRootLoggingContext(localName)) {
            this.suspendWriting();
        }
        this.writeBOL();
        this.writeString(_OPEN_START_ELEMENT);
        this.writeString(localName);
        int attributesCount = attributes.getLength();
        for (int k = 0; k < attributesCount; ++k) {
            this.writeString(_SPACE);
            this.writeString(attributes.getLocalName(k));
            this.writeString(_EQUALS_QUOTE);
            this.writeString(attributes.getValue(k));
            this.writeString(_QUOTE);
        }
        this.writeString(_CLOSE_ELEMENT);
        this.writeEOL();
        this.increaseIndentLevel();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.decreaseIndentLevel();
        this.writeBOL();
        this.writeString(_OPEN_END_ELEMENT);
        this.writeString(localName);
        this.writeString(_CLOSE_ELEMENT);
        this.writeEOL();
        if (this.detectRootLoggingContext(localName)) {
            this.permitWriting();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.writeCharacters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.writeCharacters(ch, start, length);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.writeBOL();
        this.writeString(_OPEN_COMMENT);
        this.writeString(new String(ch, start, length));
        this.writeString(_CLOSE_COMMENT);
        this.writeEOL();
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.log(1, e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.log(0, e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.log(0, e);
    }

    void setWriter(BufferedWriter outputFile) {
        this._writer = outputFile;
    }

    private void writeCharacters(char[] ch, int start, int length) throws SAXException {
        String charData = new String(ch, start, length);
        if (!CommonUtils.isEmpty(charData)) {
            this.writeString(charData);
        }
    }

    private void writeBOL() throws SAXException {
        for (int j = 0; j < this._indentLevel; ++j) {
            this.writeString(_TAB);
        }
    }

    private void writeEOL() throws SAXException {
        if (!this.writingIsSuspended()) {
            try {
                this._writer.newLine();
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    private void writeString(String output) throws SAXException {
        if (!this.writingIsSuspended()) {
            try {
                this._writer.write(output);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
    }

    private boolean writingIsSuspended() {
        return this._suppressOutput != 0;
    }

    private void suspendWriting() {
        ++this._suppressOutput;
    }

    private void permitWriting() {
        if (this.writingIsSuspended()) {
            --this._suppressOutput;
        }
    }

    private boolean detectRootLoggingContext(String localName) {
        return _ROOT_LOGGING_CONTEXT_ELEMENT_NAME.equals(localName);
    }

    private void log(int level, SAXParseException e) throws SAXException {
        Logger.log(level, this._task, e);
        if (0 == level) {
            throw e;
        }
    }

    private void increaseIndentLevel() {
        ++this._indentLevel;
    }

    private void decreaseIndentLevel() {
        --this._indentLevel;
    }
}

