/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.tasks.LoggerPropertiesEditorHandler;
import com.sas.tools.webappconfig.util.AbstractFileTransformer;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import org.apache.tools.ant.Task;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class LoggerPropertiesEditor
extends AbstractFileTransformer {
    private LoggerPropertiesEditorHandler _handler;

    LoggerPropertiesEditor(Task task) {
        this._handler = new LoggerPropertiesEditorHandler(task);
    }

    @Override
    public void transformFile(Task task, String source, String destination) throws WebAppConfigException {
        BufferedReader openInputFile = this.openInputFile(task, source);
        BufferedWriter outputFile = this.openOutputFile(task, destination, openInputFile);
        this._handler.setWriter(outputFile);
        try {
            XMLReader reader = this.getXMLReader();
            reader.setContentHandler(this._handler);
            reader.setDTDHandler(this._handler);
            reader.setEntityResolver(this._handler);
            reader.setErrorHandler(this._handler);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", this._handler);
            reader.parse(new InputSource(openInputFile));
        }
        catch (SAXException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotProcessScriptErrorMessage(task, source), e);
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotProcessScriptErrorMessage(task, source), e);
        }
        finally {
            CommonUtils.closeReader(openInputFile);
            CommonUtils.closeWriter(outputFile);
        }
    }

    private XMLReader getXMLReader() throws SAXException {
        XMLReader reader;
        try {
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            reader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
        }
        return reader;
    }
}

