/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.app.PickList;
import com.sas.app.Plugin;
import com.sas.app.Repository;
import com.sas.app.VersionSpec;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.tools.ant.Task;

public class LoadVJR
extends TaskImpl {
    private static final String _DEFAULT_OPTIONS = "notaint";
    private static final String _OPTIONS_ATTR = "options";
    private static final String _OPTIONS_VARNAME = "sas.app.repository.options";
    private static final String _PLUGINS_FOLDER = "plugins";
    private static final String _ECLIPSE_FOLDER = "eclipse";
    private static final String _PATH_VARNAME = "sas.app.repository.path";
    private long _subtaskTimeout = 0L;
    private File _reportFile = null;
    private BufferedWriter _writer = null;
    private static final String _LS = System.getProperty("line.separator");

    @Override
    protected boolean doWork() throws WebAppConfigException {
        File destination = this.getDirectory();
        this.setPathVar();
        this.setOptions();
        Plugin[] plugins = this.getPlugins(this.getRepository(), this.readPickList());
        this.openWriter();
        this.writeLine("<files>");
        for (int i = 0; i < plugins.length; ++i) {
            this.processPlugin(destination, plugins[i]);
        }
        this.writeLine("</files>");
        CommonUtils.closeWriter(this._writer);
        return true;
    }

    private void openWriter() throws WebAppConfigException {
        if (null != this._reportFile) {
            try {
                this._writer = CommonUtils.getUTF8Writer(this, this._reportFile.getCanonicalPath());
            }
            catch (IOException e) {
                throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, this._reportFile), e);
            }
        }
    }

    private void writeLine(String line) throws WebAppConfigException {
        if (null == this._writer) {
            return;
        }
        try {
            this._writer.write(line);
            this._writer.write(_LS);
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotWriteToFileErrorMessage(this, this._reportFile), e);
        }
    }

    public final void setTimeoutSeconds(long timeout) {
        this._subtaskTimeout = 1000L * timeout;
    }

    public final void setReportFile(File reportFile) {
        this._reportFile = reportFile;
    }

    private void setOptions() throws WebAppConfigException {
        String currentValue = System.getProperty(_OPTIONS_VARNAME);
        if (!CommonUtils.isEmpty(currentValue)) {
            Logger.log(3, this, "sas.app.repository.options = " + currentValue);
            return;
        }
        String newValue = _DEFAULT_OPTIONS;
        if (this.paramExists(_OPTIONS_ATTR)) {
            newValue = this.getValue(_OPTIONS_ATTR);
        }
        Logger.log(3, this, "Setting sas.app.repository.options = " + newValue);
        System.setProperty(_OPTIONS_VARNAME, newValue);
    }

    private void setPathVar() throws WebAppConfigException {
        String currentValue = System.getProperty(_PATH_VARNAME);
        if (!CommonUtils.isEmpty(currentValue)) {
            Logger.log(3, this, "sas.app.repository.path = " + currentValue);
            return;
        }
        if (!this.paramExists("source")) {
            return;
        }
        String[] sources = CommonUtils.parsePath(this.getValue("source"));
        HashSet subfolders = new HashSet();
        for (int i = 0; i < sources.length; ++i) {
            String sourceFileName = sources[i];
            File vjrSource = new File(sourceFileName);
            CommonUtils.ensureDirectoryExists(this, vjrSource);
            subfolders.addAll(this.getAppropriateSubfolders(vjrSource));
        }
        if (subfolders.isEmpty()) {
            return;
        }
        int bufferLength = 0;
        int pathSeparatorLength = File.pathSeparator.length();
        Iterator iter = subfolders.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            bufferLength += path.length();
            if (!iter.hasNext()) continue;
            bufferLength += pathSeparatorLength;
        }
        StringBuffer builder = new StringBuffer(bufferLength);
        Iterator iter2 = subfolders.iterator();
        while (iter2.hasNext()) {
            builder.append(iter2.next());
            if (!iter2.hasNext()) continue;
            builder.append(File.pathSeparator);
        }
        System.setProperty(_PATH_VARNAME, builder.toString());
        Logger.log(3, this, "Setting sas.app.repository.path = " + builder.toString());
    }

    private Set getAppropriateSubfolders(File vjrSource) throws WebAppConfigException {
        HashSet subfolders = new HashSet();
        this.getSubfolders(subfolders, vjrSource);
        HashSet<String> appropriateSubFolders = new HashSet<String>();
        for (File file : subfolders) {
            File parent;
            if (!file.getName().equals(_PLUGINS_FOLDER) || !(parent = file.getParentFile()).getName().equals(_ECLIPSE_FOLDER)) continue;
            try {
                appropriateSubFolders.add(parent.getCanonicalPath());
            }
            catch (IOException e) {
                String message = ErrorHandling.generateCannotReadFileErrorMessage((Task)this, parent);
                throw new WebAppConfigException(message, e);
            }
        }
        return appropriateSubFolders;
    }

    private void getSubfolders(Set subfolders, File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.isDirectory()) continue;
            subfolders.add(file);
            this.getSubfolders(subfolders, file);
        }
    }

    private Plugin[] getPlugins(Repository repository, PickList picklist) throws WebAppConfigException {
        try {
            PluginFetcher fetcher = new PluginFetcher(this, repository, picklist, this._subtaskTimeout);
            fetcher.waitForThreadCompletion();
            return (Plugin[])fetcher.getReturnValue();
        }
        catch (Throwable e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotFindContentInVJRErrorMessage(this), e);
        }
    }

    private File getDirectory() throws WebAppConfigException {
        File output = new File(this.getValue("destination"));
        CommonUtils.ensureDirectoryExists(this, output);
        return output;
    }

    private void processPlugin(File destination, Plugin plugin) throws WebAppConfigException {
        String pluginName = plugin.getName();
        VersionSpec pluginVersion = plugin.getVersion();
        Logger.log(2, this, ErrorHandling.generateLoadingVersionedJarInfoMessage(this, pluginName, pluginVersion));
        this.processFileFromVJR(destination, plugin.getFile(), ErrorHandling.getVersionSpecDescription(pluginVersion));
    }

    private void processFileFromVJR(File destination, File content, String versionDescription) throws WebAppConfigException {
        if (content.isDirectory()) {
            this.processFolder(content, destination, versionDescription);
        } else {
            Logger.log(3, this, ErrorHandling.generateLoadingVersionedJarFileInfoMessage(this, content));
            CommonUtils.copyToDir(this, content, destination, true);
            this.log(content, versionDescription);
        }
    }

    private void log(File content, String versionDescription) throws WebAppConfigException {
        String[] pieces = new String[]{"  <file name=\"", content.getName(), "\" version=\"", versionDescription, "\"/>"};
        int length = 0;
        for (int i = 0; i < pieces.length; ++i) {
            length += pieces[i].length();
        }
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < pieces.length; ++i) {
            buffer.append(pieces[i]);
        }
        this.writeLine(buffer.toString());
    }

    private void processFolder(File folder, File destination, String versionDescription) throws WebAppConfigException {
        if (folder.getName().equals("META-INF")) {
            return;
        }
        File[] contents = folder.listFiles();
        for (int i = 0; i < contents.length; ++i) {
            this.processFileFromVJR(destination, contents[i], versionDescription);
        }
    }

    private Repository getRepository() throws WebAppConfigException {
        try {
            RepositoryFetcher fetcher = new RepositoryFetcher(this, this._subtaskTimeout);
            fetcher.waitForThreadCompletion();
            return (Repository)fetcher.getReturnValue();
        }
        catch (Throwable e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotAccessVJRErrorMessage(this), e);
        }
    }

    private PickList readPickList() throws WebAppConfigException {
        String pickListFileName = this.getValue("picklist");
        InputStream s = this.openPicklist(pickListFileName);
        try {
            PicklistReader reader = new PicklistReader(this, s, pickListFileName, this._subtaskTimeout);
            reader.waitForThreadCompletion();
            PickList pickList = (PickList)reader.getReturnValue();
            return pickList;
        }
        catch (Throwable t) {
            throw (WebAppConfigException)t;
        }
        finally {
            CommonUtils.closeInputStream(s);
        }
    }

    private InputStream openPicklist(String pickListFileName) throws WebAppConfigException {
        try {
            return new FileInputStream(pickListFileName);
        }
        catch (FileNotFoundException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, pickListFileName), e);
        }
    }

    private static class PicklistReader
    extends WorkerThread {
        private InputStream _stream;
        private String _filename;
        private PickList _picklist;

        PicklistReader(Task task, InputStream stream, String filename, long timeout) {
            super(task, timeout);
            this._stream = stream;
            this._filename = filename;
            this._picklist = null;
        }

        @Override
        protected void acquireContent() throws WebAppConfigException {
            try {
                this._picklist = new PickList(this._stream);
            }
            catch (Throwable e) {
                throw new WebAppConfigException(ErrorHandling.generateCannotReadFileErrorMessage(this.getTask(), this._filename), e);
            }
        }

        @Override
        protected Object getContent() {
            return this._picklist;
        }

        @Override
        protected WebAppConfigException processMissingContent() {
            return new WebAppConfigException(ErrorHandling.generateTimeoutReadingPicklistErrorMessage(this.getTask()), null);
        }
    }

    private static class RepositoryFetcher
    extends WorkerThread {
        private Repository _repository = null;

        RepositoryFetcher(Task task, long timeout) {
            super(task, timeout);
        }

        @Override
        protected void acquireContent() throws WebAppConfigException {
            try {
                this._repository = Repository.getDefaultRepository();
            }
            catch (Throwable e) {
                throw new WebAppConfigException(ErrorHandling.generateCannotAccessVJRErrorMessage(this.getTask()), e);
            }
        }

        @Override
        protected Object getContent() {
            return this._repository;
        }

        @Override
        protected WebAppConfigException processMissingContent() {
            return new WebAppConfigException(ErrorHandling.generateTimeoutAccessingRepositoryErrorMessage(this.getTask()), null);
        }
    }

    private static class PluginFetcher
    extends WorkerThread {
        private Plugin[] _plugins = null;
        private Repository _repository;
        private PickList _picklist;

        PluginFetcher(Task task, Repository repository, PickList picklist, long timeout) {
            super(task, timeout);
            this._repository = repository;
            this._picklist = picklist;
        }

        @Override
        protected void acquireContent() throws WebAppConfigException {
            try {
                this._plugins = this._repository.find(this._picklist);
            }
            catch (Throwable e) {
                throw new WebAppConfigException(ErrorHandling.generateCannotFindContentInVJRErrorMessage(this.getTask()), e);
            }
        }

        @Override
        protected Object getContent() {
            return this._plugins;
        }

        @Override
        protected WebAppConfigException processMissingContent() {
            return new WebAppConfigException(ErrorHandling.generateTimeoutReadingRepositoryErrorMessage(this.getTask()), null);
        }
    }

    private static abstract class WorkerThread
    implements Runnable {
        private static final long _DEFAULT_THREAD_TIMEOUT_MS = 30000L;
        private WebAppConfigException _error = null;
        private long _timeout;
        private Task _task;

        WorkerThread(Task task, long timeout) {
            this._timeout = timeout <= 0L ? 30000L : timeout;
            this._task = task;
        }

        final Task getTask() {
            return this._task;
        }

        final void waitForThreadCompletion() {
            new Thread(this).start();
            long now = System.currentTimeMillis();
            while (System.currentTimeMillis() - now < this._timeout && this.getContent() == null && this._error == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        @Override
        public final void run() {
            try {
                this.acquireContent();
            }
            catch (WebAppConfigException e) {
                this._error = e;
            }
        }

        final Object getReturnValue() throws WebAppConfigException {
            if (this._error != null) {
                throw this._error;
            }
            Object content = this.getContent();
            if (content == null) {
                throw this.processMissingContent();
            }
            return content;
        }

        protected abstract WebAppConfigException processMissingContent();

        protected abstract Object getContent();

        protected abstract void acquireContent() throws WebAppConfigException;
    }
}

