/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.InternalLogin;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.tools.webappconfig.tasks.ModeledPropertyInterface;
import com.sas.tools.webappconfig.util.Logger;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class GlobalRootProperties
implements ModeledPropertyInterface {
    private static String userAuthDomainName = null;
    private static String userAccountType = null;

    @Override
    public Properties getModeledProperties(Root globalrootSoftwareComponent) {
        MdFactory m_mdFactory = null;
        MdObjectStore m_mdObjectStore = null;
        Properties m_ConfigurableObjectProperties = new Properties();
        Properties globalrootProperties = new Properties();
        String authProviderDomain_SASPW_Alias = null;
        String FoundationReposName = null;
        if (globalrootSoftwareComponent == null) {
            Logger.log(2, null, "WARNING:  GetModeledProperties was passed a null configurable object.  GetModeledProperties returning a null.");
            return globalrootProperties;
        }
        try {
            Logger.log(2, null, "Fetching modeled properties for configurable object : " + globalrootSoftwareComponent.getName());
            m_mdFactory = globalrootSoftwareComponent.getObjectStore().getFactory();
            m_mdFactory.setDebug(false);
            m_mdObjectStore = (MdObjectStore)globalrootSoftwareComponent.getObjectStore();
            authProviderDomain_SASPW_Alias = this.getSASPW_authPD_Alias(m_mdFactory);
            Logger.log(2, null, "Found authProviderDomain_SASPW_Alias = \"" + authProviderDomain_SASPW_Alias + "\"");
        }
        catch (Exception ex) {
            Logger.log(2, null, "EXCEPTION Occured : " + ex.getMessage());
            Logger.log(2, null, "EXCEPTION Occured : " + ex.toString());
        }
        m_ConfigurableObjectProperties = GlobalRootProperties.getPropertiesfromConfigurableObj(globalrootSoftwareComponent, "all");
        if (m_ConfigurableObjectProperties == null) {
            Logger.log(2, null, "WARNING:  The GlobalRoot SoftwareComponent had no associated properties.  GetModeledProperties returning a null.");
            return globalrootProperties;
        }
        try {
            FoundationReposName = m_mdFactory.getOMIUtil().getFoundationRepository().getName();
        }
        catch (Exception ex) {
            Logger.log(2, null, "EXCEPTION Occured retrieving Foudation Repository name: " + ex.getMessage());
            ex.printStackTrace();
        }
        Logger.log(2, null, "Value for Foundation Repository Name: " + FoundationReposName);
        globalrootProperties.put("oma.repository.foundation.name", FoundationReposName);
        userAccountType = m_ConfigurableObjectProperties.getProperty("user.account.type");
        String metadataAuthDomain = m_ConfigurableObjectProperties.getProperty("iomsrv.metadatasrv.authdomain");
        String my_IdentityName = null;
        String loginUserID = null;
        my_IdentityName = m_ConfigurableObjectProperties.getProperty("oma.person.admin.person.name");
        Logger.log(2, null, "\nProcessing properties for oma.person.admin Identity: " + my_IdentityName);
        Identity my_Identity = null;
        my_Identity = GlobalRootProperties.getIdentity(m_mdFactory, m_mdObjectStore, my_IdentityName);
        if (my_Identity != null) {
            this.setDisplayNameProperty(my_Identity, "oma.person.admin.person.display.name", globalrootProperties);
            loginUserID = GlobalRootProperties.retrievepreferredLoginfromIdentity(my_Identity, m_ConfigurableObjectProperties.getProperty("oma.person.admin.login.userid"), metadataAuthDomain, authProviderDomain_SASPW_Alias, false);
            if (loginUserID != null) {
                globalrootProperties.put("oma.person.admin.login.userid", loginUserID);
            }
            if (userAuthDomainName != null) {
                globalrootProperties.put("oma.person.admin.login.authdomain", userAuthDomainName);
            }
        }
        my_IdentityName = m_ConfigurableObjectProperties.getProperty("oma.person.trustusr.person.name");
        Logger.log(2, null, "\nProcessing properties for oma.person.trustusr Identity: " + my_IdentityName);
        my_Identity = GlobalRootProperties.getIdentity(m_mdFactory, m_mdObjectStore, my_IdentityName);
        if (my_Identity != null) {
            this.setDisplayNameProperty(my_Identity, "oma.person.trustusr.person.display.name", globalrootProperties);
            loginUserID = GlobalRootProperties.retrievepreferredLoginfromIdentity(my_Identity, m_ConfigurableObjectProperties.getProperty("oma.person.trustusr.login.userid"), metadataAuthDomain, authProviderDomain_SASPW_Alias, false);
            if (loginUserID != null) {
                globalrootProperties.put("oma.person.trustusr.login.userid", loginUserID);
            }
            if (userAuthDomainName != null) {
                globalrootProperties.put("oma.person.trustusr.login.authdomain", userAuthDomainName);
            }
        }
        Logger.log(2, null, "Note:  user.account.type property deemed to be " + userAccountType);
        globalrootProperties.put("user.account.type", userAccountType);
        my_IdentityName = m_ConfigurableObjectProperties.getProperty("oma.person.webanon.person.name");
        my_Identity = GlobalRootProperties.getIdentity(m_mdFactory, m_mdObjectStore, my_IdentityName);
        if (my_Identity != null) {
            Logger.log(2, null, "\nProcessing properties for oma.person.webanon Identity: " + my_IdentityName);
            this.setDisplayNameProperty(my_Identity, "oma.person.webanon.person.display.name", globalrootProperties);
            loginUserID = GlobalRootProperties.retrievepreferredLoginfromIdentity(my_Identity, m_ConfigurableObjectProperties.getProperty("oma.person.webanon.login.userid"), metadataAuthDomain, authProviderDomain_SASPW_Alias, false);
            if (loginUserID != null) {
                globalrootProperties.put("oma.person.webanon.login.userid", loginUserID);
            }
            if (userAuthDomainName != null) {
                globalrootProperties.put("oma.person.webanon.login.authdomain", userAuthDomainName);
            }
        }
        if ((my_IdentityName = m_ConfigurableObjectProperties.getProperty("oma.person.demo.person.name")) != null) {
            Logger.log(2, null, "\nProcessing properties for oma.person.demo Identity: " + my_IdentityName);
            my_Identity = GlobalRootProperties.getIdentity(m_mdFactory, m_mdObjectStore, my_IdentityName);
            if (my_Identity != null) {
                this.setDisplayNameProperty(my_Identity, "oma.person.demo.person.display.name", globalrootProperties);
                loginUserID = GlobalRootProperties.retrievepreferredLoginfromIdentity(my_Identity, m_ConfigurableObjectProperties.getProperty("oma.person.demo.login.userid"), metadataAuthDomain, authProviderDomain_SASPW_Alias, true);
                if (loginUserID != null) {
                    globalrootProperties.put("oma.person.demo.login.userid", loginUserID);
                }
                if (userAuthDomainName != null) {
                    globalrootProperties.put("oma.person.demo.login.authdomain", userAuthDomainName);
                }
            } else {
                Logger.log(2, null, "\noma.person.demo.person.name Identity was not found in metadata so blanking out corresponding properties.");
                globalrootProperties.put("oma.person.demo.person.name", "");
                globalrootProperties.put("oma.person.demo.person.display.name", "");
                globalrootProperties.put("oma.person.demo.login.userid", "");
                globalrootProperties.put("oma.person.demo.login.authdomain", "");
            }
        } else {
            Logger.log(2, null, "\noma.person.demo.person.name property not set. Identity was not configured.");
        }
        if ((my_IdentityName = m_ConfigurableObjectProperties.getProperty("oma.identitygroup.genservers.group.name")) != null) {
            Logger.log(2, null, "\nProcessing properties for oma.identitygroup.genservers.group Identity: " + my_IdentityName);
            my_Identity = GlobalRootProperties.getIdentity(m_mdFactory, m_mdObjectStore, my_IdentityName);
            if (my_Identity != null) {
                this.setDisplayNameProperty(my_Identity, "oma.identitygroup.genservers.group.display.name", globalrootProperties);
            }
        } else {
            Logger.log(2, null, "\noma.identitygroup.genservers.group.name property not set. Identity was not configured.");
        }
        if ((my_IdentityName = m_ConfigurableObjectProperties.getProperty("oma.identitygroup.biws.group.name")) != null) {
            Logger.log(2, null, "\nProcessing properties for oma.identitygroup.biws.group Identity: " + my_IdentityName);
            my_Identity = GlobalRootProperties.getIdentity(m_mdFactory, m_mdObjectStore, my_IdentityName);
            if (my_Identity != null) {
                this.setDisplayNameProperty(my_Identity, "oma.identitygroup.biws.group.display.name", globalrootProperties);
            }
        } else {
            Logger.log(2, null, "\noma.identitygroup.biws.group.name property not set. Identity was not configured.");
        }
        if ((my_IdentityName = m_ConfigurableObjectProperties.getProperty("oma.person.solutions.admin.person.name")) != null) {
            Logger.log(2, null, "\nProcessing properties for oma.person.solutions.admin Identity: " + my_IdentityName);
            my_Identity = GlobalRootProperties.getIdentity(m_mdFactory, m_mdObjectStore, my_IdentityName);
            if (my_Identity != null) {
                this.setDisplayNameProperty(my_Identity, "oma.person.solutions.admin.display.name", globalrootProperties);
                loginUserID = GlobalRootProperties.retrievepreferredLoginfromIdentity(my_Identity, m_ConfigurableObjectProperties.getProperty("oma.person.solutions.admin.login.userid"), metadataAuthDomain, authProviderDomain_SASPW_Alias, false);
                if (loginUserID != null) {
                    globalrootProperties.put("oma.person.solutions.admin.login.userid", loginUserID);
                }
                if (userAuthDomainName != null) {
                    globalrootProperties.put("oma.person.solutions.admin.login.authdomain", userAuthDomainName);
                }
            }
        } else {
            Logger.log(2, null, "\noma.person.solutions.admin.person.name property not set. Identity not configured.");
        }
        String SOULTIONS_JDBC_PERSON_NAME_DEFAULT = "Solutions Host User";
        my_IdentityName = m_ConfigurableObjectProperties.getProperty("solutions.jdbc.user.person.name", "Solutions Host User");
        if (my_IdentityName != null) {
            Logger.log(2, null, "\nProcessing properties for solutions.jdbc Identity: " + my_IdentityName);
            my_Identity = GlobalRootProperties.getIdentity(m_mdFactory, m_mdObjectStore, my_IdentityName);
            if (my_Identity != null) {
                this.setDisplayNameProperty(my_Identity, "solutions.jdbc.user.display.name", globalrootProperties);
                loginUserID = GlobalRootProperties.retrievepreferredLoginfromIdentity(my_Identity, m_ConfigurableObjectProperties.getProperty("solutions.jdbc.userid"), metadataAuthDomain, authProviderDomain_SASPW_Alias, false);
                if (loginUserID != null) {
                    globalrootProperties.put("solutions.jdbc.userid", loginUserID);
                }
                if (userAuthDomainName != null) {
                    globalrootProperties.put("solutions.jdbc.user.authdomain.name", userAuthDomainName);
                }
            } else {
                Logger.log(2, null, "\nNo identity with name '" + my_IdentityName + "' found. Identity not configured.");
            }
        } else {
            Logger.log(2, null, "\noma.person.solutions.admin.person.name property not set. Identity not configured.");
        }
        return globalrootProperties;
    }

    private void setDisplayNameProperty(Identity my_Identity, String propertyName, Properties globalrootProperties) {
        try {
            String my_identityDisplayName = my_Identity.getDisplayName();
            if (my_identityDisplayName != null) {
                globalrootProperties.put(propertyName, my_identityDisplayName);
                Logger.log(2, null, "Setting  " + propertyName + "=" + my_identityDisplayName);
            }
        }
        catch (RemoteException e) {
            Logger.log(2, null, "Unable to retrieve DisplayName from metadata so blanking out property " + propertyName);
            globalrootProperties.put(propertyName, "");
        }
    }

    private String getSASPW_authPD_Alias(MdFactory my_mdFactory) {
        MdOMRConnection m_MdOMRConnection = null;
        ISecurity_1_1 m_ISecurity_1_1 = null;
        VariableArray2dOfStringHolder m_ISecurity_output = new VariableArray2dOfStringHolder();
        try {
            m_MdOMRConnection = my_mdFactory.getConnection();
            m_ISecurity_1_1 = m_MdOMRConnection.MakeISecurityConnection(m_MdOMRConnection.getCMRHandle());
            String[][] dummy = new String[][]{{""}, {""}};
            m_ISecurity_1_1.GetInfo("SASPW_Alias", "", dummy, m_ISecurity_output);
        }
        catch (Exception e) {
            Logger.log(0, null, "WARNING: Exception thrown while trying to getSASPW_AuthPD_Alias");
        }
        return m_ISecurity_output.value[0][1];
    }

    private static Identity getIdentity(MdFactory m_mdFactory, MdObjectStore m_mdObjectStore, String my_IdentityName) {
        Identity my_Identity = null;
        if (my_IdentityName != null && my_IdentityName.length() > 0) {
            try {
                String m_repositoryFQID = "";
                int flags = 8600;
                String xmlSelect = "<XMLSelect search=\"*[@Name='" + my_IdentityName + "']\"/>";
                List objectsList = m_mdFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)m_mdObjectStore, m_repositoryFQID, "Identity", flags, xmlSelect);
                if (objectsList != null && objectsList.size() > 0) {
                    my_Identity = (Identity)objectsList.get(0);
                } else {
                    Logger.log(2, null, "Could not find  Identity: " + my_IdentityName);
                }
            }
            catch (Exception e) {
                Logger.log(2, null, "Search for Identity threw exception with message: " + e.getMessage());
                Logger.log(2, null, "   m_mdFactory: " + m_mdFactory);
                Logger.log(2, null, "Search for Identity threw exception with String: " + e.toString());
            }
        }
        return my_Identity;
    }

    public static Properties getPropertiesfromConfigurableObj(Root configurableObject, String whichProps) {
        String PUBLIC_TEXT_STORE_NAME = "Public Configuration Properties";
        String PRIVATE_TEXT_STORE_NAME = "Private Configuration Properties";
        Properties configurableObjectProperties = new Properties();
        TextStore textStore = null;
        try {
            AssociationList al = configurableObject.getNotes();
            for (Object o : al) {
                if (o instanceof TextStore) {
                    textStore = (TextStore)o;
                }
                if ((whichProps.equalsIgnoreCase("All") || whichProps.equalsIgnoreCase("Public")) && textStore.getName().equals("Public Configuration Properties")) {
                    configurableObjectProperties.putAll((Map<?, ?>)GlobalRootProperties.createPropertiesfromStoredText(textStore));
                    continue;
                }
                if (!whichProps.equalsIgnoreCase("All") && !whichProps.equalsIgnoreCase("Private") || !textStore.getName().equals("Private Configuration Properties")) continue;
                configurableObjectProperties.putAll((Map<?, ?>)GlobalRootProperties.createPropertiesfromStoredText(textStore));
            }
            if (textStore == null) {
                Logger.log(2, null, "No TextStore objects found associated with configurable object: " + configurableObject.getName());
            }
        }
        catch (Exception e) {
            Logger.log(0, null, "Error getting text store: " + e.getMessage());
            Logger.log(0, null, "   configurableObject: " + configurableObject);
        }
        return configurableObjectProperties;
    }

    public static Properties createPropertiesfromStoredText(TextStore textStore) {
        Properties props = new Properties();
        try {
            String storedTextAttribute = textStore.getStoredText();
            StringReader reader = new StringReader(storedTextAttribute);
            PropertyMap myProperties = new PropertyMap();
            myProperties.load((Reader)reader);
            Iterator iterator = myProperties.getPropertyIterator();
            while (iterator.hasNext()) {
                String propName = (String)iterator.next();
                String propValue = myProperties.getProperty(propName);
                props.put(propName, propValue);
            }
        }
        catch (Exception e) {
            Logger.log(0, null, "Error retrieving text from TextStore: " + e.getMessage());
            Logger.log(0, null, " TextStore: " + textStore);
            return null;
        }
        return props;
    }

    public static String retrievepreferredLoginfromIdentity(Identity myIdentity, String preferredUserID, String preferredAuthDomain, String saspw_authPD_Alias, boolean externalsonly) {
        String foundUserID = null;
        String identityName = null;
        userAuthDomainName = null;
        InternalLogin myInternalLogin = null;
        AssociationList loginsList = null;
        Login mylogin2 = null;
        try {
            identityName = myIdentity.getName();
        }
        catch (Exception e) {
            Logger.log(2, null, "Error getting Name for Identity" + e.getMessage());
            return null;
        }
        int isDisabled = 1;
        if (!externalsonly) {
            try {
                myInternalLogin = myIdentity.getInternalLoginInfo();
                isDisabled = myInternalLogin.getIsDisabled();
            }
            catch (Exception e) {
                Logger.log(0, null, "No InternalLogin objects associated with Identity " + identityName);
            }
        }
        if (myInternalLogin != null && isDisabled == 0) {
            foundUserID = identityName + "@" + saspw_authPD_Alias;
            userAccountType = "internal";
            Logger.log(2, null, "Found valid InternalLogin for " + identityName + " so returning Login UserID = " + foundUserID);
        } else {
            boolean foundpreferred = false;
            boolean foundBasedOnAuthDomain = false;
            try {
                loginsList = myIdentity.getLogins();
            }
            catch (Exception e) {
                Logger.log(2, null, "Warning:  Returning orginal property value since no Login objects were associated with Identity" + identityName);
                return null;
            }
            if (loginsList != null && loginsList.size() > 0 && preferredAuthDomain != null) {
                for (Login mylogin2 : loginsList) {
                    try {
                        foundUserID = mylogin2.getUserID();
                    }
                    catch (RemoteException e) {
                        Logger.log(0, null, "Warning:  Unable to get associated Userid for Identity " + identityName);
                    }
                    try {
                        AuthenticationDomain domain = mylogin2.getDomain();
                        if (domain == null || domain.getName() == null || !domain.getName().equalsIgnoreCase(preferredAuthDomain)) continue;
                        foundBasedOnAuthDomain = true;
                        break;
                    }
                    catch (Exception e) {
                        Logger.log(2, null, "Error retrieving authentication domaind for UserID " + foundUserID);
                    }
                }
                if (!foundBasedOnAuthDomain) {
                    for (Login mylogin2 : loginsList) {
                        try {
                            foundUserID = mylogin2.getUserID();
                        }
                        catch (RemoteException e) {
                            Logger.log(0, null, "Warning:  Unable to get associated Userid for Identity " + identityName);
                        }
                        if (!foundUserID.equalsIgnoreCase(preferredUserID)) continue;
                        foundpreferred = true;
                        break;
                    }
                }
            }
            if (foundUserID == null) {
                Logger.log(2, null, "Warning:  No Login UserID found in metadata for Identity: " + identityName);
            } else {
                if (foundpreferred) {
                    Logger.log(2, null, "Found the originally configured or migrated external UserID: " + foundUserID);
                } else {
                    Logger.log(2, null, "Originally configured or migrated external UserID " + preferredUserID + " could not be found so returning substitute: " + foundUserID);
                }
                AuthenticationDomain myauthdomain = null;
                try {
                    myauthdomain = mylogin2.getDomain();
                    userAuthDomainName = myauthdomain.getName();
                }
                catch (Exception e) {
                    Logger.log(2, null, "No AuthenticationDomains were associated with UserID " + foundUserID);
                }
                if (myauthdomain != null) {
                    Logger.log(2, null, "Returning associated authdomain " + userAuthDomainName);
                }
            }
        }
        return foundUserID;
    }

    public static String retrievepreferredLoginfromIdentity(Identity myIdentity, String preferredUserID, String saspw_authPD_Alias, boolean externalsonly) {
        return GlobalRootProperties.retrievepreferredLoginfromIdentity(myIdentity, preferredUserID, null, saspw_authPD_Alias, externalsonly);
    }
}

