/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.tasks.LoggerPropertiesEditor;
import com.sas.tools.webappconfig.tasks.LoggerPropertiesExpander;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.FileTransformer;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class FixLoggerProperties
extends TaskImpl {
    private static final String _PARAM_ELEMENT = "param";
    private static final String _NAME_ATTRIBUTE = "name";
    private static final String _VALUE_ATTRIBUTE = "value";
    private static final String _FILE_TYPE = "File";

    @Override
    protected boolean doWork() throws WebAppConfigException {
        this.processFiles(this.getValue("files"));
        return true;
    }

    private void processFiles(String files) throws WebAppConfigException {
        String[] filenames = CommonUtils.parseCommaDelimitedInput(files);
        for (int i = 0; i < filenames.length; ++i) {
            this.processFile(filenames[i]);
        }
    }

    private void processFile(String filename) throws WebAppConfigException {
        Logger.log(3, this, ErrorHandling.generateProcessingFileInfoMessage(this, filename));
        this.expandSlashes(filename);
        this.ensureReferencedDirectoriesExist(filename);
        this.stripRootContext(filename);
    }

    private void stripRootContext(String filename) throws WebAppConfigException {
        if (this.getValueAsBool("stripRootContext", false)) {
            Logger.log(2, this, ErrorHandling.generateStrippingRootContextMessage(this, filename));
            LoggerPropertiesEditor transform = new LoggerPropertiesEditor(this);
            new FileTransformer(this, filename, transform).executeTransformation();
        }
    }

    private void ensureReferencedDirectoriesExist(String filename) throws WebAppConfigException {
        if (!this.getValueAsBool("checkdirs", true)) {
            return;
        }
        Logger.log(2, this, ErrorHandling.generateValidatingXMLFileInfoMessage(this, filename));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            NodeList list = factory.newDocumentBuilder().parse(new File(filename)).getDocumentElement().getElementsByTagName(_PARAM_ELEMENT);
            int targetCount = list.getLength();
            HashSet<File> folders = new HashSet<File>(targetCount);
            for (int i = 0; i < targetCount; ++i) {
                String fileName;
                File parent;
                Element element = (Element)list.item(i);
                if (!_FILE_TYPE.equals(element.getAttribute(_NAME_ATTRIBUTE)) || null == (parent = new File(fileName = element.getAttribute(_VALUE_ATTRIBUTE)).getParentFile())) continue;
                folders.add(parent);
            }
            for (File parent : folders) {
                Logger.log(2, this, ErrorHandling.generateValidatingDirectoryInfoMessage(this, parent));
                parent.mkdirs();
                if (!parent.exists()) {
                    throw new WebAppConfigException(ErrorHandling.generateCannotCreateDirectoryErrorMessage(this, parent), null);
                }
                if (parent.isDirectory()) continue;
                throw new WebAppConfigException(ErrorHandling.generateDirectoryIsNotADirectoryErrorMessage(this, parent), null);
            }
        }
        catch (ParserConfigurationException pce) {
            throw new WebAppConfigException(ErrorHandling.generateCannotProcessScriptErrorMessage(this, filename), pce);
        }
        catch (SAXException se) {
            throw new WebAppConfigException(ErrorHandling.generateCannotProcessScriptErrorMessage(this, filename), se);
        }
        catch (IOException ioe) {
            throw new WebAppConfigException(ErrorHandling.generateCannotProcessScriptErrorMessage(this, filename), ioe);
        }
    }

    private void expandSlashes(String filename) throws WebAppConfigException {
        new FileTransformer(this, filename, new LoggerPropertiesExpander()).executeTransformation();
    }
}

