/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.Task;

public final class Expand
extends TaskImpl {
    public static final String END_STRING = "|";
    public static final String EXPAND_AS_URL = "webappconfig.expandAsUrl|";
    public static final String EXPAND_AS_FILE = "webappconfig.expandAsFile|";
    public static final String WRITE_PROPERTY = "webappconfig.writeProperty|";
    public static final String EXPAND_AS_PERMISSION_FILE = "webappconfig.expandAsPermissionsFile|";

    @Override
    protected boolean doWork() throws WebAppConfigException {
        this.processInputFiles(this.getValue("files"));
        return true;
    }

    private void processInputFiles(String files) throws WebAppConfigException {
        String[] filenames = CommonUtils.parseCommaDelimitedInput(files);
        for (int i = 0; i < filenames.length; ++i) {
            this.processInputFile(filenames[i]);
        }
    }

    private void processInputFile(String filename) throws WebAppConfigException {
        Logger.log(3, this, ErrorHandling.generateProcessingFileInfoMessage(this, filename));
        BufferedReader infile = null;
        BufferedWriter outfile = null;
        String tmpName = filename + ".tmp";
        try {
            infile = CommonUtils.getUTF8Reader((Task)this, filename);
        }
        catch (FileNotFoundException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, filename), e);
        }
        try {
            outfile = CommonUtils.getUTF8Writer(this, tmpName);
        }
        catch (IOException e) {
            CommonUtils.closeReader(infile);
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, tmpName), e);
        }
        boolean isPropertyFile = CommonUtils.isPropertiesFile(filename);
        try {
            String line = null;
            while (null != (line = infile.readLine())) {
                String originalLine = line;
                line = this.processLine(originalLine, line, isPropertyFile, filename, new WritePropertyExpansion());
                line = this.processLine(originalLine, line, isPropertyFile, filename, new FilePropertyExpansion());
                line = this.processLine(originalLine, line, isPropertyFile, filename, new URLPropertyExpansion());
                line = this.processLine(originalLine, line, isPropertyFile, filename, new PermissionFilePropertyExpansion());
                outfile.write(line);
                outfile.newLine();
            }
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotProcessExpansionsErrorMessage(this, filename), e);
        }
        CommonUtils.closeWriter(outfile);
        CommonUtils.closeReader(infile);
        File targetFile = new File(filename);
        if (!targetFile.delete()) {
            throw new WebAppConfigException(ErrorHandling.generateCannotDeleteFileErrorMessage(this, filename), null);
        }
        if (!new File(tmpName).renameTo(targetFile)) {
            throw new WebAppConfigException(ErrorHandling.generateCannotRenameFileErrorMessage(this, tmpName, filename), null);
        }
    }

    private String processLine(String originalLine, String line, boolean isPropertyFile, String filename, ExpanderInterface expander) throws WebAppConfigException {
        String processedLine = line;
        String macroStart = expander.getStart();
        int macroStartLength = macroStart.length();
        String macroEnd = expander.getEnd();
        int macroEndLength = macroEnd.length();
        int index = processedLine.indexOf(macroStart);
        while (-1 != index) {
            int finalIndex = processedLine.indexOf(macroEnd, index + macroStartLength);
            if (-1 == finalIndex) {
                throw new WebAppConfigException(ErrorHandling.generateImbalancedDelimitersErrorMessage(this, originalLine, filename), null);
            }
            String substitution = expander.expand(processedLine.substring(index + macroStartLength, finalIndex));
            if (isPropertyFile && !(expander instanceof PermissionFilePropertyExpansion)) {
                substitution = CommonUtils.replaceAll(substitution, "\\", "\\\\");
            }
            processedLine = CommonUtils.replaceAll(processedLine, processedLine.substring(index, finalIndex + macroEndLength), substitution);
            index = processedLine.indexOf(macroStart);
        }
        return processedLine;
    }

    class PermissionFilePropertyExpansion
    extends AbstractExpansion {
        PermissionFilePropertyExpansion() {
        }

        @Override
        public final String getStart() {
            return Expand.EXPAND_AS_PERMISSION_FILE;
        }

        @Override
        public final String expand(String line) throws WebAppConfigException {
            String replacement = null;
            try {
                replacement = new File(line).getCanonicalPath();
                replacement = replacement.replaceAll("/", "\\${/}");
                replacement = replacement.replaceAll("\\\\", "\\${/}");
                replacement = replacement.replaceAll(" ", "\\\\ ");
            }
            catch (IOException e) {
                this.processException(Expand.this, line, e);
            }
            return replacement;
        }
    }

    class WritePropertyExpansion
    extends AbstractExpansion {
        WritePropertyExpansion() {
        }

        @Override
        public final String getStart() {
            return Expand.WRITE_PROPERTY;
        }

        @Override
        public final String expand(String line) throws WebAppConfigException {
            String replacement = Expand.this.getProperty(line);
            if (null == replacement) {
                throw new WebAppConfigException(ErrorHandling.generateCannotExpandPropertyErrorMessage(Expand.this, line), null);
            }
            return replacement;
        }
    }

    class FilePropertyExpansion
    extends AbstractExpansion {
        FilePropertyExpansion() {
        }

        @Override
        public final String getStart() {
            return Expand.EXPAND_AS_FILE;
        }

        @Override
        public final String expand(String line) throws WebAppConfigException {
            String replacement = null;
            try {
                replacement = new File(line).getCanonicalFile().getAbsolutePath();
            }
            catch (IOException e) {
                this.processException(Expand.this, line, e);
            }
            return replacement;
        }
    }

    class URLPropertyExpansion
    extends AbstractExpansion {
        URLPropertyExpansion() {
        }

        @Override
        public final String getStart() {
            return Expand.EXPAND_AS_URL;
        }

        @Override
        public final String expand(String line) throws WebAppConfigException {
            String replacement = null;
            try {
                replacement = new URL("file", "", new File(line).getCanonicalFile().getAbsolutePath()).toExternalForm();
            }
            catch (MalformedURLException e) {
                this.processException(Expand.this, line, e);
            }
            catch (IOException e) {
                this.processException(Expand.this, line, e);
            }
            return replacement;
        }
    }

    static abstract class AbstractExpansion
    implements ExpanderInterface {
        AbstractExpansion() {
        }

        @Override
        public final String getEnd() {
            return Expand.END_STRING;
        }

        @Override
        public final void processException(Expand instance, String line, Throwable cause) throws WebAppConfigException {
            String start = this.getStart();
            String end = this.getEnd();
            int bufferLength = start.length() + line.length() + end.length();
            StringBuffer expansion = new StringBuffer(bufferLength);
            expansion.append(start);
            expansion.append(line);
            expansion.append(end);
            throw new WebAppConfigException(ErrorHandling.generateCannotProcessExpansionErrorMessage(instance, expansion.toString()), cause);
        }
    }

    private static interface ExpanderInterface {
        public String getStart();

        public String getEnd();

        public String expand(String var1) throws WebAppConfigException;

        public void processException(Expand var1, String var2, Throwable var3) throws WebAppConfigException;
    }
}

