/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DialogData {
    private Element root = null;

    public DialogData(String file) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this(new File(file));
    }

    public DialogData(File file) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        FileInputStream fis = new FileInputStream(file);
        this.root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new InputStreamReader((InputStream)fis, "UTF-8"))).getDocumentElement();
    }

    public Dialog[] getDialogs(String plat) {
        Vector<Dialog> dialogList = new Vector<Dialog>();
        if (this.root != null && "configDlgs".equals(this.root.getTagName())) {
            Dialog dialog = null;
            NodeList dialogs = this.root.getElementsByTagName("dialog");
            for (int i = 0; i < dialogs.getLength(); ++i) {
                dialog = new Dialog((Element)dialogs.item(i), plat.toLowerCase(Locale.ENGLISH));
                if (dialog.getPropertyCount() <= 0) continue;
                dialogList.add(dialog);
            }
        }
        return dialogList.toArray(new Dialog[0]);
    }

    public class Property {
        public final int TYPE_STRING = 1;
        public final int TYPE_STRING_REQUIRED = 2;
        public final int TYPE_NUMBER = 3;
        public final int TYPE_BOOLEAN = 4;
        public final int TYPE_USERID = 5;
        public final int TYPE_USERID_MS = 6;
        public final int TYPE_USERID_STATIC = 7;
        public final int TYPE_PASSWORD = 8;
        public final int TYPE_PASSWORD_OS = 9;
        public final int TYPE_PASSWORD_OS_BAT = 10;
        public final int TYPE_PASSWORD_MS = 11;
        public final int TYPE_PASSWORD_MS_NEW = 12;
        public final int TYPE_PASSWORD_PLAIN = 13;
        public final int TYPE_FILE = 14;
        public final int TYPE_FILE_EXISTS = 15;
        public final int TYPE_DIR = 16;
        public final int TYPE_DIR_EXISTS = 17;
        public final int TYPE_URL = 18;
        public final int TYPE_URI = 19;
        public final int TYPE_PORT = 20;
        public final int TYPE_COMBO = 21;
        public final int TYPE_JOBCARD = 22;
        public final int TYPE_STATIC = 23;
        public final int SIZE_SMALL = 1;
        public final int SIZE_MEDIUM = 2;
        public final int SIZE_LARGE = 3;
        public final int LEVEL_BASIC = 1;
        public final int LEVEL_ADVANCED = 2;
        public final int SCOPE_PUBLIC = 1;
        public final int SCOPE_PRIVATE = 2;
        private String name = null;
        private String rule = null;
        private String owner = null;
        private String genPrompt = null;
        private String comboData = null;
        private String genType = null;
        private String[] depends = null;
        private int order = 0;
        private int type = 0;
        private int size = 0;
        private int level = 0;
        private int maxLength = 0;
        private int scope = 0;
        private boolean prompt = false;
        private boolean persist = false;

        protected Property(Element root) {
            this.name = root.getAttribute("name");
            this.order = Integer.parseInt(root.getAttribute("order"));
            this.rule = root.getAttribute("rule");
            String temp = root.getAttribute("depends");
            if (temp == null) {
                this.depends = new String[0];
            } else {
                StringTokenizer tokens = new StringTokenizer(temp);
                this.depends = new String[tokens.countTokens()];
                int i = 0;
                while (tokens.hasMoreTokens()) {
                    this.depends[i] = tokens.nextToken();
                    ++i;
                }
            }
            this.owner = root.getAttribute("owner");
            temp = root.getAttribute("prompt");
            if ("true".equalsIgnoreCase(temp)) {
                this.prompt = true;
            } else if ("false".equalsIgnoreCase(temp)) {
                this.prompt = false;
            } else {
                this.genPrompt = temp;
            }
            this.setType(root.getAttribute("type"));
            temp = root.getAttribute("control").toLowerCase(Locale.ENGLISH);
            if ("small".equals(temp)) {
                this.size = 1;
            } else if ("medium".equals(temp)) {
                this.size = 2;
            } else if ("large".equals(temp)) {
                this.size = 3;
            }
            temp = root.getAttribute("level").toLowerCase(Locale.ENGLISH);
            if ("basic".equals(temp)) {
                this.level = 1;
            } else if ("advanced".equals(temp)) {
                this.level = 2;
            }
            String maxLen = root.getAttribute("maxlength").trim();
            if (maxLen != null && maxLen.length() > 0) {
                try {
                    this.maxLength = Integer.parseInt(maxLen);
                }
                catch (Exception e) {
                    this.maxLength = 0;
                }
            } else {
                this.maxLength = 0;
            }
            if ("true".equalsIgnoreCase(temp = root.getAttribute("persist"))) {
                this.persist = true;
            } else if ("false".equalsIgnoreCase(temp)) {
                this.persist = false;
            }
            temp = root.getAttribute("scope").toLowerCase(Locale.ENGLISH);
            if ("public".equals(temp)) {
                this.scope = 1;
            } else if ("private".equals(temp)) {
                this.scope = 2;
            }
        }

        public void setType(String fieldType) {
            String temp = fieldType.toLowerCase(Locale.ENGLISH);
            if ("string".equals(temp)) {
                this.type = 1;
            } else if ("string_required".equals(temp)) {
                this.type = 2;
            } else if ("number".equals(temp)) {
                this.type = 3;
            } else if ("boolean".equals(temp)) {
                this.type = 4;
            } else if ("userid".equals(temp)) {
                this.type = 5;
            } else if ("userid_ms".equals(temp)) {
                this.type = 6;
            } else if ("userid_static".equals(temp)) {
                this.type = 7;
            } else if ("password".equals(temp)) {
                this.type = 8;
            } else if ("password_os".equals(temp)) {
                this.type = 9;
            } else if ("password_os_bat".equals(temp)) {
                this.type = 10;
            } else if ("password_ms".equals(temp)) {
                this.type = 11;
            } else if ("password_ms_new".equals(temp)) {
                this.type = 12;
            } else if ("password_plain".equals(temp)) {
                this.type = 13;
            } else if ("file".equals(temp)) {
                this.type = 14;
            } else if ("file_exists".equals(temp)) {
                this.type = 15;
            } else if ("dir".equals(temp)) {
                this.type = 16;
            } else if ("dir_exists".equals(temp)) {
                this.type = 17;
            } else if ("url".equals(temp)) {
                this.type = 18;
            } else if ("uri".equals(temp)) {
                this.type = 19;
            } else if ("port".equals(temp)) {
                this.type = 20;
            } else if (temp != null && temp.startsWith("combo")) {
                this.type = 21;
                this.comboData = fieldType.length() > 7 && fieldType.substring(5, 6).equals("[") && fieldType.endsWith("]") ? fieldType.substring(6, fieldType.length() - 1) : "";
            } else if ("jobcard".equals(temp)) {
                this.type = 22;
            } else if ("static".equals(temp)) {
                this.type = 23;
            } else {
                this.genType = fieldType;
            }
            if (this.type != 21) {
                this.comboData = "";
            }
        }

        public String getName() {
            return this.name;
        }

        public int getOrder() {
            return this.order;
        }

        public String getRule() {
            return this.rule;
        }

        public String[] getDepends() {
            return this.depends;
        }

        public String getOwner() {
            return this.owner;
        }

        public boolean getPrompt() {
            return this.prompt;
        }

        public String getGenPrompt() {
            return this.genPrompt;
        }

        public int getType() {
            return this.type;
        }

        public String getGenType() {
            return this.genType;
        }

        public String getComboData() {
            return this.comboData;
        }

        public int getSize() {
            return this.size;
        }

        public int getLevel() {
            return this.level;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public boolean getPersist() {
            return this.persist;
        }

        public int getScope() {
            return this.scope;
        }
    }

    public class Dialog {
        private String group = null;
        private Vector propertyList = new Vector();

        protected Dialog(Element root, String plat) {
            int j;
            boolean process = false;
            String platform = null;
            Element element = null;
            this.group = root.getAttribute("group").toLowerCase(Locale.ENGLISH);
            NodeList platforms = root.getElementsByTagName("platform");
            for (int i = 0; i < platforms.getLength(); ++i) {
                element = (Element)platforms.item(i);
                platform = element.getAttribute("plat").toLowerCase(Locale.ENGLISH);
                process = false;
                if ("prt".equals(platform) || platform.equals(plat)) {
                    process = true;
                }
                if (!process) continue;
                NodeList properties = element.getElementsByTagName("property");
                for (j = 0; j < properties.getLength(); ++j) {
                    this.propertyList.add(new Property((Element)properties.item(j)));
                }
            }
            Object temp = null;
            for (int i = this.propertyList.size() - 1; i > 0; --i) {
                for (j = 0; j < i; ++j) {
                    if (((Property)this.propertyList.get(j)).getOrder() <= ((Property)this.propertyList.get(j + 1)).getOrder()) continue;
                    temp = this.propertyList.get(j);
                    this.propertyList.set(j, this.propertyList.get(j + 1));
                    this.propertyList.set(j + 1, temp);
                }
            }
        }

        public String getGroup() {
            return this.group;
        }

        public int getPropertyCount() {
            return this.propertyList.size();
        }

        public Property[] getProperties() {
            return this.propertyList.toArray(new Property[0]);
        }
    }
}

