/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.meta.SASOMI.ISecurity_1_1Helper;
import com.sas.metadata.MetadataWorkspace;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import org.omg.CORBA.Object;

public class CreateInternalAccount
extends TaskImpl {
    private String host = null;
    private String port = null;
    private String user = null;
    private String password = null;
    private String personname = null;
    private String personpassword = null;
    private String setoptions = "TRUE";

    @Override
    public boolean doWork() throws WebAppConfigException {
        boolean valid = true;
        try {
            MetadataWorkspace workspace = MetadataWorkspace.getWorkspace();
            IOMI omrConnection = workspace.makeOMRConnection(this.host, this.port, this.user, this.password);
            Logger.log(3, this, "Successful connection to the metadata server.  Host = " + this.host + " Port = " + this.port + " User = " + this.user);
            workspace.setCMRHandle(omrConnection);
            ISecurity_1_1 security = ISecurity_1_1Helper.narrow((Object)workspace.getCMRHandle());
            Logger.log(3, this, "Security object successfully created.");
            security.SetInternalPassword(this.personname, this.personpassword);
            Logger.log(3, this, "Internal password successfully set for " + this.personname + ".");
            if (this.setoptions.equalsIgnoreCase("TRUE")) {
                security.SetInternalLoginUserOptions(this.personname, false, true, false, false, 0, false, false, false, 0L);
                Logger.log(3, this, "Internal login options successfully set for " + this.personname + ".");
            }
            workspace.closeISecurityConnection((ISecurity)security);
            workspace.closeOMRConnection();
            Logger.log(3, this, "Connection to the metadata server successfully closed.");
        }
        catch (Exception e) {
            valid = false;
            Logger.log(0, this, "ERROR:  Error creating internal login: " + e.getMessage());
        }
        return valid;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPersonname(String personname) {
        this.personname = personname;
    }

    public void setPersonpassword(String personpassword) {
        this.personpassword = personpassword;
    }

    public void setSetoptions(String setoptions) {
        this.setoptions = setoptions;
    }
}

