/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.propertymgmt.BackSlashToSlashPropertyPreprocessor;
import com.sas.tools.webappconfig.propertymgmt.PropertyMap;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.Task;

public final class Copy
extends TaskImpl {
    private boolean _doRecurse;
    private PropertyMap _installProps;
    private TaskExceptionHelper _helper;

    @Override
    protected boolean doWork() throws WebAppConfigException {
        String[] destinations;
        String sourceDirs = this.getValue("files", "sourceDirs");
        String destDirMacros = this.getValue("destination", "destDirMacros");
        this._installProps = this.readProperties(new BackSlashToSlashPropertyPreprocessor(), "propsFileName", null);
        this._doRecurse = this.getValueAsBool("recurse", false);
        this._helper = new TaskExceptionHelper(sourceDirs, destDirMacros);
        String[] sources = CommonUtils.parseCommaDelimitedInput(sourceDirs, true);
        if (sources.length != (destinations = CommonUtils.parseCommaDelimitedInput(destDirMacros, true)).length) {
            throw new WebAppConfigException(ErrorHandling.generateDirectoryNumberMismatchErrorMessage(this, sourceDirs, destDirMacros), null);
        }
        for (int i = 0; i < destinations.length; ++i) {
            this.copyElement(sources[i], destinations[i]);
            this._helper.next();
        }
        return true;
    }

    private void copyElement(String source, String destination) throws WebAppConfigException {
        String sourceDir = this.getSourceDirectory(source);
        String destDir = this.getDestinationDirectory(destination);
        this.copyFiles(sourceDir, destDir);
    }

    private String getDestinationDirectory(String nextElement) throws WebAppConfigException {
        String rawDirectoryKey = nextElement;
        if (CommonUtils.isEmpty(rawDirectoryKey)) {
            throw new WebAppConfigException(ErrorHandling.generateEmptyParameterErrorMessage(this, this._helper.getIndex(), this._helper.getDestinationContext()), null);
        }
        String destDir = (String)this._installProps.get(Copy.cookDirectoryKey(rawDirectoryKey, "@"));
        if (!CommonUtils.isEmpty(destDir)) {
            return destDir;
        }
        destDir = (String)this._installProps.get(Copy.cookDirectoryKey(rawDirectoryKey, "$"));
        if (!CommonUtils.isEmpty(destDir)) {
            return destDir;
        }
        return rawDirectoryKey;
    }

    private static String cookDirectoryKey(String rawDirectoryKey, String delimiter) {
        StringBuffer token = new StringBuffer(rawDirectoryKey.length() + 2 * delimiter.length());
        token.append(delimiter).append(rawDirectoryKey).append(delimiter);
        return token.toString();
    }

    private String getSourceDirectory(String nextElement) throws WebAppConfigException {
        String sourceDir = nextElement;
        if (!CommonUtils.isEmpty(sourceDir)) {
            return sourceDir;
        }
        throw new WebAppConfigException(ErrorHandling.generateEmptyParameterErrorMessage(this, this._helper.getIndex(), this._helper.getSourceContext()), null);
    }

    private void copyFiles(String sourceDir, String destDir) throws WebAppConfigException {
        File sourceDirFile = new File(sourceDir);
        File destDirFile = new File(destDir);
        String sourcePath = null;
        String destPath = null;
        try {
            sourcePath = sourceDirFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, sourceDir), e);
        }
        try {
            destPath = destDirFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, destDir), e);
        }
        if (sourcePath.equals(destPath)) {
            return;
        }
        if (!sourceDirFile.exists()) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, sourceDir), null);
        }
        Logger.log(3, this, ErrorHandling.generateCopyingDirectoryInfoMessage(this, sourceDirFile, destDirFile));
        CommonUtils.ensureDirectoryExists(this, destDirFile);
        File[] files = sourceDirFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            CommonUtils.copyToDir(this, files[i], new File(destDirFile, files[i].getName()), this._doRecurse);
        }
    }

    private static class TaskExceptionHelper {
        private String _sourceContext;
        private String _destinationContext;
        private int _index;

        TaskExceptionHelper(String sourceContext, String destinationContext) {
            this._sourceContext = sourceContext;
            this._destinationContext = destinationContext;
            this._index = 1;
        }

        final String getSourceContext() {
            return this._sourceContext;
        }

        final String getDestinationContext() {
            return this._destinationContext;
        }

        final Integer getIndex() {
            return new Integer(this._index);
        }

        final void next() {
            ++this._index;
        }
    }
}

