/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.propertymgmt.PropertyMap;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Localization;
import com.sas.tools.webappconfig.util.WebAppConfigException;

public final class Condition
extends TaskImpl {
    private Boolean _value = null;

    private void getValue() throws WebAppConfigException {
        if (null == this._value) {
            this.calculateValue();
        }
    }

    private void calculateValue() throws WebAppConfigException {
        PropertyMap properties = this.readProperties(null, "files", "source");
        if (properties.isEmpty()) {
            throw new WebAppConfigException(ErrorHandling.generateNoPropertiesFilesDefinedErrorMessage(this), null);
        }
        String propertyName = this.getValue("property");
        String rawValues = this.getValue("value");
        if (!properties.containsKey(propertyName)) {
            String errorMessage = ErrorHandling.generatePropertyUndefinedErrorMessage(this, propertyName);
            throw new WebAppConfigException(errorMessage, null);
        }
        String value = (String)properties.get(propertyName);
        if (this.getValueAsBool("caseinsensitive", false)) {
            value = Localization.toLowerCase(value);
            rawValues = Localization.toLowerCase(rawValues);
        }
        boolean rval = this.scanForMatchingToken(value, rawValues);
        if (this.getValueAsBool("negate", false)) {
            rval = !rval;
        }
        String property = this.getValue("propertyname");
        String setting = rval ? "true" : "false";
        this.setProperty(property, setting);
        ErrorHandling.generatePropertySetMessage(this, property, setting);
        this._value = rval ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean scanForMatchingToken(String value, String rawValues) {
        String[] tokens = CommonUtils.parseCommaDelimitedInput(rawValues);
        for (int i = 0; i < tokens.length; ++i) {
            if (!value.equals(tokens[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean doWork() throws WebAppConfigException {
        this.getValue();
        return true;
    }
}

