/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.tools.ant.Task;

public final class AuditContent
extends TaskImpl {
    private static final int _INITIAL_MAP_SIZE = 16;
    private Set _exclusions;
    private Set _requirements;

    @Override
    protected boolean doWork() throws WebAppConfigException {
        this._exclusions = new HashSet(16);
        this._requirements = new HashSet(16);
        if (this.paramExists("excluded")) {
            this.populateList(this._exclusions, "excluded");
        }
        if (this.paramExists("required")) {
            this.populateList(this._requirements, "required");
        }
        return this.checkInputFiles(this.getValue("files"));
    }

    private void populateList(Set set, String paramName) throws WebAppConfigException {
        CommonUtils.extractSetOfLinesFromFile(this, set, new File(this.getValue(paramName)));
    }

    private boolean checkInputFiles(String files) {
        boolean status = true;
        String[] fileNames = CommonUtils.parseCommaDelimitedInput(files);
        for (int i = 0; i < fileNames.length; ++i) {
            status &= this.processInputFile(fileNames[i]);
        }
        return status;
    }

    private boolean processInputFile(String filename) {
        try {
            if (!this.checkFile(filename)) {
                return false;
            }
        }
        catch (WebAppConfigException e) {
            Logger.log(0, this, e);
            return false;
        }
        return true;
    }

    private boolean checkFile(String filename) throws WebAppConfigException {
        HashSet excludedStatus = new HashSet(this._exclusions);
        HashSet requiredStatus = new HashSet(this._requirements);
        boolean status = true;
        BufferedReader infile = null;
        try {
            infile = CommonUtils.getUTF8Reader((Task)this, filename);
        }
        catch (FileNotFoundException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage((Task)this, filename), e);
        }
        try {
            String line = null;
            while (null != (line = infile.readLine())) {
                Iterator iter = excludedStatus.iterator();
                while (iter.hasNext()) {
                    String exclusion = (String)iter.next();
                    if (-1 == line.indexOf(exclusion)) continue;
                    Logger.log(0, this, ErrorHandling.generateFoundExcludedStringErrorMessage(this, exclusion, filename));
                    iter.remove();
                    status = false;
                }
                iter = requiredStatus.iterator();
                while (iter.hasNext()) {
                    String requirement = (String)iter.next();
                    if (-1 == line.indexOf(requirement)) continue;
                    iter.remove();
                }
            }
        }
        catch (IOException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotReadFileErrorMessage((Task)this, filename), e);
        }
        CommonUtils.closeReader(infile);
        if (0 != requiredStatus.size()) {
            status = false;
            Iterator iter = requiredStatus.iterator();
            while (iter.hasNext()) {
                Logger.log(0, this, ErrorHandling.generateDidNotFindStringErrorMessage(this, iter.next().toString(), filename));
            }
        }
        return status;
    }
}

