/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.tasks;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.tools.webappconfig.tasks.ObjectPropertiesUtil;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.Logger;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.rmi.RemoteException;

public class AddDependency
extends TaskImpl {
    private String fqid = null;
    private String dependsonfqid = null;
    private String m_repositoryFQID = "";
    private String m_reposID = null;
    private MdFactory m_mdFactory = null;
    private MdObjectStore m_mdObjectStore = null;
    private boolean connected = false;

    private boolean validate() {
        if (this.fqid == null) {
            Logger.log(0, this, "Error during setting of properties.  Passed in FullyQualifiedID is null.");
            return false;
        }
        if (this.dependsonfqid == null) {
            Logger.log(0, this, "Error during setting of properties.  Passed in DependentFQID is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean doWork() throws WebAppConfigException {
        try {
            if (!this.validate()) {
                return false;
            }
            this.m_reposID = this.fqid.substring(0, 8);
            this.m_repositoryFQID = "A0000001." + this.m_reposID;
            String host = this.getProject().getProperty("iomsrv.metadatasrv.host");
            String port = this.getProject().getProperty("iomsrv.metadatasrv.port");
            String user = this.getProject().getProperty("metadata.connection.userid");
            String password = this.getProject().getProperty("metadata.connection.passwd");
            String repository = this.getProject().getProperty("oma.repository.foundation.name");
            this.connected = this.makeConnection(host, port, user, password, repository);
            if (!this.connected) {
                return false;
            }
            Root softwareComponent = this.getRoot(this.fqid);
            Root dependentComponent = this.getRoot(this.dependsonfqid);
            AssociationList al = ((DeployedComponent)softwareComponent).getDependsOnComponents();
            if (al == null) {
                Logger.log(0, this, "Error during adding of dependency.  Null dependency list.");
                return false;
            }
            al.add((Object)dependentComponent);
            Logger.log(2, this, "Added dependency for " + softwareComponent.getFQID() + " on Name:" + dependentComponent.getName() + " FQID:" + dependentComponent.getFQID() + "\n");
            softwareComponent.updateMetadataAll();
            return true;
        }
        catch (RemoteException e) {
            Logger.log(0, this, "Remote Exception during AddDependency Task.");
        }
        catch (MdException e) {
            Logger.log(0, this, "MdException during AddDependency Task.");
        }
        this.closeConnection();
        return false;
    }

    public void setFqid(String fqid) {
        this.fqid = fqid;
    }

    public void setDependsonfqid(String dependsonfqid) {
        this.dependsonfqid = dependsonfqid;
    }

    public boolean makeConnection(String host, String port, String user, String password, String repository) {
        this.m_mdFactory = ObjectPropertiesUtil.makeConnection(this, host, port, user, password);
        if (this.m_mdFactory == null) {
            return false;
        }
        this.m_mdObjectStore = ObjectPropertiesUtil.createObjectStore(this, this.m_mdFactory);
        if (this.m_mdObjectStore == null) {
            return false;
        }
        this.connected = true;
        return true;
    }

    public void closeConnection() {
        ObjectPropertiesUtil.closeConnection(this, this.m_mdFactory);
    }

    private Root getRoot(String myfqid) {
        return ObjectPropertiesUtil.getRoot(this, this.m_mdFactory, myfqid, this.m_mdObjectStore, this.m_repositoryFQID);
    }
}

