/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.propertymgmt;

import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.AssociationList;
import com.sas.metadata.CMetadata;
import com.sas.metadata.MdException;
import com.sas.metadata.MdObjectFactory;
import com.sas.metadata.MdStore;
import com.sas.metadata.MetadataUtil;
import com.sas.metadata.MetadataWorkspace;
import com.sas.metadata.Property;
import com.sas.metadata.PropertyGroup;
import com.sas.tools.webappconfig.propertymgmt.AbstractPropertySourceImpl;
import com.sas.tools.webappconfig.propertymgmt.KeyValuePair;
import com.sas.tools.webappconfig.propertymgmt.PropertyMap;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.tools.ant.Task;

public class MetadataPropertySource
extends AbstractPropertySourceImpl {
    private static final int _METADATA_FLAGS = 388;
    private static final String _DEFAULT_REPOSITORY = "Foundation";
    private String _serverHost = null;
    private String _serverPort = null;
    private String _serverUserid = null;
    private String _serverPassword = null;
    private String _repositoryName = "Foundation";
    private boolean _debugTraffic = false;
    private String _xmlSource = null;
    private IOMI _omr;
    private String _repositoryID;
    private static final String _SEARCH_OPTIONS = "<XMLSelect search=\"PropertyGroup[@Name='SAS Master Configuration']\"/><Templates><Property Name=\"\" Desc=\"\" PropertyName=\"\" DefaultValue=\"\"/><PropertyGroup Name=\"\"><GroupedProperties/></PropertyGroup></Templates>";

    public void setHost(String host) {
        this._serverHost = host;
    }

    public void setPort(String port) {
        this._serverPort = port;
    }

    public void setUserid(String userid) {
        this._serverUserid = userid;
    }

    public void setPassword(String password) {
        this._serverPassword = password;
    }

    public void setRepository(String repository) {
        this._repositoryName = repository;
    }

    public void setQuery(String query) {
        this._xmlSource = query;
    }

    public void setDebug(boolean debug) {
        this._debugTraffic = debug;
    }

    private void getOMRConnection(Task task) throws WebAppConfigException {
        MdObjectFactory.getInstance().setLoggingEnabled(this._debugTraffic);
        MetadataWorkspace workspace = MetadataWorkspace.getWorkspace();
        try {
            this._omr = workspace.makeOMRConnection(this._serverHost, this._serverPort, this._serverUserid, this._serverPassword);
        }
        catch (Exception e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotConnectToSASMetadataServerErrorMessage(task, this._serverHost, this._serverPort), e);
        }
        workspace.setCMRHandle(this._omr);
    }

    private AssociationList getPropertiesFromRepository(Task task) throws WebAppConfigException {
        AssociationList groupedProperties;
        List objects;
        try {
            objects = MetadataUtil.getMetadataObjectsSubset((IOMI)this._omr, (MdStore)MdObjectFactory.createObjectStore(), (String)this._repositoryID, (String)"PropertyGroup", (int)388, (String)this.getQuery(task), (boolean)false);
        }
        catch (MdException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotAccessSASMetadataServerErrorMessage(task, this._serverHost, this._serverPort), e);
        }
        if (objects.isEmpty()) {
            throw new WebAppConfigException(ErrorHandling.generateCannotFindSASMasterConfigurationErrorMessage(task, this._repositoryName), null);
        }
        if (objects.size() > 1) {
            throw new WebAppConfigException(ErrorHandling.generateMultipleConfigurationPropertyGroupsDetectedErrorMessage(task), null);
        }
        try {
            groupedProperties = ((PropertyGroup)objects.get(0)).getGroupedProperties(true);
        }
        catch (MdException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotAccessPropertiesErrorMessage(task), e);
        }
        return groupedProperties;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getQuery(Task task) throws WebAppConfigException {
        String query = _SEARCH_OPTIONS;
        if (null == this._xmlSource) return query;
        BufferedReader reader = null;
        try {
            reader = CommonUtils.getUTF8Reader(task, this._xmlSource);
            StringBuffer buffer = new StringBuffer((int)new File(this._xmlSource).length());
            String line = reader.readLine();
            while (null != line) {
                buffer.append(line);
                line = reader.readLine();
            }
            query = buffer.toString();
        }
        catch (FileNotFoundException e) {
            try {
                String message = ErrorHandling.generateCannotOpenFileErrorMessage(task, this._xmlSource);
                throw new WebAppConfigException(message, e);
                catch (IOException e2) {
                    message = ErrorHandling.generateCannotReadFileErrorMessage(task, this._xmlSource);
                    throw new WebAppConfigException(message, e2);
                }
            }
            catch (Throwable throwable) {
                CommonUtils.closeReader(reader);
                throw throwable;
            }
        }
        CommonUtils.closeReader(reader);
        return query;
    }

    private String lookupSpecifiedRepository(Task task) throws WebAppConfigException {
        List repositories;
        try {
            repositories = MetadataUtil.getRepositories();
        }
        catch (MdException e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotGetListOfAvailableRepositoriesErrorMessage(task), e);
        }
        for (CMetadata cm : repositories) {
            if (!this._repositoryName.equals(cm.getName())) continue;
            return cm.getId();
        }
        throw new WebAppConfigException(ErrorHandling.generateCannotFindRepositoryErrorMessage(task, this._repositoryName), null);
    }

    @Override
    protected void doResolveMyProperties(Task task, PropertyMap map) throws WebAppConfigException {
        this.getOMRConnection(task);
        this._repositoryID = this.lookupSpecifiedRepository(task);
        AssociationList properties1 = this.getPropertiesFromRepository(task);
        for (Property property : properties1) {
            String name = property.getName();
            String value = property.getDefaultValue();
            KeyValuePair pair = new KeyValuePair(name, value);
            if (null == (pair = this.validateKeyAndValue(pair))) continue;
            this.executePreprocessor(pair);
            if (null == (pair = this.validateKeyAndValue(pair))) continue;
            map.put(pair.getKey(), pair.getValue());
        }
    }

    @Override
    protected void initialize(Task task) throws WebAppConfigException {
        if (null == this._serverHost) {
            throw new WebAppConfigException(ErrorHandling.generateMissingParameterErrorMessage(task, "host"), null);
        }
        if (null == this._serverPort) {
            throw new WebAppConfigException(ErrorHandling.generateMissingParameterErrorMessage(task, "port"), null);
        }
        if (null == this._serverUserid) {
            throw new WebAppConfigException(ErrorHandling.generateMissingParameterErrorMessage(task, "userid"), null);
        }
        if (null == this._serverPassword) {
            throw new WebAppConfigException(ErrorHandling.generateMissingParameterErrorMessage(task, "password"), null);
        }
    }

    @Override
    public String getMyDefinition() {
        int rawLength = 2 + this._repositoryName.length() + this._serverHost.length() + this._serverPort.length();
        StringBuffer buffer = new StringBuffer(rawLength);
        buffer.append(this._repositoryName);
        buffer.append('@');
        buffer.append(this._serverHost);
        buffer.append(':');
        buffer.append(this._serverPort);
        return buffer.toString();
    }

    @Override
    protected boolean doWork() throws WebAppConfigException {
        return false;
    }
}

