/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.propertymgmt;

import com.sas.tools.webappconfig.propertymgmt.AbstractPropertySourceImpl;
import com.sas.tools.webappconfig.propertymgmt.KeyValuePair;
import com.sas.tools.webappconfig.propertymgmt.PropertyMap;
import com.sas.tools.webappconfig.util.CommonUtils;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.tools.ant.Task;

public final class FilePropertySource
extends AbstractPropertySourceImpl {
    private static final char _COMMENT_CHARACTER = '#';
    private String _filename;
    private boolean _isOptional;

    public FilePropertySource() {
        this(null, false);
    }

    public void setFile(String filename) {
        this._filename = filename.trim();
    }

    public void setOptional(boolean optional) {
        this._isOptional = optional;
    }

    public FilePropertySource(String filename, boolean isOptional) {
        this._isOptional = isOptional;
        this._filename = filename;
    }

    /*
     * Loose catch block
     */
    @Override
    protected void doResolveMyProperties(Task task, PropertyMap map) throws WebAppConfigException {
        BufferedReader in = null;
        try {
            in = CommonUtils.getUTF8Reader(task, this._filename);
            String line = null;
            while (null != (line = in.readLine())) {
                KeyValuePair pair = this.preprocessLine(line);
                if (null == pair) continue;
                this.executePreprocessor(pair);
                if (null == (pair = this.validateKeyAndValue(pair))) continue;
                map.put(pair.getKey(), pair.getValue());
            }
        }
        catch (FileNotFoundException e) {
            block7: {
                if (this._isOptional) break block7;
                throw new WebAppConfigException(ErrorHandling.generateCannotOpenFileErrorMessage(task, this._filename), e);
            }
            CommonUtils.closeReader(in);
        }
        catch (IOException e2) {
            throw new WebAppConfigException(ErrorHandling.generateCannotReadFileErrorMessage(task, this._filename), e2);
            {
                catch (Throwable throwable) {
                    CommonUtils.closeReader(in);
                    throw throwable;
                }
            }
        }
        CommonUtils.closeReader(in);
    }

    private KeyValuePair preprocessLine(String line) {
        if (CommonUtils.isEmpty(line)) {
            return null;
        }
        if (line.charAt(0) == '#') {
            return null;
        }
        int i = line.indexOf(61);
        if (-1 != i) {
            KeyValuePair pair = new KeyValuePair(line.substring(0, i).trim(), line.substring(i + 1).trim());
            return this.validateKeyAndValue(pair);
        }
        return null;
    }

    @Override
    protected void initialize(Task task) throws WebAppConfigException {
        if (null == this._filename) {
            throw new WebAppConfigException(ErrorHandling.generateMissingParameterErrorMessage(task, "file"), null);
        }
    }

    @Override
    public String getMyDefinition() {
        if (!this._isOptional) {
            return this._filename;
        }
        StringBuffer buffer = new StringBuffer(this._filename.length() + 1);
        buffer.append('*');
        buffer.append(this._filename);
        return buffer.toString();
    }

    @Override
    protected boolean doWork() throws WebAppConfigException {
        return false;
    }
}

