/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.propertymgmt;

import com.sas.tools.webappconfig.propertymgmt.AbstractPropertyPreprocessor;
import com.sas.tools.webappconfig.propertymgmt.KeyValuePair;
import com.sas.tools.webappconfig.propertymgmt.PropertyMap;
import com.sas.tools.webappconfig.propertymgmt.PropertySourceInterface;
import com.sas.tools.webappconfig.tasks.TaskImpl;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.Task;

public abstract class AbstractPropertySourceImpl
extends TaskImpl
implements PropertySourceInterface {
    private List _sources = new ArrayList();
    private String _string = null;
    private List _definitions = null;
    private AbstractPropertyPreprocessor _preprocessor;

    protected AbstractPropertySourceImpl() {
    }

    private void modified() {
        this._string = null;
        this._definitions = null;
    }

    @Override
    public final void setPreprocessor(AbstractPropertyPreprocessor preprocessor) {
        this._preprocessor = preprocessor;
        for (PropertySourceInterface source : this._sources) {
            source.setPreprocessor(preprocessor);
        }
        this.modified();
    }

    protected void executePreprocessor(KeyValuePair pair) {
        if (null != this._preprocessor) {
            this._preprocessor.setPair(pair);
            this._preprocessor.preprocessEntry();
        }
    }

    protected abstract void initialize(Task var1) throws WebAppConfigException;

    @Override
    public final PropertyMap resolveProperties(Task task) throws WebAppConfigException {
        this.initialize(task);
        PropertyMap map = new PropertyMap();
        this.doResolveMyProperties(task, map);
        for (PropertySourceInterface source : this._sources) {
            PropertyMap nextMap = source.resolveProperties(task);
            for (Map.Entry property : nextMap.entrySet()) {
                map.put(property.getKey(), property.getValue());
            }
        }
        return map;
    }

    protected abstract void doResolveMyProperties(Task var1, PropertyMap var2) throws WebAppConfigException;

    @Override
    public final void addPropertySource(Task task, PropertySourceInterface source) throws WebAppConfigException {
        this._sources.add(source);
        if (null != this._preprocessor) {
            source.setPreprocessor(this._preprocessor);
        }
        this.modified();
    }

    @Override
    public final List getDefinitions() {
        if (null == this._definitions) {
            this._definitions = new ArrayList();
            String myDefinition = this.getMyDefinition();
            if (null != myDefinition) {
                this._definitions.add(myDefinition);
            }
            this.addSubordinateDefinitions(this._definitions);
        }
        return this._definitions;
    }

    protected void addSubordinateDefinitions(List definitions) {
        for (PropertySourceInterface source : this._sources) {
            String sourceDefinition = source.getMyDefinition();
            if (null == sourceDefinition) continue;
            definitions.add(sourceDefinition);
        }
    }

    protected int getSourceCount() {
        return this._sources.size();
    }

    protected KeyValuePair validateKeyAndValue(KeyValuePair pair) {
        return pair.isValid() ? pair : null;
    }

    private static String definitionsToString(List definitions) {
        int rawLength = 2;
        Iterator iter = definitions.iterator();
        while (iter.hasNext()) {
            rawLength += ((String)iter.next()).length();
        }
        if (definitions.size() > 1) {
            rawLength += 2 * (definitions.size() - 1);
        }
        StringBuffer buffer = new StringBuffer(rawLength);
        buffer.append('[');
        Iterator iter2 = definitions.iterator();
        while (iter2.hasNext()) {
            buffer.append(iter2.next());
            if (!iter2.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String toString() {
        if (null == this._string) {
            this._string = AbstractPropertySourceImpl.definitionsToString(this.getDefinitions());
        }
        return this._string;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractPropertySourceImpl)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }
}

