/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.products;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.TextStore;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.tools.webappconfig.tasks.ConnectionAntProperties;
import com.sas.tools.webappconfig.tasks.ObjectPropertiesUtil;
import com.sas.tools.webappconfig.tasks.VaBaseModeledProperties;
import com.sas.tools.webappconfig.util.Logger;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class saslaunchcfgModeledProperties
extends VaBaseModeledProperties {
    private static final String TCPIP_CONNECTION_TYPE = "TCPIPConnection";
    private static final String LAUNCHER_SERVER_PORT_PROPERTY = "saslaunchcfg.server.component.port";
    private static final String TCPIP_CONNECTION_PROPERTY = "saslaunchcfg.tcpip.connection.name";
    private static List _propData = null;
    private static ConnectionAntProperties _connectionAntProperties = null;

    @Override
    public Properties getModeledProperties(Root root) {
        Properties retval = super.getModeledProperties(root);
        String repository = null;
        String launcher_connection = null;
        Object twelve_byte = null;
        TextStore publicTextStore = ObjectPropertiesUtil.getTextStore(null, root, true);
        if (publicTextStore != null) {
            Logger.log(2, null, "Private Text Store: ");
            Properties publicProps = this.createProperties(publicTextStore);
            launcher_connection = publicProps.getProperty(TCPIP_CONNECTION_PROPERTY);
            Logger.log(2, null, "saslaunchcfg.tcpip.connection.name: " + launcher_connection);
        }
        try {
            Logger.log(2, null, "Setting up connection to metadata repo.");
            repository = "A0000001." + root.getRepositoryID();
            Logger.log(2, null, "Repository:" + repository);
            MdFactory factory = root.getObjectStore().getFactory();
            Logger.log(2, null, "Factory set.");
            MdObjectStore store = (MdObjectStore)root.getObjectStore();
            Logger.log(2, null, "Store set.");
            Logger.log(2, null, "Retrieve port.");
            String TCPIP_Port = saslaunchcfgModeledProperties.getTCPIPServerPort(factory, store, repository, root, launcher_connection);
            if (TCPIP_Port != null) {
                retval.setProperty(LAUNCHER_SERVER_PORT_PROPERTY, TCPIP_Port);
            }
        }
        catch (RemoteException e) {
            Logger.log(0, null, "RemoteException encountered - Using textstore values");
            e.printStackTrace();
        }
        catch (MdException e) {
            Logger.log(0, null, "MdException encountered - Using textstore values");
            e.printStackTrace();
        }
        catch (Throwable t) {
            Logger.log(0, null, "Throwable encountered - Using textstore values");
            t.printStackTrace();
        }
        return retval;
    }

    @Override
    public List getPropertyData() {
        return _propData;
    }

    @Override
    public ConnectionAntProperties getConnectionAntProperties() {
        return _connectionAntProperties;
    }

    public static String getTCPIPServerPort(MdFactory factory, MdObjectStore store, String repository, Root root, String launcher_server) throws RemoteException, MdException {
        Logger.log(2, null, "ENTER getTCPIPServerPort.");
        String serverPort = null;
        int my_flags = 385;
        String search_string = "<XMLSelect search=\"TCPIPConnection[@Name='" + launcher_server + "']\" />";
        Logger.log(2, null, "Search string is: " + search_string + " for type: " + TCPIP_CONNECTION_TYPE);
        List list = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repository, TCPIP_CONNECTION_TYPE, my_flags, search_string);
        if (list == null || list.size() != 1) {
            Logger.log(2, null, "No single TCPIP connection found for " + launcher_server + " identifer. Using textstore values");
        } else {
            TCPIPConnection connection = (TCPIPConnection)list.get(0);
            serverPort = String.valueOf(connection.getPort());
            Logger.log(2, null, "For Connection " + connection.getName() + " using port: " + serverPort);
        }
        Logger.log(2, null, "EXIT getTCPIPServerPort.");
        return serverPort;
    }

    private Properties createProperties(TextStore textStore) {
        Properties props = new Properties();
        try {
            String storedTextAttribute = textStore.getStoredText();
            StringReader reader = new StringReader(storedTextAttribute);
            PropertyMap myProperties = new PropertyMap();
            myProperties.load((Reader)reader);
            Iterator iterator = myProperties.getPropertyIterator();
            while (iterator.hasNext()) {
                String propName = (String)iterator.next();
                String propValue = myProperties.getProperty(propName);
                Logger.log(3, null, propName + "=" + propValue);
                props.put(propName, propValue);
            }
        }
        catch (Exception e) {
            Logger.log(0, null, "Error retrieving text from TextStore: " + e.getMessage());
            Logger.log(0, null, " TextStore: " + textStore);
            return null;
        }
        return props;
    }
}

