/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.products;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.tools.webappconfig.tasks.PropertyData;
import com.sas.tools.webappconfig.tasks.WebappBaseModeledProperties;
import com.sas.tools.webappconfig.util.Logger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class clasvrcModeledProperties
extends WebappBaseModeledProperties {
    private static final String SAS = "SAS";
    private static final String CLASVRC_APDM_LIBREF = "clasvrc.apdm.libref";
    private static final String CLASVRC_BDM_DATABASE_TYPE = "clasvrc.cla.bdm.dbms.type";
    private static final String CLASVRC_ANI_LIBREF = "clasvrc.analytics.inter.libref";
    private static final String CLASVRC_ANO_LIBREF = "clasvrc.analytics.output.libref";
    private static final String CLASVRC_BDI_LIBREF = "clasvrc.bdm.intermediate.libref";
    private static final String CLASVRC_BDO_LIBREF = "clasvrc.bdm.output.libref";
    private static final String DBMS_APDM_LIBREF_PROPERTY = "data.clasvrc.dbms.apdm.libref";
    private static final String DBMS_APDM_LIBNAME_PROPERTY = "data.clasvrc.dbms.apdm.libname";
    private static final String DBMS_APDM_DATABASE_PROPERTY = "data.clasvrc.dbms.apdm.database.name";
    private static final String DBMS_APDM_USERID_PROPERTY = "data.clasvrc.dbms.apdm.userid";
    private static final String DBMS_APDM_DOMAIN_PROPERTY = "data.clasvrc.dbms.apdm.domain";
    private static final String DBMS_BDM_TYPE_PROPERTY = "data.clasvrc.dbms.bdm.type";
    private static final String DBMS_BDM_USERID_PROPERTY = "data.clasvrc.dbms.bdm.userid";
    private static final String DBMS_BDM_DOMAIN_PROPERTY = "data.clasvrc.dbms.bdm.domain";
    private static final String DBMS_BDM_HOST_PROPERTY = "data.clasvrc.dbms.bdm.host";
    private static final String DBMS_ANI_LIBREF_PROPERTY = "data.clasvrc.dbms.ani.libref";
    private static final String DBMS_ANI_LIBNAME_PROPERTY = "data.clasvrc.dbms.ani.libname";
    private static final String DBMS_ANI_SCHEMA_PAROPERTY = "data.clasvrc.dbms.ani.schema.name";
    private static final String DBMS_ANO_LIBREF_PROPERTY = "data.clasvrc.dbms.anop.libref";
    private static final String DBMS_ANO_LIBNAME_PROPERTY = "data.clasvrc.dbms.anop.libname";
    private static final String DBMS_ANO_SCHEMA_PAROPERTY = "data.clasvrc.dbms.anop.schema.name";
    private static final String DBMS_BDI_LIBREF_PROPERTY = "data.clasvrc.dbms.bdmi.libref";
    private static final String DBMS_BDI_LIBNAME_PROPERTY = "data.clasvrc.dbms.bdmi.libname";
    private static final String DBMS_BDI_SCHEMA_PAROPERTY = "data.clasvrc.dbms.bdmi.schema.name";
    private static final String DBMS_BDO_LIBREF_PROPERTY = "data.clasvrc.dbms.bdmop.libref";
    private static final String DBMS_BDO_LIBNAME_PROPERTY = "data.clasvrc.dbms.bdmop.libname";
    private static final String DBMS_BDO_SCHEMA_PAROPERTY = "data.clasvrc.dbms.bdmop.schema.name";
    private static final String POSTGRES_DATABASE_PROPERTYNAME = "DATABASE";
    private static final String TERADATA_HOST_PAROPERTYNAME = "SERVER";
    private static final List _propData = new ArrayList();

    @Override
    public List getPropertyData() {
        return _propData;
    }

    @Override
    public Properties getModeledProperties(Root root) {
        Properties retval = new Properties();
        SoftwareComponent configObject = (SoftwareComponent)root;
        Properties librefProperties = super.getModeledProperties(root);
        String apdmLibref = librefProperties.getProperty(DBMS_APDM_LIBREF_PROPERTY);
        Logger.log(2, null, "Libref: \"" + apdmLibref + "\"");
        try {
            MdObjectStore mdStore = (MdObjectStore)configObject.getObjectStore();
            String reposId = "A0000001." + configObject.getRepositoryID();
            SASLibrary apdmLib = this.getLibraryWithLibref(mdStore, reposId, apdmLibref);
            if (apdmLib != null) {
                retval.setProperty(DBMS_APDM_LIBNAME_PROPERTY, apdmLib.getName());
                Logger.log(2, null, "SASLibrary: " + apdmLib.getName());
                retval.setProperty(DBMS_APDM_USERID_PROPERTY, apdmLib.getDefaultLogin().getUserID());
                retval.setProperty(DBMS_APDM_DOMAIN_PROPERTY, apdmLib.getDefaultLogin().getDomain().getName());
                AssociationList properties = apdmLib.getProperties();
                retval.setProperty(DBMS_APDM_DATABASE_PROPERTY, this.getPropertyByPropertyName((List)properties, POSTGRES_DATABASE_PROPERTYNAME).getDefaultValue().replace("\"", ""));
            } else {
                Logger.log(1, null, "Could not find a SAS Library with the specified libref: " + apdmLibref);
            }
            String bdmType = librefProperties.getProperty(DBMS_BDM_TYPE_PROPERTY);
            if (!bdmType.equals(SAS)) {
                String bdmSchema;
                String bdmLibref = librefProperties.getProperty(DBMS_ANI_LIBREF_PROPERTY);
                SASLibrary bdmLib = this.getLibraryWithLibref(mdStore, reposId, bdmLibref);
                if (bdmLib != null) {
                    retval.setProperty(DBMS_ANI_LIBNAME_PROPERTY, bdmLib.getName());
                    Logger.log(2, null, "SASLibrary: " + bdmLib.getName());
                    retval.setProperty(DBMS_BDM_USERID_PROPERTY, bdmLib.getDefaultLogin().getUserID());
                    retval.setProperty(DBMS_BDM_DOMAIN_PROPERTY, bdmLib.getDefaultLogin().getDomain().getName());
                    bdmSchema = this.getDatabaseSchema(bdmLib);
                    retval.setProperty(DBMS_ANI_SCHEMA_PAROPERTY, bdmSchema.replace("\"", ""));
                    SASClientConnection clientConn = bdmLib.getLibraryConnection();
                    AssociationList properties = clientConn.getProperties();
                    retval.setProperty(DBMS_BDM_HOST_PROPERTY, this.getPropertyByPropertyName((List)properties, TERADATA_HOST_PAROPERTYNAME).getDefaultValue().replace("\"", ""));
                } else {
                    Logger.log(1, null, "Could not find a SAS Library with the specified libref: " + bdmLibref);
                }
                bdmLibref = librefProperties.getProperty(DBMS_ANO_LIBREF_PROPERTY);
                bdmLib = this.getLibraryWithLibref(mdStore, reposId, bdmLibref);
                if (bdmLib != null) {
                    retval.setProperty(DBMS_ANO_LIBNAME_PROPERTY, bdmLib.getName());
                    Logger.log(2, null, "SASLibrary: " + bdmLib.getName());
                    bdmSchema = this.getDatabaseSchema(bdmLib);
                    if (bdmSchema != null) {
                        retval.setProperty(DBMS_ANO_SCHEMA_PAROPERTY, bdmSchema.replace("\"", ""));
                    }
                } else {
                    Logger.log(1, null, "Could not find a SAS Library with the specified libref: " + bdmLibref);
                }
                bdmLibref = librefProperties.getProperty(DBMS_BDI_LIBREF_PROPERTY);
                bdmLib = this.getLibraryWithLibref(mdStore, reposId, bdmLibref);
                if (bdmLib != null) {
                    retval.setProperty(DBMS_BDI_LIBNAME_PROPERTY, bdmLib.getName());
                    Logger.log(2, null, "SASLibrary: " + bdmLib.getName());
                    bdmSchema = this.getDatabaseSchema(bdmLib);
                    if (bdmSchema != null) {
                        retval.setProperty(DBMS_BDI_SCHEMA_PAROPERTY, bdmSchema.replace("\"", ""));
                    }
                } else {
                    Logger.log(1, null, "Could not find a SAS Library with the specified libref: " + bdmLibref);
                }
                bdmLibref = librefProperties.getProperty(DBMS_BDO_LIBREF_PROPERTY);
                bdmLib = this.getLibraryWithLibref(mdStore, reposId, bdmLibref);
                if (bdmLib != null) {
                    retval.setProperty(DBMS_BDO_LIBNAME_PROPERTY, bdmLib.getName());
                    Logger.log(2, null, "SASLibrary: " + bdmLib.getName());
                    bdmSchema = this.getDatabaseSchema(bdmLib);
                    if (bdmSchema != null) {
                        retval.setProperty(DBMS_BDO_SCHEMA_PAROPERTY, bdmSchema.replace("\"", ""));
                    }
                } else {
                    Logger.log(1, null, "Could not find a SAS Library with the specified libref: " + bdmLibref);
                }
            } else {
                String bdmLibref = librefProperties.getProperty(DBMS_ANI_LIBREF_PROPERTY);
                SASLibrary bdmLib = this.getLibraryWithLibref(mdStore, reposId, bdmLibref);
                if (bdmLib != null) {
                    retval.setProperty(DBMS_ANI_LIBNAME_PROPERTY, bdmLib.getName());
                    Logger.log(2, null, "SASLibrary: " + bdmLib.getName());
                } else {
                    Logger.log(1, null, "Could not find a SAS Library with the specified libref: " + bdmLibref);
                }
                bdmLibref = librefProperties.getProperty(DBMS_ANO_LIBREF_PROPERTY);
                bdmLib = this.getLibraryWithLibref(mdStore, reposId, bdmLibref);
                if (bdmLib != null) {
                    retval.setProperty(DBMS_ANO_LIBNAME_PROPERTY, bdmLib.getName());
                    Logger.log(2, null, "SASLibrary: " + bdmLib.getName());
                } else {
                    Logger.log(1, null, "Could not find a SAS Library with the specified libref: " + bdmLibref);
                }
                bdmLibref = librefProperties.getProperty(DBMS_BDI_LIBREF_PROPERTY);
                bdmLib = this.getLibraryWithLibref(mdStore, reposId, bdmLibref);
                if (bdmLib != null) {
                    retval.setProperty(DBMS_BDI_LIBNAME_PROPERTY, bdmLib.getName());
                    Logger.log(2, null, "SASLibrary: " + bdmLib.getName());
                } else {
                    Logger.log(1, null, "Could not find a SAS Library with the specified libref: " + bdmLibref);
                }
                bdmLibref = librefProperties.getProperty(DBMS_BDO_LIBREF_PROPERTY);
                bdmLib = this.getLibraryWithLibref(mdStore, reposId, bdmLibref);
                if (bdmLib != null) {
                    retval.setProperty(DBMS_BDO_LIBNAME_PROPERTY, bdmLib.getName());
                    Logger.log(2, null, "SASLibrary: " + bdmLib.getName());
                } else {
                    Logger.log(1, null, "Could not find a SAS Library with the specified libref: " + bdmLibref);
                }
            }
        }
        catch (RemoteException e) {
            Logger.log(0, null, "clasvrcModeledProperties: " + e.getMessage());
        }
        catch (MdException e) {
            Logger.log(0, null, "clasvrcModeledProperties: " + e.getMessage());
        }
        return retval;
    }

    public static List findMetadataObjects(MdObjectStore mdObjectStore, String reposId, String mdType, String xmlSelect) throws MdException, RemoteException {
        MdFactory factory = mdObjectStore.getFactory();
        MdOMIUtil util = factory.getOMIUtil();
        List objectList = util.getMetadataObjectsSubset((MdStore)mdObjectStore, reposId, mdType, 384, xmlSelect);
        return objectList;
    }

    private String getDatabaseSchema(SASLibrary owner) throws RemoteException, MdException {
        String retval = null;
        AssociationList usingPackages = owner.getUsingPackages();
        for (Root usingPackage : usingPackages) {
            if (!(usingPackage instanceof DatabaseSchema)) continue;
            DatabaseSchema schema = (DatabaseSchema)usingPackage;
            retval = schema.getSchemaName();
            break;
        }
        return retval;
    }

    private Property getPropertyByPropertyName(List properties, String propertyName) throws RemoteException {
        Property retval = null;
        for (Property property : properties) {
            if (!property.getPropertyName().equals(propertyName)) continue;
            retval = property;
            break;
        }
        return retval;
    }

    private SASLibrary getLibraryWithLibref(MdObjectStore mdObjectStore, String reposId, String libref) throws RemoteException, MdException {
        String mdType = "SASLibrary";
        String xmlSelect = "<XMLSELECT Search=\"@Libref='" + libref + "'\"/>";
        Logger.log(2, null, reposId);
        Logger.log(2, null, mdType);
        Logger.log(2, null, xmlSelect);
        List found = clasvrcModeledProperties.findMetadataObjects(mdObjectStore, reposId, mdType, xmlSelect);
        SASLibrary sasLib = null;
        if (found != null && found.size() > 0) {
            sasLib = (SASLibrary)found.get(0);
        }
        return sasLib;
    }

    static {
        _propData.add(new PropertyData(CLASVRC_APDM_LIBREF, DBMS_APDM_LIBREF_PROPERTY));
        _propData.add(new PropertyData(CLASVRC_BDM_DATABASE_TYPE, DBMS_BDM_TYPE_PROPERTY));
        _propData.add(new PropertyData(CLASVRC_ANI_LIBREF, DBMS_ANI_LIBREF_PROPERTY));
        _propData.add(new PropertyData(CLASVRC_ANO_LIBREF, DBMS_ANO_LIBREF_PROPERTY));
        _propData.add(new PropertyData(CLASVRC_BDI_LIBREF, DBMS_BDI_LIBREF_PROPERTY));
        _propData.add(new PropertyData(CLASVRC_BDO_LIBREF, DBMS_BDO_LIBREF_PROPERTY));
    }
}

