/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.products;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.tools.webappconfig.tasks.ModeledPropertyInterface;
import com.sas.tools.webappconfig.util.Logger;
import java.rmi.RemoteException;
import java.util.Properties;

public class cladbsvrcModeledProperties
implements ModeledPropertyInterface {
    private static final String DBMS_HOST_PROPERTY = "iomsrv.cladbsvrc.host";
    private static final String DBMS_PORT_PROPERTY = "iomsrv.cladbsvrc.port";
    private static final String DBMS_DOMAIN_PROPERTY = "iomsrv.cladbsvrc.authdomain";
    private static final String POSTGRES_HOST_PAROPERTYNAME = "SERVER";
    private static final String POSTGRES_PORT_PAROPERTYNAME = "PORT";

    @Override
    public Properties getModeledProperties(Root root) {
        Properties retval = new Properties();
        try {
            String serverName = root.getName();
            Connection connection = this.getConnectionNamed(root, serverName);
            if (connection == null) {
                String eMessage = "The connection, " + serverName + ", was not found.";
                Logger.log(0, null, eMessage);
                throw new MdException(eMessage);
            }
            String host = this.getPropertyNamed(connection, POSTGRES_HOST_PAROPERTYNAME).getDefaultValue();
            retval.setProperty(DBMS_HOST_PROPERTY, host);
            Logger.log(2, null, "DBMS Host: " + host);
            String port = this.getPropertyNamed(connection, POSTGRES_PORT_PAROPERTYNAME).getDefaultValue();
            retval.setProperty(DBMS_PORT_PROPERTY, port);
            Logger.log(2, null, "DBMS Port: " + port);
            String domain = connection.getDomain().getName();
            retval.setProperty(DBMS_DOMAIN_PROPERTY, domain);
            Logger.log(2, null, "DBMS Auth Domain: " + domain);
        }
        catch (RemoteException e) {
            Logger.log(0, null, e.getMessage());
        }
        catch (MdException e) {
            Logger.log(0, null, e.getMessage());
        }
        return retval;
    }

    private Connection getConnectionNamed(Root owner, String name) throws RemoteException, MdException {
        Connection retval = null;
        ServerComponent sc = (ServerComponent)owner;
        AssociationList connections = sc.getSourceConnections();
        for (Connection connection : connections) {
            if (!connection.getName().equals(name)) continue;
            retval = connection;
            break;
        }
        return retval;
    }

    private Property getPropertyNamed(Connection conn, String name) throws RemoteException, MdException {
        Property retval = null;
        AssociationList properties = conn.getProperties();
        for (Property property : properties) {
            if (!property.getPropertyName().equals(name)) continue;
            retval = property;
            break;
        }
        return retval;
    }
}

