/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.webappconfig.password;

import com.sas.tools.webappconfig.password.FileRule;
import com.sas.tools.webappconfig.password.PasswordRule;
import com.sas.tools.webappconfig.util.ErrorHandling;
import com.sas.tools.webappconfig.util.WebAppConfigException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.Task;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RulesParser
extends DefaultHandler {
    private SAXParserFactory _factory;
    private InputStream _rulesStream;
    private FileRule _currentFile;
    private PasswordRule _currentPassword;
    private List _rules;
    private Properties _properties;
    private String _configLevel;
    private Task _task;
    private String _filename;

    public RulesParser(Task task, String filename, String configLevel) {
        this._task = task;
        this._filename = filename;
        this._configLevel = configLevel;
        this._factory = SAXParserFactory.newInstance();
        this._rules = new LinkedList();
    }

    public List getRules() throws WebAppConfigException {
        try {
            this._factory.newSAXParser().parse(this._rulesStream, (DefaultHandler)this);
        }
        catch (Exception e) {
            throw new WebAppConfigException(ErrorHandling.generateCannotReadFileErrorMessage(this._task, this._filename), e);
        }
        return this._rules;
    }

    public void setRulesStream(InputStream rulesStream) {
        this._rulesStream = rulesStream;
    }

    public void setProperties(Properties properties) {
        this._properties = properties;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (FileRule.getElementName().equals(qName)) {
            HashMap attributeMap = new HashMap();
            this.populateAttributeMap(attributes, attributeMap, FileRule.getAttributeNames());
            this._currentFile = new FileRule(this._properties, attributeMap, this._configLevel);
        } else if (PasswordRule.getElementName().equals(qName)) {
            HashMap attributeMap = new HashMap();
            this.populateAttributeMap(attributes, attributeMap, PasswordRule.getAttributeNames());
            this._currentPassword = new PasswordRule(attributeMap);
        }
    }

    private void populateAttributeMap(Attributes attributes, Map attributeMap, Iterator iter) {
        while (iter.hasNext()) {
            String key = iter.next().toString();
            attributeMap.put(key, attributes.getValue(key));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (FileRule.getElementName().equals(qName)) {
            this._rules.add(this._currentFile);
        } else if (PasswordRule.getElementName().equals(qName)) {
            if (null == this._currentFile) {
                throw new SAXException(ErrorHandling.generateCannotProcessPasswordRuleErrorMessage(this._task));
            }
            this._currentFile.addPasswordRule(this._currentPassword);
        }
    }
}

