/*
 * Decompiled with CFR 0.152.
 */
package com.sas.hadoop.serde.spde.hive.utilities;

import com.sas.hadoop.serde.spde.hive.SPDInputParms;
import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SerdeUtils {
    private static Logger logger = LogManager.getLogger(SerdeUtils.class);
    static HiveMetaStoreClient hiveMetaStoreClient;

    public static ResourceBundle getResourceBundle() {
        String language = SPDInputParms.USER_LOCALE_LANGUAGE.getConfigParm();
        String country = SPDInputParms.USER_LOCALE_COUNTRY.getConfigParm();
        return SerdeUtils.getResourceBundle(country, language);
    }

    public static ResourceBundle getResourceBundle(String country, String language) {
        Locale locale = null;
        try {
            if (language != null && language.length() > 0) {
                locale = country == null || country.length() == 0 ? new Locale(language.toLowerCase()) : new Locale(language.toLowerCase(), country.toUpperCase());
            }
        }
        catch (Exception e) {
            logger.debug("The application is unable to determine the user locale from the configuration.", (Throwable)e);
        }
        return SerdeUtils.getResourceBundle(locale);
    }

    public static ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle rb = null;
        if (locale != null) {
            try {
                rb = ResourceBundle.getBundle("com.sas.hadoop.serde.spde.hive.utilities.Resources", locale);
            }
            catch (Exception e) {
                logger.debug("The application is unable to use the requested locale " + locale.toString() + ".  Switching to default locale.", (Throwable)e);
            }
        }
        if (rb == null) {
            locale = Locale.getDefault();
            try {
                rb = ResourceBundle.getBundle("com.sas.hadoop.serde.spde.hive.utilities.Resources", locale);
            }
            catch (Exception e) {
                logger.debug("The application is unable to use the default locale " + locale.toString() + ".  Defaulting to en_US.", (Throwable)e);
                locale = new Locale("en", "US");
                rb = ResourceBundle.getBundle("com.sas.hadoop.serde.spde.hive.utilities.Resources", locale);
            }
        }
        return rb;
    }

    public static String[] splitString(String record, char delimiter, char textqualifier, int columnCount) {
        int end;
        String[] recordColumns = new String[columnCount];
        int currentColumn = 0;
        int start = 0;
        int recLength = record.length();
        char[] chars = record.toCharArray();
        boolean inQualifier = false;
        boolean qualified = false;
        for (end = 0; end < recLength; ++end) {
            char c = chars[end];
            if (c == textqualifier) {
                if (!inQualifier && start == end) {
                    inQualifier = true;
                    qualified = true;
                    continue;
                }
                if (end < recLength - 1 && chars[end + 1] == textqualifier) {
                    ++end;
                    continue;
                }
                inQualifier = false;
                continue;
            }
            if (c != delimiter || inQualifier) continue;
            if (start < end) {
                if (qualified) {
                    recordColumns[currentColumn++] = record.substring(start + 1, end - 1);
                    qualified = false;
                } else {
                    recordColumns[currentColumn++] = record.substring(start, end).trim();
                }
            } else {
                recordColumns[currentColumn++] = "";
            }
            start = end + 1;
        }
        while (currentColumn < columnCount) {
            if (start < end) {
                recordColumns[currentColumn++] = qualified ? record.substring(start + 1, end - 1) : record.substring(start).trim();
                start = end + 1;
                continue;
            }
            recordColumns[currentColumn++] = "";
        }
        return recordColumns;
    }

    public static synchronized HiveMetaStoreClient getHiveMetaStoreClient(HiveConf hiveConf) {
        if (hiveMetaStoreClient == null) {
            try {
                Constructor constr = HiveMetaStoreClient.class.getConstructor(Configuration.class);
                logger.info("Detected Hive 3.x HiveMetaStoreClient API.");
                Configuration tempConfig = new Configuration((Configuration)hiveConf);
                hiveMetaStoreClient = (HiveMetaStoreClient)constr.newInstance(tempConfig);
            }
            catch (NoSuchMethodException e) {
                try {
                    logger.info("Detected Hive 2.x HiveMetaStoreClient API.");
                    Constructor constr2 = HiveMetaStoreClient.class.getConstructor(HiveConf.class);
                    hiveMetaStoreClient = (HiveMetaStoreClient)constr2.newInstance(hiveConf);
                }
                catch (Exception e1) {
                    logger.error(e1.getMessage(), (Throwable)e1);
                    throw new RuntimeException(e1);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
            logger.info("Established a new connection to Hive MetaStore.");
            return hiveMetaStoreClient;
        }
        logger.info("Re-using Hive MetaStore connection.");
        return hiveMetaStoreClient;
    }

    public class ColumnMeta {
        public short name_len;
        public int col_len;
        public int col_offset;
        public int name_offset;
        public String type;
        public String name;
        public int formatname_len;
        public int format_offset;
        public int format_len;
    }
}

