/*
 * Decompiled with CFR 0.152.
 */
package com.sas.hadoop.serde.spde.hive;

import com.sas.hadoop.serde.spde.hive.SPDDeletedRecordHandler;
import com.sas.hadoop.serde.spde.hive.utilities.SerdeUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SPDInputFormat
extends FileInputFormat<LongWritable, BytesWritable>
implements JobConfigurable {
    private static final Logger logger = LogManager.getLogger(SPDInputFormat.class);
    private final boolean debugEnabled = logger.isDebugEnabled();
    private final boolean traceEnabled = logger.isTraceEnabled();
    private int obsLength;
    boolean configured = false;

    public SPDInputFormat() {
        if (this.debugEnabled) {
            logger.debug("Inside SPDInputFormat constructor.");
        }
    }

    public void configure(JobConf jobConf) {
        SPDInputFormat.setInputPathFilter((JobConf)jobConf, SPDDPFFilter.class);
        this.configured = true;
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        if (this.debugEnabled) {
            logger.debug("Inside SPDInputFormat getSplits.");
        }
        this.setObsLength(job);
        return super.getSplits(job, numSplits);
    }

    private boolean insideMRJob(JobConf job) {
        return job != null && HiveConf.getVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.PLAN) != null && !HiveConf.getVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.PLAN).isEmpty();
    }

    private Map<Path, PartitionDesc> invokeGetPathToPartition(JobConf job) {
        Method pathToPartMethod = null;
        Class<MapWork> cmw = MapWork.class;
        try {
            pathToPartMethod = cmw.getDeclaredMethod("getPathToPartitionInfo", null);
        }
        catch (NoSuchMethodException ex) {
            logger.error("invokeGetPathToPartition: could not get the getPathToPartitionInfo method through reflection: " + ex.getMessage());
            throw new RuntimeException(SerdeUtils.getResourceBundle().getString("SPDInputformat.partdesc.error.txt"));
        }
        catch (SecurityException ex) {
            logger.error("invokeGetPathToPartition: could not get the getPathToPartitionInfo method through reflection: " + ex.getMessage());
            throw new RuntimeException(SerdeUtils.getResourceBundle().getString("SPDInputformat.partdesc.error.txt"));
        }
        if (this.debugEnabled) {
            logger.debug("invokeGetPathToPartition: " + pathToPartMethod.toGenericString());
        }
        MapWork mapwork = Utilities.getMapWork((Configuration)job);
        Map mapobj = null;
        try {
            mapobj = (Map)pathToPartMethod.invoke((Object)mapwork, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            logger.error("invokeGetPathToPartition: could not invoke the getPathToPartitionInfo method through reflection: " + ex.getMessage());
            throw new RuntimeException(SerdeUtils.getResourceBundle().getString("SPDInputformat.partdesc.error.txt"));
        }
        catch (IllegalAccessException ex) {
            logger.error("invokeGetPathToPartition: could not invoke the getPathToPartitionInfo method through reflection: " + ex.getMessage());
            throw new RuntimeException(SerdeUtils.getResourceBundle().getString("SPDInputformat.partdesc.error.txt"));
        }
        catch (InvocationTargetException ex) {
            logger.error("invokeGetPathToPartition: could not invoke the getPathToPartitionInfo method through reflection: " + ex.getMessage());
            throw new RuntimeException(SerdeUtils.getResourceBundle().getString("SPDInputformat.partdesc.error.txt"));
        }
        return mapobj;
    }

    private void setObsLength(JobConf job) {
        String obsLength_str;
        if (this.insideMRJob(job)) {
            if (this.debugEnabled) {
                logger.debug("inside MR job");
            }
            PartitionDesc partDesc = null;
            Map<Path, PartitionDesc> partDescMap = this.invokeGetPathToPartition(job);
            if (partDescMap == null) {
                logger.error("setObsLength: invokeGetPathToPartition returned a null Map");
                throw new RuntimeException(SerdeUtils.getResourceBundle().getString("SPDInputformat.partdesc.error.txt"));
            }
            partDesc = partDescMap.get(SPDInputFormat.getInputPaths((JobConf)job)[0]);
            if (partDesc == null) {
                logger.error("setObsLength: could not get the partitionDesc ");
                throw new RuntimeException(SerdeUtils.getResourceBundle().getString("SPDInputformat.partdesc.error.txt"));
            }
            Properties tableProperties = partDesc.getTableDesc().getProperties();
            obsLength_str = (String)tableProperties.get("spd.record.length");
            String mdfFileName = (String)tableProperties.get("spd.mdf.location");
            if (mdfFileName != null) {
                job.set("spd.mdf.location", mdfFileName);
            }
        } else {
            if (this.debugEnabled) {
                logger.debug("not inside MR job");
            }
            if ((obsLength_str = job.get("spd.record.length")) == null) {
                if (this.debugEnabled) {
                    logger.debug("setObsLength spd.record.length was not in jobConf.  Attempting access via CA jobConf parms.");
                }
                obsLength_str = this.setPropsFromCATable(job);
            }
        }
        try {
            this.obsLength = Integer.parseInt(obsLength_str);
        }
        catch (Exception e) {
            throw new RuntimeException(SerdeUtils.getResourceBundle().getString("SPDInputformat.recordbyte.not.found.error.txt"));
        }
    }

    private String setPropsFromCATable(JobConf jobConf) {
        if (this.debugEnabled) {
            logger.debug("Inside setPropsFromCATable");
        }
        String obsLen_str = null;
        String dbname = jobConf.get("sas.ca.hcat.dbname", "");
        String name = jobConf.get("sas.ca.hcat.table", "").trim();
        if (this.debugEnabled) {
            logger.debug("setPropsFromCATable got the following information from the jobConf: sas.ca.hcat.dbname: '" + dbname + "'; " + "sas.ca.hcat.table" + ": '" + name + "'");
        }
        if (name != null && name.length() > 0) {
            if (dbname.trim().length() == 0) {
                dbname = "default";
            }
            HiveConf hiveConfig = null;
            try (HiveMetaStoreClient metastore = null;){
                hiveConfig = SPDInputFormat.buildHiveConf((Configuration)jobConf);
                metastore = SerdeUtils.getHiveMetaStoreClient(hiveConfig);
                Table t = metastore.getTable(dbname, name);
                Map parms = t.getParameters();
                obsLen_str = (String)parms.get("spd.record.length");
                if (obsLen_str != null) {
                    jobConf.set("spd.record.length", obsLen_str);
                } else {
                    jobConf.set("spd.record.length", "");
                }
                String mdfFile = (String)parms.get("spd.mdf.location");
                if (mdfFile != null) {
                    jobConf.set("spd.mdf.location", mdfFile);
                } else {
                    jobConf.set("spd.mdf.location", "");
                }
            }
        }
        return obsLen_str;
    }

    public RecordReader<LongWritable, BytesWritable> getRecordReader(InputSplit split, JobConf job, Reporter arg2) throws IOException {
        if (this.debugEnabled) {
            logger.debug("inside getRecordReader.");
        }
        FileSplit fsplit = (FileSplit)split;
        if (this.obsLength == 0) {
            this.obsLength = this.getObsLength(job, fsplit);
        }
        return new SPDRecordReader(job, fsplit, this.obsLength);
    }

    static String normSlash(String s) {
        StringBuilder sb = new StringBuilder(s);
        int prev = 0;
        int cur = 1;
        while (cur < sb.length()) {
            if (sb.charAt(cur) == '/' && sb.charAt(prev) == '/') {
                sb.deleteCharAt(cur);
                continue;
            }
            ++prev;
            ++cur;
        }
        return sb.toString();
    }

    private int getObsLength(JobConf job, FileSplit fsplit) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)job);
        String obsLength_str = null;
        if (this.insideMRJob(job)) {
            if (this.debugEnabled) {
                logger.debug("inside MR job");
            }
            String qualifiedSplitPath = SPDInputFormat.normSlash(fs.makeQualified(fsplit.getPath()).toString());
            Map<Path, PartitionDesc> partDescMap = this.invokeGetPathToPartition(job);
            if (partDescMap == null) {
                logger.error("getObsLength: invokeGetPathToPartition returned a null Map");
                throw new RuntimeException(SerdeUtils.getResourceBundle().getString("SPDInputformat.partdesc.error.txt"));
            }
            for (Map.Entry<Path, PartitionDesc> pathsAndParts : partDescMap.entrySet()) {
                String partitionPath = null;
                Path key = pathsAndParts.getKey();
                if (key == null) continue;
                partitionPath = key.toString();
                partitionPath = SPDInputFormat.normSlash(partitionPath);
                if (this.traceEnabled) {
                    logger.trace("fsplit.getPath" + qualifiedSplitPath);
                    logger.trace("Partition " + partitionPath);
                }
                if (this.pathIsInPartition(qualifiedSplitPath, partitionPath)) {
                    PartitionDesc partDesc = pathsAndParts.getValue();
                    if (partDesc == null) continue;
                    Properties props = pathsAndParts.getValue().getProperties();
                    obsLength_str = (String)props.get("spd.record.length");
                    continue;
                }
                if (!this.debugEnabled) continue;
                logger.debug("PathIsInPartion returned false for partition " + partitionPath + " and split " + qualifiedSplitPath);
            }
        } else {
            if (this.debugEnabled) {
                logger.debug("Not inside MR job");
            }
            if ((obsLength_str = job.get("spd.record.length")) == null) {
                if (this.debugEnabled) {
                    logger.debug("getObsLength spd.record.length was not in jobConf.  Attempting access via CA jobConf parms.");
                }
                obsLength_str = this.setPropsFromCATable(job);
            }
        }
        try {
            return Integer.parseInt(obsLength_str);
        }
        catch (Exception e) {
            throw new RuntimeException(SerdeUtils.getResourceBundle().getString("SPDInputformat.recordbyte.not.found.error.txt"));
        }
    }

    private boolean pathIsInPartition(String split, String partitionPath) {
        return split.startsWith(partitionPath);
    }

    protected long computeSplitSize(long goalsize, long minsize, long blocksize) {
        if (this.debugEnabled) {
            logger.debug("Into computeSplitSize.");
        }
        long result = super.computeSplitSize(goalsize, minsize, blocksize);
        return result / (long)this.obsLength * (long)this.obsLength + (long)this.obsLength;
    }

    public static HiveConf buildHiveConf(Configuration config) throws IOException {
        URL hiveSiteURL = SPDInputFormat.class.getClassLoader().getResource("hive-site.xml");
        HiveConf baseConf = HCatUtil.getHiveConf((Configuration)config);
        boolean isKerberos = config.get("hive.server2.authentication", "").trim().equalsIgnoreCase("KERBEROS");
        if (logger.isDebugEnabled()) {
            logger.debug("buildHiveConf: Kerberos enabled ? " + isKerberos);
        }
        if (hiveSiteURL != null && !hiveSiteURL.toString().isEmpty() || !isKerberos) {
            return baseConf;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("buildHiveConf: building the new HiveConf for a Kerberos enabled cluster");
        }
        for (Object o : baseConf.getAllProperties().keySet()) {
            String key = (String)o;
            String configValue = config.get(key);
            if (configValue == null) continue;
            baseConf.set(key, configValue);
        }
        return HCatUtil.getHiveConf((Configuration)baseConf);
    }

    private class SPDRecordReader
    implements RecordReader<LongWritable, BytesWritable> {
        private final boolean debugEnabled = SPDInputFormat.access$000().isDebugEnabled();
        final BytesWritable m_bytesWritable;
        final LongWritable m_longWritable;
        final FSDataInputStream fsInputStream;
        private long position;
        private final long last_position;
        private final long length;
        private long currentRecord;
        private final int obslen;
        byte[] bytearray;
        SPDDeletedRecordHandler deletedRecords;
        private final String mdfFile;
        long start;

        public SPDRecordReader(JobConf job, FileSplit genericSplit, int obsLength) throws IOException {
            FileSplit split = genericSplit;
            Path splitPath = split.getPath();
            FileSystem fs = FileSystem.get((Configuration)job);
            long splitStart = split.getStart();
            long splitLength = split.getLength();
            long splitEnd = splitStart + splitLength;
            long bytesToNextRecord = 0L;
            long bytesPastRecordStart = 0L;
            this.start = splitStart;
            if (splitStart != 0L && (bytesPastRecordStart = splitStart % (long)obsLength) > 0L) {
                bytesToNextRecord = (long)obsLength - bytesPastRecordStart;
                this.start += bytesToNextRecord;
            }
            this.position = this.start;
            bytesToNextRecord = 0L;
            bytesPastRecordStart = splitEnd % (long)obsLength;
            if (bytesPastRecordStart > 0L) {
                bytesToNextRecord = (long)obsLength - bytesPastRecordStart;
            }
            this.last_position = splitEnd + bytesToNextRecord;
            this.length = this.last_position - this.start;
            if (this.debugEnabled) {
                bytesToNextRecord = this.length % (long)obsLength;
                long totalRecords = this.length / (long)obsLength;
                logger.debug("Split File: " + splitPath);
                logger.debug("record length: " + obsLength + "; split start: " + splitStart + "; adjusted start: " + this.start + "; split length: " + splitLength + "; adjusted length: " + this.length + "; split end: " + splitEnd + "; adjusted end: " + this.last_position);
                logger.debug("Processing " + totalRecords + " records;  overflow? " + bytesToNextRecord);
            }
            this.mdfFile = this.getMdfFileName(job, splitPath, fs);
            this.m_longWritable = new LongWritable();
            this.m_bytesWritable = new BytesWritable();
            this.obslen = obsLength;
            this.bytearray = new byte[this.obslen];
            this.fsInputStream = fs.open(splitPath);
            this.fsInputStream.seek(this.position);
            long startingRecordNumber = this.position / (long)this.obslen + 1L;
            long recordCount = this.length / (long)this.obslen;
            String dpfFile = split.getPath().toUri().getPath();
            this.deletedRecords = SPDDeletedRecordHandler.getHandler(job, startingRecordNumber, recordCount, this.mdfFile, dpfFile);
            this.currentRecord = this.deletedRecords.getStartingRecord();
            if (this.debugEnabled) {
                logger.debug("DPFFILE: " + dpfFile);
            }
            if (!dpfFile.toLowerCase().contains(".dpf.")) {
                this.position = this.last_position;
            }
        }

        private String getMdfFileName(JobConf job, Path splitPath, FileSystem fs) throws FileNotFoundException {
            String m_mdfFile = job.get("spd.mdf.location", "");
            if (m_mdfFile.trim().length() == 0) {
                m_mdfFile = null;
                if (this.debugEnabled) {
                    logger.debug("spd.mdf.location was not specified in the JobConf ");
                }
                throw new FileNotFoundException(SerdeUtils.getResourceBundle().getString("SPDInputformat.mdf.file.not.found.error.txt"));
            }
            return m_mdfFile;
        }

        public void close() throws IOException {
            if (this.fsInputStream != null) {
                this.fsInputStream.close();
            }
        }

        public LongWritable createKey() {
            return this.m_longWritable;
        }

        public BytesWritable createValue() {
            return this.m_bytesWritable;
        }

        public long getPos() throws IOException {
            return this.position;
        }

        public float getProgress() throws IOException {
            if (this.length == 0L) {
                return 1.0f;
            }
            return Math.min(1.0f, (float)(this.position - this.start) / (float)this.length);
        }

        public boolean next(LongWritable key, BytesWritable value) throws IOException {
            byte[] nextRecord = this.next();
            if (nextRecord != null) {
                key.set(this.position - (long)this.obslen);
                value.set(nextRecord, 0, this.obslen);
                return true;
            }
            return false;
        }

        public byte[] next() throws IOException {
            while (this.position != this.last_position && this.deletedRecords.isRecordDeleted(this.currentRecord)) {
                this.fsInputStream.skip((long)this.obslen);
                this.position += (long)this.obslen;
                ++this.currentRecord;
            }
            if (this.position != this.last_position) {
                this.fsInputStream.readFully(this.bytearray);
                this.position += (long)this.obslen;
                ++this.currentRecord;
                return this.bytearray;
            }
            return null;
        }
    }

    public static class SPDDPFFilter
    implements PathFilter,
    JobConfigurable {
        private static final Logger logger = LogManager.getLogger(SPDDPFFilter.class);
        private final boolean debugEnabled = logger.isDebugEnabled();
        private JobConf jobConf;

        public void configure(JobConf jobConf) {
            if (jobConf != null) {
                this.jobConf = jobConf;
            }
        }

        public boolean accept(Path filePath) {
            if (this.debugEnabled) {
                logger.debug("Filter checking file " + filePath);
            }
            try {
                if (this.jobConf != null) {
                    FileSystem fs = filePath.getFileSystem((Configuration)this.jobConf);
                    if (fs.isDirectory(filePath)) {
                        return true;
                    }
                    if (fs.isFile(filePath)) {
                        return filePath.toString().toLowerCase().contains(".dpf.");
                    }
                    return false;
                }
                if (this.debugEnabled) {
                    logger.debug("conf was null");
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            return true;
        }
    }
}

