/*
 * Decompiled with CFR 0.152.
 */
package com.sas.hadoop.serde.spde.hive;

import com.sas.hadoop.serde.spde.hive.SPDMDFReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.activation.UnsupportedDataTypeException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;

public class SPDDeletedRecordHandler {
    private static final long[] RECORD_MASK = new long[]{0x80000000L, 0x40000000L, 0x20000000L, 0x10000000L, 0x8000000L, 0x4000000L, 0x2000000L, 0x1000000L, 0x800000L, 0x400000L, 0x200000L, 0x100000L, 524288L, 262144L, 131072L, 65536L, 32768L, 16384L, 8192L, 4096L, 2048L, 1024L, 512L, 256L, 128L, 64L, 32L, 16L, 8L, 4L, 2L, 1L};
    private final NavigableMap<Long, int[]> deletedRecordMap;
    private final long startingRecordNumber;
    int[] currentMap;
    long currentRange = -1L;
    long mapSetRecordNumber = -1L;

    public static SPDDeletedRecordHandler getHandler(JobConf jobConf, String mdfFile) throws IOException {
        return SPDDeletedRecordHandler.getHandler(jobConf, 1L, -1L, mdfFile, null);
    }

    public static SPDDeletedRecordHandler getHandler(JobConf jobConf, long firstObs, long recordCount, String mdfFile, String dpfFile) throws IOException {
        SPDMDFReader mdfReader = new SPDMDFReader(mdfFile, jobConf);
        if (mdfReader.isCompressed || mdfReader.isEncrypted || mdfReader.isPasswordProtected) {
            throw new UnsupportedDataTypeException();
        }
        long deletedMapHead = mdfReader.getDA_DSFDELMAP();
        if (deletedMapHead == -1L) {
            mdfReader.close();
            return new SPDDeletedRecordHandler(firstObs);
        }
        if (dpfFile != null) {
            firstObs = SPDDeletedRecordHandler.getAdjustedStart(dpfFile, mdfReader, firstObs, jobConf);
        }
        long lastObs = recordCount == -1L ? mdfReader.getNumberOfObservations() : firstObs + recordCount - 1L;
        ArrayList<BitMapHolder> holder = new ArrayList<BitMapHolder>();
        mdfReader.seek(deletedMapHead + 16L);
        int bitmapBytes = mdfReader.readInt();
        int numInts = bitmapBytes / 4;
        long dmpdirOff = mdfReader.readAlignedLong(deletedMapHead);
        long obsCount = numInts * 32;
        while (dmpdirOff != -1L) {
            int i;
            mdfReader.seek(dmpdirOff + 8L);
            long nextOff = mdfReader.readAlignedLong(dmpdirOff);
            mdfReader.skip(4L);
            int numAlloc = mdfReader.readInt();
            long[] bitMapAddrs = new long[numAlloc];
            long[] startingRecords = new long[numAlloc];
            for (i = 0; i < numAlloc; ++i) {
                bitMapAddrs[i] = mdfReader.readLong();
                startingRecords[i] = mdfReader.readLong();
            }
            for (i = 0; i < numAlloc; ++i) {
                long bitMapAddr = bitMapAddrs[i];
                long bitMapFirstObs = startingRecords[i];
                long bitMapLastObs = bitMapFirstObs + obsCount - 1L;
                if (lastObs < bitMapFirstObs || firstObs > bitMapLastObs) continue;
                SPDDeletedRecordHandler.processBitMap(mdfReader, holder, bitMapAddr, numInts, bitMapFirstObs, bitMapLastObs, obsCount, firstObs, lastObs);
            }
            dmpdirOff = nextOff;
        }
        mdfReader.close();
        if (holder.size() == 0 || holder.size() == 1 && ((BitMapHolder)holder.get((int)0)).ints == null) {
            return new SPDDeletedRecordHandler(firstObs);
        }
        return new SPDDeletedRecordHandler(holder, firstObs);
    }

    private static long getAdjustedStart(String dpfFile, SPDMDFReader mdfReader, long firstObs, JobConf conf) throws IOException {
        String[] dpfFiles = mdfReader.getDPFnames();
        long skippedRecords = 0L;
        long recLen = mdfReader.getPub_odsreclen();
        boolean found = false;
        FileSystem fs = FileSystem.get((Configuration)conf);
        for (String dpf : dpfFiles) {
            if (dpfFile.equals(dpf)) {
                firstObs += skippedRecords;
                found = true;
                break;
            }
            FileStatus fstat = fs.getFileStatus(new Path(dpf));
            long fileLen = fstat.getLen();
            long fileRecCnt = fileLen / recLen;
            skippedRecords += fileRecCnt;
        }
        if (!found) {
            throw new FileNotFoundException(dpfFile);
        }
        return firstObs;
    }

    private static void processBitMap(SPDMDFReader mdfReader, ArrayList<BitMapHolder> holder, long bitMapAddr, int totalInts, long bitMapFirstObs, long bitMapLastObs, long obsCount, long firstObs, long lastObs) throws IOException {
        long intSkip = 0L;
        long byteSkip = 0L;
        long startingRecord = bitMapFirstObs;
        if (bitMapFirstObs < firstObs) {
            long skip = firstObs - bitMapFirstObs;
            intSkip = skip / 32L;
            byteSkip = intSkip * 4L;
            startingRecord = bitMapFirstObs + 32L * intSkip;
            totalInts = (int)((long)totalInts - intSkip);
        }
        if (lastObs > bitMapLastObs) {
            intSkip = 0L;
        } else {
            intSkip = (bitMapLastObs - lastObs) / 32L;
            totalInts = (int)((long)totalInts - intSkip);
        }
        mdfReader.seek(bitMapAddr + byteSkip);
        boolean usedPrevious = false;
        BitMapHolder currentHolder = null;
        while (totalInts-- > 0) {
            int map = mdfReader.readInt();
            if (map == 0) {
                usedPrevious = false;
            } else {
                if (usedPrevious && !currentHolder.add(map)) {
                    usedPrevious = false;
                }
                if (!usedPrevious) {
                    currentHolder = new BitMapHolder(startingRecord);
                    currentHolder.add(map);
                    usedPrevious = true;
                    holder.add(currentHolder);
                }
            }
            startingRecord += 32L;
        }
    }

    public boolean isRecordDeleted(long recordNumber) {
        if (this.deletedRecordMap == null) {
            return false;
        }
        if (recordNumber > this.currentRange || recordNumber < this.mapSetRecordNumber) {
            Map.Entry<Long, int[]> entry = this.deletedRecordMap.floorEntry(recordNumber);
            if (entry == null) {
                this.currentMap = null;
                this.currentRange = -1L;
                this.mapSetRecordNumber = -1L;
                return false;
            }
            this.currentMap = entry.getValue();
            this.mapSetRecordNumber = entry.getKey();
            if (this.currentMap != null) {
                long includedRecords = 32 * this.currentMap.length;
                this.currentRange = this.mapSetRecordNumber + includedRecords - 1L;
            } else {
                Map.Entry<Long, int[]> entry2 = this.deletedRecordMap.higherEntry(recordNumber);
                if (entry2 != null) {
                    long nextEntry = entry2.getKey();
                    this.currentRange = nextEntry - 1L;
                } else {
                    this.currentRange = this.mapSetRecordNumber + 31L;
                }
            }
        }
        if (this.currentMap == null) {
            return false;
        }
        int offset = (int)(recordNumber - this.mapSetRecordNumber);
        int whichInt = offset / 32;
        int deletedMask = this.currentMap[whichInt];
        long recordMask = RECORD_MASK[offset % 32];
        return ((long)deletedMask & recordMask) != 0L;
    }

    private SPDDeletedRecordHandler(ArrayList<BitMapHolder> holders, long firstObs) throws IOException {
        this.startingRecordNumber = firstObs;
        Collections.sort(holders);
        int holderCount = holders.size();
        this.deletedRecordMap = new TreeMap<Long, int[]>();
        BitMapHolder currentHolder = holders.get(0);
        for (int i = 1; i < holderCount; ++i) {
            BitMapHolder holder = holders.get(i);
            if (holder.startingRecordNumber == currentHolder.lastRecordNumber + 1L) {
                if (currentHolder.add(holder.ints)) continue;
                this.addToNavMap(currentHolder, false);
                currentHolder = holder;
                continue;
            }
            this.addToNavMap(currentHolder, true);
            currentHolder = holder;
        }
        this.addToNavMap(currentHolder, true);
    }

    private SPDDeletedRecordHandler(long firstObs) {
        this.startingRecordNumber = firstObs;
        this.deletedRecordMap = null;
    }

    public long getStartingRecord() {
        return this.startingRecordNumber;
    }

    private void addToNavMap(BitMapHolder currentHolder, boolean addNullMap) {
        int[] value = currentHolder.getIntArray();
        Long key = new Long(currentHolder.startingRecordNumber);
        this.deletedRecordMap.put(key, value);
        this.deletedRecordMap.put(new Long(currentHolder.lastRecordNumber + 1L), null);
    }

    private static class BitMapHolder
    implements Comparable<BitMapHolder> {
        long startingRecordNumber;
        long lastRecordNumber;
        ArrayList<Integer> ints = new ArrayList();

        public BitMapHolder(long startingRecord) {
            this.startingRecordNumber = startingRecord;
            this.lastRecordNumber = this.startingRecordNumber - 1L;
        }

        public int[] getIntArray() {
            int intCount = this.ints.size();
            int[] intArray = new int[intCount];
            for (int i = 0; i < intCount; ++i) {
                intArray[i] = this.ints.get(i);
            }
            return intArray;
        }

        public boolean add(ArrayList<Integer> ints2) {
            if (this.ints.size() + ints2.size() > Integer.MAX_VALUE) {
                return false;
            }
            for (Integer i : ints2) {
                this.ints.add(i);
                this.lastRecordNumber += 32L;
            }
            return true;
        }

        public boolean add(int map) {
            if (this.ints.size() == Integer.MAX_VALUE) {
                return false;
            }
            this.ints.add(map);
            this.lastRecordNumber += 32L;
            return true;
        }

        @Override
        public int compareTo(BitMapHolder o) {
            if (this.startingRecordNumber > o.startingRecordNumber) {
                return 1;
            }
            if (this.startingRecordNumber < o.startingRecordNumber) {
                return -1;
            }
            return 0;
        }
    }
}

