/*
 * Decompiled with CFR 0.152.
 */
package com.sas.hadoop.serde.spde.hive;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

class MdfFilter
implements PathFilter {
    private final String filterFirstPart;
    private final FileSystem fs;
    private final int filterPartLen;
    private static final String mdf_u = "MDF.";
    private static final String mdf_l = "mdf.";
    private static final String spds_l = ".spds9";
    private static final String spds_u = ".SPDS9";

    public MdfFilter(String name, FileSystem fs) {
        this.filterFirstPart = name;
        this.fs = fs;
        this.filterPartLen = this.filterFirstPart.length();
    }

    public boolean accept(Path path) {
        try {
            if (!this.fs.isFile(path)) {
                return false;
            }
            String fileName = path.getName();
            int firstDot = fileName.indexOf(46);
            if (firstDot > 0) {
                int fileNameLen = fileName.length();
                if (this.filterPartLen != firstDot || fileNameLen < this.filterPartLen + 16) {
                    return false;
                }
                String fileFirstPart = fileName.substring(0, firstDot);
                String fileMdfPart = fileName.substring(firstDot + 1, firstDot + 5);
                String fileSpdsPart = fileName.substring(fileNameLen - 6);
                return !(!fileFirstPart.equals(this.filterFirstPart) || !fileMdfPart.equals(mdf_l) && !fileMdfPart.equals(mdf_u) || !fileSpdsPart.equals(spds_l) && !fileSpdsPart.equals(spds_u));
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

