/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import java.util.HashMap;

public final class WebDAVStatus {
    private static final HashMap<Integer, String> STATUSCODE_TO_TEXT_MAP = new HashMap();

    public static String getStatusText(int httpStatusCode) {
        return STATUSCODE_TO_TEXT_MAP.get(httpStatusCode);
    }

    static {
        STATUSCODE_TO_TEXT_MAP.put(200, "OK");
        STATUSCODE_TO_TEXT_MAP.put(201, "Created");
        STATUSCODE_TO_TEXT_MAP.put(202, "Accepted");
        STATUSCODE_TO_TEXT_MAP.put(204, "No Content");
        STATUSCODE_TO_TEXT_MAP.put(301, "Moved Permanently");
        STATUSCODE_TO_TEXT_MAP.put(302, "Moved Temporarily");
        STATUSCODE_TO_TEXT_MAP.put(304, "Not Modified");
        STATUSCODE_TO_TEXT_MAP.put(400, "Bad Request");
        STATUSCODE_TO_TEXT_MAP.put(401, "Unauthorized");
        STATUSCODE_TO_TEXT_MAP.put(403, "Forbidden");
        STATUSCODE_TO_TEXT_MAP.put(404, "Not Found");
        STATUSCODE_TO_TEXT_MAP.put(500, "Internal Server Error");
        STATUSCODE_TO_TEXT_MAP.put(501, "Not Implemented");
        STATUSCODE_TO_TEXT_MAP.put(502, "Bad Gateway");
        STATUSCODE_TO_TEXT_MAP.put(503, "Service Unavailable");
        STATUSCODE_TO_TEXT_MAP.put(100, "Continue");
        STATUSCODE_TO_TEXT_MAP.put(405, "Method Not Allowed");
        STATUSCODE_TO_TEXT_MAP.put(409, "Conflict");
        STATUSCODE_TO_TEXT_MAP.put(412, "Precondition Failed");
        STATUSCODE_TO_TEXT_MAP.put(413, "Request Too Long");
        STATUSCODE_TO_TEXT_MAP.put(415, "Unsupported Media Type");
        STATUSCODE_TO_TEXT_MAP.put(101, "Switching Protocols");
        STATUSCODE_TO_TEXT_MAP.put(203, "Non Authoritative Information");
        STATUSCODE_TO_TEXT_MAP.put(205, "Reset Content");
        STATUSCODE_TO_TEXT_MAP.put(504, "Gateway Timeout");
        STATUSCODE_TO_TEXT_MAP.put(505, "Http Version Not Supported");
        STATUSCODE_TO_TEXT_MAP.put(102, "Processing/* I18nOK:EMS */");
        STATUSCODE_TO_TEXT_MAP.put(207, "Multi-Status/* I18nOK:EMS */");
        STATUSCODE_TO_TEXT_MAP.put(422, "Unprocessable Entity");
        STATUSCODE_TO_TEXT_MAP.put(419, "Insufficient Space On Resource");
        STATUSCODE_TO_TEXT_MAP.put(420, "Method Failure");
        STATUSCODE_TO_TEXT_MAP.put(423, "Locked");
        STATUSCODE_TO_TEXT_MAP.put(508, "Loop Detected");
        STATUSCODE_TO_TEXT_MAP.put(507, "Insufficient Storage");
        STATUSCODE_TO_TEXT_MAP.put(424, "Failed Dependency");
    }
}

