/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.services.webdav.Ace;
import com.sas.services.webdav.Acl;
import com.sas.services.webdav.ConnectionInfo;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.DavPropertyResult;
import com.sas.services.webdav.Path;
import com.sas.services.webdav.Principal;
import com.sas.services.webdav.Privilege;
import com.sas.services.webdav.PropertyName;
import com.sas.services.webdav.XMLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.w3c.dom.Element;

@SASScope
public class WebDAVRestore {
    private static final String version = "9.4.004";
    private static SimpleDateFormat df;
    private static int restored;
    private static int skipped;
    private static String davServer;
    private static boolean supportsACL;
    private static boolean supportsVC;
    private static final String XYTHOS_WFS_VERSION_HDR = "Xythos-WFS-Version";
    private static DAVResource r;
    private static String basePath;
    private static String origBasePath;
    private static String personHttpUrl;
    private static String groupHttpUrl;
    private static String davDomain;
    private static List<Resource> resourceList;
    private static List<String> principalCollectionList;
    private static String url;
    private static String user;
    private static String pwd;
    private static boolean replace;
    private static boolean silent;
    private static String fName;
    private static final QName QN_NAME;
    private static final QName QN_SERVER;
    private static final QName QN_PRINCIPAL;
    private static final QName QN_MIMETYPE;
    private static final QName QN_DATE;
    private static final QName QN_BY;
    private static final QName QNE_OWNER;
    private static final QName QNE_CONTENT;
    private static final QName QNE_RESOURCES;
    private static final QName QNE_RESOURCE;
    private static final QName QNE_PROPERTY;
    private static final QName QNE_PERMISSION;
    private static final QName QNE_PROPERTIES;
    private static final QName QNE_PERMISSIONS;
    private static final QName QNE_CREATED;
    private static final QName QNE_MODIFIED;
    private static final String EMPTY_ACL = "<D:acl xmlns:D=\"DAV:\"/>";
    private static final String SAS_UNKNOWN_PRINCIPAL_PREFIX = "unknown/";
    private static final String SAS_PERSON_PRINCIPAL_PREFIX = "person/";
    private static final String SAS_GROUP_PRINCIPAL_PREFIX = "group/";

    public static void allFiles(URI srcUri, File source) {
        File[] files = source.listFiles();
        for (int i = 0; i < files.length; ++i) {
            Resource r = new Resource(files[i]);
            URI thisUri = files[i].toURI();
            URI relUri = srcUri.relativize(thisUri);
            r.setPath(relUri.getPath());
            resourceList.add(r);
            if (!files[i].isDirectory()) continue;
            WebDAVRestore.allFiles(srcUri, files[i]);
        }
    }

    public static void doDavResourceSource(File file) throws DAVException, ParserConfigurationException, IOException {
        DavProperty<?> davProperty;
        df = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss.SSS ", Locale.US);
        df.setTimeZone(TimeZone.getDefault());
        if (r == null) {
            ConnectionInfo c = new ConnectionInfo(url, user, pwd);
            r = new DAVResource(c);
        }
        WebDAVRestore.getServerInformation();
        PropertyName[] propNames = new PropertyName[]{new PropertyName("{DAV:}principal-collection-set")};
        DavPropertyResult davPropertyResult = r.getDavProperties(propNames, r.getDepth());
        if (davPropertyResult.getDavProperties().size() > 0 && (davProperty = davPropertyResult.getDavProperties().get(0).getDavProperty()).getName().getName().equals("principal-collection-set")) {
            principalCollectionList = XMLUtil.getDavPropertyHrefs(davProperty);
            for (String url : principalCollectionList) {
                if (url.endsWith(SAS_PERSON_PRINCIPAL_PREFIX)) {
                    personHttpUrl = url;
                    continue;
                }
                if (!url.endsWith(SAS_GROUP_PRINCIPAL_PREFIX)) continue;
                groupHttpUrl = url;
            }
        }
        File source = file;
        File dumpFile = null;
        resourceList.clear();
        if (source.isDirectory()) {
            dumpFile = new File(source, "WFSDump.xml");
            if (!dumpFile.exists()) {
                dumpFile = new File(source, "contents.xml");
            }
            if (!dumpFile.exists()) {
                URI srcUri = source.toURI();
                WebDAVRestore.allFiles(srcUri, source);
            } else {
                try {
                    XMLEventReader parser = WebDAVRestore.parseXML(new FileInputStream(dumpFile));
                    while (parser.hasNext()) {
                        XMLEvent event = parser.nextEvent();
                        if (!event.isStartElement()) continue;
                        if (QNE_RESOURCES.equals(event.asStartElement().getName())) {
                            Attribute serverAttr = event.asStartElement().getAttributeByName(QN_SERVER);
                            WebDAVRestore.findOrigBasePath(serverAttr);
                            continue;
                        }
                        if (!QNE_RESOURCE.equals(event.asStartElement().getName())) continue;
                        resourceList.add(new Resource(parser, event.asStartElement().getAttributeByName(QN_NAME).getValue(), null));
                    }
                }
                catch (XMLStreamException ex) {
                    System.out.println(ex);
                    ex.printStackTrace();
                }
            }
        } else if (source.getName().endsWith(".zip")) {
            ZipFile z = new ZipFile(source);
            ZipEntry ze = z.getEntry("WFSDump.xml");
            if (ze == null) {
                ze = z.getEntry("contents.xml");
            }
            if (ze != null) {
                try {
                    XMLEventReader parser = WebDAVRestore.parseXML(z.getInputStream(ze));
                    boolean eors = false;
                    while (parser.hasNext() & !eors) {
                        XMLEvent event = parser.nextEvent();
                        if (!event.isStartElement()) continue;
                        if (QNE_RESOURCES.equals(event.asStartElement().getName())) {
                            Attribute serverAttr = event.asStartElement().getAttributeByName(QN_SERVER);
                            WebDAVRestore.findOrigBasePath(serverAttr);
                            continue;
                        }
                        if (!QNE_RESOURCE.equals(event.asStartElement().getName())) continue;
                        Resource r = new Resource(parser, event.asStartElement().getAttributeByName(QN_NAME).getValue(), z);
                        r.setEntryType(Resource.ENTRY_TYPE_ZIPENTRY);
                        resourceList.add(r);
                    }
                }
                catch (XMLStreamException ex) {
                    System.out.println(ex);
                    ex.printStackTrace();
                }
            } else {
                Enumeration<? extends ZipEntry> entries = z.entries();
                TreeMap<String, ZipEntry> dirs = new TreeMap<String, ZipEntry>();
                while (entries.hasMoreElements()) {
                    ze = entries.nextElement();
                    dirs.put(ze.getName(), ze);
                }
                for (Map.Entry me : dirs.entrySet()) {
                    resourceList.add(new Resource(z, (ZipEntry)me.getValue()));
                }
            }
        } else {
            resourceList.add(new Resource(source));
        }
        for (int i = 0; i < resourceList.size(); ++i) {
            WebDAVRestore.restore(resourceList.get(i));
        }
    }

    private static void getServerInformation() throws DAVException {
        Properties opts = null;
        try {
            opts = r.doOptions();
            int sc = r.getStatusCode();
            if (sc != 200) {
                throw new DAVException("Unable to get OPTIONS information from the server, sc=" + sc);
            }
            if (!r.exists()) {
                throw new DAVException("Base path '" + r.getPath() + "' does not exist");
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (opts != null) {
            davServer = (String)opts.get("Server");
            if (opts.containsKey(XYTHOS_WFS_VERSION_HDR)) {
                davServer = (String)opts.get(XYTHOS_WFS_VERSION_HDR);
            }
            String[] caps = r.getDavCapabilities();
            for (int i = 0; i < caps.length; ++i) {
                if ("access-control".equalsIgnoreCase(caps[i])) {
                    supportsACL = true;
                }
                if (!"version-control".equalsIgnoreCase(caps[i])) continue;
                supportsVC = true;
            }
        }
    }

    public static void restore(DAVResource rsc, File file) throws DAVException, RemoteException {
        r = rsc;
        try {
            fName = file.getAbsolutePath();
            basePath = rsc.getURL().getPath();
            WebDAVRestore.doDavResourceSource(file);
        }
        catch (ParserConfigurationException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private static void restore(Resource resource) throws DAVException, RemoteException {
        boolean err = false;
        String name = resource.getPath();
        if (name == null) {
            name = resource.getName();
        }
        if (origBasePath != null && name.startsWith(origBasePath)) {
            name = name.substring(origBasePath.length());
        }
        if (!name.startsWith(basePath)) {
            name = Path.combine(new Path(basePath), new Path(name)).toString();
        }
        r.setPath(name);
        if (resource.isDir) {
            int sc = 0;
            try {
                r.makeCollection();
                sc = r.getStatusCode();
            }
            catch (DAVException e) {
                sc = e.getStatusCode();
            }
            if (!replace && sc == 405) {
                System.out.println("Skipped " + name + " as option is noreplace");
                ++skipped;
                return;
            }
            if (sc != 201 && sc != 405) {
                System.out.println("Creating directory " + name + " status=" + sc);
                err = true;
            }
        } else {
            if (!replace && r.exists()) {
                System.out.println("Skipped " + name + " as option is noreplace");
                ++skipped;
                return;
            }
            InputStream contents = resource.getContent();
            String mimeType = resource.getMimeType();
            if (mimeType != null) {
                r.setContentType(mimeType);
            }
            r.setContents(contents);
            int sc = r.getStatusCode();
            if (sc != 201 && sc != 204) {
                System.out.println("Setting content " + name + " status=" + sc);
                err = true;
            }
        }
        WebDAVRestore.doProperties(resource);
        WebDAVRestore.doDavPermissions(resource);
        if (!err) {
            System.out.println("Restored " + name);
            ++restored;
        } else {
            System.out.println("Error(s) restoring " + name);
        }
    }

    private static void doDavPermissions(Resource resource) {
        Map<String, String> permissions = resource.getPermissions();
        if (permissions == null) {
            return;
        }
        try {
            Acl acl;
            PropertyName[] pNames = new PropertyName[]{new PropertyName("{DAV:}acl")};
            DavPropertyResult davPropertyResult = r.getDavProperties(pNames, r.getDepth());
            if (davPropertyResult.getDavProperties().size() > 0) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                Element aclElement = davPropertyResult.getDavProperties().get(0).getDavProperty().toXml(factory.newDocumentBuilder().newDocument());
                acl = Acl.extractAclFromResponse(aclElement);
                Iterator<Ace> iter = acl.getAceList().iterator();
                while (iter.hasNext()) {
                    Ace ace = iter.next();
                    if (ace.isInherited() || ace.isProtected()) continue;
                    iter.remove();
                }
            } else {
                acl = new Acl();
            }
            String privileges = null;
            for (Map.Entry<String, String> me : permissions.entrySet()) {
                String principal = me.getKey();
                privileges = me.getValue();
                if (privileges == null) continue;
                int p = principal.lastIndexOf("@");
                if (p != -1) {
                    principal = principal.substring(0, p);
                }
                if ("owner".equalsIgnoreCase(principal)) continue;
                if (!(principal.startsWith("http") || principal.startsWith("ALL_PRINCIPALS") || principal.startsWith("OWNER") || principal.startsWith("AUTHENTICATED") || principal.startsWith("UNAUTHENTICATED"))) {
                    if (principal.startsWith("GROUPS") && groupHttpUrl != null) {
                        principal = groupHttpUrl + principal.substring(7).replace("+", "%20");
                    } else if (personHttpUrl != null) {
                        if ((principal = WebDAVRestore.convertToSCSPrincipal(principal)).startsWith(SAS_PERSON_PRINCIPAL_PREFIX)) {
                            principal = principal.substring(SAS_PERSON_PRINCIPAL_PREFIX.length());
                            principal = personHttpUrl + principal.replace(" ", "%20");
                        } else if (principal.startsWith(SAS_GROUP_PRINCIPAL_PREFIX)) {
                            principal = principal.substring(SAS_GROUP_PRINCIPAL_PREFIX.length());
                            principal = groupHttpUrl + principal.replace(" ", "%20");
                        } else {
                            principal = principal.replace("\\", "_");
                            principal = principal.replace("/", "_");
                            principal = personHttpUrl + principal.replace(" ", "%20");
                        }
                    }
                }
                Ace ace = new Ace(Principal.getPrincipalFromString(principal), Privilege.getPrivilegesFromString(privileges));
                acl.addAce(ace);
            }
            String s = acl.getUpdateableAclString();
            if (s == null) {
                s = EMPTY_ACL;
            }
            r.setACL(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String convertToSCSPrincipal(String srcPrincipal) {
        String scsPrincipal;
        if (srcPrincipal.startsWith(SAS_GROUP_PRINCIPAL_PREFIX) || srcPrincipal.startsWith(SAS_PERSON_PRINCIPAL_PREFIX)) {
            return srcPrincipal;
        }
        String login = srcPrincipal;
        if ((login = WebDAVRestore.handleDavDomain(login)) == null) {
            System.out.println("Error: Inconsistent DAV domain for login (" + login + ").");
            scsPrincipal = SAS_UNKNOWN_PRINCIPAL_PREFIX + srcPrincipal;
        } else {
            scsPrincipal = login;
        }
        System.out.println("DEBUG: Converted principal (" + srcPrincipal + ") to SCS principal (" + scsPrincipal + ")");
        return scsPrincipal;
    }

    private static String handleDavDomain(String src) {
        int atIndex = src.lastIndexOf("@");
        if (atIndex != -1) {
            String domain = src.substring(atIndex + 1);
            if (davDomain != null && !domain.equals(davDomain)) {
                return null;
            }
            return src.substring(0, atIndex);
        }
        return src;
    }

    private static void doProperties(Resource resource) {
        Map<String, String> properties = resource.getProperties();
        if (properties == null) {
            return;
        }
        ArrayList<PropertyName> names = new ArrayList<PropertyName>();
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry<String, String> me : properties.entrySet()) {
            names.add(new PropertyName(me.getKey()));
            values.add(me.getValue());
        }
        try {
            r.setProperties(names.toArray(new PropertyName[0]), values.toArray(new String[0]));
            int sc = r.getStatusCode();
            if (sc != 207) {
                System.out.println("Setting properties, status=" + sc);
            }
        }
        catch (DAVException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private static XMLEventReader parseXML(InputStream is) {
        XMLEventReader parser = null;
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            parser = factory.createXMLEventReader(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return parser;
    }

    public static void main(String[] argv) {
        int rc = 0;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-url")) {
                url = argv[++i];
                continue;
            }
            if (argv[i].equals("-user")) {
                user = argv[++i];
                continue;
            }
            if (argv[i].equals("-pwd")) {
                pwd = argv[++i];
                continue;
            }
            if (argv[i].equals("-silent")) {
                silent = true;
                continue;
            }
            if (argv[i].equals("-replace")) {
                replace = true;
                continue;
            }
            if (argv[i].startsWith("-")) {
                System.out.println("Unknown option: " + argv[i]);
                WebDAVRestore.printUsage();
                return;
            }
            fName = argv[i];
            break;
        }
        try {
            URL _url = new URL(url);
            basePath = _url.getPath();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.exit(8);
        }
        try {
            File f = new File(fName);
            if (!f.exists()) {
                throw new FileNotFoundException(fName + " does not exist");
            }
            System.out.println("WebDAVRestore (9.4.004)");
            System.out.println("Current time is: " + new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date()));
            System.out.println("Restoring to \"" + basePath + "\" for user \"" + user + "\" from \"" + fName + "\"");
            WebDAVRestore.doDavResourceSource(new File(fName));
            System.out.print("Restored: " + restored);
            if (skipped > 0) {
                System.out.print(", skipped: " + skipped);
            }
            System.out.println();
        }
        catch (Exception e) {
            rc = 8;
            e.printStackTrace();
        }
        System.exit(rc);
    }

    private static void findOrigBasePath(Attribute server) {
        origBasePath = null;
        if (server != null) {
            System.out.println("*** Dumped from: " + server.getValue());
            try {
                URL url = new URL(server.getValue());
                origBasePath = url.getPath();
                System.out.println("*** Original base path: " + origBasePath);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private static void printUsage() {
        System.out.println("Usage:\tjava WebDAVRestore -url url [-user user [-pwd password]][-replace][-silent] dir");
        System.out.println("   where: ");
        System.out.println("       user: is a logon ID for an SAS Metadata Server unrestricted administrator (such as \"sasadm\").");
        System.out.println("       dir: is the directory that contains the dump.");
    }

    static {
        restored = 0;
        skipped = 0;
        supportsACL = false;
        supportsVC = false;
        origBasePath = null;
        personHttpUrl = null;
        groupHttpUrl = null;
        davDomain = null;
        resourceList = new ArrayList<Resource>(100);
        principalCollectionList = new ArrayList<String>();
        replace = false;
        silent = false;
        QN_NAME = new QName("name");
        QN_SERVER = new QName("server");
        QN_PRINCIPAL = new QName("principal");
        QN_MIMETYPE = new QName("mimetype");
        QN_DATE = new QName("date");
        QN_BY = new QName("by");
        QNE_OWNER = new QName("owner");
        QNE_CONTENT = new QName("content");
        QNE_RESOURCES = new QName("resources");
        QNE_RESOURCE = new QName("resource");
        QNE_PROPERTY = new QName("property");
        QNE_PERMISSION = new QName("permission");
        QNE_PROPERTIES = new QName("properties");
        QNE_PERMISSIONS = new QName("permissions");
        QNE_CREATED = new QName("created");
        QNE_MODIFIED = new QName("modified");
    }

    @SASScope
    static class Resource {
        private int entryType;
        private static int ENTRY_TYPE_FILE = 1;
        private static int ENTRY_TYPE_ZIPENTRY = 2;
        private String name;
        private String owner;
        private String content;
        private String version;
        private Map<String, String> properties;
        private Map<String, String> permissions;
        private String lastModified;
        private String created;
        private String lastModifiedBy;
        private String createdBy;
        private String mimeType;
        private boolean isDir;
        private String path;
        private ZipFile z;

        public Resource() {
        }

        public Resource(XMLEventReader parser, String name, ZipFile z) {
            this.z = z;
            this.setName(name);
            this.isDir = true;
            try {
                boolean eor = false;
                while (parser.hasNext() & !eor) {
                    XMLEvent event = parser.nextEvent();
                    if (event.isStartElement()) {
                        if (QNE_PROPERTIES.equals(event.asStartElement().getName())) {
                            this.properties = new HashMap<String, String>();
                            continue;
                        }
                        if (QNE_PERMISSIONS.equals(event.asStartElement().getName())) {
                            this.permissions = new HashMap<String, String>();
                            continue;
                        }
                        if (QNE_PROPERTY.equals(event.asStartElement().getName())) {
                            String prop = parser.getElementText();
                            int p = prop.indexOf("=");
                            String nsname = prop.substring(0, p);
                            String value = prop.substring(p + 1);
                            this.properties.put(nsname, value);
                            continue;
                        }
                        if (QNE_PERMISSION.equals(event.asStartElement().getName())) {
                            String principal = event.asStartElement().getAttributeByName(QN_PRINCIPAL).getValue();
                            String perms = parser.getElementText();
                            if (perms.trim().length() == 0) {
                                perms = null;
                            }
                            this.permissions.put(principal, perms);
                            continue;
                        }
                        if (QNE_CONTENT.equals(event.asStartElement().getName())) {
                            this.isDir = false;
                            Attribute mimeType = event.asStartElement().getAttributeByName(QN_MIMETYPE);
                            if (mimeType != null) {
                                this.setMimeType(mimeType.getValue());
                            }
                            this.content = parser.getElementText();
                            if (z != null) {
                                this.entryType = ENTRY_TYPE_ZIPENTRY;
                                continue;
                            }
                            this.entryType = ENTRY_TYPE_FILE;
                            File file = new File(this.content);
                            if (file.isAbsolute()) continue;
                            file = new File(fName, this.content);
                            this.content = file.getAbsolutePath();
                            continue;
                        }
                        if (QNE_CREATED.equals(event.asStartElement().getName())) {
                            this.setCreated(event.asStartElement().getAttributeByName(QN_DATE).getValue());
                            this.setCreatedBy(event.asStartElement().getAttributeByName(QN_BY).getValue());
                            continue;
                        }
                        if (QNE_OWNER.equals(event.asStartElement().getName())) {
                            this.setOwner(parser.getElementText());
                            continue;
                        }
                        if (!QNE_MODIFIED.equals(event.asStartElement().getName())) continue;
                        this.setLastModified(event.asStartElement().getAttributeByName(QN_DATE).getValue());
                        this.setLastModifiedBy(event.asStartElement().getAttributeByName(QN_BY).getValue());
                        continue;
                    }
                    if (!event.isEndElement() || !QNE_RESOURCE.equals(event.asEndElement().getName())) continue;
                    eor = true;
                }
            }
            catch (XMLStreamException ex) {
                System.out.println(ex);
                ex.printStackTrace();
            }
        }

        public Resource(File f) {
            this.entryType = ENTRY_TYPE_FILE;
            if (f == null) {
                throw new IllegalArgumentException();
            }
            this.isDir = f.isDirectory();
            this.setName(f.getName());
            if (!this.isDir) {
                this.content = f.getAbsolutePath();
            }
        }

        public Resource(ZipFile z, ZipEntry ze) {
            this.z = z;
            this.entryType = ENTRY_TYPE_ZIPENTRY;
            this.isDir = ze.isDirectory();
            this.setName(ze.getName());
            if (!this.isDir) {
                this.content = ze.getName();
            }
            this.setLastModified(new Date(ze.getTime()).toString());
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getOwner() {
            return this.owner;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public InputStream getContent() {
            try {
                if (this.entryType == ENTRY_TYPE_ZIPENTRY) {
                    return this.z.getInputStream(this.z.getEntry(this.content));
                }
                return new FileInputStream(this.content);
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }

        public String getContentName() {
            return this.content;
        }

        public void setContentName(String contentName) {
            this.content = contentName;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public Map<String, String> getPermissions() {
            return this.permissions;
        }

        public void setPermissions(Map<String, String> permissions) {
            this.permissions = permissions;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        public String getCreated() {
            return this.created;
        }

        public void setCreated(String created) {
            this.created = created;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String toString() {
            System.out.println("Name=" + this.name + (this.isDir ? " [Dir" : " [File=" + this.getContentName() + ", mimeType=" + this.getMimeType()) + " path=" + this.getPath() + "]");
            if (this.created != null) {
                System.out.println("\tCreated: " + this.created);
            }
            if (this.lastModified != null) {
                System.out.println("\tLastModified: " + this.lastModified);
            }
            if (this.properties != null) {
                for (Map.Entry<String, String> me : this.properties.entrySet()) {
                    System.out.println("\t" + me.getKey() + "=" + me.getValue());
                }
            }
            if (this.permissions != null) {
                for (Map.Entry<String, String> me : this.permissions.entrySet()) {
                    System.out.println("\t" + me.getKey() + "=" + me.getValue());
                }
            }
            return "";
        }

        public String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public String getCreatedBy() {
            return this.createdBy;
        }

        public void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public int getEntryType() {
            return this.entryType;
        }

        public void setEntryType(int entryType) {
            this.entryType = entryType;
        }
    }
}

