/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.services.webdav.Ace;
import com.sas.services.webdav.Acl;
import com.sas.services.webdav.ConnectionInfo;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.DavPropertyResult;
import com.sas.services.webdav.Privilege;
import com.sas.services.webdav.PropertyMap;
import com.sas.services.webdav.PropertyName;
import com.sas.services.webdav.ResourceFilter;
import com.sas.services.webdav.ResourceFinder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;

@SASScope
public class WebDAVDump {
    private static SimpleDateFormat df;
    private static DecimalFormat fnfmt;
    private static BufferedWriter out;
    private static int fileNum;
    private static String dirName;
    private static int dumped;
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static DAVResource davResource;
    private static String fName;
    private static String url;
    private static String user;
    private static String pwd;
    private static boolean silent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpContentToZip(File zipFile, String url, String user, String password) throws IOException, DAVException, ParserConfigurationException {
        File xmlFile = null;
        ZipOutputStream zos = null;
        df = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss.SSS ", Locale.US);
        df.setTimeZone(TimeZone.getDefault());
        ConnectionInfo connectionInfo = new ConnectionInfo(url, user, password);
        davResource = new DAVResource(connectionInfo);
        ResourceFilter packageFilter = new ResourceFilter(){

            @Override
            public boolean accept(Map pMap) {
                return true;
            }

            public List getPropertyList() {
                ArrayList results = new ArrayList();
                return results;
            }
        };
        FileInputStream fis = null;
        try {
            int len;
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            try {
                URL theURL = new URL(url);
                url = theURL.getProtocol() + "://" + theURL.getHost() + ":" + (theURL.getPort() == -1 ? 80 : theURL.getPort()) + theURL.getPath();
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
            xmlFile = File.createTempFile("Pub", ".xml");
            xmlFile.deleteOnExit();
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), "UTF-8"));
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.newLine();
            out.write("<resources server=\"" + url + "\">");
            out.newLine();
            ArrayList results = new ArrayList();
            System.out.println("Fetch list of resources - start");
            ResourceFinder.getDavResources(davResource, packageFilter, results, false);
            System.out.println("Fetch list of resources - end");
            ConnectionInfo c = new ConnectionInfo(url, user, password);
            davResource = new DAVResource(c);
            WebDAVDump.dump(davResource, results, zos);
            out.write("</resources>");
            out.newLine();
            out.close();
            ZipEntry ze = new ZipEntry("WFSDump.xml");
            zos.putNextEntry(ze);
            fis = new FileInputStream(xmlFile);
            byte[] buf = new byte[4096];
            while ((len = fis.read(buf)) > 0) {
                zos.write(buf, 0, len);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
            if (xmlFile != null) {
                try {
                    xmlFile.delete();
                }
                catch (Exception exception) {}
            }
            if (zos != null) {
                try {
                    zos.flush();
                }
                catch (IOException iOException) {}
                zos.close();
            }
        }
    }

    private static void dump(DAVResource davResource, List resources, ZipOutputStream zos) throws DAVException, IOException, ParserConfigurationException {
        for (Map item : resources) {
            Object[] keys = item.keySet().toArray();
            String path = (String)keys[0];
            davResource.setPath(path);
            Map propMap = (Map)item.get(path);
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            out.write("<resource name=\"" + WebDAVDump.XMLESCAPE(path) + "\">");
            out.newLine();
            if (!WebDAVDump.isCollection(propMap)) {
                String tempName = fnfmt.format(fileNum);
                if (zos == null) {
                    File file = new File(dirName + File.separator + tempName);
                    davResource.setPath(path);
                    davResource.getContents(file);
                } else {
                    int len;
                    InputStream is = davResource.getContentsInputStream();
                    ZipEntry ze = new ZipEntry(tempName);
                    zos.putNextEntry(ze);
                    byte[] buf = new byte[4096];
                    while ((len = is.read(buf)) > 0) {
                        zos.write(buf, 0, len);
                    }
                }
                String contentType = (String)propMap.get("{DAV:}getcontenttype");
                if (contentType != null) {
                    out.write("<content mimetype=\"" + contentType + "\">" + tempName + "</content>");
                } else {
                    out.write("<content>" + tempName + "</content>");
                }
                out.newLine();
                ++fileNum;
            }
            Iterator props = propMap.entrySet().iterator();
            int propNum = 0;
            boolean foundCustomProperty = false;
            while (props.hasNext()) {
                Map.Entry me2 = props.next();
                String propName = (String)me2.getKey();
                String propValue = (String)me2.getValue();
                if (!WebDAVDump.isCustomProperty(propName)) continue;
                if (propNum == 0) {
                    foundCustomProperty = true;
                    out.write("<properties>");
                    out.newLine();
                }
                out.write("<property>");
                out.write(propName + "=" + WebDAVDump.XMLESCAPE(propValue));
                out.write("</property>");
                out.newLine();
                ++propNum;
            }
            if (foundCustomProperty) {
                out.write("</properties>");
                out.newLine();
            }
            WebDAVDump.dumpDavPermissions(davResource, path, out);
            out.write("</resource>");
            out.newLine();
            System.out.println("Dumped " + path + ".");
            ++dumped;
        }
    }

    private static boolean isCollection(Map propMap) {
        return "COLLECTION".equals(propMap.get("{DAV:}resourcetype"));
    }

    private static String XMLESCAPE(String text) {
        if (text == null) {
            return "";
        }
        if (text.startsWith(CDATA_START) && text.endsWith(CDATA_END)) {
            return text;
        }
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        return text;
    }

    private static boolean isCustomProperty(String propName) {
        return !propName.startsWith("{DAV:}") && !propName.startsWith("{http://www.jcp.org/jcr/1.0}");
    }

    public static void main(String[] argv) {
        int rc = 0;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-url")) {
                url = argv[++i];
                continue;
            }
            if (argv[i].equals("-user")) {
                user = argv[++i];
                continue;
            }
            if (argv[i].equals("-pwd")) {
                pwd = argv[++i];
                continue;
            }
            if (argv[i].equals("-silent")) {
                silent = true;
                continue;
            }
            fName = argv[i];
            break;
        }
        if (!silent) {
            System.out.println("Dumping from \"" + url + "\" for user \"" + user + "\" to file \"" + fName + "\"");
        }
        try {
            WebDAVDump.dumpContentToZip(new File(fName), url, user, pwd);
        }
        catch (Exception e) {
            rc = 8;
            e.printStackTrace();
        }
        System.exit(rc);
    }

    public static void dumpResource(DAVResource rsc, File dir) throws DAVException, IOException, ParserConfigurationException {
        ArrayList results = new ArrayList();
        String dumpUrl = rsc.getURL().toString();
        ResourceFilter filter = new ResourceFilter(){

            @Override
            public boolean accept(Map properties) {
                return true;
            }

            public List getPropertyList() {
                return new ArrayList();
            }
        };
        ResourceFinder.getDavResources(rsc, filter, results, false);
        int fileNum = 0;
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(dir, "WFSDump.xml")), "UTF-8"));
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.newLine();
        out.write("<resources server=\"" + dumpUrl + "\">");
        out.newLine();
        for (Map map : results) {
            for (Map.Entry me : map.entrySet()) {
                String path = (String)me.getKey();
                PropertyMap propMap = (PropertyMap)me.getValue();
                out.write("<resource name=\"" + WebDAVDump.XMLESCAPE(path) + "\">");
                out.newLine();
                if (!WebDAVDump.isCollection(propMap)) {
                    String tempName = fnfmt.format(fileNum);
                    File file = new File(dir, tempName);
                    rsc.setPath(path);
                    rsc.getContents(file);
                    String contentType = (String)propMap.get("{DAV:}getcontenttype");
                    if (contentType != null) {
                        out.write("<content mimetype=\"" + contentType + "\">" + tempName + "</content>");
                    } else {
                        out.write("<content>" + tempName + "</content>");
                    }
                    out.newLine();
                    ++fileNum;
                }
                Iterator props = propMap.entrySet().iterator();
                int propNum = 0;
                boolean foundCustomProperty = false;
                while (props.hasNext()) {
                    Map.Entry me2 = props.next();
                    String propName = (String)me2.getKey();
                    String propValue = (String)me2.getValue();
                    if (!WebDAVDump.isCustomProperty(propName)) continue;
                    if (propNum == 0) {
                        foundCustomProperty = true;
                        out.write("<properties>");
                        out.newLine();
                    }
                    out.write("<property>");
                    out.write(propName + "=" + WebDAVDump.XMLESCAPE(propValue));
                    out.write("</property>");
                    out.newLine();
                    ++propNum;
                }
                if (foundCustomProperty) {
                    out.write("</properties>");
                    out.newLine();
                }
                WebDAVDump.dumpDavPermissions(rsc, path, out);
                out.write("</resource>");
                out.newLine();
                System.out.println("Dumped " + path + ".");
            }
        }
        out.write("</resources>");
        out.newLine();
        out.close();
    }

    private static void dumpDavPermissions(DAVResource rsc, String path, BufferedWriter out) throws IOException, DAVException, RemoteException, ParserConfigurationException {
        rsc.setPath(path);
        DavPropertyResult davPropertyResult = rsc.getDavProperties(new PropertyName[]{PropertyName.DAV_ACL_PN}, rsc.getDepth());
        if (davPropertyResult.getDavProperties().size() > 0) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            Element aclElement = davPropertyResult.getDavProperties().get(0).getDavProperty().toXml(factory.newDocumentBuilder().newDocument());
            Acl acl = Acl.extractAclFromResponse(aclElement);
            List<Ace> aceList = acl.getAceList();
            if (!aceList.isEmpty()) {
                out.write("<permissions>");
                out.newLine();
                for (Ace ace : aceList) {
                    out.write("<permission principal=\"" + ace.getPrincipal().getDumpForm() + "\">");
                    Privilege[] privileges = ace.getPrivileges();
                    for (int j = 0; j < privileges.length; ++j) {
                        out.write(Privilege.getDumpForm(privileges[j]) + " ");
                    }
                    out.write("</permission>");
                    out.newLine();
                }
                out.write("</permissions>");
                out.newLine();
            }
        }
    }

    static {
        fnfmt = new DecimalFormat("X0000000");
        out = null;
        fileNum = 0;
        dirName = null;
        dumped = 0;
        silent = false;
    }
}

