/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.SASScope;
import java.util.StringTokenizer;

@SASScope
public class Path {
    private String[] segments;
    private boolean isRelative = true;

    public Path(String path) {
        if (path.startsWith("/")) {
            this.isRelative = false;
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        int nTokens = st.countTokens();
        this.segments = new String[nTokens];
        for (int i = 0; i < nTokens; ++i) {
            this.segments[i] = st.nextToken();
        }
        this.checkValid();
    }

    public Path(Path path, int length) {
        if (length > path.segments.length) {
            throw new IllegalArgumentException();
        }
        this.segments = new String[length];
        for (int i = 0; i < length; ++i) {
            this.segments[i] = path.segments[i];
        }
        this.checkValid();
    }

    public Path(String[] segments, int length) {
        this.segments = new String[length];
        for (int i = 0; i < length; ++i) {
            this.segments[i] = segments[i];
        }
        this.checkValid();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this.isRelative) {
            sb.append("/");
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (i > 0) {
                sb.append("/");
            }
            sb.append(this.segments[i]);
        }
        return sb.toString();
    }

    public Path getParent() {
        if (this.isRoot()) {
            return null;
        }
        return new Path(this.segments, this.segments.length - 1);
    }

    public String getLastSegment() {
        if (!this.isRelative && this.segments.length == 0) {
            return null;
        }
        return this.segments[this.segments.length - 1];
    }

    public boolean isRoot() {
        if (this.isRelative) {
            return this.segments.length == 1;
        }
        return this.segments.length == 0;
    }

    private void checkValid() {
        if (this.isRelative && this.segments.length < 1) {
            throw new IllegalArgumentException("Relative path cannot be empty");
        }
    }

    public Path addPath(Path p) {
        int i;
        int p1Length = this.segments.length;
        int p2Length = p.segments.length;
        String[] segs = new String[p1Length + p2Length];
        for (i = 0; i < p1Length; ++i) {
            segs[i] = this.segments[i];
        }
        for (i = 0; i < p2Length; ++i) {
            segs[p1Length + i] = p.segments[i];
        }
        Path result = new Path(segs, p1Length + p2Length);
        result.setRelative(this.isRelative());
        return result;
    }

    public Path resolve(Path p) {
        Path result;
        int p1Length = this.segments.length;
        int p2Length = p.segments.length;
        if (!p.isRelative) {
            result = new Path(p.segments, p2Length);
            result.isRelative = false;
        } else {
            int i;
            String[] segs = new String[p1Length + p2Length];
            for (i = 0; i < p1Length; ++i) {
                segs[i] = this.segments[i];
            }
            for (i = 0; i < p2Length; ++i) {
                segs[p1Length + i] = p.segments[i];
            }
            result = new Path(segs, p1Length + p2Length);
        }
        return result;
    }

    public static Path combine(Path p1, Path p2) {
        int p1Length = p1.getNumSegments();
        int p2Length = p2.getNumSegments();
        int offset = 0;
        int maxSegs = Math.min(p1Length, p2Length);
        for (int i = 0; i < maxSegs && p2.segments[offset].equals(p1.segments[p1Length - offset - 1]); ++i) {
            ++offset;
        }
        String[] newSegments = new String[p1Length + p2Length - offset];
        System.arraycopy(p1.segments, 0, newSegments, 0, p1Length);
        System.arraycopy(p2.segments, offset, newSegments, p1Length, p2Length - offset);
        Path result = new Path(newSegments, newSegments.length);
        result.setRelative(p1.isRelative);
        return result;
    }

    public boolean isRelative() {
        return this.isRelative;
    }

    public void setRelative(boolean isRelative) {
        this.isRelative = isRelative;
    }

    public String getSegment(int i) {
        if (i > this.segments.length) {
            throw new IllegalArgumentException();
        }
        return this.segments[i];
    }

    public int getNumSegments() {
        return this.segments.length;
    }

    public boolean equals(Object o) {
        if (o instanceof Path) {
            return this.toString().equals(o.toString());
        }
        return false;
    }
}

