/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.webdav;

import com.sas.codepolicy.SASScope;
import com.sas.services.webdav.CollectionInterface;
import com.sas.services.webdav.ConnectionInfo;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.DAVResourceInterface;
import com.sas.services.webdav.DavPropertyItem;
import com.sas.services.webdav.DavPropertyResult;
import com.sas.services.webdav.PropertyMap;
import com.sas.services.webdav.RB;
import com.sas.services.webdav.Resource;
import com.sas.services.webdav.ResourceFactory;
import com.sas.services.webdav.ResourceInterface;
import com.sas.services.webdav.SharedResource;
import com.sas.services.webdav.SharedResourceInterface;
import com.sas.services.webdav.Utils;
import com.sas.text.Message;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;

@SASScope
public class Collection
extends Resource
implements CollectionInterface {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CollectionInterface createCollection(CollectionInterface model, String name) throws DAVException, RemoteException {
        DAVResource r;
        String _url = Utils.addSegment(model.getURL(), name);
        String path = Collection.getPath(_url);
        if (model.isSharedResource()) {
            SharedResourceInterface sr = model.getSharedResource();
            if (sr instanceof SharedResource) {
                try {
                    DAVResourceInterface r2 = sr.getConnection();
                    r2.setPath(path);
                    r2.makeCollection();
                    Collection collection = new Collection(sr, _url);
                    return collection;
                }
                finally {
                    sr.releaseConnection();
                }
            }
            return sr.createCollection(model, name);
        }
        DAVResource dAVResource = r = ((Collection)model)._resource;
        synchronized (dAVResource) {
            r.setPath(path);
            r.makeCollection();
            return new Collection(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceInterface createResource(CollectionInterface model, String name) throws DAVException, RemoteException {
        DAVResource r;
        String _url = Utils.addSegment(model.getURL(), name);
        String path = Collection.getPath(_url);
        if (model.isSharedResource()) {
            SharedResourceInterface sr = model.getSharedResource();
            if (sr instanceof SharedResource) {
                try {
                    DAVResourceInterface r2 = sr.getConnection();
                    r2.setPath(path);
                    Resource resource = new Resource(sr, _url);
                    return resource;
                }
                finally {
                    sr.releaseConnection();
                }
            }
            return sr.createResource(model, name);
        }
        DAVResource dAVResource = r = ((Collection)model)._resource;
        synchronized (dAVResource) {
            r.setPath(path);
            return new Resource(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CollectionInterface createCollection(SharedResourceInterface sr, CollectionInterface model, String name) throws DAVException, RemoteException {
        String _url = Utils.addSegment(model.getURL(), name);
        String path = Collection.getPath(_url);
        try {
            DAVResourceInterface r = sr.getConnection();
            r.setPath(path);
            r.makeCollection();
            Collection collection = new Collection(sr, _url);
            return collection;
        }
        finally {
            sr.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceInterface createResource(SharedResourceInterface sr, CollectionInterface model, String name) throws DAVException, RemoteException {
        String _url = Utils.addSegment(model.getURL(), name);
        String path = Collection.getPath(_url);
        try {
            DAVResourceInterface r = sr.getConnection();
            r.setPath(path);
            Resource resource = new Resource(sr, _url);
            return resource;
        }
        finally {
            sr.releaseConnection();
        }
    }

    public Collection(SharedResourceInterface sr) throws DAVException, RemoteException {
        super(sr);
    }

    public Collection(SharedResourceInterface sr, String urlStr) {
        super(sr, urlStr);
    }

    public Collection(DAVResource r) throws DAVException, RemoteException {
        super(r);
    }

    @Override
    public CollectionInterface createCollection(String collName) throws DAVException, RemoteException {
        return this.createCollection(collName, null, null);
    }

    @Override
    public CollectionInterface createCollection(String collName, String userName, String pwd) throws DAVException, RemoteException {
        DAVResource newcoll;
        String _url;
        String fullUrl;
        if (!this._path.equals(this._resource.getPath())) {
            this._resource.setPath(this._path);
        }
        if ((fullUrl = Utils.addSegment(_url = this._resource.getURL().toString(), collName)).charAt(fullUrl.length() - 1) != '/') {
            fullUrl = fullUrl + "/";
        }
        ConnectionInfo cInfo = new ConnectionInfo(fullUrl, userName, pwd);
        if (this._resource.proxyHost != null && this._resource.proxyPort >= 0) {
            cInfo.setProxyHost(this._resource.proxyHost);
            cInfo.setProxyPort(this._resource.proxyPort);
        }
        if (!(newcoll = new DAVResource(cInfo, true)).SUCCEEDED()) {
            throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Collection.makecol.ex.fmt.txt", (Object)newcoll.getStatusMessage()));
        }
        return new Collection(newcoll);
    }

    @Override
    public ResourceInterface createResource(String resName) throws DAVException, RemoteException {
        return this.createResource(resName, null, null);
    }

    @Override
    public ResourceInterface createResource(String resName, String userName, String pwd) throws DAVException, RemoteException {
        DAVResource newres;
        if (!this._path.equals(this._resource.getPath())) {
            this._resource.setPath(this._path);
        }
        String _url = this._resource.getURL().toString();
        String fullUrl = Utils.addSegment(_url, resName);
        ConnectionInfo cInfo = new ConnectionInfo(fullUrl, userName, pwd);
        if (this._resource.proxyHost != null && this._resource.proxyPort >= 0) {
            cInfo.setProxyHost(this._resource.proxyHost);
            cInfo.setProxyPort(this._resource.proxyPort);
        }
        if (!(newres = new DAVResource(cInfo)).SUCCEEDED() && newres.getStatusCode() != 404) {
            throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Collection.createres.ex.fmt.txt", (Object)newres.getStatusMessage()));
        }
        return new Resource(newres);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getChildren() throws DAVException, RemoteException {
        DavPropertyResult davPropertyResult;
        block8: {
            DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
            davPropertyNameSet.add(DavPropertyName.RESOURCETYPE);
            davPropertyResult = null;
            if (this.isSharedResource) {
                DAVResourceInterface r = null;
                try {
                    r = this.sharedResource.getConnection();
                    r.setPath(this._path);
                    davPropertyResult = r.getDavProperties(davPropertyNameSet, 1);
                    if (!r.SUCCEEDED()) {
                        throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Collection.getprop.ex.fmt.txt", (Object)r.getStatusMessage()));
                    }
                    break block8;
                }
                finally {
                    this.sharedResource.releaseConnection(r);
                    r = null;
                }
            }
            if (!this._path.equals(this._resource.getPath())) {
                this._resource.setPath(this._path);
            }
            davPropertyResult = this._resource.getDavProperties(davPropertyNameSet, 1);
            if (!this._resource.SUCCEEDED()) {
                throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Collection.getprop.ex.fmt.txt", (Object)this._resource.getStatusMessage()));
            }
        }
        List<DavPropertyItem> davPropertyItems = davPropertyResult.getDavProperties();
        ArrayList<ResourceInterface> members = new ArrayList<ResourceInterface>(davPropertyItems.size());
        String resourceURL = this.getURL();
        for (DavPropertyItem davPropertyItem : davPropertyItems) {
            String owningURL = davPropertyItem.getDavResourceHref();
            String newurl = Utils.transformURL(this.getURL(), owningURL);
            if (Utils.isSameUrl(newurl, resourceURL)) continue;
            ResourceInterface member = this.isSharedResource ? ResourceFactory.bindResource(this.sharedResource, Collection.getPath(newurl)) : (!this._resource.isAuthReqd() ? ResourceFactory.bindResource(newurl) : ResourceFactory.bindResource(newurl, this._resource.userName, this._resource.password));
            members.add(member);
        }
        return members;
    }

    @Override
    public Map<String, PropertyMap> getDavChildrenProperties() throws DAVException, RemoteException, ParserConfigurationException {
        List<DavPropertyItem> davPropertyItems;
        block7: {
            if (this.isSharedResource) {
                DAVResourceInterface r = null;
                try {
                    r = this.sharedResource.getConnection();
                    r.setPath(this._path);
                    davPropertyItems = r.getDavProperties(1).getDavProperties();
                    if (!r.SUCCEEDED()) {
                        throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Collection.getprop.ex.fmt.txt", (Object)r.getStatusMessage()));
                    }
                    break block7;
                }
                finally {
                    this.sharedResource.releaseConnection(r);
                    r = null;
                }
            }
            if (!this._path.equals(this._resource.getPath())) {
                this._resource.setPath(this._path);
            }
            int savedDepth = this._resource.getDepth();
            this._resource.setDepth(1);
            davPropertyItems = this._resource.getDavProperties().getDavProperties();
            if (!this._resource.SUCCEEDED()) {
                throw new DAVException(Message.format((ResourceBundle)RB.getResources(), (String)"Collection.getprop.ex.fmt.txt", (Object)this._resource.getStatusMessage()));
            }
            this._resource.setDepth(savedDepth);
        }
        return Utils.transformDavProperties(this.getURL(), davPropertyItems, 2);
    }

    @Override
    public InputStream getContents() throws DAVException, RemoteException {
        return null;
    }

    private static String getPath(String urlStr) {
        String path = null;
        int p = urlStr.indexOf("://");
        path = p > 0 ? ((p = urlStr.indexOf("/", p + 3)) > 0 ? urlStr.substring(p) : "") : urlStr;
        return path;
    }
}

