/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.client.util;

import com.sas.svcs.commons.ObjectIdentity;
import java.util.regex.Pattern;

public class ContentRESTUtils {
    private static final String REPOSKEY_PATTERN = "\\w{8}.[A-Z,0-9,#]{8}/.*";
    private static final String LINKID_PATTERN = "\\w{8}.[A-Z,0-9,*]{8}-.*";

    public static String getIdForLink(String objectId) {
        String id = objectId;
        if (Pattern.matches(REPOSKEY_PATTERN, id)) {
            id = id.replaceFirst("/", "-");
            id = id.replace("#", "*");
        }
        return id;
    }

    public static String getIdFromLink(String objectId) {
        String id = objectId;
        if (Pattern.matches(LINKID_PATTERN, id)) {
            id = id.replaceFirst("-", "/");
            id = id.replace("*", "#");
        }
        return id;
    }

    public static ObjectIdentity parseContentUri(String uri) throws IllegalArgumentException {
        long objectType;
        int sepIndex = uri.indexOf(47);
        if (sepIndex == -1) {
            throw new IllegalArgumentException("Invalid uri syntax.  Missing identity separator: " + uri);
        }
        String type = uri.substring(0, sepIndex);
        try {
            objectType = Long.parseLong(type);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid uri syntax.  Invalid object type value: " + type);
        }
        String id = uri.substring(sepIndex + 1);
        id = ContentRESTUtils.getIdFromLink(id);
        return new ObjectIdentity(objectType, id);
    }

    public static String createContentUri(ObjectIdentity identity) {
        return identity.getObjectType() + "/" + ContentRESTUtils.getIdForLink(identity.getId());
    }
}

