/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client;

import com.sas.commons.expr.Expression;
import com.sas.commons.expr.SimpleName;
import com.sas.commons.expr.SortKey;
import com.sas.svcs.common.client.AttributeMapper;
import com.sas.svcs.common.client.FieldMapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContentComparator<T>
implements Comparator<T> {
    private static Logger log = LogManager.getLogger((String)"com.sas.svcs.common.client.ContentComparator");
    public static final String SORT_ASCENDING = "ascending";
    public static final String SORT_DESCENDING = "descending";
    public static final List<String> SORT_DIRECTIONS = Arrays.asList("ascending", "descending");
    public static final String SORT_STRENGTH_PRIMARY = "primary";
    public static final String SORT_STRENGTH_SECONDARY = "secondary";
    public static final String SORT_STRENGTH_TERTIARY = "tertiary";
    public static final String SORT_STRENGTH_QUATERNARY = "quaternary";
    public static final String SORT_STRENGTH_IDENTICAL = "identical";
    public static final List<String> SORT_STRENGTHS = Arrays.asList("primary", "secondary", "tertiary", "quaternary", "identical");
    List<SortKey> sortElements;
    private final Class<T> type;
    private Map<String, FieldMapper> mappings = new HashMap<String, FieldMapper>();

    public ContentComparator(List<SortKey> sortElements, Class<T> type) {
        this.sortElements = sortElements;
        this.type = type;
    }

    public void addFieldMapping(FieldMapper mapper) {
        this.mappings.put(mapper.getFieldName(), mapper);
    }

    public void addFieldMappings(List<FieldMapper> mappers) {
        for (FieldMapper mapper : mappers) {
            this.addFieldMapping(mapper);
        }
    }

    @Override
    public int compare(T o1, T o2) {
        int result = 0;
        for (int index = 0; result == 0 && index < this.sortElements.size(); ++index) {
            SortKey sk = this.sortElements.get(index);
            result = this.processSortElement(sk, o1, o2);
        }
        return result;
    }

    protected int processSortElement(SortKey sortKey, T o1, T o2) {
        int result = 0;
        Method method = null;
        method = this.getMethod(sortKey);
        try {
            Object val1 = method.invoke(o1, (Object[])null);
            Object val2 = method.invoke(o2, (Object[])null);
            if (val1 instanceof String) {
                result = this.stringCompare(val1, val2);
            } else if (val1 instanceof Integer) {
                result = this.integerCompare(val1, val2);
            } else if (val1 instanceof Long) {
                result = this.longCompare(val1, val2);
            } else if (val1 instanceof Double) {
                result = this.doubleCompare(val1, val2);
            } else if (val1 instanceof Date) {
                result = this.dateCompare(val1, val2);
            }
            if (!sortKey.isAscending()) {
                result *= -1;
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return result;
    }

    protected Method getMethod(SortKey sortKey) {
        Method result = null;
        Expression expression = sortKey.getKey();
        if (!(expression instanceof SimpleName)) {
            throw new IllegalArgumentException();
        }
        String keyName = ((SimpleName)expression).getText();
        FieldMapper mapper = this.mappings.get(keyName);
        if (mapper != null) {
            if (mapper instanceof AttributeMapper) {
                String[] alternateNames = ((AttributeMapper)mapper).getAlternateAttributeNames();
                if (alternateNames != null) {
                    for (String name : alternateNames) {
                        result = this.getMethod(name);
                        if (result == null) continue;
                        keyName = name;
                        break;
                    }
                } else {
                    keyName = ((AttributeMapper)mapper).getAttributeName();
                    result = this.getMethod(keyName);
                }
            }
        } else {
            result = this.getMethod(keyName);
        }
        if (result == null) {
            throw new IllegalArgumentException(keyName + " is not a valid element of the class.");
        }
        return result;
    }

    protected Method getMethod(String name) {
        String methodName = "get" + name;
        Method m = null;
        try {
            m = this.type.getMethod(methodName, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return m;
    }

    protected int stringCompare(Object o1, Object o2) {
        String string1 = (String)o1;
        String string2 = (String)o2;
        return string1.compareTo(string2);
    }

    protected int integerCompare(Object o1, Object o2) {
        Integer int1 = (Integer)o1;
        Integer int2 = (Integer)o2;
        return int1.compareTo(int2);
    }

    protected int longCompare(Object o1, Object o2) {
        Long long1 = (Long)o1;
        Long long2 = (Long)o2;
        return long1.compareTo(long2);
    }

    protected int doubleCompare(Object o1, Object o2) {
        Double double1 = (Double)o1;
        Double double2 = (Double)o2;
        return double1.compareTo(double2);
    }

    protected int dateCompare(Object o1, Object o2) {
        Date date1 = (Date)o1;
        Date date2 = (Date)o2;
        return date1.compareTo(date2);
    }
}

