/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dmv.relationship.ox;

import com.sas.dmv.relationship.ox.ObjectFactory;
import com.sas.dmv.relationship.ox.RelationshipAttribute;
import com.sas.dmv.relationship.ox.RelationshipAttributes;
import com.sas.dmv.relationship.ox.RelationshipModel;
import com.sas.dmv.relationship.ox.RelationshipModels;
import com.sas.dmv.relationship.ox.RelationshipNode;
import com.sas.dmv.relationship.ox.RelationshipNodes;
import com.sas.dmv.relationship.ox.RelationshipType;
import com.sas.dmv.relationship.ox.Resource;
import com.sas.dmv.relationship.ox.ResourceAttribute;
import com.sas.dmv.relationship.ox.ResourceAttributes;
import com.sas.dmv.relationship.ox.Resources;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.XmlMappingException;

public class RelationshipObjectFactory
extends ObjectFactory {
    Logger _logger = LoggerFactory.getLogger(this.getClass());
    private static int _object_creation_counter = 0;
    @Autowired
    @Qualifier(value="marshaller")
    private Marshaller _marshaller = null;
    @Autowired
    @Qualifier(value="marshaller")
    private Unmarshaller _unmarshaller = null;

    public XMLGregorianCalendar getXMLDateFromJavaDate(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        XMLGregorianCalendar date2 = null;
        try {
            date2 = DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
        }
        catch (DatatypeConfigurationException ex) {
            this._logger.debug(ex.getLocalizedMessage());
        }
        return date2;
    }

    public Date getDateXMLDate(XMLGregorianCalendar date) {
        GregorianCalendar c = date.toGregorianCalendar();
        return c.getTime();
    }

    public void addResourceToResourceList(Resource addedResource, List<Resource> resources) {
        boolean found = false;
        for (Resource r : resources) {
            if (!r.getType().equals(addedResource.getType()) || !r.getId().equals(addedResource.getId())) continue;
            found = true;
        }
        if (!found) {
            resources.add(addedResource);
        }
    }

    public void marshallResourcesToFile(String filename, Resources resources) {
        this.marshallObjectToFile(resources, filename);
    }

    public void marshallRelationshipModelToFile(RelationshipModel model, String filename) {
        this.marshallObjectToFile(model, filename);
    }

    public void marshallRelationshipModelsToFile(RelationshipModels models, String filename) {
        this.marshallObjectToFile(models, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshallObjectToFile(Object resources, String filename) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(filename);
            this._marshaller.marshal(resources, (Result)new StreamResult(os));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (XmlMappingException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public Resources unMarshallResourcesFromFile(String filename) {
        return (Resources)this.unMarshallObjectFromFile(filename);
    }

    public RelationshipModels unMarshallRelationshipModelsFromFile(String filename) {
        return (RelationshipModels)this.unMarshallObjectFromFile(filename);
    }

    public RelationshipModel unMarshallRelationshipModelFromFile(String filename) {
        return (RelationshipModel)this.unMarshallObjectFromFile(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unMarshallObjectFromFile(String filename) {
        Object after = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(filename);
            after = this._unmarshaller.unmarshal((Source)new StreamSource(is));
        }
        catch (FileNotFoundException ex) {
            this._logger.error("Error trying to unmarshall resources from " + filename, (Throwable)ex);
        }
        catch (XmlMappingException ex) {
            this._logger.error("Error trying to unmarshall resources from " + filename, (Throwable)ex);
        }
        catch (IOException ex) {
            this._logger.error("Error trying to unmarshall resources from " + filename, (Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    this._logger.debug("Error closing stream when unmarshalling " + filename, (Throwable)ex);
                }
            }
        }
        return after;
    }

    public String marshallResourcesToString(Resources resources) {
        return this.marshallObjectToString(resources);
    }

    public String marshallRelationshipModelToString(RelationshipModel model) {
        return this.marshallObjectToString(model);
    }

    public String marshallRelationshipModelsToString(RelationshipModels models) {
        return this.marshallObjectToString(models);
    }

    private String marshallObjectToString(Object resources) {
        String returnValue = "";
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this._marshaller.marshal(resources, (Result)new StreamResult(os));
            returnValue = os.toString("UTF-8");
        }
        catch (XmlMappingException ex) {
            this._logger.error("Error marshalling resources to string", (Throwable)ex);
        }
        catch (IOException ex) {
            this._logger.error("Error marshalling resources to string", (Throwable)ex);
        }
        return returnValue;
    }

    public Resources unMarshallResourcesFromString(String inputXML) {
        return (Resources)this.unMarshallObjectFromString(inputXML);
    }

    public RelationshipModel unMarshallRelationshipModelFromString(String inputXML) {
        return (RelationshipModel)this.unMarshallObjectFromString(inputXML);
    }

    public RelationshipModels unMarshallRelationshipModelsFromString(String inputXML) {
        return (RelationshipModels)this.unMarshallObjectFromString(inputXML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unMarshallObjectFromString(String inputXML) {
        Object returnValue = null;
        if (null == inputXML) {
            return returnValue;
        }
        try (StringReader stReader = null;){
            stReader = new StringReader(inputXML);
            returnValue = this._unmarshaller.unmarshal((Source)new StreamSource(stReader));
        }
        return returnValue;
    }

    public Resource createResource(String label, String type, String identity) {
        Resource returnValue = this.createResource();
        if (null != returnValue) {
            returnValue.setLabel(label);
            returnValue.setType(type);
            returnValue.setId(identity);
        }
        return returnValue;
    }

    @Override
    public Resource createResource() {
        Resource returnValue = super.createResource();
        returnValue.setResourceId(RelationshipObjectFactory.makeID());
        return returnValue;
    }

    public static synchronized boolean isTemporaryId(String id) {
        boolean returnValue = false;
        if (id.length() > 0 && id.startsWith("$")) {
            returnValue = true;
        }
        return returnValue;
    }

    public static synchronized String makeID() {
        StringBuffer id = new StringBuffer(String.valueOf(_object_creation_counter));
        int iLength = id.length();
        for (int i = 7; i > iLength; --i) {
            id.insert(0, "0");
        }
        id.insert(0, "$");
        if (++_object_creation_counter > 9999999) {
            _object_creation_counter = 0;
        }
        return id.toString();
    }

    public boolean setResourceAttributeValue(Resource object, String name, String value) {
        boolean returnValue = false;
        if (null == object) {
            return returnValue;
        }
        ResourceAttributes attrs = object.getResourceAttributes();
        if (null == attrs) {
            attrs = this.createResourceAttributes();
            object.setResourceAttributes(attrs);
            ResourceAttribute attribute = this.createResourceAttribute();
            attrs.getResourceAttribute().add(attribute);
            attribute.setName(name);
            attribute.setValue(value);
            returnValue = true;
        } else {
            List<ResourceAttribute> attributeList = attrs.getResourceAttribute();
            ResourceAttribute attribute = null;
            for (ResourceAttribute attr : attributeList) {
                if (!attr.getName().equals(name)) continue;
                attribute = attr;
                break;
            }
            if (null == attribute) {
                attribute = this.createResourceAttribute();
                attribute.setName(name);
                attrs.getResourceAttribute().add(attribute);
            }
            attribute.setValue(value);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setRelationshipAttributeValue(RelationshipNode object, String name, String value) {
        boolean returnValue = false;
        if (null == object) {
            return returnValue;
        }
        RelationshipAttributes attrs = object.getRelationshipAttributes();
        if (null == attrs) {
            attrs = this.createRelationshipAttributes();
            object.setRelationshipAttributes(attrs);
            RelationshipAttribute attribute = this.createRelationshipAttribute();
            attrs.getRelationshipAttribute().add(attribute);
            attribute.setName(name);
            attribute.setValue(value);
            returnValue = true;
        } else {
            List<RelationshipAttribute> attributeList = attrs.getRelationshipAttribute();
            RelationshipAttribute attribute = null;
            for (RelationshipAttribute attr : attributeList) {
                if (!attr.getName().equals(name)) continue;
                attribute = attr;
                break;
            }
            if (null == attribute) {
                attribute = this.createRelationshipAttribute();
                attribute.setName(name);
                attrs.getRelationshipAttribute().add(attribute);
            }
            attribute.setValue(value);
            returnValue = true;
        }
        return returnValue;
    }

    public RelationshipNode addRelationshipToModel(RelationshipModel model, Resource a, RelationshipType d, Resource b, int direction) {
        RelationshipNode returnValue = null;
        if (null == model) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        if (!this.isRelationshipInModel(model, a, d, b)) {
            RelationshipNodes nodes = model.getRelationshipNodes();
            if (null == nodes) {
                nodes = this.createRelationshipNodes();
                model.setRelationshipNodes(nodes);
            }
            returnValue = this.createRelationshipNode();
            returnValue.setDirection(direction);
            returnValue.setType(d);
            returnValue.setResource(b);
            nodes.getRelationshipNode().add(returnValue);
        }
        return returnValue;
    }

    public boolean isRelationshipInModel(RelationshipModel model, Resource a, RelationshipType d, Resource b) {
        boolean returnValue = false;
        RelationshipNode node = this.getRelationshipNodeFromModel(model, a, d, b);
        if (null != node) {
            returnValue = true;
        }
        return returnValue;
    }

    public RelationshipNode getRelationshipNodeFromModel(RelationshipModel model, Resource a, RelationshipType d, Resource b) {
        RelationshipNode returnValue = null;
        RelationshipNodes nodes = model.getRelationshipNodes();
        if (null == nodes) {
            return returnValue;
        }
        Resource target = null;
        Resource modelSourceRes = model.getResource();
        if (modelSourceRes.equals(a)) {
            target = b;
        } else if (modelSourceRes.equals(b)) {
            target = a;
        } else {
            return returnValue;
        }
        for (RelationshipNode node : nodes.getRelationshipNode()) {
            if (!node.getResource().equals(target) || !node.getType().equals((Object)d)) continue;
            returnValue = node;
            return returnValue;
        }
        return returnValue;
    }

    public RelationshipModel addRelationshipModel(RelationshipModels models, Resource res) {
        RelationshipModel returnValue = this.createRelationshipModel();
        models.getRelationshipModel().add(returnValue);
        returnValue.setResource(res);
        return returnValue;
    }

    public RelationshipModel getRelationshipModelForResource(RelationshipModels models, Resource res) {
        RelationshipModel returnValue = null;
        for (RelationshipModel t : models.getRelationshipModel()) {
            if (!t.getResource().equals(res)) continue;
            returnValue = t;
            return t;
        }
        return returnValue;
    }

    public boolean doesRelatinoshipModelExist(RelationshipModels models, Resource res) {
        boolean returnValue = false;
        RelationshipModel model = this.getRelationshipModelForResource(models, res);
        returnValue = null != model;
        return returnValue;
    }

    public String getRelationshipAttributeValue(RelationshipNode node, String key) {
        String returnValue = "";
        RelationshipAttributes attrs = node.getRelationshipAttributes();
        if (null != attrs) {
            List<RelationshipAttribute> attributeList = attrs.getRelationshipAttribute();
            RelationshipAttribute attribute = null;
            for (RelationshipAttribute attr : attributeList) {
                if (!attr.getName().equals(key)) continue;
                attribute = attr;
                break;
            }
            if (null != attribute) {
                returnValue = attribute.getValue();
            }
        }
        return returnValue;
    }

    public String getResourceAttributeValue(Resource res, String key) {
        String returnValue = "";
        ResourceAttributes attrs = res.getResourceAttributes();
        if (null != attrs) {
            List<ResourceAttribute> attributeList = attrs.getResourceAttribute();
            ResourceAttribute attribute = null;
            for (ResourceAttribute attr : attributeList) {
                if (!attr.getName().equals(key)) continue;
                attribute = attr;
                break;
            }
            if (null != attribute) {
                returnValue = attribute.getValue();
            }
        }
        return returnValue;
    }
}

