/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.PropertyException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PropertyUtils {
    public static Set<Class<?>> getAllImplementedInterfaces(Class clazz) {
        Set<Class<?>> ret = null;
        ret = clazz.getSuperclass() != null ? PropertyUtils.getAllImplementedInterfaces(clazz.getSuperclass()) : new HashSet();
        Class<?>[] interfaces = clazz.getInterfaces();
        ret.addAll(Arrays.asList(interfaces));
        return ret;
    }

    public static void setProperty(Object target, String propertyName, Object propertyValue) throws PropertyException {
        String[] propertyNames = propertyName.split("\\.");
        Object currentTarget = target;
        for (int i = 0; i < propertyNames.length - 1; ++i) {
            String name = propertyNames[i];
            Object result = PropertyUtils.callGetter(currentTarget, name);
            if (result == null) {
                Class propertyType = PropertyUtils.getPropertyType(target, name);
                try {
                    result = propertyType.newInstance();
                }
                catch (InstantiationException ex) {
                    throw new PropertyException("cannot set property '" + propertyName + "' - '" + name + "' is null and cannot be auto-filled", ex);
                }
                catch (IllegalAccessException ex) {
                    throw new PropertyException("cannot set property '" + propertyName + "' - '" + name + "' is null and cannot be auto-filled", ex);
                }
                PropertyUtils.callSetter(currentTarget, name, result);
            }
            currentTarget = result;
        }
        String lastPropertyName = propertyNames[propertyNames.length - 1];
        if (currentTarget instanceof Properties) {
            Properties p = (Properties)currentTarget;
            p.setProperty(lastPropertyName, propertyValue.toString());
        } else {
            PropertyUtils.setDirectProperty(currentTarget, lastPropertyName, propertyValue);
        }
    }

    public static void setProperties(Object target, Map properties) throws PropertyException {
        for (Map.Entry entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            PropertyUtils.setProperty(target, name, value);
        }
    }

    private static void setDirectProperty(Object target, String propertyName, Object propertyValue) throws PropertyException {
        Method setter = PropertyUtils.getSetter(target, propertyName);
        Class<?> parameterType = setter.getParameterTypes()[0];
        try {
            if (propertyValue != null) {
                Object transformedPropertyValue = PropertyUtils.convert(propertyValue, parameterType);
                setter.invoke(target, transformedPropertyValue);
            } else {
                setter.invoke(target, new Object[]{null});
            }
        }
        catch (IllegalAccessException ex) {
            throw new PropertyException("property '" + propertyName + "' is not accessible", ex);
        }
        catch (InvocationTargetException ex) {
            throw new PropertyException("property '" + propertyName + "' access threw an exception", ex);
        }
    }

    private static Object convert(Object value, Class destinationClass) throws PropertyException {
        if (value.getClass() == destinationClass) {
            return value;
        }
        if (PropertyUtils.isPrimitiveType(value.getClass())) {
            return value;
        }
        if (value.getClass() == String.class && PropertyUtils.isPrimitiveType(destinationClass)) {
            return PropertyUtils.convertStringToPrimitive((String)value, destinationClass);
        }
        if (Set.class.isAssignableFrom(destinationClass) && value.getClass() == String.class) {
            return PropertyUtils.convertStringToSet((String)value);
        }
        if (destinationClass.isAssignableFrom(value.getClass())) {
            return value;
        }
        throw new PropertyException("cannot convert values of type '" + value.getClass().getName() + "' into type '" + destinationClass + "'");
    }

    private static Set<String> convertStringToSet(String propertyValue) {
        String[] elements = propertyValue.split(",");
        HashSet<String> result = new HashSet<String>();
        for (String element : elements) {
            result.add(element);
        }
        return result;
    }

    private static Object convertStringToPrimitive(String value, Class destinationClass) {
        if (destinationClass == Integer.TYPE || destinationClass == Integer.class) {
            return new Integer(value);
        }
        if (destinationClass == Boolean.TYPE || destinationClass == Boolean.class) {
            return Boolean.valueOf(value);
        }
        if (destinationClass == Short.TYPE || destinationClass == Short.class) {
            return new Short(value);
        }
        if (destinationClass == Byte.TYPE || destinationClass == Byte.class) {
            return new Byte(value);
        }
        if (destinationClass == Long.TYPE || destinationClass == Long.class) {
            return new Long(value);
        }
        if (destinationClass == Float.TYPE || destinationClass == Float.class) {
            return new Float(value);
        }
        if (destinationClass == Double.TYPE || destinationClass == Double.class) {
            return new Double(value);
        }
        if (destinationClass == Character.TYPE || destinationClass == Character.class) {
            return Character.valueOf(value.charAt(0));
        }
        return null;
    }

    private static boolean isPrimitiveType(Class clazz) {
        return clazz == Integer.TYPE || clazz == Integer.class || clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Long.TYPE || clazz == Long.class || clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || clazz == Character.TYPE || clazz == Character.class;
    }

    private static void callSetter(Object target, String propertyName, Object parameter) throws PropertyException {
        Method setter = PropertyUtils.getSetter(target, propertyName);
        try {
            setter.invoke(target, parameter);
        }
        catch (IllegalAccessException ex) {
            throw new PropertyException("property '" + propertyName + "' is not accessible", ex);
        }
        catch (InvocationTargetException ex) {
            throw new PropertyException("property '" + propertyName + "' access threw an exception", ex);
        }
    }

    private static Object callGetter(Object target, String propertyName) throws PropertyException {
        Method getter = PropertyUtils.getGetter(target, propertyName);
        try {
            return getter.invoke(target, (Object[])null);
        }
        catch (IllegalAccessException ex) {
            throw new PropertyException("property '" + propertyName + "' is not accessible", ex);
        }
        catch (InvocationTargetException ex) {
            throw new PropertyException("property '" + propertyName + "' access threw an exception", ex);
        }
    }

    private static Method getSetter(Object target, String propertyName) throws PropertyException {
        if (propertyName == null || "".equals(propertyName)) {
            throw new PropertyException("encountered invalid null or empty property name");
        }
        String setterName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method[] methods = target.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(setterName) || !method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        throw new PropertyException("no writeable property '" + propertyName + "' in class '" + target.getClass().getName() + "'");
    }

    private static Method getGetter(Object target, String propertyName) throws PropertyException {
        String getterName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method[] methods = target.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(getterName) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) continue;
            return method;
        }
        throw new PropertyException("no readable property '" + propertyName + "' in class '" + target.getClass().getName() + "'");
    }

    private static boolean containsSetterForGetter(Class clazz, Method getterMethod) throws PropertyException {
        String setterMethodName;
        String getterMethodName = getterMethod.getName();
        if (getterMethodName.startsWith("get")) {
            setterMethodName = "set" + getterMethodName.substring(3);
        } else if (getterMethodName.startsWith("is")) {
            setterMethodName = "set" + getterMethodName.substring(2);
        } else {
            throw new PropertyException("method '" + getterMethodName + "' is not a getter, no setter can be found");
        }
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(setterMethodName)) continue;
            return true;
        }
        return false;
    }

    private static Class getPropertyType(Object target, String propertyName) throws PropertyException {
        String getterName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method[] methods = target.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(getterName) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) continue;
            return method.getReturnType();
        }
        throw new PropertyException("no property '" + propertyName + "' in class '" + target.getClass().getName() + "'");
    }

    public static String printProperties(Properties properties, Set<String> propertyNamesToHide) {
        StringBuffer ret = new StringBuffer();
        if (properties != null) {
            Enumeration<?> it = properties.propertyNames();
            ret.append("[");
            boolean first = true;
            while (it.hasMoreElements()) {
                if (!first) {
                    ret.append(",");
                }
                String name = (String)it.nextElement();
                String value = PropertyUtils.getValueToPrintForProperty(name, properties, propertyNamesToHide);
                ret.append(name);
                ret.append("=");
                ret.append(value);
                first = false;
            }
            ret.append("]");
        }
        return ret.toString();
    }

    private static String getValueToPrintForProperty(String name, Properties properties, Set<String> propertyNamesToHide) {
        String ret = null;
        ret = PropertyUtils.propertyValueMayNotBePrinted(name, propertyNamesToHide) ? "*****" : properties.getProperty(name);
        return ret;
    }

    private static boolean propertyValueMayNotBePrinted(String name, Set<String> propertyNamesToHide) {
        boolean ret = false;
        if (propertyNamesToHide != null) {
            ret = propertyNamesToHide.contains(name);
        }
        return ret;
    }

    public static String toString(Properties xaProperties) {
        StringBuffer ret = new StringBuffer();
        if (xaProperties != null) {
            Set<String> it = xaProperties.stringPropertyNames();
            ret.append("[");
            boolean first = true;
            for (String name : it) {
                if (!first) {
                    ret.append(",");
                }
                String value = xaProperties.getProperty(name);
                ret.append(name);
                ret.append("=");
                ret.append(value);
                first = false;
            }
            ret.append("]");
        }
        return ret.toString();
    }
}

