/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.labeling;

import com.sas.graphics.util.labeling.Candidate;
import com.sas.graphics.util.labeling.Graph;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;

public final class Node {
    public int index;
    public String text;
    public int x;
    public int y;
    protected int markerSize;
    protected Rectangle markerRect = null;
    protected boolean delayed = false;
    public int dx = 0;
    public int dy = 0;
    ArrayList candidates;
    public int textWidth;
    public int textHeight;
    public int textDescent;
    protected boolean resolved = false;
    public Candidate lastRemovedCandidate = null;
    public Candidate resolvedCandidate = null;

    public Node(int id, String label, int x, int y, FontMetrics fm, int markerSize) {
        this.index = id;
        this.text = label;
        this.x = x;
        this.y = y;
        this.markerSize = markerSize;
        this.markerRect = new Rectangle(x - markerSize / 2, y - markerSize / 2, markerSize, markerSize);
        if (this.text == null) {
            return;
        }
        this.textWidth = fm.stringWidth(this.text);
        this.textHeight = fm.getDescent() + fm.getAscent();
        this.textDescent = fm.getDescent();
        this.candidates = new ArrayList();
    }

    public void createCandidates(Rectangle clipBounds, ArrayList obstacles) {
        if (this.text == null) {
            return;
        }
        if (this.text.trim().length() == 0) {
            this.candidates.add(new Candidate(this, -1));
            return;
        }
        int maxStringLength = 0;
        int maxStringCandidate = 0;
        boolean obstructed = false;
        for (int i = 0; i < Graph.MAX_CANDIDATES; ++i) {
            Candidate c = new Candidate(this, i);
            Rectangle r = c.bbox;
            if (clipBounds.contains(r) && !Graph.isObstructed(obstacles, r)) {
                this.candidates.add(c);
                continue;
            }
            if (!clipBounds.contains(r)) {
                int len = (int)r.intersection(clipBounds).getWidth();
                if (len <= maxStringLength) continue;
                maxStringLength = len;
                maxStringCandidate = i;
                continue;
            }
            obstructed = true;
        }
        if (this.candidates != null && this.candidates.size() == 0) {
            this.candidates.add(new Candidate(this, maxStringCandidate));
            if (obstructed) {
                this.delayed = true;
            }
        }
    }

    public int getNumCandidates() {
        return this.candidates.size();
    }

    public Iterator getCandidates() {
        return this.candidates.listIterator();
    }

    public Candidate getCandidate(int i) {
        return (Candidate)this.candidates.get(i);
    }

    public void removeCandidate(Candidate c) {
        this.candidates.remove(c);
        this.lastRemovedCandidate = c;
    }

    public int getLabelPosition() {
        int labelPosition = -1;
        if (this.text != null) {
            labelPosition = this.getNumCandidates() == 1 ? this.getCandidate(0).getPosition() : (this.lastRemovedCandidate != null ? this.lastRemovedCandidate.getPosition() : 0);
        }
        return labelPosition;
    }

    public void dump() {
        System.out.println("Node: " + this.text);
        System.out.println("Candidates: " + this.getNumCandidates());
        Iterator i = this.getCandidates();
        while (i.hasNext()) {
            ((Candidate)i.next()).dump();
        }
    }

    public void doPhaseI(int rule) {
        block6: {
            Candidate c;
            block8: {
                block7: {
                    if (this.isResolved() || this.delayed) {
                        return;
                    }
                    if (rule != 0) break block7;
                    Iterator i = this.getCandidates();
                    while (i.hasNext()) {
                        Candidate c2 = (Candidate)i.next();
                        if (c2.getNumConflictPartners() != 0) continue;
                        c2.resolved(rule);
                        break block6;
                    }
                    break block6;
                }
                if (rule != 1) break block8;
                block1: for (int i = 0; i < this.getNumCandidates(); ++i) {
                    Candidate pi = this.getCandidate(i);
                    if (pi.getNumConflictPartners() != 1) continue;
                    Candidate qk = pi.getConflictPartner(0);
                    int qkp = qk.getPosition();
                    Node q = qk.getNode();
                    for (int j = 0; j < q.getNumCandidates(); ++j) {
                        Candidate c3;
                        Candidate qj = q.getCandidate(j);
                        if (qkp == qj.getPosition() || qj.getNumConflictPartners() != 1 || (c3 = qj.getConflictPartner(0)).getNode() != this || c3.getPosition() == pi.getPosition()) continue;
                        pi.resolved(rule);
                        qj.resolved(rule);
                        continue block1;
                    }
                }
                break block6;
            }
            if (this.getNumCandidates() != 1 || (c = this.getCandidate(0)).getNumConflictPartners() <= 0 || !this.checkClique(c)) break block6;
            this.setResolved(true);
            for (int i = 0; i < c.getNumConflictPartners(); ++i) {
                Candidate q = c.getConflictPartner(i);
                if (q.getNode().getNumCandidates() == 1) {
                    q.getNode().delayed = true;
                }
                q.getNode().removeCandidate(q);
                q.removeFromConflictPartners();
                q.applyRule(rule);
            }
        }
    }

    public void doPhaseII() {
        if (this.isResolved() || this.delayed) {
            return;
        }
        int maxConflicts = Integer.MIN_VALUE;
        Candidate cm = null;
        Iterator i = this.getCandidates();
        while (i.hasNext()) {
            Candidate c = (Candidate)i.next();
            int nc = c.getNumConflictPartners();
            if (nc <= maxConflicts) continue;
            cm = c;
            maxConflicts = nc;
        }
        if (cm != null) {
            this.removeCandidate(cm);
            cm.removeFromConflictPartners();
            cm.applyRule(0);
            cm.applyRule(1);
            cm.applyRule(2);
        }
        if (this.getNumCandidates() == 0) {
            this.delayed = true;
        }
    }

    private boolean checkClique(Candidate c) {
        Iterator i = c.getConflictPartners();
        Candidate cp = (Candidate)i.next();
        Rectangle intersect = cp.bbox;
        while (i.hasNext()) {
            cp = (Candidate)i.next();
            intersect = intersect.intersection(cp.bbox);
        }
        return intersect.width > 0 && intersect.height > 0;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean b) {
        this.resolved = b;
    }
}

