/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.labeling;

import com.sas.graphics.util.labeling.Candidate;
import com.sas.graphics.util.labeling.Node;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public final class Graph {
    public static final int RULE_L1 = 0;
    public static final int RULE_L2 = 1;
    public static final int RULE_L3 = 2;
    public static int MAX_CANDIDATES = 8;
    ArrayList nodes;
    Rectangle clipBounds;
    int hMaxShift = 0;
    int vMaxShift = 0;
    double vDistanceWeight = 2.0;
    private ArrayList obstacles = null;
    public boolean debugDraw = false;
    private Node[] allNodes = null;

    public Graph(Rectangle bounds) {
        this.clipBounds = bounds;
        this.nodes = new ArrayList();
    }

    public ArrayList getObstacles() {
        return this.obstacles;
    }

    public void addObstacle(Shape obstacle) {
        if (this.obstacles == null) {
            this.obstacles = new ArrayList();
        }
        this.obstacles.add(obstacle);
    }

    public int getHMaxShift() {
        return this.hMaxShift;
    }

    public void setHMaxShift(int shift) {
        this.hMaxShift = shift;
    }

    public int getVMaxShift() {
        return this.vMaxShift;
    }

    public void setVMaxShift(int shift) {
        this.vMaxShift = shift;
    }

    public double getVDistanceWeight() {
        return this.vDistanceWeight;
    }

    public void setVDistanceWeight(double weight) {
        this.vDistanceWeight = weight;
    }

    public void addNode(int id, String label, int x, int y, FontMetrics fm, int ms) {
        Node n = new Node(id, label, x, y, fm, ms);
        n.createCandidates(this.clipBounds, this.obstacles);
        this.nodes.add(n);
    }

    public boolean isFreeOfObstacles() {
        return this.obstacles == null;
    }

    public static void addObstaclePoint(GeneralPath obstacle, int x, int y) {
        if (obstacle.getCurrentPoint() == null) {
            obstacle.moveTo(x, y);
        } else {
            obstacle.lineTo(x, y);
            obstacle.moveTo(x, y);
        }
    }

    public static boolean isObstructed(ArrayList obstacles, Rectangle r) {
        if (obstacles == null) {
            return false;
        }
        boolean obstructed = false;
        for (int i = 0; i < obstacles.size(); ++i) {
            Shape obstacle = (Shape)obstacles.get(i);
            if (!obstacle.intersects(r)) continue;
            obstructed = true;
            break;
        }
        return obstructed;
    }

    public static boolean isObstructed(ArrayList obstacles, int x, int y, int w, int h) {
        if (obstacles == null) {
            return false;
        }
        boolean obstructed = false;
        for (int i = 0; i < obstacles.size(); ++i) {
            Shape obstacle = (Shape)obstacles.get(i);
            if (!obstacle.intersects(x, y, w, h)) continue;
            obstructed = true;
            break;
        }
        return obstructed;
    }

    public void buildConflictGraph() {
        for (int i = 0; i < this.nodes.size(); ++i) {
            Node s = (Node)this.nodes.get(i);
            for (int j = i + 1; j < this.nodes.size(); ++j) {
                Node d = (Node)this.nodes.get(j);
                this.addConflict(s, d);
            }
        }
    }

    private void addConflict(Node s, Node d) {
        if (s.text == null || d.text == null) {
            return;
        }
        Iterator i = s.getCandidates();
        while (i.hasNext()) {
            Candidate sc = (Candidate)i.next();
            Rectangle rs = sc.bbox;
            Iterator j = d.getCandidates();
            while (j.hasNext()) {
                Candidate dc = (Candidate)j.next();
                Rectangle rd = dc.bbox;
                Rectangle ir = rd.intersection(rs);
                if (ir.width <= 1 || ir.height <= 1) continue;
                sc.addConflictPartner(dc);
                dc.addConflictPartner(sc);
            }
        }
    }

    public void placeLabels() {
        Node n;
        ListIterator i = this.nodes.listIterator();
        while (i.hasNext()) {
            n = (Node)i.next();
            if (n.text == null) continue;
            n.doPhaseI(0);
        }
        i = this.nodes.listIterator();
        while (i.hasNext()) {
            n = (Node)i.next();
            if (n.text == null) continue;
            n.doPhaseI(1);
        }
        i = this.nodes.listIterator();
        while (i.hasNext()) {
            n = (Node)i.next();
            if (n.text == null) continue;
            n.doPhaseI(2);
        }
        for (int maxCandidates = MAX_CANDIDATES; maxCandidates > 0; --maxCandidates) {
            ListIterator i2 = this.nodes.listIterator();
            while (i2.hasNext()) {
                Node n2 = (Node)i2.next();
                if (n2.text == null || n2.candidates.size() != maxCandidates) continue;
                n2.doPhaseII();
            }
        }
        if (this.hMaxShift != 0 || this.vMaxShift != 0) {
            int i3;
            this.allNodes = new Node[this.nodes.size()];
            for (i3 = 0; i3 < this.nodes.size(); ++i3) {
                this.allNodes[i3] = n = (Node)this.nodes.get(i3);
                if (n.text == null || !n.resolved || n.delayed) continue;
                n.resolvedCandidate = n.getCandidate(0);
            }
            for (i3 = 0; i3 < this.allNodes.length; ++i3) {
                n = this.allNodes[i3];
                if (n.text == null || n.text.trim().length() == 0 || !n.delayed) continue;
                this.resolveDelayed(n);
            }
        }
    }

    private void resolveDelayed(Node node) {
        int i;
        int nNodes = this.allNodes.length;
        int ix = node.textWidth / node.text.length();
        int iy = node.textHeight / 4;
        Candidate c0 = new Candidate(node, 0);
        Candidate c1 = new Candidate(node, 1);
        Candidate c2 = new Candidate(node, 2);
        Candidate c3 = new Candidate(node, 3);
        Candidate c = c2;
        Rectangle b0 = c0.bbox;
        Rectangle b1 = c1.bbox;
        Rectangle b2 = c2.bbox;
        Rectangle b3 = c3.bbox;
        int deltaX = 0;
        int deltaY = 0;
        int y = 0;
        Candidate fc = null;
        double minDist = Double.MAX_VALUE;
        for (i = 0; i <= 8 * this.vMaxShift; ++i) {
            if (i > 0) {
                y = i % 2 == 0 ? -iy * i / 2 : iy * (i / 2 + 1);
            }
            int x = 0;
            for (int j = 0; j <= 2 * this.hMaxShift; ++j) {
                int bh;
                int bw;
                int by;
                int bx;
                if (j > 0) {
                    if (j % 2 == 0) {
                        x = -ix * j / 2;
                        if (y < 0) {
                            bx = b1.x;
                            by = b1.y;
                            bw = b1.width;
                            bh = b1.height;
                            c = c1;
                        } else {
                            bx = b3.x;
                            by = b3.y;
                            bw = b3.width;
                            bh = b3.height;
                            c = c3;
                        }
                    } else {
                        x = ix * (j / 2 + 1);
                        if (y < 0) {
                            bx = b0.x;
                            by = b0.y;
                            bw = b0.width;
                            bh = b0.height;
                            c = c0;
                        } else {
                            bx = b2.x;
                            by = b2.y;
                            bw = b2.width;
                            bh = b2.height;
                            c = c2;
                        }
                    }
                } else {
                    bx = b2.x;
                    by = b2.y;
                    bw = b2.width;
                    bh = b2.height;
                    c = c2;
                }
                if (!this.clipBounds.contains(bx += x, by += y, bw, bh) || Graph.isObstructed(this.obstacles, bx, by, bw, bh)) continue;
                boolean found = true;
                for (int k = 0; k < nNodes; ++k) {
                    Node n = this.allNodes[k];
                    if (n == node) continue;
                    if (n.text != null && n.resolved && !n.delayed) {
                        Rectangle bn = n.resolvedCandidate.bbox;
                        if (bx + bw > bn.x && by + bh > bn.y && bx < bn.x + bn.width && by < bn.y + bn.height) {
                            found = false;
                            break;
                        }
                    }
                    if (bx + bw <= n.markerRect.x || by + bh <= n.markerRect.y || bx >= n.markerRect.x + n.markerRect.width || by >= n.markerRect.y + n.markerRect.height) continue;
                    found = false;
                    break;
                }
                if (!found || !((double)Math.abs(x) + this.vDistanceWeight * (double)Math.abs(y) < minDist)) continue;
                minDist = (double)Math.abs(x) + this.vDistanceWeight * (double)Math.abs(y);
                fc = c;
                deltaX = x;
                deltaY = y;
            }
        }
        if (fc == null) {
            if (node.lastRemovedCandidate != null) {
                fc = node.lastRemovedCandidate;
            } else {
                for (i = 4; i < 8; ++i) {
                    fc = new Candidate(node, i);
                    Rectangle r = new Rectangle(fc.bbox);
                    r.y = this.clipBounds.y + this.clipBounds.height - r.y;
                    if (this.clipBounds.contains(r)) break;
                }
            }
        }
        if (node.getNumCandidates() > 0) {
            node.candidates.remove(0);
        }
        node.dx = deltaX;
        node.dy = deltaY;
        node.candidates.add(fc);
        fc.calcBBox();
        node.resolvedCandidate = fc;
        node.setResolved(true);
        node.delayed = false;
    }

    public int getNumNodes() {
        return this.nodes.size();
    }

    public Node getNode(int index) {
        return (Node)this.nodes.get(index);
    }

    public void draw(Graphics gc) {
        ListIterator i = this.nodes.listIterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (n.text == null) continue;
            if (this.debugDraw) {
                gc.setColor(Color.lightGray);
                if (n.getLabelPosition() != -1) {
                    Rectangle r = n.getCandidate((int)0).bbox;
                    gc.drawRect(r.x, r.y, r.width, r.height);
                } else {
                    gc.drawRect(n.x - n.textWidth, n.y - n.textHeight, 2 * n.textWidth, 2 * n.textHeight);
                    gc.drawLine(n.x, n.y - n.textHeight, n.x, n.y + n.textHeight);
                    gc.drawLine(n.x - n.textWidth, n.y, n.x + n.textWidth, n.y);
                }
            }
            gc.setColor(Color.black);
            switch (n.getLabelPosition()) {
                default: {
                    break;
                }
                case 0: {
                    gc.drawString(n.text, n.x + n.dx, n.y + n.dy + -n.textDescent);
                    break;
                }
                case 1: {
                    gc.drawString(n.text, n.x + n.dx - n.textWidth, n.y + n.dy - n.textDescent);
                    break;
                }
                case 2: {
                    gc.drawString(n.text, n.x + n.dx, n.y + n.dy + n.textHeight - n.textDescent);
                    break;
                }
                case 3: {
                    gc.drawString(n.text, n.x + n.dx - n.textWidth, n.y + n.dy + n.textHeight - n.textDescent);
                    break;
                }
                case 4: {
                    gc.drawString(n.text, n.x + n.dx, n.y + n.dy + n.textHeight / 2 - n.textDescent);
                    break;
                }
                case 5: {
                    gc.drawString(n.text, n.x + n.dx - n.textWidth / 2, n.y + n.dy - n.textDescent);
                    break;
                }
                case 6: {
                    gc.drawString(n.text, n.x + n.dx - n.textWidth, n.y + n.dy + n.textHeight / 2 - n.textDescent);
                    break;
                }
                case 7: {
                    gc.drawString(n.text, n.x + n.dx - n.textWidth / 2, n.y + n.dy + n.textHeight - n.textDescent);
                }
            }
            if (!this.debugDraw) continue;
            gc.setColor(Color.red);
            gc.fillRect(n.x - 1, n.y - 1, 3, 3);
        }
    }
}

