/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.categorization;

public class Bucket {
    protected static final double MACEPS = 1.110223024625157E-16;
    protected static final double DBL_EPSILON = 2.220446049250313E-16;
    protected static final double ZMIDCONST = 5.0E-6;

    public static double[] calcMidpoints(int n, double xmin, double xmax) {
        if (n < 1) {
            n = 1;
        }
        double[] midPoints = new double[2];
        if (n < 2) {
            midPoints[0] = (xmin + xmax) / 2.0;
            midPoints[1] = 0.0;
            return midPoints;
        }
        double d = 0.6 * (xmax - xmin) / (double)n;
        Bucket.scale(n, xmin + d, xmax - d, midPoints);
        if (midPoints[0] + 2.220446049250313E-13 < xmin) {
            Bucket.scale(n, xmin + (d *= 1.5), xmax - d, midPoints);
        }
        return midPoints;
    }

    public static void scale(int n, double xmin, double xmax, double[] midPoints) {
        int i;
        double s;
        double[] unit = new double[]{1.0, 1.2, 1.6, 2.0, 2.5, 3.0, 4.0, 5.0, 6.0, 8.0, 10.0};
        double x = Math.abs(xmax);
        if (x == 0.0) {
            x = 1.0;
        }
        if (xmax - xmin < x * 5.0E-6) {
            if (xmax < 0.0) {
                xmax = 0.0;
            } else if (xmax == 0.0) {
                xmax = 1.0;
            } else {
                xmin = 0.0;
            }
        }
        midPoints[1] = s = (xmax - xmin) / (double)(--n);
        while (s < 1.0) {
            s *= 10.0;
        }
        while (s >= 10.0) {
            s /= 10.0;
        }
        x = s - 1.0E-4;
        for (i = 0; i < 10 && !(x <= unit[i]); ++i) {
        }
        midPoints[1] = midPoints[1] * unit[i] / s;
        double range = (double)n * midPoints[1];
        x = 0.5 * (1.0 + (xmin + xmax - range) / midPoints[1]);
        long j = (long)(x - 1.0E-4);
        if (x < 0.0) {
            --j;
        }
        midPoints[0] = midPoints[1] * (double)j;
    }
}

