/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.DateFormatNameConversion;
import com.sas.text.SASFormat;
import java.util.ArrayList;

public class ZxAxis {
    private static double[] sCuts = new double[]{1.0, 2.0, 4.0, 5.0};
    private static double[] iCuts = new double[]{1.0, 2.0, 2.5, 5.0};
    private static int[] sCutsInt = new int[]{1, 2, 3, 5};
    private static int[] siCuts = new int[]{1, 2, 5, 10};
    public static final char IU_SECONDS = 's';
    public static final char IU_DAYS = 'd';
    public static final char IU_OBS = 'o';
    public static final char IU_UNDEF = 'u';
    public static final int IC_NONE = 0;
    public static final int IC_OBS = 1;
    public static final int IC_SECOND = 10;
    public static final int IC_MINUTE = 15;
    public static final int IC_HOUR = 20;
    public static final int IC_DAY = 25;
    public static final int IC_WEEKDAY = 27;
    public static final int IC_BUSDAY = 28;
    public static final int IC_BUSWEEK = 29;
    public static final int IC_WEEK = 30;
    public static final int IC_WEEKV = 31;
    public static final int IC_TENDAY = 35;
    public static final int IC_BUSSEMIMON = 38;
    public static final int IC_SEMIMON = 40;
    public static final int IC_BUSMONTH = 43;
    public static final int IC_MONTH = 45;
    public static final int IC_R445MON = 46;
    public static final int IC_R454MON = 47;
    public static final int IC_R544MON = 48;
    public static final int IC_BUSQTR = 49;
    public static final int IC_QTR = 50;
    public static final int IC_R445QTR = 51;
    public static final int IC_R454QTR = 52;
    public static final int IC_R544QTR = 53;
    public static final int IC_BUSSEMIYR = 54;
    public static final int IC_SEMIYEAR = 55;
    public static final int IC_BUSYEAR = 58;
    public static final int IC_YEAR = 60;
    public static final int IC_R445YR = 61;
    public static final int IC_R454YR = 62;
    public static final int IC_R544YR = 63;
    public static final int IC_YEARV = 64;
    public static final int IC_CONTINUOUS = 0;
    private static boolean IntInit = false;
    static int TABLE_LEN = 35;
    static boolean zt_init = false;
    static Table[] table;
    static int level;
    private static final long MACLONG = Integer.MAX_VALUE;
    private static final double MINDATE = -138061.0;
    private static final double MAXDATE = 6589335.0;
    private static final long LMAXDATE = 6589335L;
    protected static final double MACMISSING = Double.NaN;
    private static int[] dpm;
    private static int[] dpml;
    private static int[] dbm;
    private static final double DMINDATE = -138061.0;
    private static final double DMAXDATE = 6589335.0;
    private static final int YEARCUTOFF = 1920;
    private static String[] lookup;
    static final int NPRIMES = 12;
    static int[] prime;
    private static double minDateTime;
    private static double maxDateTime;

    public static double[] znaxis(double low, double high, boolean horizontal, boolean zeroflag, int maxTicks, double minCover, double targetCover) {
        double maxabs;
        double dataRange;
        double[] result = new double[3];
        if (minCover < 0.25 || minCover > 0.9) {
            minCover = 0.6;
        }
        if (targetCover < 0.5 || targetCover > 0.9) {
            targetCover = 0.8;
        }
        if (high < low) {
            double temp = low;
            low = high;
            high = temp;
        } else if (high == low) {
            result[0] = low;
            result[1] = 0.0;
            result[2] = 1.0;
            return result;
        }
        if (zeroflag) {
            if (low > 0.0) {
                low = 0.0;
            } else if (high < 0.0) {
                high = 0.0;
            }
        }
        if ((dataRange = high - low) < Math.max(1.0E-6 * (maxabs = Math.max(Math.abs(low), Math.abs(high))), Math.sqrt(Double.MIN_VALUE))) {
            return ZxAxis.noRange(low, high, horizontal, maxTicks);
        }
        double logTen = Math.log(10.0);
        double logscale = Math.floor(Math.log(maxabs) / logTen);
        double scale10 = Math.pow(10.0, logscale);
        boolean found = false;
        double lowTick = 0.0;
        double highTick = 0.0;
        double axisRange = 0.0;
        while (true) {
            for (int i = 0; i < sCuts.length; ++i) {
                double scale = scale10 / sCuts[i];
                lowTick = Math.floor(low / scale + 1.0E-6) * scale;
                highTick = Math.ceil(high / scale - 1.0E-6) * scale;
                axisRange = highTick - lowTick;
                if (axisRange / dataRange < 0.9999 || dataRange / axisRange < targetCover) continue;
                found = true;
                break;
            }
            if (found) break;
            scale10 /= 10.0;
        }
        int numberOfTicks = 0;
        double increment10 = scale10 / 10.0;
        double tickOne = lowTick;
        double tickTwo = highTick;
        if (!horizontal) {
            // empty if block
        }
        double increment = 0.0;
        double x = 0.0;
        if (found) {
            found = false;
            block2: do {
                for (int i = 0; i < iCuts.length; ++i) {
                    increment = increment10 * iCuts[i];
                    lowTick = Math.floor(tickOne / increment + 1.0E-6) * increment;
                    highTick = Math.ceil(tickTwo / increment - 1.0E-6) * increment;
                    x = lowTick + increment;
                    if (low > x && (!zeroflag || x <= 1.0E-6 * increment)) {
                        lowTick = x;
                    }
                    if (high < (x = highTick - increment) && (!zeroflag || x >= 1.0E-6 * increment)) {
                        highTick = x;
                    }
                    axisRange = highTick - lowTick;
                    numberOfTicks = (int)Math.floor(axisRange / increment + 1.0E-6) + 1;
                    if (horizontal) {
                        // empty if block
                    }
                    if (numberOfTicks > maxTicks || dataRange / axisRange < minCover) continue;
                    if (numberOfTicks < 3) continue block2;
                    if (zeroflag && (x = tickOne / increment + 1.0E-6) - Math.floor(x) > 1.0E-4) continue;
                    found = true;
                    continue block2;
                }
            } while (!found && !((increment10 *= 10.0) > dataRange));
        }
        if (!found) {
            lowTick = low;
            axisRange = high - low;
            numberOfTicks = Math.min(6, Math.max(maxTicks, 2));
            increment = axisRange / (double)(numberOfTicks - 1);
        } else {
            numberOfTicks = (int)Math.floor(axisRange / increment + 1.0E-6) + 1;
        }
        result[0] = lowTick;
        result[1] = increment;
        result[2] = numberOfTicks;
        return result;
    }

    public static double[] ziaxis(long low, long high, boolean horizontal, boolean zeroflag, int maxTicks, double minCover, double targetCover) {
        double[] result = new double[3];
        if (minCover < 0.25 || minCover > 0.9) {
            minCover = 0.6;
        }
        if (targetCover < 0.5 || targetCover > 0.9) {
            targetCover = 0.8;
        }
        if (high < low) {
            long temp = low;
            low = high;
            high = temp;
        } else if (high == low) {
            result[0] = low;
            result[1] = 0.0;
            result[2] = 1.0;
            return result;
        }
        if (zeroflag) {
            if (low > 0L) {
                low = 0L;
            } else if (high < 0L) {
                high = 0L;
            }
        }
        long dataRange = high - low;
        long maxabs = Math.max(Math.abs(low), Math.abs(high));
        if (dataRange == 0L) {
            return ZxAxis.noRange(low, high, horizontal, maxTicks);
        }
        if (dataRange < 10L && dataRange + 1L <= (long)maxTicks) {
            result[0] = low;
            result[1] = 1.0;
            result[2] = dataRange + 1L;
            return result;
        }
        double logTen = Math.log(10.0);
        double logscale = Math.floor(Math.log(maxabs) / logTen);
        double scale10 = Math.pow(10.0, logscale);
        boolean found = false;
        long lowTick = 0L;
        long highTick = 0L;
        long axisRange = 0L;
        while (true) {
            long scale;
            for (int i = 0; i < siCuts.length && (scale = (long)(scale10 / (double)siCuts[i])) != 0L; ++i) {
                lowTick = (long)Math.floor((double)low / (double)scale) * scale;
                highTick = (long)Math.ceil((double)high / (double)scale) * scale;
                axisRange = highTick - lowTick;
                if (axisRange / dataRange < 1L || (double)dataRange / (double)axisRange < targetCover) continue;
                found = true;
                break;
            }
            if (found) break;
            scale10 /= 10.0;
        }
        int numberOfTicks = 0;
        long increment10 = (long)Math.max(1.0, scale10 / 10.0);
        long tickOne = lowTick;
        long tickTwo = highTick;
        if (!horizontal) {
            // empty if block
        }
        long increment = 0L;
        long x = 0L;
        if (found) {
            found = false;
            block2: do {
                for (int i = 0; i < siCuts.length; ++i) {
                    increment = increment10 * (long)siCuts[i];
                    lowTick = (long)Math.floor((double)tickOne / (double)increment) * increment;
                    highTick = (long)Math.ceil((double)tickTwo / (double)increment) * increment;
                    x = lowTick + increment;
                    if (!(low <= x || zeroflag && x > 0L)) {
                        lowTick = x;
                    }
                    if (!(high >= (x = highTick - increment) || zeroflag && x < 0L)) {
                        highTick = x;
                    }
                    axisRange = highTick - lowTick;
                    numberOfTicks = (int)(axisRange / increment) + 1;
                    if (horizontal) {
                        // empty if block
                    }
                    if (numberOfTicks > maxTicks || (double)dataRange / (double)axisRange < minCover) continue;
                    if (numberOfTicks < 3) continue block2;
                    if (zeroflag && (double)(x = tickOne / increment) - Math.floor(x) > 1.0E-4) continue;
                    found = true;
                    continue block2;
                }
            } while (!found && (increment10 *= 10L) <= dataRange);
        }
        if (!found) {
            lowTick = low;
            axisRange = high - low;
            numberOfTicks = Math.min(6, Math.max(maxTicks, 2));
            increment = Math.max(1L, (long)Math.ceil((double)axisRange / (double)(numberOfTicks - 1)));
        } else {
            numberOfTicks = (int)(axisRange / increment) + 1;
        }
        result[0] = lowTick;
        result[1] = increment;
        result[2] = numberOfTicks;
        return result;
    }

    private static double[] noRange(double low, double high, boolean horizontal, int maxTicks) {
        double[] result = new double[3];
        result[0] = low;
        double dataRange = high - low;
        result[2] = Math.min(6, Math.max(maxTicks, 2));
        result[1] = dataRange / (result[2] - 1.0);
        return result;
    }

    private static void doIntInit() {
        if (IntInit) {
            return;
        }
        IntInit = true;
        lookup = new String[61];
        for (int i = 0; i < 61; ++i) {
            ZxAxis.lookup[i] = "???";
        }
        ZxAxis.lookup[1] = "IC_OBS";
        ZxAxis.lookup[10] = "IC_SECOND";
        ZxAxis.lookup[15] = "IC_MINUTE";
        ZxAxis.lookup[20] = "IC_HOUR";
        ZxAxis.lookup[25] = "IC_DAY";
        ZxAxis.lookup[27] = "IC_WEEKDAY";
        ZxAxis.lookup[28] = "IC_BUSDAY";
        ZxAxis.lookup[29] = "IC_BUSWEEK";
        ZxAxis.lookup[30] = "IC_WEEK";
        ZxAxis.lookup[35] = "IC_TENDAY";
        ZxAxis.lookup[38] = "IC_BUSSEMIMON";
        ZxAxis.lookup[40] = "IC_SEMIMON";
        ZxAxis.lookup[43] = "IC_BUSMONTH";
        ZxAxis.lookup[45] = "IC_MONTH";
        ZxAxis.lookup[48] = "IC_BUSQTR";
        ZxAxis.lookup[50] = "IC_QTR";
        ZxAxis.lookup[53] = "IC_BUSSEMIYR";
        ZxAxis.lookup[55] = "IC_SEMIYEAR";
        ZxAxis.lookup[58] = "IC_BUSYEAR";
        ZxAxis.lookup[60] = "IC_YEAR";
        ZxAxis.lookup[0] = "IC_CONTINUOUS=IC_NONE";
    }

    private static void initZT() {
        if (zt_init) {
            return;
        }
        zt_init = true;
        table = new Table[36];
        ZxAxis.table[0] = new Table(10, 1, "SECOND5", "DATETIME", 17, 15);
        ZxAxis.table[1] = new Table(10, 5, "SECOND10", "DATETIME", 17, 15);
        ZxAxis.table[2] = new Table(10, -1, "MINUTE", "DATETIME", 15, 13);
        ZxAxis.table[3] = new Table(15, 1, "MINUTE5", "DATETIME", 15, 13);
        ZxAxis.table[4] = new Table(15, 5, "MINUTE10", "DATETIME", 15, 13);
        ZxAxis.table[5] = new Table(15, -1, "HOUR", "DATETIME", 12, 10);
        ZxAxis.table[6] = new Table(20, 1, "HOUR2", "DATETIME", 12, 10);
        ZxAxis.table[7] = new Table(20, 2, "HOUR3", "DATETIME", 12, 10);
        ZxAxis.table[8] = new Table(20, 3, "HOUR6", "DATETIME", 12, 10);
        ZxAxis.table[9] = new Table(20, 6, "HOUR12", "DATETIME", 12, 10);
        ZxAxis.table[10] = new Table(20, -1, "DAY", "DATETIME", 12, 10);
        ZxAxis.table[11] = new Table(25, 1, "DAY2", "DATE    ", 9, 7);
        ZxAxis.table[12] = new Table(25, -1, "WEEK", "DATE    ", 9, 7);
        ZxAxis.table[13] = new Table(30, -1, "SEMIMONTH", "DATE    ", 9, 7);
        ZxAxis.table[14] = new Table(27, 1, "WEEK", "DATE    ", 9, 7);
        ZxAxis.table[15] = new Table(27, -1, "SEMIMONTH", "DATE    ", 9, 7);
        ZxAxis.table[16] = new Table(30, 1, "WEEK2", "WEEKDATX", 17, 15);
        ZxAxis.table[17] = new Table(30, 2, "WEEK4", "WEEKDATX", 17, 15);
        ZxAxis.table[18] = new Table(30, -1, "MONTH2", "WEEKDATX", 17, 15);
        ZxAxis.table[19] = new Table(35, -1, "MONTH", "MONYY   ", 7, 5);
        ZxAxis.table[20] = new Table(40, -1, "MONTH", "MONYY   ", 7, 5);
        ZxAxis.table[21] = new Table(45, 1, "MONTH2", "MONYY   ", 7, 5);
        ZxAxis.table[22] = new Table(45, 2, "MONTH3", "MONYY   ", 7, 5);
        ZxAxis.table[23] = new Table(45, 3, "MONTH4", "MONYY   ", 7, 5);
        ZxAxis.table[24] = new Table(45, 4, "MONTH6", "MONYY   ", 7, 5);
        ZxAxis.table[25] = new Table(45, -1, "YEAR", "YEAR    ", 4, 2);
        ZxAxis.table[26] = new Table(50, 1, "QTR2", "YYQC    ", 8, 6);
        ZxAxis.table[27] = new Table(50, -1, "YEAR", "YEAR    ", 4, 2);
        ZxAxis.table[28] = new Table(55, -1, "YEAR", "YEAR    ", 4, 2);
        ZxAxis.table[29] = new Table(60, 1, "YEAR2", "YEAR    ", 4, 2);
        ZxAxis.table[30] = new Table(60, 2, "YEAR5", "YEAR    ", 4, 2);
        ZxAxis.table[31] = new Table(60, 5, "YEAR10", "YEAR    ", 4, 2);
        ZxAxis.table[32] = new Table(60, 10, "YEAR20", "YEAR    ", 4, 2);
        ZxAxis.table[33] = new Table(60, 20, "YEAR50", "YEAR    ", 4, 4);
        ZxAxis.table[34] = new Table(60, 99, "YEAR100", "YEAR    ", 4, 4);
        ZxAxis.table[35] = new Table(60, -2, "**end**", "        ", 0, 0);
    }

    private static double INTNX(Interval i, double t, double n) {
        return ZxAxis.zintnx2(i, t, n);
    }

    private static double INTCEIL(Interval i, double t) {
        return ZxAxis.zintcl(i, t);
    }

    private static double INTFLOOR(Interval i, double t) {
        return ZxAxis.INTNX(i, t, 0.0);
    }

    private static double INTCK(Interval i, double f, double t) {
        return ZxAxis.zintck2(i, f, t);
    }

    public static synchronized Object[] ztaxis(Interval interval, double xmin, double xmax, int maxticks, double mincover, SASFormat fmt) {
        int tickn;
        double tickstart;
        double high;
        if (!ZxAxis.isValidDateTime(new double[]{xmin, xmax}, fmt)) {
            throw new Error("ZxAxis : Minimum value or maximum value is out of range.");
        }
        ZxAxis.initZT();
        Object[] rc = null;
        Interval tickintvl = new Interval();
        Interval temp_intvl = new Interval();
        double user_max = xmax;
        int init_maxticks = maxticks;
        if (interval.intcode == 0) {
            String fmtname = "";
            if (fmt != null) {
                fmtname = ZxAxis.getEnglishFormatName(fmt.getName());
            }
            if (fmt == null || fmt.isDateFormat()) {
                interval.intcode = 25;
                interval.units = (char)100;
            } else if (fmt.isTimeFormat() || fmt.isDateTimeFormat()) {
                interval.intcode = fmtname.startsWith("DTYEAR") ? 60 : (fmtname.startsWith("DTSEMIYEAR") ? 55 : (fmtname.startsWith("DTYYQC") ? 50 : (fmtname.startsWith("DTMONYY") ? 45 : (fmtname.startsWith("DT") ? 25 : 10))));
                interval.units = (char)115;
            } else {
                System.out.println("ZxAxis : " + fmtname + " not recognized as a DateTime format.");
                throw new Error("Bad DateTime format");
            }
        }
        xmin = ZxAxis.INTNX(interval, xmin, 0.0);
        xmax = ZxAxis.INTNX(interval, xmax, 0.0);
        mincover = mincover <= 0.0 ? 0.7 : Math.min(Math.max(mincover, 0.25), 0.95);
        while (true) {
            double low;
            Interval axis_intvl = interval;
            axis_intvl = ZxAxis.taxis(axis_intvl, xmin, xmax, maxticks, temp_intvl);
            if (axis_intvl.intper > 1) {
                low = ZxAxis.INTFLOOR(axis_intvl, xmin);
                high = ZxAxis.INTCEIL(axis_intvl, xmax);
                double cover = (xmax - xmin) / (high - low);
                if (cover < mincover) {
                    axis_intvl.shiftper = (short)ZxAxis.INTCK(axis_intvl, low, xmin);
                }
            }
            tickintvl = axis_intvl;
            low = ZxAxis.INTFLOOR(tickintvl, xmin);
            high = ZxAxis.INTCEIL(tickintvl, xmax);
            tickstart = low;
            tickn = Double.isNaN(low) || Double.isNaN(high) ? -1 : (int)ZxAxis.INTCK(tickintvl, low, high) + 1;
            if (tickn >= 2) break;
            if (maxticks > 50) {
                tickintvl = null;
                break;
            }
            maxticks += init_maxticks;
        }
        if (high < user_max) {
            ++tickn;
        }
        rc = new Object[]{tickintvl, new Double(tickstart), new Integer(tickn)};
        return rc;
    }

    private static Interval taxis(Interval interval, double min, double max, int maxticks, Interval tempintvl) {
        int max_ticks;
        double[] x = new double[4];
        double low = ZxAxis.INTFLOOR(interval, min);
        double hi = ZxAxis.INTCEIL(interval, max);
        if (Double.isNaN(low) || Double.isNaN(hi)) {
            return null;
        }
        int n_ticks = (int)ZxAxis.INTCK(interval, low, hi) + 1;
        if (n_ticks <= (max_ticks = maxticks)) {
            return interval;
        }
        if (max_ticks < 2 && interval.intcode >= 60) {
            return null;
        }
        int rc = ZxAxis.outer(interval, tempintvl);
        if (rc != 0) {
            return null;
        }
        interval = tempintvl;
        ++level;
        ZxAxis.taxis(interval, min, max, maxticks, tempintvl);
        --level;
        return tempintvl;
    }

    private static int outer(Interval interval, Interval outer_intvl) {
        int i;
        Table t = null;
        int intcode = interval.intcode;
        short intper = interval.intper;
        for (i = 0; i < TABLE_LEN; ++i) {
            t = table[i];
            if (t.intcode < intcode) continue;
            if (t.intcode > intcode) {
                return 1;
            }
            if (t.maxper < 0 || intper <= t.maxper) break;
        }
        if (t.maxper == -2 || i >= TABLE_LEN) {
            return 1;
        }
        ZxAxis.zintstr(t.intname, outer_intvl);
        outer_intvl.units = interval.units;
        return 0;
    }

    private static String getEnglishFormatName(String fmtname) {
        if (fmtname == null) {
            return null;
        }
        int i = -1;
        for (int c = 0; c < fmtname.length(); ++c) {
            if (Character.isLetter(fmtname.charAt(c))) continue;
            i = c;
            break;
        }
        if (i != -1) {
            fmtname = fmtname.substring(0, i);
        }
        try {
            DateFormatNameConversion dfnc = DateFormatNameConversion.newDataFormatNameConversion(fmtname.toUpperCase());
            fmtname = dfnc.getEnglishFormatName();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return fmtname;
    }

    public static String zintfmt(Interval istr, boolean wider) {
        String fname;
        boolean days;
        if (istr == null || istr.intcode == 0) {
            return null;
        }
        boolean shiftper = istr.shiftper > 1;
        boolean bl = days = istr.units == 'd';
        if (istr.units == 'o' || istr.units == 'u') {
            fname = "BEST12";
        } else {
            switch (istr.intcode) {
                case 60: {
                    if (shiftper) {
                        if (wider) {
                            fname = days ? "MONYY7" : "DTMONYY7";
                            break;
                        }
                        fname = days ? "MONYY5" : "DTMONYY5";
                        break;
                    }
                    if (wider) {
                        fname = days ? "YEAR4" : "DTYEAR4";
                        break;
                    }
                    fname = days ? "YEAR2" : "DTYEAR2";
                    break;
                }
                case 55: {
                    if (wider) {
                        fname = days ? "MONYY7" : "DTMONYY7";
                        break;
                    }
                    fname = days ? "MONYY5" : "DTMONYY5";
                    break;
                }
                case 50: {
                    if (shiftper) {
                        if (wider) {
                            fname = days ? "MONYY7" : "DTMONYY7";
                            break;
                        }
                        fname = days ? "MONYY5" : "DTMONYY5";
                        break;
                    }
                    if (wider) {
                        fname = days ? "YYQC6" : "DTYYQC6";
                        break;
                    }
                    fname = days ? "YYQC4" : "DTYYQC4";
                    break;
                }
                case 45: {
                    if (wider) {
                        fname = days ? "MONYY7" : "DTMONYY7";
                        break;
                    }
                    fname = days ? "MONYY5" : "DTMONYY5";
                    break;
                }
                case 35: 
                case 40: {
                    if (wider) {
                        fname = days ? "DATE9" : "DTDATE9";
                        break;
                    }
                    fname = days ? "DATE7" : "DTDATE7";
                    break;
                }
                case 30: {
                    if (wider) {
                        fname = days ? "WEEKDATX17" : "DTWKDATX17";
                        break;
                    }
                    fname = days ? "WEEKDATX15" : "DTWKDATX15";
                    break;
                }
                case 25: 
                case 27: {
                    if (wider) {
                        fname = days ? "DATE9" : "DTDATE9";
                        break;
                    }
                    fname = days ? "DATE7" : "DTDATE7";
                    break;
                }
                case 20: {
                    fname = shiftper ? "DATETIME13" : "DATETIME10";
                    break;
                }
                case 15: {
                    fname = shiftper ? "DATETIME16" : "DATETIME13";
                    break;
                }
                case 10: {
                    fname = "DATETIME16";
                    break;
                }
                default: {
                    fname = wider ? (days ? "DATE9" : "DATETIME16") : (days ? "DATE7" : "DATETIME16");
                }
            }
        }
        return fname;
    }

    public static String zintfmm(Interval istr, double idval, boolean wider, SASFormat fmt) {
        if (fmt != null && fmt.isTimeFormat()) {
            return ZxAxis.zintfmm(istr, idval, wider);
        }
        return ZxAxis.zintfmt(istr, wider);
    }

    public static String zintfmm(Interval istr, double idval, boolean wider) {
        if (istr == null || istr.intcode == 0 || Double.isNaN(idval) || istr.units == 'o' || istr.units == 'u' || istr.intcode != 20 && istr.intcode != 15 && istr.intcode != 10) {
            return ZxAxis.zintfmt(istr, wider);
        }
        short intper = istr.intper;
        short shiftper = istr.shiftper;
        double time = 0.0;
        switch (istr.intcode) {
            case 20: {
                time = (double)intper * 3600.0;
                break;
            }
            case 15: {
                time = (double)intper * 60.0;
                break;
            }
            case 10: {
                time = (double)intper * 1.0;
            }
        }
        if (idval < 0.0 || idval > 86400.0 || time >= 86400.0) {
            return ZxAxis.zintfmt(istr, wider);
        }
        String fname = null;
        switch (istr.intcode) {
            case 20: {
                fname = shiftper > 0 ? "TIME8" : "TIME5";
                break;
            }
            case 15: {
                fname = shiftper > 0 ? "TIME8" : "TIME5";
                break;
            }
            case 10: {
                fname = "TIME8";
            }
        }
        return fname;
    }

    protected static void zintstr(String spec, Interval istr) {
        int i;
        String nam = new String();
        if (istr == null || spec == null) {
            return;
        }
        int l = spec.length();
        istr.token = spec;
        istr.intper = 1;
        int nl = 0;
        for (i = 0; i < l && Character.isLetter(spec.charAt(i)); ++i) {
        }
        nl = i;
        nam = spec.substring(0, nl);
        int wi = -1;
        int di = -1;
        while (i < l) {
            char c = spec.charAt(i);
            switch (c) {
                case 'W': 
                case 'w': {
                    if (wi != -1 || di != -1) {
                        return;
                    }
                    wi = i;
                    break;
                }
                case '.': {
                    if (di != -1) {
                        return;
                    }
                    di = i;
                    break;
                }
                default: {
                    if (Character.isDigit(c)) break;
                    return;
                }
            }
            ++i;
        }
        if (nl == 0) {
            if (wi >= 0) {
                return;
            }
            int[] ps = ZxAxis.getnum(spec, l, di);
            if (ps == null) {
                return;
            }
            if (ps[1] != 0) {
                return;
            }
            istr.units = (char)111;
            istr.intcode = 1;
            istr.intper = (short)ps[0];
            return;
        }
        spec = spec.substring(nl);
        l -= nl;
        di -= nl;
        wi -= nl;
        String n = nam;
        if (n.charAt(0) == 'D') {
            if (nl > 1 && n.charAt(1) == 'T') {
                n = n.substring(2);
                nl -= 2;
                istr.units = (char)115;
            }
        } else if (n.charAt(0) == 'T' && nl > 1 && n.charAt(1) != 'E') {
            n = n.substring(1);
            --nl;
            istr.units = (char)115;
        }
        if (nl < 2) {
            return;
        }
        int code = ZxAxis.getname(n, nl);
        if (code == 0) {
            return;
        }
        istr.intcode = code;
        if (istr.units == '\u0000') {
            istr.units = istr.intcode == 0 || istr.intcode == 1 ? (char)111 : (char)(code < 25 ? 115 : 100);
        }
        if (code == 27 ? ZxAxis.weekday(istr, spec, wi) != 0 : wi >= 0) {
            return;
        }
        if (wi >= 0) {
            spec = spec + ++wi;
            l -= wi;
            di -= wi;
        }
        if (l == 0) {
            return;
        }
        int[] ps = ZxAxis.getnum(spec, l, di);
        if (ps == null) {
            return;
        }
        istr.intper = (short)ps[0];
        if (ps[1] != 0) {
            if (ZxAxis.checkshift(code, ps[0], ps[1])) {
                return;
            }
            istr.shiftper = (short)(ps[1] - 1);
        }
    }

    private static boolean E(String s, String name) {
        return s.trim().equalsIgnoreCase(name.trim());
    }

    private static int getname(String name, int l) {
        --l;
        char c = name.charAt(0);
        name = name.substring(1);
        switch (c) {
            case 'A': {
                if (ZxAxis.E(name, "NNUAL")) {
                    return 60;
                }
                if (ZxAxis.E(name, "NNUALLY")) {
                    return 60;
                }
                if (ZxAxis.E(name, "NNUALS")) {
                    return 60;
                }
                return 0;
            }
            case 'D': {
                if (ZxAxis.E(name, "AY")) {
                    return 25;
                }
                if (ZxAxis.E(name, "AILY")) {
                    return 25;
                }
                if (ZxAxis.E(name, "AYS")) {
                    return 25;
                }
                return 0;
            }
            case 'H': {
                if (ZxAxis.E(name, "OUR")) {
                    return 20;
                }
                if (ZxAxis.E(name, "OURLY")) {
                    return 20;
                }
                if (ZxAxis.E(name, "OURS")) {
                    return 20;
                }
                if (ZxAxis.E(name, "R")) {
                    return 20;
                }
                return 0;
            }
            case 'M': {
                if (ZxAxis.E(name, "ONTH")) {
                    return 45;
                }
                if (ZxAxis.E(name, "INUTE")) {
                    return 15;
                }
                if (ZxAxis.E(name, "ONTHLY")) {
                    return 45;
                }
                if (ZxAxis.E(name, "ONTHS")) {
                    return 45;
                }
                if (ZxAxis.E(name, "ON")) {
                    return 45;
                }
                if (ZxAxis.E(name, "INUTES")) {
                    return 15;
                }
                if (ZxAxis.E(name, "IN")) {
                    return 15;
                }
                return 0;
            }
            case 'N': {
                if (ZxAxis.E(name, "ONE")) {
                    return 0;
                }
                return 0;
            }
            case 'O': {
                if (ZxAxis.E(name, "BS")) {
                    return 1;
                }
                return 0;
            }
            case 'Q': {
                if (ZxAxis.E(name, "TR")) {
                    return 50;
                }
                if (ZxAxis.E(name, "UARTER")) {
                    return 50;
                }
                if (ZxAxis.E(name, "UARTERLY")) {
                    return 50;
                }
                if (ZxAxis.E(name, "UARTERS")) {
                    return 50;
                }
                if (ZxAxis.E(name, "TRLY")) {
                    return 50;
                }
                if (ZxAxis.E(name, "TRS")) {
                    return 50;
                }
                return 0;
            }
            case 'S': {
                if (ZxAxis.E(name, "ECOND")) {
                    return 10;
                }
                if (ZxAxis.E(name, "EMIMONTH")) {
                    return 40;
                }
                if (ZxAxis.E(name, "EMIYEAR")) {
                    return 55;
                }
                if (ZxAxis.E(name, "ECONDS")) {
                    return 10;
                }
                if (ZxAxis.E(name, "EC")) {
                    return 10;
                }
                if (ZxAxis.E(name, "EMIMONTHLY")) {
                    return 40;
                }
                if (ZxAxis.E(name, "EMIMONTHS")) {
                    return 40;
                }
                if (ZxAxis.E(name, "EMIMON")) {
                    return 40;
                }
                if (ZxAxis.E(name, "EMIYEARLY")) {
                    return 55;
                }
                if (ZxAxis.E(name, "EMIYEARS")) {
                    return 55;
                }
                if (ZxAxis.E(name, "EMIYR")) {
                    return 55;
                }
                if (ZxAxis.E(name, "EMIANNUAL")) {
                    return 55;
                }
                if (ZxAxis.E(name, "EMIANN")) {
                    return 55;
                }
                return 0;
            }
            case 'T': {
                if (ZxAxis.E(name, "ENDAY")) {
                    return 35;
                }
                return 0;
            }
            case 'W': {
                if (ZxAxis.E(name, "EEK")) {
                    return 30;
                }
                if (ZxAxis.E(name, "EEKDAY")) {
                    return 27;
                }
                if (ZxAxis.E(name, "EEKLY")) {
                    return 30;
                }
                if (ZxAxis.E(name, "EEKS")) {
                    return 30;
                }
                if (ZxAxis.E(name, "EEKDAYS")) {
                    return 27;
                }
                return 0;
            }
            case 'Y': {
                if (ZxAxis.E(name, "EAR")) {
                    return 60;
                }
                if (ZxAxis.E(name, "EARS")) {
                    return 60;
                }
                if (ZxAxis.E(name, "EARLY")) {
                    return 60;
                }
                if (ZxAxis.E(name, "R")) {
                    return 60;
                }
                return 0;
            }
        }
        return 0;
    }

    private static int[] getnum(String s, int l, int di) {
        int i;
        int[] ps = new int[]{1, 0};
        int k = di >= 0 ? di : l;
        for (i = 0; i < k; ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return null;
        }
        if (k > 0) {
            ps[0] = new Integer(s.substring(0, k));
        }
        if (di < 0) {
            return ps;
        }
        if ((k = l - ++di) <= 0) {
            return ps;
        }
        i = 0;
        int c = di;
        while (i < k) {
            if (!Character.isDigit(s.charAt(c))) {
                return null;
            }
            ++i;
            ++c;
        }
        Integer tobj = new Integer(s.substring(di, di + k));
        int t = tobj;
        if (t < 1) {
            return null;
        }
        ps[1] = t;
        return ps;
    }

    static boolean checkshift(int code, int intper, int shift) {
        int f;
        if (shift < 1) {
            return false;
        }
        switch (code) {
            case 60: {
                f = 12;
                break;
            }
            case 55: {
                f = 6;
                break;
            }
            case 50: {
                f = 3;
                break;
            }
            case 30: {
                f = 7;
                break;
            }
            default: {
                f = 1;
            }
        }
        return (long)shift > (long)f * (long)intper;
    }

    static int weekday(Interval istr, String s, int wi) {
        int k;
        if (wi < 0) {
            istr.nweekday = (char)5;
            istr.weekend[0] = true;
            istr.weekend[6] = true;
            return 0;
        }
        if (wi == 0 || wi > 6) {
            return 1;
        }
        while (wi > 0) {
            k = s.charAt(0) - 49;
            if (k >= 7 || k < 0) {
                return 1;
            }
            istr.weekend[k] = true;
            --wi;
            s = s.substring(1);
        }
        k = 0;
        for (int i = 0; i < 7; ++i) {
            if (istr.weekend[i]) continue;
            ++k;
        }
        if (k == 0) {
            return 1;
        }
        istr.nweekday = (char)k;
        return 0;
    }

    private static double zintcl(Interval istr, double x) {
        double t = ZxAxis.INTNX(istr, x, 0.0);
        if (t == x) {
            return x;
        }
        return ZxAxis.INTNX(istr, t, 1.0);
    }

    public static double zintnx2(Interval istr, double x, double n) {
        x = Math.floor(x + 1.0E-12);
        n = Math.floor(n + 1.0E-12);
        if (istr.intcode == 1) {
            if (istr.units != 'o') {
                return Double.NaN;
            }
            if (istr.intper == 1) {
                return x + n;
            }
            x = (double)istr.intper * Math.floor(x / (double)istr.intper);
            return x + n * (double)istr.intper;
        }
        if (istr.intcode >= 25) {
            return ZxAxis.datenx(istr, x, n);
        }
        return ZxAxis.timenx(istr, x, n);
    }

    private static double datenx(Interval istr, double d, double k) {
        boolean converted = false;
        if (istr.units == 's') {
            d = Math.floor(d / 86400.0);
            converted = true;
        } else if (istr.units != 'd') {
            return Double.NaN;
        }
        if (d < -138061.0 || d > 6589335.0) {
            return Double.NaN;
        }
        long n = (long)k;
        long f = istr.intper;
        if (f < 1L) {
            f = 1L;
        }
        long s = istr.shiftper;
        double r = istr.intcode > 30 ? ZxAxis.yearbase(istr.intcode, d, n, f, s) : ZxAxis.daybase(istr, (long)d, n, f, s);
        if (r < -138061.0 || r > 6589335.0) {
            return Double.NaN;
        }
        if (converted) {
            r *= 86400.0;
        }
        return r;
    }

    static double timenx(Interval istr, double x, double n) {
        long k;
        if (istr.units != 's') {
            return Double.NaN;
        }
        long f = istr.intper;
        if (f < 1L) {
            f = 1L;
        }
        long s = istr.shiftper;
        switch (istr.intcode) {
            case 20: {
                k = 3600L;
                f *= k;
                break;
            }
            case 15: {
                k = 60L;
                f *= k;
                break;
            }
            case 10: {
                k = 1L;
                break;
            }
            default: {
                System.out.println("zintnx2: bad intcode=" + istr.intcode);
                return Double.NaN;
            }
        }
        if (s != 0L) {
            s = f - k * s;
        }
        double ss = s;
        double ff = f;
        x = Math.floor((x + ss) / ff);
        double r = (x + n) * ff - ss;
        return r;
    }

    private static double yearbase(int intcode, double date, long n, long f, long s) {
        int[] mdy = ZxAxis.zidmdyd(date);
        if (mdy == null) {
            return Double.NaN;
        }
        int m = mdy[0];
        int d = mdy[1];
        int y = mdy[2];
        long r = 12L * (long)(y -= 1960) + (long)(--m);
        long k = 31L;
        long nperyr = 12L;
        switch (intcode) {
            case 35: {
                nperyr = 36L;
                k = 11L;
                r = 3L * r + (long)(d > 20 ? 1 : 0) + (long)(d > 10 ? 1 : 0);
                break;
            }
            case 40: {
                nperyr = 24L;
                k = 16L;
                r = 2L * r + (long)(d > 15 ? 1 : 0);
                break;
            }
            case 45: {
                break;
            }
            case 50: {
                f *= 3L;
                break;
            }
            case 55: {
                f *= 6L;
                break;
            }
            case 60: {
                f *= 12L;
                break;
            }
            default: {
                System.out.println("zintnx2: yearbase: bad intcode=" + intcode);
                return Double.NaN;
            }
        }
        if (s != 0L) {
            s = f - s;
        }
        if (n != 0L && 2140894312L / Math.abs(n) < f * k) {
            return Double.NaN;
        }
        long x = f != 1L ? (ZxAxis.ldiv(r + s, f) + n) * f - s : r + n;
        y = (int)ZxAxis.ldiv(x, nperyr) + 1960;
        switch (intcode) {
            case 35: {
                m = (int)ZxAxis.ldiv(ZxAxis.lmod(x, 36L), 3L) + 1;
                d = (int)ZxAxis.lmod(x, 3L);
                d = d == 0 ? 1 : (d == 1 ? 11 : 21);
                break;
            }
            case 40: {
                m = (int)ZxAxis.ldiv(ZxAxis.lmod(x, 24L), 2L) + 1;
                d = ZxAxis.lmod(x, 2L) == 0L ? 1 : 16;
                break;
            }
            default: {
                m = (int)ZxAxis.lmod(x, 12L) + 1;
                d = 1;
            }
        }
        double z = ZxAxis.ziddmdy(m, d, y);
        return z;
    }

    private static double daybase(Interval istr, long x, long n, long f, long s) {
        int intcode = istr.intcode;
        if (intcode == 30) {
            f *= 7L;
            s -= 5L;
        } else if (intcode == 27) {
            return ZxAxis.weekday(istr, x, n, f, s);
        }
        if (f == 1L) {
            return x + n;
        }
        if (s != 0L) {
            s = f - s;
        }
        long r = (ZxAxis.ldiv(x + s, f) + n) * f - s;
        return r;
    }

    static double weekday(Interval istr, long x, long n, long f, long s) {
        long k;
        long nweekday = istr.nweekday;
        boolean[] weekend = istr.weekend;
        int dow = (int)ZxAxis.lmod(x + 5L, 7L);
        while (weekend[dow]) {
            --x;
            if (--dow >= 0) continue;
            dow = 6;
        }
        if (f > 1L) {
            n *= f;
            if (s != 0L) {
                s = f - s;
            }
            k = ZxAxis.ldiv(x, 7L) * nweekday;
            int dow2 = 6;
            for (long j = ZxAxis.lmod(x, 7L); j > 0L; --j) {
                if (!weekend[dow2]) {
                    ++k;
                }
                if (++dow2 <= 6) continue;
                dow2 = 0;
            }
            k -= ZxAxis.ldiv(k + s, f) * f - s;
            while (k > 0L) {
                --x;
                if (--dow < 0) {
                    dow = 6;
                }
                while (weekend[dow]) {
                    --x;
                    if (--dow >= 0) continue;
                    dow = 6;
                }
                --k;
            }
        }
        k = ZxAxis.ldiv(n, nweekday);
        x += 7L * k;
        for (k = ZxAxis.lmod(n, nweekday); k > 0L; --k) {
            ++x;
            if (++dow > 6) {
                dow = 0;
            }
            while (weekend[dow]) {
                ++x;
                if (++dow <= 6) continue;
                dow = 0;
            }
        }
        return x;
    }

    private static long lmod(long a, long m) {
        if (a < 0L) {
            a = m - -a % m;
        }
        return a % m;
    }

    private static long ldiv(long n, long d) {
        if (n >= 0L) {
            return n / d;
        }
        n = -n;
        return -(n / d + (long)(n % d != 0L ? 1 : 0));
    }

    public static double zintck2(Interval istr, double x1, double x2) {
        x1 = Math.floor(x1);
        x2 = Math.floor(x2);
        if (istr.intcode == 1) {
            if (istr.units != 'o') {
                return Double.NaN;
            }
            return Math.floor(x2 / (double)istr.intper) - Math.floor(x1 / (double)istr.intper);
        }
        if (istr.intcode >= 25) {
            return ZxAxis.dateck(istr, x1, x2);
        }
        return ZxAxis.timeck(istr, x1, x2);
    }

    private static double dateck(Interval istr, double x1, double x2) {
        if (istr.units == 's') {
            x1 = Math.floor(x1 / 86400.0);
            x2 = Math.floor(x2 / 86400.0);
        } else if (istr.units != 'd') {
            return Double.NaN;
        }
        if (x1 < -138061.0 || x1 > 6589335.0) {
            return Double.NaN;
        }
        if (x2 < -138061.0 || x2 > 6589335.0) {
            return Double.NaN;
        }
        long f = istr.intper;
        if (f < 1L) {
            f = 1L;
        }
        long s = istr.shiftper;
        int intcode = istr.intcode;
        double r = intcode > 30 ? ZxAxis.yearbase(intcode, x1, x2, f, s) : ZxAxis.daybase2(istr, (long)x1, (long)x2, f, s);
        return r;
    }

    private static double yearbase(int intcode, double date1, double date2, long f, long s) {
        int[] mdy = ZxAxis.zidmdyd(date1);
        if (mdy == null) {
            return Double.NaN;
        }
        int m1 = mdy[0];
        int d1 = mdy[1];
        int y1 = mdy[2];
        mdy = ZxAxis.zidmdyd(date2);
        if (mdy == null) {
            return Double.NaN;
        }
        int m2 = mdy[0];
        int d2 = mdy[1];
        int y2 = mdy[2];
        long x2 = 12L * (long)(y2 -= 1960) + (long)(--m2);
        long x1 = 12L * (long)(y1 -= 1960) + (long)(--m1);
        switch (intcode) {
            case 35: {
                x2 = 3L * x2 + (long)(d2 > 10 ? 1 : 0) + (long)(d2 > 20 ? 1 : 0);
                x1 = 3L * x1 + (long)(d1 > 10 ? 1 : 0) + (long)(d1 > 20 ? 1 : 0);
                break;
            }
            case 40: {
                x2 = 2L * x2 + (long)(d2 > 15 ? 1 : 0);
                x1 = 2L * x1 + (long)(d1 > 15 ? 1 : 0);
                break;
            }
            case 45: {
                break;
            }
            case 50: {
                f *= 3L;
                break;
            }
            case 55: {
                f *= 6L;
                break;
            }
            case 60: {
                f *= 12L;
                break;
            }
            default: {
                System.out.println("zintck2: invalid intcode=" + intcode);
                return Double.NaN;
            }
        }
        if (f == 1L) {
            return x2 - x1;
        }
        if (s != 0L) {
            s = f - s;
        }
        x2 = ZxAxis.ldiv(x2 + s, f);
        x1 = ZxAxis.ldiv(x1 + s, f);
        return x2 - x1;
    }

    private static double daybase2(Interval istr, long x1, long x2, long f, long s) {
        int intcode = istr.intcode;
        if (intcode == 30) {
            f *= 7L;
            s -= 5L;
        } else if (intcode == 27) {
            return ZxAxis.weekday2(istr, x1, x2, f, s);
        }
        if (f == 1L) {
            return x2 - x1;
        }
        if (s != 0L) {
            s = f - s;
        }
        x2 = ZxAxis.ldiv(x2 + s, f);
        x1 = ZxAxis.ldiv(x1 + s, f);
        return x2 - x1;
    }

    private static double weekday2(Interval istr, long x1, long x2, long f, long s) {
        char nweekday = istr.nweekday;
        boolean[] weekend = istr.weekend;
        int dow1 = (int)ZxAxis.lmod(x1 + 5L, 7L);
        int dow2 = (int)ZxAxis.lmod(x2 + 5L, 7L);
        while (weekend[dow1]) {
            --x1;
            if (--dow1 >= 0) continue;
            dow1 = 6;
        }
        while (weekend[dow2]) {
            --x2;
            if (--dow2 >= 0) continue;
            dow2 = 6;
        }
        long j = ZxAxis.lmod(x1, 7L);
        x1 = ZxAxis.ldiv(x1, 7L) * (long)nweekday;
        int d = 6;
        while (j > 0L) {
            if (!weekend[d]) {
                ++x1;
            }
            if (++d > 6) {
                d = 0;
            }
            --j;
        }
        j = ZxAxis.lmod(x2, 7L);
        x2 = ZxAxis.ldiv(x2, 7L) * (long)nweekday;
        d = 6;
        while (j > 0L) {
            if (!weekend[d]) {
                ++x2;
            }
            if (++d > 6) {
                d = 0;
            }
            --j;
        }
        if (f == 1L) {
            return x2 - x1;
        }
        if (s != 0L) {
            s = f - s;
        }
        x1 = ZxAxis.ldiv(x1 + s, f);
        x2 = ZxAxis.ldiv(x2 + s, f);
        return x2 - x1;
    }

    static double timeck(Interval istr, double x1, double x2) {
        int k;
        if (istr.units != 's') {
            return Double.NaN;
        }
        long f = istr.intper;
        if (f < 1L) {
            f = 1L;
        }
        long s = istr.shiftper;
        switch (istr.intcode) {
            case 20: {
                k = 3600;
                f *= (long)k;
                break;
            }
            case 15: {
                k = 60;
                f *= (long)k;
                break;
            }
            case 10: {
                k = 1;
                break;
            }
            default: {
                System.out.println("zintck2: bad intcode=" + istr.intcode);
                return Double.NaN;
            }
        }
        if (f == 1L) {
            return x2 - x1;
        }
        if (s != 0L) {
            s = f - (long)k * s;
        }
        double ss = s;
        double ff = f;
        x2 = Math.floor((x2 + ss) / ff);
        x1 = Math.floor((x1 + ss) / ff);
        return x2 - x1;
    }

    private static int LEAPYEAR(int year) {
        int leapday;
        if (year % 4 == 0) {
            leapday = 1;
            if (year % 100 == 0) {
                leapday = year % 4000 == 0 ? 0 : (year % 400 == 0 ? 1 : 0);
            }
        } else {
            leapday = 0;
        }
        return leapday;
    }

    private static int NLEAP(int year) {
        int year1 = year - 1;
        int numleap = year1 / 100;
        numleap = year1 / 4 - numleap + numleap / 4 - year1 / 4000;
        return numleap;
    }

    private static double ziddmdy(int month, int day, int year) {
        if (year <= 99) {
            int startyr;
            int yc;
            year += yc - startyr + ((startyr = (yc = 1920) % 100) > year ? 1 : 0) * 100;
        }
        int leapday = ZxAxis.LEAPYEAR(year);
        int serial = dbm[month - 1];
        if (month > 2) {
            serial += leapday;
        }
        int numleap = ZxAxis.NLEAP(year);
        long sasdate = (long)year * 365L + (long)numleap + (long)serial + (long)day - 715875L;
        return sasdate;
    }

    private static int[] zidmdyd(double sasdate) {
        long idate = (long)sasdate;
        long baseyr0 = idate + 715875L;
        long invleap = baseyr0 / 1461L - baseyr0 / 36525L + baseyr0 / 146100L - baseyr0 / 1461000L + 1L;
        int year = (int)((baseyr0 - invleap) / 365L);
        int numleap = ZxAxis.NLEAP(year);
        int serial = (int)(idate - ((long)year * 365L - 715875L + (long)numleap));
        int leapday = ZxAxis.LEAPYEAR(year);
        int month = 1;
        int[] p = leapday == 1 ? dpml : dpm;
        int pi = 0;
        while (serial > p[pi]) {
            serial -= p[pi++];
            ++month;
        }
        int[] rc = new int[]{month, serial, year};
        return rc;
    }

    public static synchronized Interval ztaxis2(Interval data, Interval axis, int maxticks) {
        if (maxticks < 1) {
            return null;
        }
        Interval minor = null;
        boolean found = false;
        double d0 = ZxAxis.INTNX(axis, 0.0, 0.0);
        double d1 = ZxAxis.INTNX(axis, 0.0, 1.0);
        ArrayList intervals = ZxAxis.getMinorIntervals(axis, data);
        if (intervals == null || intervals.size() == 0) {
            if (axis.intper > 1) {
                minor = new Interval(axis);
                minor.intper = 1;
                minor.shiftper = 0;
                return minor;
            }
            return null;
        }
        if (axis.intcode == data.intcode) {
            if (axis.intper == data.intper) {
                return null;
            }
            minor = new Interval(data);
            MinorInterval intvl = (MinorInterval)intervals.get(0);
            while (true) {
                int n;
                if ((n = (int)ZxAxis.INTCK(minor, d0, d1) - 1) <= maxticks) {
                    if (n > 0) {
                        found = true;
                    }
                } else {
                    int p = minor.intper * ZxAxis.minfactor(n + 1);
                    if (p <= intvl.maxper) {
                        minor.intper = (short)p;
                        continue;
                    }
                }
                break;
            }
        } else {
            minor = new Interval();
            minor.units = axis.units;
            block1: for (int i = 0; i < intervals.size() && !found; ++i) {
                MinorInterval intvl = (MinorInterval)intervals.get(i);
                if (intvl.intcode < data.intcode) continue;
                minor.intcode = intvl.intcode;
                short s = minor.intper = intvl.intcode == data.intcode ? data.intper : (short)1;
                while (true) {
                    int n;
                    if ((n = (int)ZxAxis.INTCK(minor, d0, d1) - 1) <= maxticks) {
                        if (n <= 0) continue block1;
                        found = true;
                        continue block1;
                    }
                    int p = minor.intper * ZxAxis.minfactor(n + 1);
                    if (p > intvl.maxper) continue block1;
                    minor.intper = (short)p;
                }
            }
        }
        if (found) {
            return minor;
        }
        if (axis.intper > 1) {
            minor = new Interval(axis);
            minor.intper = 1;
            minor.shiftper = 0;
            return minor;
        }
        return null;
    }

    static ArrayList getMinorIntervals(Interval axis, Interval data) {
        int[] maxper;
        int[] intcode;
        ArrayList<MinorInterval> intervals = new ArrayList<MinorInterval>();
        switch (axis.intcode) {
            case 60: {
                if (axis.intper >= 2) {
                    intcode = new int[]{60};
                    maxper = new int[]{(int)((double)axis.intper / 2.0)};
                    break;
                }
                intcode = new int[]{40, 45, 50, 55};
                maxper = new int[]{1, 2, 2, 1};
                break;
            }
            case 55: {
                intcode = new int[]{45, 50};
                maxper = new int[]{2, 1};
                break;
            }
            case 50: {
                intcode = new int[]{45};
                maxper = new int[]{1};
                break;
            }
            case 45: {
                if (axis.intper >= 6) {
                    intcode = new int[]{45};
                    maxper = new int[]{(int)((double)axis.intper / 2.0)};
                    break;
                }
                if (axis.intper > 1) {
                    intcode = new int[]{40};
                    maxper = new int[]{1};
                    break;
                }
                intcode = new int[]{25, 35, 40};
                maxper = new int[]{1, 1, 1};
                break;
            }
            case 40: {
                intcode = new int[]{25};
                maxper = new int[]{1};
                break;
            }
            case 35: {
                intcode = new int[]{25};
                maxper = new int[]{5};
                break;
            }
            case 30: {
                intcode = new int[]{25};
                maxper = new int[]{1};
                break;
            }
            case 27: {
                if (axis.units != 's') {
                    return null;
                }
                intcode = new int[]{20};
                maxper = new int[]{12};
                break;
            }
            case 25: {
                if (axis.units != 's') {
                    return null;
                }
                intcode = new int[]{20};
                maxper = new int[]{12};
                break;
            }
            case 20: {
                intcode = new int[]{15};
                maxper = new int[]{30};
                break;
            }
            case 15: {
                intcode = new int[]{10};
                maxper = new int[]{30};
                break;
            }
            case 10: {
                return null;
            }
            default: {
                System.out.println("ztaxis2: invalid axis interval code");
                return null;
            }
        }
        for (int i = 0; i < intcode.length; ++i) {
            if (data.intcode == 27 && intcode[i] == 25) {
                intcode[i] = 27;
            }
            if (intcode[i] < data.intcode) continue;
            intervals.add(new MinorInterval(intcode[i], maxper[i]));
        }
        return intervals;
    }

    static int minfactor(int n) {
        for (int i = 0; i < 12; ++i) {
            int p = prime[i];
            if (n / p * p != n) continue;
            return p;
        }
        return n;
    }

    public static Object[] getClosestDates(double date, SASFormat format) {
        int startcode;
        if (format == null) {
            return new Object[]{new Double(date - 1.0), new Double(date + 1.0), null};
        }
        int[] intCodes = new int[]{10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60};
        Interval interval = new Interval();
        String fmtname = format.getName();
        fmtname = ZxAxis.getEnglishFormatName(fmtname);
        int endcode = 10;
        if (format.isDateFormat()) {
            interval.units = (char)100;
            startcode = 3;
        } else if (format.isTimeFormat() || format.isDateTimeFormat()) {
            interval.units = (char)115;
            if (fmtname.startsWith("DTYEAR")) {
                startcode = 10;
            } else if (fmtname.startsWith("DTSEMIYEAR")) {
                startcode = 9;
            } else if (fmtname.startsWith("DTYYQC")) {
                startcode = 8;
            } else if (fmtname.startsWith("DTMONYY")) {
                startcode = 7;
            } else if (fmtname.startsWith("DT")) {
                startcode = 3;
            } else {
                startcode = 0;
                endcode = 2;
            }
        } else {
            return new Object[]{new Double(date - 1.0), new Double(date + 1.0), null};
        }
        String dateStr = format.format((Object)new Double(date));
        double[] dates = new double[2];
        for (int i = startcode; i <= endcode; ++i) {
            interval.intcode = intCodes[i];
            dates[0] = ZxAxis.zintnx2(interval, date, -1.0);
            dates[1] = ZxAxis.zintnx2(interval, date, 1.0);
            if (!format.format((Object)new Double(dates[0])).equals(dateStr) && !format.format((Object)new Double(dates[1])).equals(dateStr)) break;
        }
        return new Object[]{new Double(dates[0]), new Double(dates[1]), interval};
    }

    public static boolean isValidDateTime(double[] values, SASFormat format) {
        block4: {
            block3: {
                if (values == null) {
                    return false;
                }
                if (format == null || !format.isDateFormat()) break block3;
                for (int i = 0; i < values.length; ++i) {
                    if (!(values[i] < -138061.0) && !(values[i] > 6589335.0)) continue;
                    return false;
                }
                break block4;
            }
            if (format == null || !format.isDateTimeFormat()) break block4;
            for (int i = 0; i < values.length; ++i) {
                if (!(values[i] / 86400.0 < -138061.0) && !(values[i] / 86400.0 > 6589335.0)) continue;
                return false;
            }
        }
        return true;
    }

    public static LogarithmTicks zlogaxis(double min, double max, double base, int maxTicks, double thresholdMin, double thresholdMax, boolean minorTicksOn, boolean uniformInterval) {
        return ZxAxis.zlogaxis(min, max, base, maxTicks, thresholdMin, thresholdMax, minorTicksOn, -1, uniformInterval);
    }

    public static LogarithmTicks zlogaxis(double min, double max, double base, int maxTicks, double thresholdMin, double thresholdMax, boolean minorTicksOn, int minorTickCount, boolean uniformInterval) {
        if (min <= 0.0 || max <= 0.0 || base <= 0.0) {
            return null;
        }
        if (max < min) {
            double temp = min;
            min = max;
            max = temp;
        }
        LogarithmTicks logObject = new LogarithmTicks();
        if (uniformInterval) {
            ZxAxis.zlogaxis_uniform(min, max, base, maxTicks, thresholdMin, thresholdMax, logObject);
        } else {
            ZxAxis.zlogaxis_log(min, max, base, maxTicks, thresholdMin, thresholdMax, logObject);
        }
        if (minorTicksOn && logObject.tickValues.length >= 2) {
            if (base == 10.0 && !uniformInterval) {
                ZxAxis.zlogaxis_minor_10(logObject, minorTickCount);
            } else if (uniformInterval) {
                ZxAxis.zlogaxis_minor_uniform(logObject, minorTickCount);
            }
        }
        return logObject;
    }

    private static void zlogaxis_log(double min, double max, double base, int maxTicks, double thresholdMin, double thresholdMax, LogarithmTicks logObject) {
        double logMin = Math.log(min) / Math.log(base);
        int nLo = (int)Math.floor(logMin);
        double logMax = Math.log(max) / Math.log(base);
        int nHi = (int)Math.ceil(logMax);
        int nTicks = nHi - nLo + 1;
        double interval = 1.0;
        int n = nTicks;
        if (maxTicks > 2 && nTicks > maxTicks) {
            interval = Math.ceil((double)(nTicks - 1) / (double)(maxTicks - 1));
            n = (int)Math.ceil((double)(nTicks - 1) / interval) + 1;
        }
        double[] logTicks = new double[n];
        logTicks[n - 1] = nHi;
        for (int i = n - 2; i >= 0; --i) {
            logTicks[i] = logTicks[i + 1] - interval;
        }
        int start = 0;
        int end = n - 1;
        if (n <= 2 || logMin - logTicks[0] <= thresholdMin * interval) {
            min = Math.pow(base, logTicks[0]);
            logMin = logTicks[0];
        } else {
            ++start;
        }
        if (n <= 2 || logTicks[n - 1] - logMax <= thresholdMax * interval) {
            max = Math.pow(base, logTicks[n - 1]);
            logMax = logTicks[n - 1];
        } else {
            --end;
        }
        if (start > 0 && end < n - 1 && end - start + 1 < 2) {
            if (logTicks[1] - logMin > logMax - logTicks[1]) {
                start = 0;
                min = Math.pow(base, logTicks[0]);
                logMin = logTicks[0];
            } else {
                end = n - 1;
                max = Math.pow(base, logTicks[n - 1]);
                logMax = logTicks[n - 1];
            }
        }
        boolean oneCycle = false;
        if (base == 10.0 && end - start + 1 == 2 && interval == 1.0) {
            oneCycle = true;
        }
        double[] majorTickValues = oneCycle ? new double[3] : new double[end - start + 1];
        double[] logTickValues = oneCycle ? new double[3] : new double[end - start + 1];
        for (int i = start; i <= end; ++i) {
            majorTickValues[i - start] = Math.pow(base, logTicks[i]);
            logTickValues[i - start] = logTicks[i];
        }
        if (oneCycle) {
            majorTickValues[2] = majorTickValues[1];
            logTickValues[2] = logTickValues[1];
            majorTickValues[1] = 5.0 * majorTickValues[0];
            logTickValues[1] = Math.log(majorTickValues[1]) / Math.log(base);
        }
        logObject.min = min;
        logObject.max = max;
        logObject.logMin = logMin;
        logObject.logMax = logMax;
        logObject.tickValues = majorTickValues;
        logObject.logTickValues = logTickValues;
    }

    private static void zlogaxis_uniform(double min, double max, double base, int maxTicks, double thresholdMin, double thresholdMax, LogarithmTicks logObject) {
        int i;
        double[] val = ZxAxis.znaxis(min, max, true, false, maxTicks + 1, 0.2, 0.8);
        int n = (int)val[2];
        double interval = val[1];
        double minTick = val[0];
        double maxTick = minTick + interval * (double)(n - 1);
        if (minTick == 0.0) {
            minTick = Math.pow(10.0, Math.floor(Math.log(min) / Math.log(10.0)));
        }
        double logMin = Math.log(min) / Math.log(base);
        double logMax = Math.log(max) / Math.log(base);
        double logMinTicks = Math.log(minTick) / Math.log(base);
        double logMaxTicks = Math.log(maxTick) / Math.log(base);
        double logMin2Ticks = Math.log(val[0] + interval) / Math.log(base);
        double logMax2Ticks = Math.log(maxTick - interval) / Math.log(base);
        if (n == 1) {
            logObject.min = min;
            logObject.max = max;
            logObject.logMin = logMin;
            logObject.logMax = logMax;
            logObject.tickValues = new double[]{minTick};
            return;
        }
        int start = 0;
        int end = n - 1;
        if (n <= 2 || logMin - logMinTicks < thresholdMin * (logMin2Ticks - logMinTicks)) {
            min = minTick;
            logMin = logMinTicks;
        } else {
            ++start;
        }
        if (n <= 2 || logMaxTicks - logMax < thresholdMax * (logMaxTicks - logMax2Ticks)) {
            max = maxTick;
            logMax = logMaxTicks;
        } else {
            --end;
        }
        if (start > 0 && end < n - 1 && end - start + 1 < 2) {
            if (logMin2Ticks - logMin > logMax - logMin2Ticks) {
                start = 0;
                min = minTick;
                logMin = logMinTicks;
            } else {
                end = n - 1;
                max = maxTick;
                logMax = logMaxTicks;
            }
        }
        boolean addTicks = false;
        double[] newTicks = null;
        double midTick = 0.0;
        double log2nd = Math.log(val[0] + interval) / Math.log(base);
        if (log2nd - logMin > 0.5 * (logMax - logMin)) {
            addTicks = true;
            double mid = Math.pow(base, (logMin + log2nd) * 0.5);
            midTick = Math.pow(10.0, Math.floor(Math.log(mid) / Math.log(10.0)));
            midTick *= (double)((int)(mid / midTick));
            n = 1;
            if (midTick / minTick >= 100.0) {
                ++n;
            }
            if ((val[0] + interval) / midTick >= 100.0) {
                ++n;
            }
            newTicks = new double[n];
            n = 0;
            if (midTick / minTick >= 100.0) {
                newTicks[n++] = minTick * 10.0;
            }
            newTicks[n++] = midTick;
            if ((val[0] + interval) / midTick >= 100.0) {
                newTicks[n++] = (val[0] + interval) / 10.0;
            }
        }
        int num = end - start + 1;
        if (addTicks) {
            num += newTicks.length;
        }
        double[] majorTickValues = new double[num];
        n = 0;
        if (addTicks) {
            if (start > 0) {
                for (i = 0; i < newTicks.length; ++i) {
                    majorTickValues[n++] = newTicks[i];
                }
                majorTickValues[n++] = val[0] + interval;
            } else {
                majorTickValues[n++] = minTick;
                for (i = 0; i < newTicks.length; ++i) {
                    majorTickValues[n++] = newTicks[i];
                }
                majorTickValues[n++] = val[0] + interval;
            }
        } else if (start > 0) {
            majorTickValues[n++] = val[0] + (double)start * interval;
        } else {
            majorTickValues[n++] = minTick;
            majorTickValues[n++] = val[0] + interval;
        }
        for (i = n; i < num; ++i) {
            majorTickValues[i] = majorTickValues[i - 1] + interval;
        }
        if (min > majorTickValues[0]) {
            min = majorTickValues[0];
            logMin = Math.log(min) / Math.log(base);
        }
        if (max < majorTickValues[majorTickValues.length - 1]) {
            max = majorTickValues[majorTickValues.length - 1];
            logMax = Math.log(max) / Math.log(base);
        }
        logObject.min = min;
        logObject.max = max;
        logObject.logMin = logMin;
        logObject.logMax = logMax;
        logObject.tickValues = majorTickValues;
    }

    public static void zlogaxis_minor_10(LogarithmTicks logObject, int minorTickCount) {
        int i;
        int j;
        int j2;
        int n;
        double intvl;
        if (minorTickCount >= 0) {
            ZxAxis.zlogaxis_user_minor_10(logObject, minorTickCount);
            return;
        }
        boolean oneCycle = false;
        if (logObject.logTickValues.length == 3 && logObject.logTickValues[2] - logObject.logTickValues[0] == 1.0) {
            oneCycle = true;
        }
        int nMinors = 8;
        if (oneCycle) {
            intvl = Math.round(logObject.logTickValues[2] - logObject.logTickValues[0]);
            n = (logObject.tickValues.length - 2) * nMinors;
        } else {
            intvl = Math.round(logObject.logTickValues[1] - logObject.logTickValues[0]);
            n = intvl == 1.0 ? (logObject.tickValues.length - 1) * nMinors : (logObject.tickValues.length - 1) * ((int)intvl - 1);
        }
        int nBefore = 0;
        if (intvl == 1.0) {
            for (j2 = nMinors; j2 >= 1 && logObject.tickValues[0] / 10.0 * (double)(j2 + 1) >= logObject.min; --j2) {
                ++nBefore;
            }
        } else {
            j2 = 1;
            while ((double)j2 < intvl && logObject.tickValues[0] / Math.pow(10.0, j2) >= logObject.min) {
                ++nBefore;
                ++j2;
            }
        }
        int nAfter = 0;
        if (intvl == 1.0) {
            for (j = 1; j <= nMinors && logObject.tickValues[logObject.tickValues.length - 1] * (double)(j + 1) <= logObject.max; ++j) {
                ++nAfter;
            }
        } else {
            j = 1;
            while ((double)j < intvl && logObject.tickValues[logObject.tickValues.length - 1] * Math.pow(10.0, j) <= logObject.max) {
                ++nAfter;
                ++j;
            }
        }
        double[] minorTickValues = new double[n + nBefore + nAfter];
        n = 0;
        for (i = 1; i <= nBefore; ++i) {
            minorTickValues[n++] = intvl == 1.0 ? logObject.tickValues[0] / 10.0 * (double)(nMinors - nBefore + i + 1) : logObject.tickValues[0] / Math.pow(10.0, nBefore - i + 1);
        }
        for (i = 0; i < logObject.tickValues.length - 1; ++i) {
            int j3;
            if (intvl == 1.0) {
                for (j3 = 1; j3 <= nMinors; ++j3) {
                    minorTickValues[n++] = logObject.tickValues[i] * (double)(j3 + 1);
                }
                if (!oneCycle) continue;
                break;
            }
            j3 = 1;
            while ((double)j3 < intvl) {
                minorTickValues[n++] = Math.pow(10.0, logObject.logTickValues[i] + (double)j3);
                ++j3;
            }
        }
        for (i = 1; i <= nAfter; ++i) {
            minorTickValues[n++] = intvl == 1.0 ? logObject.tickValues[logObject.tickValues.length - 1] * (double)(i + 1) : logObject.tickValues[logObject.tickValues.length - 1] * Math.pow(10.0, i);
        }
        logObject.minorTickValues = minorTickValues;
    }

    private static void zlogaxis_minor_uniform(LogarithmTicks logObject, int minorTickCount) {
        int nMinors = 1;
        int n = (logObject.tickValues.length - 1) * nMinors;
        double[] minorTickValues = new double[n];
        for (int i = 0; i < logObject.tickValues.length - 1; ++i) {
            minorTickValues[i] = (logObject.tickValues[i] + logObject.tickValues[i + 1]) * 0.5;
        }
        logObject.minorTickValues = minorTickValues;
    }

    public static void zlogaxis_user_minor_10(LogarithmTicks logObject, int minorTickCount) {
        int i;
        if (minorTickCount == 0) {
            return;
        }
        int nMinors = minorTickCount;
        double intvl = Math.round(logObject.logTickValues[1] - logObject.logTickValues[0]);
        double powIntvl = Math.pow(10.0, intvl);
        int n = (logObject.tickValues.length - 1) * nMinors;
        int nBefore = 0;
        double firstVal = logObject.tickValues[0];
        double firstMinorValueIntvl = (firstVal - firstVal / powIntvl) / (double)(minorTickCount + 1);
        for (int j = 1; j <= nMinors && firstVal - firstMinorValueIntvl * (double)j >= logObject.min; ++j) {
            ++nBefore;
        }
        int nAfter = 0;
        double lastVal = logObject.tickValues[logObject.tickValues.length - 1];
        double lastMinorValueIntvl = (lastVal * powIntvl - lastVal) / (double)(minorTickCount + 1);
        for (int j = 1; j <= nMinors && lastVal + lastMinorValueIntvl * (double)j <= logObject.max; ++j) {
            ++nAfter;
        }
        double[] minorTickValues = new double[n + nBefore + nAfter];
        n = 0;
        for (i = nBefore; i >= 1; --i) {
            minorTickValues[n++] = firstVal - (double)i * firstMinorValueIntvl;
        }
        for (i = 0; i < logObject.tickValues.length - 1; ++i) {
            double minorValueIntvl = (logObject.tickValues[i + 1] - logObject.tickValues[i]) / (double)(minorTickCount + 1);
            for (int j = 1; j <= nMinors; ++j) {
                minorTickValues[n++] = logObject.tickValues[i] + (double)j * minorValueIntvl;
            }
        }
        for (i = 1; i <= nAfter; ++i) {
            minorTickValues[n++] = lastVal + (double)i * lastMinorValueIntvl;
        }
        logObject.minorTickValues = minorTickValues;
    }

    public static boolean isValidDateTime(double d) {
        return d >= minDateTime && d < maxDateTime;
    }

    public static double ztimprt(double dt) {
        if (Double.isNaN(dt) || !ZxAxis.isValidDateTime(dt)) {
            return Double.NaN;
        }
        if (dt <= 0.0) {
            dt += -minDateTime;
        }
        return ZxAxis.lmod((int)dt, 86400L);
    }

    static {
        level = 0;
        dpm = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        dpml = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        dbm = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        prime = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37};
        minDateTime = -1.19284704E10;
        maxDateTime = 5.693186304E11;
    }

    private static class MinorInterval {
        int intcode;
        int maxper;

        MinorInterval(int intcode, int maxper) {
            this.intcode = intcode;
            this.maxper = maxper;
        }
    }

    public static class Interval {
        public char units;
        public int intcode;
        public short intper;
        public short shiftper;
        public char nweekday;
        public boolean[] weekend;
        public String token;

        public Interval() {
            ZxAxis.doIntInit();
            this.intper = 1;
            this.weekend = new boolean[7];
        }

        public Interval(Interval intvl) {
            this();
            this.units = intvl.units;
            this.intcode = intvl.intcode;
            this.intper = intvl.intper;
            this.shiftper = intvl.shiftper;
            this.nweekday = intvl.nweekday;
            this.token = intvl.token;
            for (int i = 0; i < this.weekend.length; ++i) {
                this.weekend[i] = intvl.weekend[i];
            }
        }

        public String toString() {
            String out = "{units:" + this.units + " intcode:" + lookup[this.intcode] + " intper:" + this.intper + " shiftper:" + this.shiftper + " token:" + this.token + "}";
            return out;
        }
    }

    private static class Table {
        short intcode;
        short maxper;
        short fmtw1;
        short fmtw2;
        String intname;
        String fmt;

        Table(int ic, int m, String in, String f, int w1, int w2) {
            this.intcode = (short)ic;
            this.maxper = (short)m;
            this.intname = in;
            this.fmt = f;
            this.fmtw1 = (short)w1;
            this.fmtw2 = (short)w2;
        }
    }

    public static class LogarithmTicks {
        public double[] tickValues;
        public double[] logTickValues;
        public double[] minorTickValues;
        public double min;
        public double max;
        public double logMin;
        public double logMax;
    }
}

