/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.DateFormatNameConversion;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;

public class SplitDateTime {
    private static String[] fmtnames = new String[]{"DAY     ", "WEEKDAY ", "DOWNAME ", "MONTH   ", "MONNAME ", "QTR     ", "QTRR    ", "NENGO   ", "DTSEMIYEAR", "DTYEAR  ", "YEAR    ", "JULDAY  ", "JULIAN  ", "DTWKDATX", "DTDATE", "DATE    ", "DDMMYY  ", "MMDDYY  ", "MMDDYYS ", "YYMMDD  ", "WEEKDATE", "WEEKDATX", "WORDDATE", "WORDDATX", "DTMONYY ", "MMYY    ", "MMYYC   ", "MMYYD   ", "MMYYP   ", "MMYYS   ", "MMYYN   ", "MONYY   ", "YYMM    ", "YYMMC   ", "YYMMD   ", "YYMMP   ", "YYMMS   ", "YYMMN   ", "YYMON   ", "DTYYQC  ", "YYQ     ", "YYQC    ", "YYQD    ", "YYQP    ", "YYQS    ", "YYQN    ", "YYQR    ", "YYQRC   ", "YYQRD   ", "YYQRP   ", "YYQRS   ", "YYQRN   ", "DATETIME", "DATEAMPM", "HHMM    ", "HOUR    ", "MMSS    ", "TIME    ", "TOD     ", "TIMEAMPM"};
    private static final int DAY_MONTH_YEAR = 13;
    private static final int MONTH_YEAR = 24;
    private static final int QTR_YEAR = 39;
    private static final int DATE_TIME = 52;
    private boolean timeToDate;
    private boolean dateTime;
    private boolean splittable;
    private SASFormat longTermFormat;
    private SASFormat shortTermFormat;
    private DateFormatNameConversion formatNameConvertor = null;

    public boolean isSplittable() {
        return this.splittable;
    }

    public String[] getLongTermLabels(double[] values) {
        if (this.longTermFormat == null) {
            return null;
        }
        int length = values.length;
        String[] labels = new String[length];
        for (int i = 0; i < length; ++i) {
            if (this.dateTime) {
                double sasDate = Math.floor(values[i] / 86400.0);
                labels[i] = this.longTermFormat.format((Object)new Double(sasDate)).trim();
                continue;
            }
            labels[i] = this.longTermFormat.format((Object)new Double(values[i])).trim();
        }
        return labels;
    }

    public String[] getShortTermLabels(double[] values) {
        if (this.shortTermFormat == null) {
            return null;
        }
        int length = values.length;
        String[] labels = new String[length];
        for (int i = 0; i < length; ++i) {
            if (this.dateTime) {
                double sasValue;
                if (this.timeToDate) {
                    sasValue = Math.floor(values[i] / 86400.0);
                } else {
                    sasValue = values[i] % 86400.0;
                    if (sasValue < 0.0) {
                        sasValue += 86400.0;
                    }
                }
                labels[i] = this.shortTermFormat.format((Object)new Double(sasValue)).trim();
                continue;
            }
            labels[i] = this.shortTermFormat.format((Object)new Double(values[i])).trim();
        }
        return labels;
    }

    public void splitDateTimeFormat(SASFormat format) {
        if (format == null || !(format instanceof SASDateTimeFormat)) {
            this.splittable = false;
            return;
        }
        this.splittable = true;
        String fmtnm = format.getName();
        int e = -1;
        for (int c = 0; c < fmtnm.length(); ++c) {
            if (Character.isLetter(fmtnm.charAt(c))) continue;
            e = c;
            break;
        }
        if (e != -1) {
            fmtnm = fmtnm.substring(0, e);
        }
        int length = 0;
        if (e != -1) {
            try {
                length = Integer.parseInt(format.getName().substring(e));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.formatNameConvertor = DateFormatNameConversion.newDataFormatNameConversion(fmtnm.toUpperCase());
        String fmtnm_en = this.formatNameConvertor.getEnglishFormatName();
        if (!fmtnm_en.equalsIgnoreCase(fmtnm)) {
            this.splittable = false;
            return;
        }
        this.timeToDate = false;
        this.dateTime = false;
        int i = -1;
        for (int s = 0; s < fmtnames.length; ++s) {
            if (!fmtnm.trim().equalsIgnoreCase(fmtnames[s].trim())) continue;
            i = s;
            if (!fmtnm.substring(0, 2).equalsIgnoreCase("DT")) break;
            this.dateTime = true;
            this.timeToDate = true;
            break;
        }
        if (i < 13) {
            this.splittable = false;
        } else if (i < 24) {
            if (fmtnm.equalsIgnoreCase("DATE")) {
                if (length == 5 || length == 6) {
                    this.longTermFormat = SASFormat.getInstance((String)"MONNAME3");
                    this.shortTermFormat = SASFormat.getInstance((String)"DAY2");
                } else if (length == 7 || length == 8) {
                    this.longTermFormat = SASFormat.getInstance((String)"MONYY5");
                    this.shortTermFormat = SASFormat.getInstance((String)"DAY2");
                } else if (length == 9) {
                    this.longTermFormat = SASFormat.getInstance((String)"YEAR4");
                    this.shortTermFormat = SASFormat.getInstance((String)"DATE5");
                }
            } else if (fmtnm.equalsIgnoreCase("WEEKDATE")) {
                if (length <= 14) {
                    this.splittable = false;
                } else if (length == 15 && length == 17) {
                    this.longTermFormat = SASFormat.getInstance((String)"DATE5");
                    this.shortTermFormat = SASFormat.getInstance((String)"WEEKDATE3");
                } else if (length == 16) {
                    this.longTermFormat = SASFormat.getInstance((String)"DATE7");
                    this.shortTermFormat = SASFormat.getInstance((String)"WEEKDATE3");
                } else if (length >= 18 && length <= 22) {
                    this.longTermFormat = SASFormat.getInstance((String)"WORDDATE12");
                    this.shortTermFormat = SASFormat.getInstance((String)"WEEKDATE3");
                } else if (length >= 23 && length <= 24) {
                    this.longTermFormat = SASFormat.getInstance((String)"DATE5");
                    this.shortTermFormat = SASFormat.getInstance((String)"WEEKDATE9");
                } else if (length == 25) {
                    this.longTermFormat = SASFormat.getInstance((String)"DATE7");
                    this.shortTermFormat = SASFormat.getInstance((String)"WEEKDATE9");
                } else if (length == 26) {
                    this.longTermFormat = SASFormat.getInstance((String)"WORDDATE12");
                    this.shortTermFormat = SASFormat.getInstance((String)"WEEKDATE9");
                } else if (length >= 27 && length <= 37) {
                    this.longTermFormat = SASFormat.getInstance((String)"WORDDATE32");
                    this.shortTermFormat = SASFormat.getInstance((String)"WEEKDATE9");
                }
            } else if (fmtnm.equalsIgnoreCase("WORDDATE")) {
                if (length <= 3) {
                    this.splittable = false;
                } else if (length >= 4 && length <= 8) {
                    this.longTermFormat = SASFormat.getInstance((String)"MONNAME3");
                    this.shortTermFormat = SASFormat.getInstance((String)"DAY2");
                } else if (length >= 9 && length <= 11) {
                    this.splittable = false;
                } else if (length >= 12 && length <= 17) {
                    this.longTermFormat = SASFormat.getInstance((String)"YEAR4");
                    this.shortTermFormat = SASFormat.getInstance((String)"DATE5");
                } else if (length == 18) {
                    this.longTermFormat = SASFormat.getInstance((String)"MONNAME9");
                    this.shortTermFormat = SASFormat.getInstance((String)"DAY2");
                } else if (length >= 19 && length <= 32) {
                    this.longTermFormat = SASFormat.getInstance((String)"YEAR4");
                    this.shortTermFormat = SASFormat.getInstance((String)"DATE5");
                }
            } else {
                this.longTermFormat = SASFormat.getInstance((String)"YEAR4");
                this.shortTermFormat = SASFormat.getInstance((String)"DATE5");
            }
        } else if (i < 39) {
            this.longTermFormat = SASFormat.getInstance((String)"YEAR4");
            this.shortTermFormat = SASFormat.getInstance((String)"MONNAME3");
        } else if (i < 52) {
            if (fmtnm.toUpperCase().indexOf("QR") >= 0) {
                if (length == 6 || length == 7) {
                    this.longTermFormat = SASFormat.getInstance((String)"YEAR2");
                    this.shortTermFormat = SASFormat.getInstance((String)"QTRR3");
                } else {
                    this.longTermFormat = SASFormat.getInstance((String)"YEAR4");
                    this.shortTermFormat = SASFormat.getInstance((String)"QTRR3");
                }
            } else if (length == 4 || length == 5) {
                this.longTermFormat = SASFormat.getInstance((String)"YEAR2");
                this.shortTermFormat = SASFormat.getInstance((String)"QTR1");
            } else {
                this.longTermFormat = SASFormat.getInstance((String)"YEAR4");
                this.shortTermFormat = SASFormat.getInstance((String)"QTR1");
            }
        } else if (i == 52) {
            this.dateTime = true;
            if (length == 7) {
                this.longTermFormat = SASFormat.getInstance((String)"MONNAME3");
                this.shortTermFormat = SASFormat.getInstance((String)"DAY2");
            } else if (length == 8) {
                this.longTermFormat = SASFormat.getInstance((String)"MONYY5");
                this.shortTermFormat = SASFormat.getInstance((String)"DAY2");
            } else if (length == 9) {
                this.longTermFormat = SASFormat.getInstance((String)"YEAR4");
                this.shortTermFormat = SASFormat.getInstance((String)"DATE5");
            } else {
                this.longTermFormat = SASFormat.getInstance((String)"DATE7");
                this.shortTermFormat = SASFormat.getInstance((String)"TIME8");
            }
        } else {
            this.splittable = false;
        }
    }

    private SASFormat getNLSFormat(SASFormat format) throws IllegalArgumentException {
        String fmtnm = format.getName();
        int e = -1;
        for (int c = 0; c < fmtnm.length(); ++c) {
            if (Character.isLetter(fmtnm.charAt(c))) continue;
            e = c;
            break;
        }
        if (e != -1) {
            fmtnm = fmtnm.substring(0, e);
        }
        fmtnm = this.formatNameConvertor.convertEnglishFormatName(fmtnm.toUpperCase());
        return SASFormat.getInstance((String)fmtnm);
    }
}

