/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.Arrays;

public class ShadowRenderer {
    public static final int TYPE_BOX_BLUR = 0;
    public static final int TYPE_GAUSSIAN_BLUR = 1;
    private int type = 0;
    private int size = 5;
    private float opacity = 0.2f;
    private Color color = Color.BLACK;

    public ShadowRenderer() {
    }

    public ShadowRenderer(int size, float opacity, Color color, int type) {
        this();
        this.setSize(size);
        this.setOpacity(opacity);
        this.setColor(color);
        this.setType(type);
    }

    public void setSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Size must be >= 1");
        }
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setOpacity(float opacity) {
        if (opacity < 0.0f) {
            opacity = 0.0f;
        } else if (opacity > 1.0f) {
            opacity = 1.0f;
        }
        this.opacity = opacity;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.color = color;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setType(int shadowType) {
        switch (shadowType) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Shadow type not supported");
            }
        }
        this.type = shadowType;
    }

    public int getType() {
        return this.type;
    }

    public BufferedImage createShadow(BufferedImage srcImage) {
        return ShadowRenderer.createShadow(srcImage, this.size, this.opacity, this.color, this.type);
    }

    public static BufferedImage createShadow(BufferedImage srcImage, int shadowSize, float shadowOpacity, Color shadowColor, int shadowType) {
        if (srcImage == null) {
            return null;
        }
        int width = srcImage.getWidth() + 4 * shadowSize;
        int height = srcImage.getHeight() + 4 * shadowSize;
        BufferedImage monochromeImage = new BufferedImage(width, height, 3);
        Graphics2D monochromeGraphics = monochromeImage.createGraphics();
        monochromeGraphics.drawImage((Image)srcImage, 2 * shadowSize, 2 * shadowSize, null);
        monochromeGraphics.setComposite(AlphaComposite.getInstance(5, shadowOpacity));
        monochromeGraphics.setColor(shadowColor);
        monochromeGraphics.fillRect(0, 0, width, height);
        monochromeGraphics.dispose();
        BufferedImage shadowImage = ShadowRenderer.createBlurImage(monochromeImage, shadowSize, shadowType);
        BufferedImage retImage = new BufferedImage(srcImage.getWidth() + shadowSize * 2, srcImage.getHeight() + shadowSize * 2, 2);
        Graphics2D retGraphics = retImage.createGraphics();
        retGraphics.drawImage((Image)shadowImage, -shadowSize, -shadowSize, null);
        retGraphics.dispose();
        return retImage;
    }

    private static ConvolveOp getBoxBlurFilter(int radius, boolean horizontal) {
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int kernelSize = radius * 2 + 1;
        float blurFactor = 1.0f / (float)kernelSize;
        float[] kernelData = new float[kernelSize];
        Arrays.fill(kernelData, blurFactor);
        Kernel kernel = null;
        kernel = horizontal ? new Kernel(kernelSize, 1, kernelData) : new Kernel(1, kernelSize, kernelData);
        return new ConvolveOp(kernel, 1, null);
    }

    private static ConvolveOp getGausianBlurFilter(int radius, boolean horizontal) {
        int i;
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int kernelSize = radius * 2 + 1;
        float[] kernelData = new float[kernelSize];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        for (i = -radius; i <= radius; ++i) {
            float distance = i * i;
            int index = i + radius;
            kernelData[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += kernelData[index];
        }
        i = 0;
        while (i < kernelData.length) {
            int n = i++;
            kernelData[n] = kernelData[n] / total;
        }
        Kernel kernel = null;
        kernel = horizontal ? new Kernel(kernelSize, 1, kernelData) : new Kernel(1, kernelSize, kernelData);
        return new ConvolveOp(kernel, 1, null);
    }

    private static BufferedImage createBlurImage(BufferedImage srcImage, int radius, int shadowType) {
        if (srcImage == null) {
            throw new IllegalArgumentException("SrcImage must be non null");
        }
        BufferedImage blurImage = null;
        switch (shadowType) {
            case 0: {
                blurImage = ShadowRenderer.getBoxBlurFilter(radius, true).filter(srcImage, null);
                blurImage = ShadowRenderer.getBoxBlurFilter(radius, false).filter(blurImage, null);
                break;
            }
            case 1: {
                blurImage = ShadowRenderer.getGausianBlurFilter(radius, true).filter(srcImage, null);
                blurImage = ShadowRenderer.getGausianBlurFilter(radius, false).filter(blurImage, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Shadow type not supported");
            }
        }
        return blurImage;
    }
}

