/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import java.awt.BasicStroke;

public final class SASLinePatterns {
    private static final int[][] linePatterns = new int[][]{{1, 0}, {1, 65535}, {1, 3855}, {1, 14823}, {1, 4095}, {2, 8191}, {2, Short.MAX_VALUE}, {3, Short.MAX_VALUE}, {2, 6399}, {1, 16371}, {2, 32765}, {3, 32765}, {1, 16335}, {2, 32763}, {2, 10143}, {2, 4383}, {2, 32757}, {3, 32757}, {1, 15591}, {2, 32731}, {1, 511}, {2, 32639}, {2, Short.MAX_VALUE}, {3, Short.MAX_VALUE}, {4, Short.MAX_VALUE}, {2, 31611}, {3, 6399}, {2, 32763}, {3, 32763}, {1, 15591}, {2, 32631}, {3, 32631}, {4, 32631}, {1, 21845}, {1, 4369}, {1, 257}, {1, 1285}, {1, 5397}, {1, 9509}, {1, 1045}, {1, 2581}, {1, 3135}, {2, 9471}, {2, 9375}, {1, 31477}, {1, 30165}, {1, 27349}};
    private static final int NUM_PATTERNS = 47;

    public static int getStippleFactor(int style) {
        int result = -1;
        if (style >= 0 && style <= 47) {
            result = linePatterns[style][0];
        }
        return result;
    }

    public static int getStipplePattern(int style) {
        int result = -1;
        if (style >= 0 && style <= 47) {
            result = linePatterns[style][1];
        }
        return result;
    }

    public static int getPatternCount() {
        return 47;
    }

    public static BasicStroke getStroke(int pattern, int thickness) {
        if (pattern == 0 || pattern == 1) {
            return new BasicStroke(thickness);
        }
        return SASLinePatterns.getStroke(thickness, SASLinePatterns.getStipplePattern(pattern), SASLinePatterns.getStippleFactor(pattern));
    }

    public static BasicStroke getStroke(int lineWidth, int mask, int factor) {
        float[] dashArray;
        int[] dashes = new int[16];
        int index = 0;
        int scanner = 32768;
        while (scanner > 0) {
            int bitcount = 0;
            while ((scanner & mask) != 0 && scanner > 0) {
                ++bitcount;
                scanner >>= 1;
            }
            if (bitcount > 0) {
                dashes[index++] = factor * bitcount;
            }
            bitcount = 0;
            while ((scanner & mask) == 0 && scanner > 0) {
                ++bitcount;
                scanner >>= 1;
            }
            if (bitcount <= 0) continue;
            dashes[index++] = -factor * bitcount;
        }
        int[] pattern = new int[index--];
        int i = 0;
        while (index >= 0) {
            pattern[i] = dashes[index];
            ++i;
            --index;
        }
        int stippleIndex = 0;
        float dashPhase = 0.0f;
        float lw = lineWidth;
        if (pattern[0] < 0 && pattern[pattern.length - 1] > 0) {
            ++stippleIndex;
            dashPhase = pattern[1];
            dashArray = new float[pattern.length];
            dashArray[pattern.length - 1] = Math.abs(pattern[0]);
        } else if (pattern[0] < 0 && pattern[pattern.length - 1] < 0) {
            int n = pattern.length - 1;
            pattern[n] = pattern[n] + pattern[0];
            int[] newpattern = new int[pattern.length - 1];
            System.arraycopy(pattern, 1, newpattern, 0, pattern.length - 1);
            pattern = newpattern;
            dashArray = new float[pattern.length];
        } else {
            dashArray = new float[pattern.length];
        }
        int dashIndex = 0;
        while (stippleIndex < pattern.length) {
            dashArray[dashIndex] = Math.abs(pattern[stippleIndex]);
            ++stippleIndex;
            ++dashIndex;
        }
        BasicStroke bs = new BasicStroke(lw, 1, 1, Math.max(lineWidth, 1), dashArray, dashPhase);
        return bs;
    }
}

