/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.text.SASFormat;
import java.util.ArrayList;
import java.util.Locale;

public class NumericFormat {
    public static final int MAGNITUDE_BY_INTERVAL = 1;
    public static final int MAGNITUDE_BY_RANGE = 2;
    private static final int MACTENBIG = 308;
    private static final int MACTENSMALL = -308;
    private static final int DEFAULT_MAX_LENGTH = 12;
    public static final int MAX_FORMAT_WIDTH = 8;
    public static final int MAX_NUM_DECIMALS = 6;
    public static final int HINT_NUM_DECIMALS = 2;
    public static final double ZERO_VALUE = 1.0E-6;
    private static int defaultPrecision = 6;

    public static String getFormatName(double[] values, int maxLength, boolean percent) {
        return NumericFormat.getFormatName(values, 2, maxLength, percent);
    }

    public static String getFormatName(double[] values, int magnitudeBy, int maxLength, boolean percent) {
        String formatName;
        int refmt;
        int ndec;
        int formatWidth;
        double max;
        int i;
        double interval;
        if (values == null || values.length == 0) {
            return "BEST";
        }
        if (maxLength <= 0) {
            maxLength = 12;
        }
        double[] sorted = magnitudeBy == 1 ? NumericFormat.getSortedValues(values) : values;
        int num = sorted.length;
        double dmin = Double.MAX_VALUE;
        double dmax = -1.7976931348623157E308;
        if (magnitudeBy == 1) {
            if (num == 0) {
                return "BEST";
            }
            if (num == 1) {
                dmin = sorted[0];
                dmax = sorted[0];
                interval = Math.abs(dmin);
            } else {
                dmin = sorted[0];
                dmax = sorted[num - 1];
                interval = Double.MAX_VALUE;
                for (i = 0; i < num - 1; ++i) {
                    double diff = sorted[i + 1] - sorted[i];
                    if (!(diff < interval)) continue;
                    interval = diff;
                }
            }
        } else {
            for (i = 0; i < num; ++i) {
                if (Double.isNaN(sorted[i])) continue;
                if (sorted[i] > dmax) {
                    dmax = sorted[i];
                }
                if (!(sorted[i] < dmin)) continue;
                dmin = sorted[i];
            }
            if (dmin == Double.MAX_VALUE) {
                return "BEST";
            }
            interval = dmin == dmax ? Math.abs(dmin) : dmax - dmin;
        }
        int sign = dmin < 0.0 ? 1 : 0;
        int magnitude = 0;
        if (interval != 0.0) {
            double diff = interval;
            if (diff < 1.0) {
                while (diff < 0.99999) {
                    diff *= 10.0;
                    --magnitude;
                }
            } else {
                while (diff > 9.99999) {
                    diff /= 10.0;
                    ++magnitude;
                }
            }
        } else {
            magnitude = 2;
        }
        int lead = (max = Math.max(Math.abs(dmin), Math.abs(dmax))) == 0.0 ? 1 : (int)(Math.floor(Math.log(Math.abs(max)) / Math.log(10.0)) + 1.0);
        int tmp = lead - 1;
        double pow10 = Math.pow(10.0, tmp = Math.min(308, Math.max(-308, tmp)));
        if (pow10 < Math.abs(max)) {
            ++lead;
        }
        if (magnitude > 1) {
            formatWidth = Math.max(1, lead) + sign;
            ndec = 0;
            refmt = 0;
        } else {
            int magnitudeAdj = magnitude <= 0 ? -magnitude + 1 : magnitude;
            formatWidth = magnitudeAdj + sign + Math.max(1, lead) + 2;
            ndec = magnitudeAdj + 1;
            int n = refmt = ndec > 1 ? 2 : 1;
        }
        if (refmt > 0) {
            formatName = Integer.toString(formatWidth) + "." + Integer.toString(ndec);
            refmt = NumericFormat.getAdjustedFactor(sorted, formatName, formatWidth, refmt);
            formatWidth -= refmt;
            ndec -= refmt;
        }
        if (formatWidth > maxLength && !percent && lead * magnitude >= 0) {
            formatWidth = maxLength;
            formatWidth = Math.max(formatWidth, 7 + sign);
            ndec = -2;
            formatName = "E" + Integer.toString(formatWidth) + ".2";
        } else if (percent) {
            switch (ndec) {
                case 0: {
                    formatWidth += 5;
                    break;
                }
                case 1: 
                case 2: {
                    formatWidth += 3;
                    ndec = 0;
                    break;
                }
                default: {
                    formatWidth += 3;
                    ndec -= 2;
                }
            }
            formatName = "Percent" + Integer.toString(formatWidth) + "." + Integer.toString(ndec);
        } else {
            formatName = Integer.toString(formatWidth) + "." + Integer.toString(ndec);
        }
        return formatName;
    }

    private static double[] getSortedValues(double[] raw) {
        ArrayList<Double> values = new ArrayList<Double>();
        int n = 0;
        for (int j = 0; j < raw.length; ++j) {
            double v = raw[j];
            if (Double.isNaN(v)) continue;
            if (n == 0) {
                values.add(new Double(v));
            } else {
                double mid_v;
                int left = 0;
                int right = n - 1;
                do {
                    int i;
                    if (v < (mid_v = ((Number)values.get(i = (left + right) / 2)).doubleValue())) {
                        right = i - 1;
                        continue;
                    }
                    left = i + 1;
                } while (v != mid_v && left <= right);
                if (v != mid_v) {
                    int index = Math.max(left, right);
                    values.add(index, new Double(v));
                }
            }
            ++n;
        }
        int num = values.size();
        double[] sort = new double[num];
        for (int i = 0; i < num; ++i) {
            sort[i] = (Double)values.get(i);
        }
        return sort;
    }

    static int getAdjustedFactor(double[] values, String fname, int fw, int refmt) {
        SASFormat format = SASFormat.getInstance((String)fname);
        int num = values.length;
        for (int i = 0; i < num; ++i) {
            int idx;
            if (Double.isNaN(values[i])) continue;
            String fmtValues = format.format((Object)new Double(values[i]));
            if (refmt > 1 && !fmtValues.substring(idx = fw - 2, idx + 1).equals("0")) {
                refmt = 1;
            }
            if (refmt == 0 || fmtValues.substring(idx = fw - 1).equals("0")) continue;
            refmt = 0;
        }
        return refmt;
    }

    public static Object[] getGGoodFormat(SASFormat formatIn, double minIn, double maxIn, double incIn) {
        if (NumericFormat.isNamedFormat(formatIn)) {
            return new Object[]{formatIn, new Integer(0)};
        }
        return NumericFormat.getGGoodFormat(minIn, maxIn, incIn, -1, -1, -1, false);
    }

    public static Object[] getGGoodFormat(SASFormat formatIn, double minIn, double maxIn, double incIn, int maxwIn, int maxdecIn, int okdecIn, boolean scale) {
        if (NumericFormat.isNamedFormat(formatIn)) {
            return new Object[]{formatIn, new Integer(0)};
        }
        return NumericFormat.getGGoodFormat(minIn, maxIn, incIn, maxwIn, maxdecIn, okdecIn, scale);
    }

    public static Object[] getGGoodFormat(double minIn, double maxIn, double incIn) {
        return NumericFormat.getGGoodFormat(minIn, maxIn, incIn, -1, -1, -1, false);
    }

    public static Object[] getGGoodFormat(double minIn, double maxIn, double incIn, int maxwIn, int maxdecIn, int okdecIn, boolean scale) {
        return NumericFormat.getGGoodFormat(minIn, maxIn, incIn, maxwIn, maxdecIn, okdecIn, scale, false);
    }

    public static Object[] getGGoodFormat(double minIn, double maxIn, double incIn, int maxwIn, int maxdecIn, int okdecIn, boolean scale, boolean scaleBy3) {
        if (Double.isNaN(minIn) || Double.isNaN(maxIn) || Double.isNaN(incIn)) {
            return null;
        }
        double[] niceV = NumericFormat.processValues(minIn, maxIn, incIn);
        minIn = niceV[0];
        maxIn = niceV[1];
        incIn = niceV[2];
        if (maxwIn < 0) {
            maxwIn = 8;
        }
        if (maxdecIn < 0) {
            maxdecIn = 6;
        }
        if (okdecIn < 0) {
            okdecIn = 2;
        }
        double min = minIn;
        double max = maxIn;
        double inc = incIn;
        double scaleSmall = scaleBy3 ? 9.99999E-6 : 9.99E-4;
        double scaleBig = scaleBy3 ? 999999.999999 : 9999.999999;
        double nbig = -(Math.pow(10.0, maxwIn - 2) - 1.0);
        double pbig = Math.pow(10.0, maxwIn - 1) - 1.0;
        double threshold = 0.0;
        SASFormat bestFormat = SASFormat.getInstance((String)"BEST", (int)Math.max(maxwIn, 1), (Locale)Locale.US);
        SASFormat expFormat = SASFormat.getInstance((String)"E", (int)Math.max(maxwIn, 7), (Locale)Locale.US);
        int z = 0;
        String f = " ";
        if (scale && maxdecIn > 0) {
            double lastTick;
            double firstTick = min != 0.0 ? min : min + inc;
            double d = lastTick = max != 0.0 ? max : max - inc;
            double m = scaleBy3 ? (Math.abs(firstTick) < 1.0 || Math.abs(lastTick) < 1.0 ? Math.min(Math.abs(firstTick), Math.abs(lastTick)) : Math.max(Math.abs(firstTick), Math.abs(lastTick))) : Math.max(Math.abs(min), Math.abs(max));
            z = inc == 0.0 ? (int)Math.floor(Math.log(m) / Math.log(10.0)) : (int)Math.floor(Math.log(m) / Math.log(10.0) - 1.0E-6);
            if (Math.abs(min) > scaleBig || Math.abs(max) > scaleBig) {
                if (z > 300) {
                    f = "E";
                }
            } else if (m > 0.0 && m < scaleSmall) {
                if (z < -300) {
                    f = "E";
                }
            } else {
                z = 0;
            }
            if (z != 0) {
                double l = Math.pow(10.0, -z);
                min *= l;
                max *= l;
                inc *= l;
            }
        }
        if (scale) {
            int r;
            while (maxdecIn == 0 && (Math.abs(min - Math.floor(min)) > 1.0E-6 * inc && Math.abs(min - Math.ceil(min)) > 1.0E-6 * inc || Math.abs(max - Math.floor(max)) > 1.0E-6 * inc && Math.abs(max - Math.ceil(max)) > 1.0E-6 * inc)) {
                min *= 10.0;
                max *= 10.0;
                inc *= 10.0;
                --z;
            }
            int n = Math.min(bestFormat.format((Object)new Double(inc)).trim().length(), 3);
            for (int i = 1; i <= n && maxdecIn == 0 && Math.abs(inc - Math.floor(inc)) > 1.0E-6 * inc && Math.abs(inc - Math.ceil(inc)) > 1.0E-6 * inc; ++i) {
                min *= 10.0;
                max *= 10.0;
                inc *= 10.0;
                --z;
            }
            if (scaleBy3 && z >= -12 && z < 15 && (r = z % 3) != 0) {
                int p = z > 0 ? r : 3 + r;
                z -= p;
                double l = Math.pow(10.0, p);
                min *= l;
                max *= l;
                inc *= l;
            }
        }
        String s = NumericFormat.getString(min, bestFormat, expFormat, threshold);
        String t = NumericFormat.getString(max, bestFormat, expFormat, threshold);
        if (maxdecIn == 0 && scale && (s.indexOf(69) >= 0 || t.indexOf(69) >= 0)) {
            while (Math.abs(min - Math.floor(min)) <= 1.0E-6 * inc && Math.abs(max - Math.floor(max)) <= 1.0E-6 * inc && Math.abs(inc - Math.floor(inc)) <= 1.0E-6 * inc && (min < nbig || max < nbig || min > pbig || max > pbig)) {
                min *= 0.1;
                max *= 0.1;
                inc *= 0.1;
                ++z;
            }
            s = NumericFormat.getString(min, bestFormat, expFormat, threshold);
            t = NumericFormat.getString(max, bestFormat, expFormat, threshold);
        }
        int w = 0;
        int d = 0;
        if (f.equalsIgnoreCase("E") || s.indexOf(69) >= 0 || t.indexOf(69) >= 0 || inc < threshold) {
            f = "E";
            min = minIn;
            max = maxIn;
            inc = incIn;
            z = 0;
            for (double v = min; v <= max; v += inc) {
                double x = v;
                if (Math.abs(x) < 1.0E-6 * inc) {
                    x = 0.0;
                }
                s = expFormat.format((Object)new Double(x));
                int k = s.indexOf(".0");
                int p = 0;
                if (k >= 0) {
                    t = s.substring(k);
                    if ((k = t.indexOf(69)) >= 0) {
                        t = t.substring(0, k);
                    }
                    if (!t.equals(" ") && t.replace('0', ' ').trim().equals(".")) {
                        p = t.length();
                    }
                }
                w = Math.max(w, s.length() - p);
                w = Math.max(w, 7);
                if (inc != 0.0 && v != v + inc) {
                    continue;
                }
                break;
            }
        } else {
            double x;
            int dmax = 0;
            if (maxdecIn > 0) {
                dmax = okdecIn;
                double[] val = new double[]{inc, min, max};
                int dmax2 = 0;
                for (int i = 0; i < val.length; ++i) {
                    s = NumericFormat.getString(val[i], bestFormat, expFormat, threshold);
                    if (s.indexOf(69) >= 0) continue;
                    int l = s.length();
                    int k = s.indexOf(46);
                    if (k < 0) continue;
                    dmax2 = (k = l - (k + 1)) <= (int)((double)(maxdecIn + okdecIn) / 2.0) ? Math.max(dmax2, k) : Math.max(dmax2, dmax);
                }
                dmax = dmax2;
                boolean done = false;
                while (!done) {
                    double v;
                    String fnm = Integer.toString(maxwIn).trim() + "." + Integer.toString(dmax).trim();
                    SASFormat fmt = SASFormat.getInstance((String)fnm, (Locale)Locale.US);
                    if (fmt == null) {
                        dmax = maxdecIn;
                        break;
                    }
                    for (v = min; v <= max - inc + 1.0E-6 * inc; v += inc) {
                        double x2 = v;
                        if (Math.abs(x2) < 1.0E-6 * inc) {
                            x2 = 0.0;
                        }
                        s = fmt.format((Object)new Double(x2));
                        if (Math.abs(x2 += inc) < 1.0E-6 * inc) {
                            x2 = 0.0;
                        }
                        if (s.equals(t = fmt.format((Object)new Double(x2))) && inc != 0.0) {
                            if ((dmax = Math.min(dmax + 1, maxdecIn)) < maxdecIn) {
                                done = false;
                                break;
                            }
                        } else {
                            done = true;
                        }
                        if (inc == 0.0 || v == v + inc) break;
                    }
                    if (!(v + inc >= max)) continue;
                    done = true;
                }
            }
            int p = 0;
            for (double v = min; v <= max + 1.0E-6 * inc; v += inc) {
                x = v;
                if (Math.abs(x) < 1.0E-6 * inc) {
                    x = 0.0;
                }
                if ((s = NumericFormat.getString(x, bestFormat, expFormat, threshold)).indexOf(69) < 0) {
                    int l = s.length();
                    int k = s.indexOf(46);
                    if (k >= 0) {
                        p = 1;
                        w = Math.max(w, k);
                        d = Math.min(Math.max(d, l - (k + 1)), dmax);
                    } else {
                        w = Math.max(w, l);
                    }
                }
                if (inc == 0.0 || v == v + inc) break;
            }
            w = w + d + p;
            boolean done = false;
            if (maxdecIn > 0) {
                while (!done) {
                    double v;
                    String fnm = f + Integer.toString(w).trim() + "." + Integer.toString(d).trim();
                    SASFormat fmt = SASFormat.getInstance((String)fnm, (Locale)Locale.US);
                    if (fmt == null) {
                        fmt = bestFormat;
                    }
                    for (v = min; v <= max - inc + 1.0E-6 * inc; v += inc) {
                        x = v;
                        if (Math.abs(x) < 1.0E-6 * inc) {
                            x = 0.0;
                        }
                        s = fmt.format((Object)new Double(x));
                        x = v + inc;
                        if (Math.abs(x) < 1.0E-6 * inc) {
                            x = 0.0;
                        }
                        if (s.equals(t = fmt.format((Object)new Double(x))) && inc != 0.0) {
                            if (f.equalsIgnoreCase("BEST") && w < maxwIn) {
                                ++w;
                            }
                            f = "BEST";
                            d = 0;
                            if (w < maxwIn) {
                                done = false;
                                break;
                            }
                            done = true;
                        }
                        if (inc == 0.0 || v == v + inc) break;
                    }
                    if (!(v + inc >= max)) continue;
                    done = true;
                }
            }
        }
        Object[] info = new Object[]{SASFormat.getInstance((String)(f + Integer.toString(w).trim() + "." + Integer.toString(d).trim())), new Integer(z)};
        return info;
    }

    public static Object[] getGGoodFormat(SASFormat formatIn, double[] values) {
        return NumericFormat.getGGoodFormat(formatIn, values, -1, -1, -1, false);
    }

    public static Object[] getGGoodFormat(SASFormat formatIn, double[] values, int maxwIn, int maxdecIn, int okdecIn, boolean scale) {
        if (NumericFormat.isNamedFormat(formatIn)) {
            return new Object[]{formatIn, new Integer(0)};
        }
        if (values == null || values.length == 0) {
            return null;
        }
        if (maxwIn < 0) {
            maxwIn = 8;
        }
        if (maxdecIn < 0) {
            maxdecIn = 6;
        }
        if (okdecIn < 0) {
            okdecIn = 2;
        }
        double[] valuesIn = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            valuesIn[i] = values[i];
        }
        double min = values[0];
        double max = values[values.length - 1];
        double scaleSmall = 9.99E-4;
        double scaleBig = 9999.999999;
        double nbig = -(Math.pow(10.0, maxwIn - 2) - 1.0);
        double pbig = Math.pow(10.0, maxwIn - 1) - 1.0;
        double threshold = 0.0;
        SASFormat bestFormat = SASFormat.getInstance((String)"BEST", (int)Math.max(maxwIn, 1), (Locale)Locale.US);
        SASFormat expFormat = SASFormat.getInstance((String)"E", (int)Math.max(maxwIn, 7), (Locale)Locale.US);
        int z = 0;
        String f = " ";
        if (scale && maxdecIn > 0) {
            double m = Math.max(Math.abs(min), Math.abs(max));
            z = (int)Math.floor(Math.log(m) / Math.log(10.0));
            if (Math.abs(min) > scaleBig || Math.abs(max) > scaleBig) {
                if (z > 300) {
                    f = "E";
                }
            } else if (m > 0.0 && m < scaleSmall) {
                if (z < -300) {
                    f = "E";
                }
            } else {
                z = 0;
            }
            if (z != 0) {
                double l = Math.pow(10.0, -z);
                NumericFormat.scaleValues(values, l);
            }
        }
        if (scale) {
            while (maxdecIn == 0 && !NumericFormat.areAllValuesInteger(values)) {
                NumericFormat.scaleValues(values, 10.0);
                --z;
            }
        }
        min = values[0];
        max = values[values.length - 1];
        String s = NumericFormat.getString(min, bestFormat, expFormat, threshold);
        String t = NumericFormat.getString(max, bestFormat, expFormat, threshold);
        if (maxdecIn == 0 && scale && (s.indexOf(69) >= 0 || t.indexOf(69) >= 0)) {
            while (NumericFormat.areAllValuesInteger(values) && (min < nbig || max < nbig || min > pbig || max > pbig)) {
                NumericFormat.scaleValues(values, 0.1);
                min = values[0];
                max = values[values.length - 1];
                ++z;
            }
            s = NumericFormat.getString(min, bestFormat, expFormat, threshold);
            t = NumericFormat.getString(max, bestFormat, expFormat, threshold);
        }
        int w = 0;
        int d = 0;
        if (f.equalsIgnoreCase("E") || s.indexOf(69) >= 0 || t.indexOf(69) >= 0) {
            f = "E";
            z = 0;
            for (int i = 0; i < valuesIn.length; ++i) {
                double x = valuesIn[i];
                s = expFormat.format((Object)new Double(x));
                int k = s.indexOf(".0");
                int p = 0;
                if (k >= 0) {
                    t = s.substring(k);
                    if ((k = t.indexOf(69)) >= 0) {
                        t = t.substring(0, k);
                    }
                    if (!t.equals(" ") && t.replace('0', ' ').trim().equals(".")) {
                        p = t.length();
                    }
                }
                w = Math.max(w, s.length() - p);
                w = Math.max(w, 7);
            }
        } else {
            int dmax = 0;
            if (maxdecIn > 0) {
                dmax = okdecIn;
                int dmax2 = 0;
                int maxWidth = values.length > 1 ? (int)((double)(maxdecIn + okdecIn) / 2.0) : maxdecIn;
                for (int i = 0; i < values.length; ++i) {
                    s = NumericFormat.getString(values[i], bestFormat, expFormat, threshold);
                    if (s.indexOf(69) >= 0) continue;
                    int l = s.length();
                    int k = s.indexOf(46);
                    if (k < 0) continue;
                    dmax2 = (k = l - (k + 1)) <= maxWidth ? Math.max(dmax2, k) : Math.max(dmax2, dmax);
                }
                dmax = dmax2;
            }
            int p = 0;
            for (int i = 0; i < values.length; ++i) {
                double x = values[i];
                s = NumericFormat.getString(x, bestFormat, expFormat, threshold);
                if (s.indexOf(69) >= 0) continue;
                int l = s.length();
                int k = s.indexOf(46);
                if (k >= 0) {
                    p = 1;
                    w = Math.max(w, k);
                    d = Math.min(Math.max(d, l - (k + 1)), dmax);
                    continue;
                }
                w = Math.max(w, l);
            }
            w = w + d + p;
            boolean done = false;
            if (maxdecIn > 0 && values.length > 1) {
                block6: while (!done) {
                    String fnm = f + Integer.toString(w).trim() + "." + Integer.toString(d).trim();
                    SASFormat fmt = SASFormat.getInstance((String)fnm, (Locale)Locale.US);
                    if (fmt == null) {
                        fmt = bestFormat;
                    }
                    for (int i = 0; i < values.length - 1; ++i) {
                        double x = values[i];
                        s = fmt.format((Object)new Double(x));
                        if (s.equals(t = fmt.format((Object)new Double(x = values[i + 1])))) {
                            if (f.equalsIgnoreCase("BEST") && w < maxwIn) {
                                ++w;
                            }
                            f = "BEST";
                            d = 0;
                            if (w < maxwIn) {
                                done = false;
                                continue block6;
                            }
                            done = true;
                            continue;
                        }
                        done = true;
                    }
                }
            }
        }
        Object[] info = new Object[]{SASFormat.getInstance((String)(f + Integer.toString(w).trim() + "." + Integer.toString(d).trim())), new Integer(z)};
        return info;
    }

    private static void scaleValues(double[] values, double scale) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i] * scale;
        }
    }

    private static boolean areAllValuesInteger(double[] values) {
        boolean integer = true;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] - Math.floor(values[i]) > 0.0)) continue;
            integer = false;
            break;
        }
        return integer;
    }

    private static int getNumberOfDecimals(String str) {
        int nd = 0;
        int ne = 0;
        boolean period = false;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '.') {
                period = true;
                continue;
            }
            if (str.charAt(i) == 'e' || str.charAt(i) == 'E') {
                String eStr = str.substring(i + 1);
                if (eStr.startsWith("+")) {
                    eStr = eStr.substring(1);
                }
                ne = Integer.parseInt(eStr);
                break;
            }
            if (!period) continue;
            if (str.charAt(i) != '0') {
                ++nd;
                continue;
            }
            String substr = str.substring(i + 1);
            int idx = substr.indexOf(69);
            if (idx < 0) {
                idx = substr.indexOf(101);
            }
            if (idx >= 0) {
                substr = substr.substring(0, idx);
            }
            if ((substr = substr.replace('0', ' ').trim()).length() <= 0) continue;
            ++nd;
        }
        int nz = nd - ne;
        return nz;
    }

    private static String getString(double v, SASFormat best, SASFormat exp, double threshold) {
        String s = v != 0.0 && Math.abs(v) < threshold ? exp.format((Object)new Double(v)).trim() : best.format((Object)new Double(v)).trim();
        return s;
    }

    public static boolean isNamedFormat(SASFormat fmt) {
        if (fmt == null) {
            return false;
        }
        if (fmt.isUserDefinedFormat()) {
            return true;
        }
        String name = fmt.getName().toUpperCase();
        return Character.isLetter(name.charAt(0)) && (!name.startsWith("BEST") || !Character.isDigit(name.charAt(4)) && name.charAt(4) != '.') && (!name.startsWith("F") || !Character.isDigit(name.charAt(1)) && name.charAt(1) != '.') && (!name.startsWith("D") || !Character.isDigit(name.charAt(1)) && name.charAt(1) != '.') && (!name.startsWith("PVALUE") || !Character.isDigit(name.charAt(6)) && name.charAt(6) != '.');
    }

    public static String getTrimmedValue(String value) {
        int idxNZ;
        int idxS;
        int idxE = value.indexOf("E");
        if (idxE < 0) {
            idxE = value.indexOf("e");
        }
        if (idxE < 0) {
            return value;
        }
        int idxP = -1;
        for (int i = idxE - 1; i >= 0; --i) {
            if (value.charAt(i) != '.') continue;
            idxP = i;
            break;
        }
        if (idxP >= 0) {
            int ns = idxE - 1 - idxP;
            for (int i = idxE - 1; i > idxP && value.charAt(i) == '0'; --i) {
                --ns;
            }
            idxS = ns == 0 ? idxP - 1 : idxP + ns;
        } else {
            idxS = idxE - 1;
        }
        int plus = value.charAt(idxE + 1) == '-' ? -1 : (value.charAt(idxE + 1) == '+' ? 1 : 0);
        for (int i = idxNZ = idxE + Math.abs(plus) + 1; i < value.length() && value.charAt(i) == '0'; ++i) {
            ++idxNZ;
        }
        if (idxNZ == value.length()) {
            idxNZ = value.length() - 1;
        }
        String trimmedStr = value.substring(0, idxS + 1);
        trimmedStr = trimmedStr.concat("E");
        if (plus == -1) {
            trimmedStr = trimmedStr.concat("-");
        }
        if ((trimmedStr = trimmedStr.concat(value.substring(idxNZ))).equals("0E0") || trimmedStr.equals("0E-0")) {
            trimmedStr = "0";
        }
        return trimmedStr;
    }

    public static double[] processValues(double[] values, double incIn) {
        if (values == null) {
            return null;
        }
        if (incIn == 0.0) {
            return values;
        }
        int p = NumericFormat.getValuePrecision(incIn) + defaultPrecision;
        double inc = NumericFormat.getValueByPrecision(incIn, p);
        int precision = NumericFormat.getNumberOfDecimals(inc);
        double[] newValues = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            newValues[i] = NumericFormat.getValueByPrecision(values[i], precision + 1);
        }
        return newValues;
    }

    public static double[] processValues(double[] values, double incIn, int minPrecision) {
        if (values == null) {
            return null;
        }
        if (incIn == 0.0) {
            return values;
        }
        int p = NumericFormat.getValuePrecision(incIn) + defaultPrecision;
        double inc = NumericFormat.getValueByPrecision(incIn, p);
        int precision = NumericFormat.getNumberOfDecimals(inc);
        double[] newValues = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            newValues[i] = NumericFormat.getValueByPrecision(values[i], Math.max(precision, minPrecision) + 1);
        }
        return newValues;
    }

    public static double[] processValues(double minIn, double maxIn, double incIn) {
        if (incIn == 0.0) {
            return new double[]{minIn, minIn, incIn};
        }
        if (maxIn - minIn < incIn) {
            return new double[]{minIn, maxIn, maxIn - minIn};
        }
        int p = NumericFormat.getValuePrecision(incIn) + defaultPrecision;
        double inc = NumericFormat.getValueByPrecision(incIn, p);
        int precision = NumericFormat.getNumberOfDecimals(inc);
        double min = NumericFormat.getValueByPrecision(minIn, precision + 1);
        double max = NumericFormat.getValueByPrecision(maxIn, precision + 1);
        return new double[]{min, max, inc};
    }

    private static int getValuePrecision(double valueIn) {
        double value = Math.abs(valueIn);
        int n = 0;
        if (value < 1.0 && value > 0.0) {
            do {
                ++n;
            } while ((value *= 10.0) < 1.0);
        }
        return n;
    }

    private static double getValueByPrecision(double valueIn, int precision) {
        double value;
        int integer;
        int sign = valueIn >= 0.0 ? 0 : 1;
        int w = sign + (integer = (value = Math.abs(valueIn) + Math.pow(10.0, -(precision + 1))) <= 1.0 ? 1 : (int)(Math.log(value) / Math.log(10.0)) + 1) + precision + 1;
        SASFormat fmt = SASFormat.getInstance((String)(Integer.toString(w).trim() + "." + Integer.toString(precision).trim()));
        if (fmt == null) {
            return valueIn;
        }
        String str2 = fmt.format((Object)new Double(valueIn));
        return Double.parseDouble(str2);
    }

    private static int getNumberOfDecimals(double valueIn) {
        int decimal;
        int dot;
        String str = String.valueOf(valueIn);
        int e = str.indexOf("E");
        if (e == -1) {
            e = str.indexOf("e");
        }
        int exp = 0;
        if (e > 0) {
            String eStr = str.substring(e + 1, str.length());
            exp = Integer.parseInt(eStr);
            str = str.substring(0, e);
        }
        if ((dot = str.indexOf(".")) == -1) {
            decimal = 0;
        } else {
            int last = dot;
            for (int i = str.length() - 1; i > dot; --i) {
                if (str.charAt(i) == '0') continue;
                last = i;
                break;
            }
            decimal = last - dot;
        }
        return Math.max(decimal - exp, 0);
    }
}

