/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import java.util.ArrayList;
import javax.swing.DefaultBoundedRangeModel;

public class MultipleBoundedRangeModel
extends DefaultBoundedRangeModel {
    private static final long serialVersionUID = -6819263152060594580L;
    private ArrayList _value = new ArrayList(5);
    private ArrayList _extent = new ArrayList(5);
    private ArrayList _valueInclusive = new ArrayList(5);
    private ArrayList _extentInclusive = new ArrayList(5);
    private boolean _bounded = true;
    private boolean _overlap = true;
    private boolean _endpoint = true;
    protected boolean _isExclusive = true;
    protected int _spacing = 1;
    private int _visibleMinimum = 0;
    private int _visibleMaximum = 10000;

    public MultipleBoundedRangeModel() {
        this.setMinimum(0);
        this.setMaximum(10000);
        this.setVisibleMinimum(0);
        this.setVisibleMaximum(10000);
    }

    public MultipleBoundedRangeModel(int min, int max) {
        this.setMinimum(min);
        this.setMaximum(max);
        this.setVisibleMinimum(min);
        this.setVisibleMaximum(max);
    }

    public MultipleBoundedRangeModel(int value, int extent, int min, int max) {
        this.add(value, true, extent, true);
        this.setMinimum(min);
        this.setMaximum(max);
        this.setVisibleMinimum(min);
        this.setVisibleMaximum(max);
    }

    @Override
    public int getValue() {
        if (this._value.size() == 0) {
            return 0;
        }
        return this.getValue(0);
    }

    @Override
    public void setValue(int newValue) {
        this.setValue(0, newValue);
    }

    public int getValue(int i) {
        return (Integer)this._value.get(i);
    }

    public void setValue(int i, int newValue) {
        this.setValue(i, newValue, this.getValueInclusive(i));
    }

    public boolean getValueInclusive(int i) {
        return (Boolean)this._valueInclusive.get(i);
    }

    public void setValueInclusive(int i, boolean inclusive) {
        this.setValue(i, this.getValue(i), inclusive);
    }

    public void setValue(int i, int newValue, boolean inclusive) {
        this.setRange(i, newValue, inclusive, this.getExtent(i), this.getExtentInclusive(i));
    }

    @Override
    public int getExtent() {
        return this.getExtent(0);
    }

    @Override
    public void setExtent(int newExtent) {
        this.setExtent(0, newExtent);
    }

    public int getExtent(int i) {
        return (Integer)this._extent.get(i);
    }

    public int getLimit(int i) {
        return this.getValue(i) + Math.max(0, this.getExtent(i));
    }

    public void setExtent(int i, int newExtent) {
        this.setExtent(i, newExtent, this.getExtentInclusive(i));
    }

    public boolean getExtentInclusive(int i) {
        return (Boolean)this._extentInclusive.get(i);
    }

    public void setExtentInclusive(int i, boolean inclusive) {
        this.setExtent(i, this.getExtent(i), inclusive);
    }

    public void setExtent(int i, int newExtent, boolean inclusive) {
        this.setRange(i, this.getValue(i), this.getValueInclusive(i), newExtent, inclusive);
    }

    public void setRange(int i, int newValue, int newExtent) {
        this.setRange(i, newValue, this.getValueInclusive(i), newExtent, this.getExtentInclusive(i));
    }

    public void setRange(int i, int newValue, boolean valueInclusive, int newExtent, boolean extentInclusive) {
        int[] newRange = this.correctSet(i, this.getValue(i), newValue, this.getExtent(i), newExtent);
        newValue = newRange[0];
        newExtent = newRange[1];
        if (!this.isExclusive()) {
            valueInclusive = true;
            extentInclusive = true;
        }
        boolean changed = false;
        if (newValue != this.getValue(i)) {
            this._value.set(i, new Integer(newValue));
            changed = true;
        }
        if (valueInclusive != this.getValueInclusive(i)) {
            this._valueInclusive.set(i, new Boolean(valueInclusive));
            changed = true;
        }
        if (newExtent != this.getExtent(i)) {
            this._extent.set(i, new Integer(newExtent));
            changed = true;
        }
        if (extentInclusive != this.getExtentInclusive(i)) {
            this._extentInclusive.set(i, new Boolean(extentInclusive));
            changed = true;
        }
        this.correctInclusive(i);
        if (changed) {
            this.fireStateChanged();
        }
    }

    @Override
    public void setMinimum(int newMinimum) {
        if (this._bounded) {
            for (int i = 0; i < this.ranges(); ++i) {
                if (newMinimum <= this.getValue(i)) continue;
                newMinimum = this.getValue(i);
            }
        }
        super.setMinimum(newMinimum);
    }

    @Override
    public void setMaximum(int newMaximum) {
        if (this._bounded) {
            for (int i = 0; i < this.ranges(); ++i) {
                if (newMaximum >= this.getLimit(i)) continue;
                newMaximum = this.getLimit(i);
            }
        }
        super.setMaximum(newMaximum);
    }

    public int getVisibleMinimum() {
        return this._visibleMinimum;
    }

    public void setVisibleMinimum(int visibleMinimum) {
        if (this._visibleMinimum != visibleMinimum) {
            this._visibleMinimum = visibleMinimum;
            this.fireStateChanged();
        }
    }

    public int getVisibleMaximum() {
        return this._visibleMaximum;
    }

    public void setVisibleMaximum(int visibleMaximum) {
        if (this._visibleMaximum != visibleMaximum) {
            this._visibleMaximum = visibleMaximum;
            this.fireStateChanged();
        }
    }

    public void add(int newValue, boolean valueInclusive, int newExtent, boolean extentInclusive) {
        int[] newRange = this.correctAdd(newValue, newExtent);
        newValue = newRange[0];
        newExtent = newRange[1];
        if (!this.isExclusive()) {
            valueInclusive = true;
            extentInclusive = true;
        }
        this._value.add(new Integer(newValue));
        this._valueInclusive.add(new Boolean(valueInclusive));
        this._extent.add(new Integer(newExtent));
        this._extentInclusive.add(new Boolean(extentInclusive));
        this.correctInclusive(this.ranges() - 1);
        this.fireStateChanged();
    }

    public void remove(int i) {
        this._value.remove(i);
        this._valueInclusive.remove(i);
        this._extent.remove(i);
        this._extentInclusive.remove(i);
        this.fireStateChanged();
    }

    public int[] correctAdd(int newValue, int newExtent) {
        int lim;
        int val;
        int i;
        if (!this.isOverlap()) {
            if (this.isBounded()) {
                newExtent = Math.min(newExtent, this.getMaximum() - this.getMinimum());
                newValue = Math.max(newValue, this.getMinimum());
                newValue = Math.min(newValue, this.getMaximum() - newExtent);
            }
            return new int[]{newValue, newExtent};
        }
        int nRanges = this.ranges();
        ArrayList<Integer> values = new ArrayList<Integer>(nRanges + 1);
        ArrayList<Integer> limits = new ArrayList<Integer>(nRanges + 1);
        int minValue = this.getMinimum();
        int maxLimit = this.getMaximum();
        for (i = 0; i < nRanges; ++i) {
            val = this.getValue(i);
            int ext = Math.max(this.getExtent(i), 0);
            int j = 0;
            boolean found = false;
            while (j < values.size() && !found) {
                if ((Integer)values.get(j) > val) {
                    found = true;
                    continue;
                }
                ++j;
            }
            values.add(j, new Integer(val));
            limits.add(j, new Integer(val + ext));
            if (minValue > val) {
                minValue = val;
            }
            if (maxLimit >= val + ext) continue;
            maxLimit = val + ext;
        }
        if (!this.isBounded()) {
            if (minValue > newValue) {
                minValue = newValue;
            }
            if (maxLimit < newValue + newExtent) {
                maxLimit = newValue + newExtent;
            }
        }
        if (this._spacing > 0) {
            for (i = 0; i < values.size(); ++i) {
                val = (Integer)values.get(i);
                lim = (Integer)limits.get(i);
                if (!this._isExclusive) {
                    --val;
                    val = this._spacing * (val / this._spacing);
                    ++lim;
                    lim = (int)Math.floor(this._spacing * (1 + (lim - 1) / this._spacing));
                } else {
                    val = this._spacing * (int)Math.round((double)val / (double)this._spacing);
                    lim = this._spacing * (int)Math.round((double)lim / (double)this._spacing);
                }
                values.set(i, new Integer(val));
                limits.set(i, new Integer(lim));
            }
        }
        limits.add(0, new Integer(minValue));
        values.add(values.size(), new Integer(maxLimit));
        for (i = values.size() - 1; i >= 0; --i) {
            val = (Integer)values.get(i);
            lim = (Integer)limits.get(i);
            if (lim <= val && (!this._isExclusive || lim != val || values.size() <= 1)) continue;
            limits.remove(i);
            values.remove(i);
        }
        int center = newValue + Math.max(newExtent, 0) / 2;
        int minDist = maxLimit - minValue;
        int minIndex = -1;
        for (int i2 = 0; i2 < values.size(); ++i2) {
            int val2 = (Integer)limits.get(i2);
            int lim2 = (Integer)values.get(i2);
            int dist = 0;
            if (newValue >= lim2 || newValue + Math.max(newExtent, 0) < val2) {
                dist = Math.min(Math.abs(center - val2), Math.abs(center - lim2));
            }
            if (minDist <= dist && minIndex >= 0) continue;
            minDist = dist;
            minIndex = i2;
        }
        int val3 = maxLimit;
        int lim3 = maxLimit;
        if (minIndex >= 0) {
            val3 = (Integer)limits.get(minIndex);
            lim3 = (Integer)values.get(minIndex);
        } else if (!this.isBounded()) {
            lim3 = maxLimit + newExtent;
        }
        if (newExtent < 0) {
            if (newValue < val3) {
                newValue = val3;
            }
            if (newValue > lim3) {
                newValue = lim3;
            }
        } else {
            if (newValue < val3) {
                newExtent -= val3 - newValue;
                newValue = val3;
            }
            if (newExtent > lim3 - val3) {
                newExtent = lim3 - val3;
            }
            if (newValue < lim3 && newValue + newExtent > lim3) {
                newExtent = lim3 - newValue;
            } else if (newValue > lim3) {
                newValue = lim3 - newExtent;
            }
        }
        return new int[]{newValue, newExtent};
    }

    public int[] correctSet(int index, int oldValue, int value, int oldExtent, int extent) {
        int i;
        int foundValue;
        int spacing;
        int[] newRange = new int[]{value, extent};
        int newValue = value;
        if (this._bounded) {
            if (extent >= 0 && (oldExtent == extent || oldValue != value) && newValue > this.getMaximum() - extent) {
                newValue = this.getMaximum() - extent;
            }
            if (newValue < this.getMinimum()) {
                newValue = this.getMinimum();
            }
            if (newValue > this.getMaximum()) {
                newValue = this.getMaximum();
            }
            if (extent >= 0 && oldExtent != extent && newValue == value && newValue > this.getMaximum() - extent) {
                extent = this.getMaximum() - newValue;
            }
            if (extent >= 0 && this.getMinimum() <= value && value + extent <= this.getMaximum() && newValue > value + extent) {
                newValue = value + extent;
            }
        }
        int n = spacing = this.isExclusive() ? 0 : this.getSpacing();
        if (this._overlap) {
            int i2;
            if (oldExtent < 0) {
                int foundValue2 = this.getMaximum() + 1;
                for (i2 = 0; i2 < this.ranges(); ++i2) {
                    int val = this.getValue(i2);
                    if (i2 == index || oldValue > val || foundValue2 <= val) continue;
                    foundValue2 = val;
                    if (this.getExtent(i2) > 0) continue;
                    --foundValue2;
                }
                if (foundValue2 <= this.getMaximum() && newValue > foundValue2 - spacing) {
                    newValue = foundValue2 - spacing;
                }
            }
            int foundLimit = this.getMinimum() - 1;
            for (i2 = 0; i2 < this.ranges(); ++i2) {
                int lim = this.getLimit(i2);
                if (i2 == index || oldValue < lim || foundLimit >= lim) continue;
                foundLimit = lim;
                if (this.getExtent(i2) > 0) continue;
                ++foundLimit;
            }
            if (foundLimit >= this.getMinimum() && newValue < foundLimit + spacing) {
                newValue = foundLimit + spacing;
            }
            if (oldExtent >= 0 && oldExtent == extent) {
                foundValue = this.getMaximum() + 1;
                for (i = 0; i < this.ranges(); ++i) {
                    int val = this.getValue(i);
                    if (i == index || oldValue + oldExtent > val || foundValue <= val) continue;
                    foundValue = val;
                    if (this.getExtent(i) > 0) continue;
                    --foundValue;
                }
                if (foundValue <= this.getMaximum() && newValue > foundValue - extent - spacing) {
                    newValue = foundValue - extent - spacing;
                }
            }
            if (this._overlap) {
                boolean hit = false;
                for (i = 0; i < this.ranges() && !hit; ++i) {
                    if (i == index || this.getValue(i) >= newValue || newValue >= this.getValue(i) + this.getExtent(i)) continue;
                    hit = true;
                }
                if (hit) {
                    newValue = oldValue;
                }
            }
        }
        newRange[0] = newValue;
        if (extent < 0) {
            return newRange;
        }
        int newExtent = extent;
        if (oldExtent != extent) {
            newExtent += value - newValue;
        }
        if (this._bounded) {
            if (newExtent < 0) {
                newExtent = 0;
            }
            if (newExtent > this.getMaximum() - newValue) {
                newExtent = this.getMaximum() - newValue;
            }
        }
        if (this._overlap && oldExtent >= 0) {
            foundValue = this.getMaximum() + 1;
            for (i = 0; i < this.ranges(); ++i) {
                if (i == index || newValue + oldExtent > this.getValue(i) || foundValue <= this.getValue(i)) continue;
                foundValue = this.getValue(i);
            }
            if (foundValue <= this.getMaximum() && newExtent > foundValue - newValue - spacing) {
                newExtent = foundValue - newValue - spacing;
            }
        }
        newRange[1] = newExtent;
        return newRange;
    }

    public void correctInclusive(int index) {
        int i;
        if (!(this._overlap && this._endpoint && this._isExclusive)) {
            return;
        }
        int value = this.getValue(index);
        int extent = this.getExtent(index);
        boolean valueInclusive = this.getValueInclusive(index);
        boolean extentInclusive = this.getExtentInclusive(index);
        if (extent < 0) {
            valueInclusive = true;
            extentInclusive = true;
        }
        for (i = 0; i < this.ranges(); ++i) {
            if (i == index || !this.getExtentInclusive(i) && this.getExtent(i) >= 0 || this.getLimit(i) != value) continue;
            if (extent >= 0) {
                valueInclusive = false;
                continue;
            }
            if (this.getExtent(i) < 0) continue;
            this.setExtentInclusive(i, false);
        }
        this._valueInclusive.set(index, new Boolean(valueInclusive));
        for (i = 0; i < this.ranges(); ++i) {
            if (i == index || !this.getValueInclusive(i) && this.getExtent(i) >= 0 || this.getValue(i) != value + extent) continue;
            if (extent >= 0) {
                extentInclusive = false;
                continue;
            }
            if (this.getExtent(i) < 0) continue;
            this.setValueInclusive(i, false);
        }
        this._extentInclusive.set(index, new Boolean(extentInclusive));
    }

    public int ranges() {
        return this._value.size();
    }

    public boolean isBounded() {
        return this._bounded;
    }

    public void setBounded(boolean bounded) {
        this._bounded = bounded;
    }

    public boolean isOverlap() {
        return this._overlap;
    }

    public void setOverlap(boolean overlap) {
        this._overlap = overlap;
    }

    public boolean isEndpoint() {
        return this._endpoint;
    }

    public void setEndpoint(boolean endpoint) {
        this._endpoint = endpoint;
    }

    public boolean isExclusive() {
        return this._isExclusive;
    }

    public void setExclusive(boolean isExclusive) {
        this._isExclusive = isExclusive;
    }

    public int getSpacing() {
        return this._spacing;
    }

    public void setSpacing(int spacing) {
        this._spacing = spacing;
    }

    @Override
    public String toString() {
        String s = super.toString() + "\n";
        s = s + "   vmin=" + this.getVisibleMinimum() + "  vmax=" + this.getVisibleMaximum() + "\n";
        for (int i = 0; i < this.ranges(); ++i) {
            s = s + "   range " + i + "=  " + this.getValue(i) + "  " + this.getExtent(i) + "\n";
        }
        return s;
    }

    @Override
    public void setValueIsAdjusting(boolean b) {
        boolean changed = b != this.getValueIsAdjusting();
        super.setValueIsAdjusting(b);
        if (changed) {
            this.fireStateChanged();
        }
    }
}

