/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.BasicRangeSliderUI;
import com.sas.graphics.util.RangeSlider;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MetalRangeSliderUI
extends BasicRangeSliderUI {
    private Polygon _thumb = new Polygon();
    private Rectangle _drag = new Rectangle();

    public MetalRangeSliderUI(JSlider slider) {
        super(slider);
    }

    public static ComponentUI createUI(JComponent c) {
        return new MetalRangeSliderUI((RangeSlider)c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this._thumbLarge = 16;
        this._thumbSmall = 15;
    }

    @Override
    public void setThumbSize(int size) {
        this._thumbLarge = size;
        if (this._thumbLarge % 2 == 1) {
            --this._thumbLarge;
        }
        this._thumbSmall = this._thumbLarge - 1;
        this.calculateThumbLocation();
    }

    protected int getTrackWidth() {
        float kIdealTrackWidth = 7.0f;
        float kIdealThumbLarge = 16.0f;
        float kWidthScalar = 0.4375f;
        int width = Math.round(0.4375f * (float)this._thumbLarge);
        if (width < 7) {
            width = 7;
        }
        return width;
    }

    protected int getThumbOverhang() {
        return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
    }

    @Override
    public void paintTrack(Graphics g) {
        ColorUIResource trackColor = !this.slider.isEnabled() ? MetalLookAndFeel.getControlShadow() : this.slider.getForeground();
        boolean leftToRight = this.slider.getComponentOrientation().isLeftToRight();
        int trackLeft = 0;
        int trackTop = 0;
        int trackRight = 0;
        int trackBottom = 0;
        g.translate(this.trackRect.x, this.trackRect.y);
        if (this.slider.getOrientation() == 0) {
            trackBottom = this.trackRect.height - 1 - this.getThumbOverhang();
            trackTop = trackBottom - (this.getTrackWidth() - 1);
            trackRight = this.trackRect.width - 1;
        } else {
            if (leftToRight) {
                trackLeft = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                trackRight = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                trackLeft = this.getThumbOverhang() + 1;
                trackRight = this.getThumbOverhang() + this.getTrackWidth();
            }
            trackBottom = this.trackRect.height - 1;
        }
        if (this.slider.isEnabled()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawRect(trackLeft, trackTop, trackRight - trackLeft - 1, trackBottom - trackTop - 1);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(trackLeft + 1, trackBottom, trackRight, trackBottom);
            g.drawLine(trackRight, trackTop + 1, trackRight, trackBottom);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawLine(trackLeft + 1, trackTop + 1, trackRight - 2, trackTop + 1);
            g.drawLine(trackLeft + 1, trackTop + 1, trackLeft + 1, trackBottom - 2);
        } else {
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawRect(trackLeft, trackTop, trackRight - trackLeft - 1, trackBottom - trackTop - 1);
        }
        g.translate(-this.trackRect.x, -this.trackRect.y);
    }

    @Override
    protected boolean onThumb(int x, int y, int i) {
        Rectangle r = (Rectangle)this._thumbRects.get(i);
        int x0 = r.x;
        int y0 = r.y;
        int x1 = r.x + r.width / 2;
        int y1 = r.y + r.height / 2;
        int x2 = r.x + r.width - 1;
        int y2 = r.y + r.height - 1;
        boolean isRange = this.getSlider().getExtent(i / 2) >= 0;
        boolean isHorizontal = this.slider.getOrientation() == 0;
        boolean isInverted = this.drawInverted();
        boolean isValueInclusive = this.getSlider().getValueInclusive(i / 2);
        boolean isExtentInclusive = this.getSlider().getExtentInclusive(i / 2);
        boolean isLeftToRight = this.slider.getComponentOrientation().isLeftToRight();
        this._thumb.reset();
        if (i % 2 == 0) {
            if (isRange) {
                if (isHorizontal) {
                    this._thumb.addPoint(isInverted ? x2 : x0, y2);
                    this._thumb.addPoint(isValueInclusive ? (isInverted ? x2 : x0) : x1, y1);
                    this._thumb.addPoint(isInverted ? x2 : x0, y0);
                    this._thumb.addPoint(x1, y0);
                    this._thumb.addPoint(isInverted ? x0 : x2, y1);
                    this._thumb.addPoint(x1, y2);
                } else {
                    this._thumb.addPoint(x0, isInverted ? y0 : y2);
                    this._thumb.addPoint(x1, isValueInclusive ? (isInverted ? y0 : y2) : y1);
                    this._thumb.addPoint(x2, isInverted ? y0 : y2);
                    this._thumb.addPoint(x2, y1);
                    this._thumb.addPoint(x1, isInverted ? y2 : y0);
                    this._thumb.addPoint(x0, y1);
                }
            } else if (isHorizontal) {
                this._thumb.addPoint(x0, y0);
                this._thumb.addPoint(x1, y0);
                this._thumb.addPoint(x2, y0);
                this._thumb.addPoint(x2, y1);
                this._thumb.addPoint(x1, y2);
                this._thumb.addPoint(x0, y1);
            } else {
                this._thumb.addPoint(isLeftToRight ? x0 : x2, y0);
                this._thumb.addPoint(isLeftToRight ? x0 : x2, y1);
                this._thumb.addPoint(isLeftToRight ? x0 : x2, y2);
                this._thumb.addPoint(x1, y2);
                this._thumb.addPoint(isLeftToRight ? x2 : x0, y1);
                this._thumb.addPoint(x1, y0);
            }
        } else if (isRange) {
            if (isHorizontal) {
                this._thumb.addPoint(isInverted ? x0 : x2, y2);
                this._thumb.addPoint(isExtentInclusive ? (isInverted ? x0 : x2) : x1, y1);
                this._thumb.addPoint(isInverted ? x0 : x2, y0);
                this._thumb.addPoint(x1, y0);
                this._thumb.addPoint(isInverted ? x2 : x0, y1);
                this._thumb.addPoint(x1, y2);
            } else {
                this._thumb.addPoint(x0, isInverted ? y2 : y0);
                this._thumb.addPoint(x1, isExtentInclusive ? (isInverted ? y2 : y0) : y1);
                this._thumb.addPoint(x2, isInverted ? y2 : y0);
                this._thumb.addPoint(x2, y1);
                this._thumb.addPoint(x1, isInverted ? y0 : y2);
                this._thumb.addPoint(x0, y1);
            }
        }
        return this._thumb.contains(x, y);
    }

    @Override
    protected Rectangle getRangeRectangle(int i) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        Rectangle r0 = (Rectangle)this._thumbRects.get(2 * i);
        Rectangle r1 = (Rectangle)this._thumbRects.get(2 * i + 1);
        r.x = Math.min(r0.x, r1.x);
        r.y = Math.min(r0.y, r1.y);
        if (this.slider.getOrientation() == 0) {
            r.y += this.getThumbOverhang() + 1;
            r.height = this.getTrackWidth() - 1;
            r.x += this.getThumbSize().width / 2;
            r.width = Math.abs(r1.x - r0.x);
        } else {
            r.x += this.getThumbOverhang() + 1;
            r.width = this.getTrackWidth() - 1;
            r.y += this.getThumbSize().height / 2;
            r.height = Math.abs(r1.y - r0.y);
        }
        return r;
    }

    public void paintDrag(Graphics g, int x, int y, int w, int h, Color highlightColor, Color shadowColor) {
        int d;
        int i;
        this._drag.setBounds(x, y, w, h);
        this._drag = this._drag.intersection(g.getClipBounds());
        while (this._drag.x % 4 != x % 4) {
            --this._drag.x;
            ++this._drag.width;
        }
        while (this._drag.y % 4 != y % 4) {
            --this._drag.y;
            ++this._drag.height;
        }
        g.setColor(highlightColor);
        if (this._drag.width % 2 == 1) {
            --this._drag.width;
        }
        if (this._drag.height % 2 == 1) {
            --this._drag.height;
        }
        for (i = 0; i < this._drag.width; i += 4) {
            d = Math.min(this._drag.width - 1 - i, this._drag.height - 1);
            g.drawLine(this._drag.x + i, this._drag.y, this._drag.x + i + d, this._drag.y + d);
        }
        for (i = 0; i < this._drag.height; i += 4) {
            d = Math.min(this._drag.height - 1 - i, this._drag.width - 1);
            g.drawLine(this._drag.x, this._drag.y + i, this._drag.x + d, this._drag.y + i + d);
        }
        g.setColor(shadowColor);
        for (int j = 1; j < this._drag.height; j += 2) {
            int i2;
            int n = i2 = j % 4 == 1 ? 1 : 3;
            while (i2 < this._drag.width) {
                g.drawLine(this._drag.x + i2, this._drag.y + j, this._drag.x + i2, this._drag.y + j);
                i2 += 4;
            }
        }
    }

    @Override
    public void paintRange(Graphics g, int i) {
        if (((RangeSlider)this.slider).getExtent(i) < 0) {
            return;
        }
        Rectangle r = this.getRangeRectangle(i);
        int x = r.x;
        int y = r.y;
        int w = r.width;
        int h = r.height;
        boolean focused = 2 * i == this.getValueFocus() && 2 * i + 1 == this.getExtentFocus();
        g.translate(x, y);
        g.setColor(Color.black);
        g.fillRect(0, 0, w, h);
        Color highlightColor = focused ? this.getFocusColor().brighter() : this.getHighlightColor();
        g.setColor(highlightColor);
        g.fillRect(1, 1, w - 2, h - 2);
        if (this.slider.isEnabled()) {
            g.setColor(focused ? this.getFocusColor() : this.getThumbColor());
        } else {
            g.setColor(this.getThumbColor().darker());
        }
        g.fillRect(2, 2, w - 3, h - 3);
        this.paintDrag(g, 2, 2, w - 3, h - 3, highlightColor, MetalLookAndFeel.getControlDarkShadow());
        g.translate(-x, -y);
    }

    @Override
    public void paintThumbValue(Graphics g, int i, int w, int h, boolean focused, boolean inverted) {
        Color highlightColor;
        int cw = w / 2;
        int ch = h / 2;
        Color color = highlightColor = focused ? this.getFocusColor().brighter() : this.getHighlightColor();
        if (this.slider.isEnabled()) {
            g.setColor(focused ? this.getFocusColor() : this.getThumbColor());
        } else {
            g.setColor(this.getThumbColor().darker());
        }
        if (this.slider.getOrientation() == 0) {
            g.fillRect(1, 1, w - 2, ch - 1);
            for (int j = 0; j < cw; ++j) {
                g.drawLine(1 + j, ch + j, w - 2 - j, ch + j);
            }
            int d = 2 * ((h - 3) % 4 / 2);
            for (int j = 2; j < ch; j += 2) {
                this.paintDrag(g, cw + 2 - j, d + j % 4, 2 * j - 2, h - 1 - d - j % 4 - j, highlightColor, MetalLookAndFeel.getControlDarkShadow());
            }
            g.setColor(Color.black);
            g.drawLine(1, 0, w - 2, 0);
            g.drawLine(0, 1, 0, ch);
            g.drawLine(w - 1, 1, w - 1, ch);
            g.drawLine(0, ch, cw, h - 1);
            g.drawLine(cw, h - 1, w - 1, ch);
            g.setColor(highlightColor);
            g.drawLine(1, 1, w - 2, 1);
            g.drawLine(1, 1, 1, ch);
            g.drawLine(1, ch, cw, h - 2);
        } else if (this.slider.getComponentOrientation().isLeftToRight()) {
            g.fillRect(1, 1, cw - 1, h - 2);
            for (int j = 0; j < ch; ++j) {
                g.drawLine(cw + j, 1 + j, cw + j, h - 2 - j);
            }
            int d = 2 * ((w - 3) % 4 / 2);
            for (int j = 2; j < cw; j += 2) {
                this.paintDrag(g, d + j % 4, ch + 2 - j, w - 1 - d - j % 4 - j, 2 * j - 2, highlightColor, MetalLookAndFeel.getControlDarkShadow());
            }
            g.setColor(Color.black);
            g.drawLine(0, 1, 0, h - 2);
            g.drawLine(1, 0, cw, 0);
            g.drawLine(1, h - 1, cw, h - 1);
            g.drawLine(cw, 0, w - 1, ch);
            g.drawLine(cw, h - 1, w - 1, ch);
            g.setColor(highlightColor);
            g.drawLine(1, 1, 1, h - 2);
            g.drawLine(1, 1, cw, 1);
            g.drawLine(cw, 1, w - 2, ch);
        } else {
            int j;
            g.fillRect(cw - 1, 1, cw, h - 2);
            for (j = 1; j < ch; ++j) {
                g.drawLine(cw - j, 1 + j, cw - j, h - 2 - j);
            }
            for (j = 2; j < cw; j += 2) {
                this.paintDrag(g, 2 + j, ch + 2 - j, w - 3 - j, 2 * j - 2, highlightColor, MetalLookAndFeel.getControlDarkShadow());
            }
            g.setColor(Color.black);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.drawLine(w - 2, 0, cw - 1, 0);
            g.drawLine(w - 2, h - 1, cw - 1, h - 1);
            g.drawLine(0, ch, cw - 1, 0);
            g.drawLine(0, ch, cw - 1, h - 1);
            g.setColor(highlightColor);
            g.drawLine(1, ch, cw - 1, 1);
            g.drawLine(cw - 1, 1, w - 2, 1);
            g.drawLine(1, ch, cw - 1, h - 2);
        }
    }

    @Override
    public void paintThumbValueInclusive(Graphics g, int i, int w, int h, boolean focused, boolean inverted) {
        Color highlightColor;
        int cw = w / 2;
        int ch = h / 2;
        Color color = highlightColor = focused ? this.getFocusColor().brighter() : this.getHighlightColor();
        if (this.slider.isEnabled()) {
            g.setColor(focused ? this.getFocusColor() : this.getThumbColor());
        } else {
            g.setColor(this.getThumbColor().darker());
        }
        if (this.slider.getOrientation() == 0) {
            if (inverted) {
                this.paintThumbExtentInclusive(g, i, w, h, focused, false);
            } else {
                g.fillRect(1, 1, cw - 1, h - 2);
                for (int j = 0; j < cw; ++j) {
                    g.drawLine(cw + j, 1 + j, cw + j, h - 2 - j);
                }
                int d = 2 * ((w - 3) % 4 / 2);
                for (int j = 2; j < ch; j += 2) {
                    this.paintDrag(g, d + j % 4, ch + 1 - j, w - 1 - d - j - j % 4, 2 * j - 2, highlightColor, MetalLookAndFeel.getControlDarkShadow());
                }
                g.setColor(Color.black);
                g.drawLine(0, 1, 0, h - 2);
                g.drawLine(1, 0, cw, 0);
                g.drawLine(1, h - 1, cw, h - 1);
                g.drawLine(cw, 0, w - 1, ch - 1);
                g.drawLine(cw, h - 1, w - 1, ch);
                g.setColor(highlightColor);
                g.drawLine(1, 1, 1, h - 2);
                g.drawLine(1, 1, cw, 1);
                g.drawLine(cw, 1, w - 2, ch - 1);
            }
        } else if (inverted) {
            this.paintThumbExtentInclusive(g, i, w, h, focused, false);
        } else {
            int j;
            g.fillRect(1, ch, w - 2, ch);
            for (j = 0; j < cw; ++j) {
                g.drawLine(1 + j, ch - j, w - 2 - j, ch - j);
            }
            for (j = 2; j < cw; j += 2) {
                this.paintDrag(g, cw + 1 - j, 1 + j, 2 * j - 2, h - 3 - j, highlightColor, MetalLookAndFeel.getControlDarkShadow());
            }
            g.setColor(Color.black);
            g.drawLine(1, h - 1, w - 2, h - 1);
            g.drawLine(0, ch, 0, h - 2);
            g.drawLine(w - 1, ch, w - 1, h - 2);
            g.drawLine(0, ch, cw - 1, 0);
            g.drawLine(cw, 0, w - 1, ch);
            g.setColor(highlightColor);
            g.drawLine(1, ch, 1, h - 2);
            g.drawLine(1, ch, cw - 1, 1);
            g.drawLine(cw, 1, w - 2, ch);
        }
    }

    @Override
    public void paintThumbValueExclusive(Graphics g, int i, int w, int h, boolean focused, boolean inverted) {
        Color highlightColor;
        int cw = w / 2;
        int ch = h / 2;
        Color color = highlightColor = focused ? this.getFocusColor().brighter() : this.getHighlightColor();
        if (this.slider.isEnabled()) {
            g.setColor(focused ? this.getFocusColor() : this.getThumbColor());
        } else {
            g.setColor(this.getThumbColor().darker());
        }
        if (this.slider.getOrientation() == 0) {
            if (inverted) {
                this.paintThumbExtentExclusive(g, i, w, h, focused, false);
            } else {
                for (int j = 0; j < cw; ++j) {
                    g.drawLine(1 + j, 1 + j, cw + j, 1 + j);
                    g.drawLine(1 + j, h - 2 - j, cw + j, h - 2 - j);
                }
                int d = 2 + cw % 4 / 2;
                for (int j = 0; j < cw - 1; j += 2) {
                    this.paintDrag(g, cw + d - j, ch - 1 - j, cw - d, 2, highlightColor, MetalLookAndFeel.getControlDarkShadow());
                    this.paintDrag(g, cw + d - j, ch - 1 + j, cw - d, 2, highlightColor, MetalLookAndFeel.getControlDarkShadow());
                }
                g.setColor(Color.black);
                g.drawLine(1, 0, cw, 0);
                g.drawLine(1, h - 1, cw, h - 1);
                g.drawLine(0, 1, cw - 1, ch - 1);
                g.drawLine(0, h - 2, cw - 1, ch);
                g.drawLine(cw, 0, w - 1, ch - 1);
                g.drawLine(cw, h - 1, w - 1, ch);
                g.setColor(highlightColor);
                g.drawLine(1, 1, cw, 1);
                g.drawLine(1, 1, cw, ch - 1);
                g.drawLine(1, h - 2, cw, ch);
                g.drawLine(cw, 1, w - 2, ch - 1);
            }
        } else if (inverted) {
            this.paintThumbExtentExclusive(g, i, w, h, focused, false);
        } else {
            for (int j = 0; j < cw; ++j) {
                g.drawLine(1 + j, ch - j, 1 + j, h - 1 - j);
                g.drawLine(w - 2 - j, ch - j, w - 2 - j, h - 1 - j);
            }
            int d = 2 + ch % 4 / 2;
            for (int j = 0; j < cw - 2; j += 2) {
                this.paintDrag(g, cw - 1 - j, d + j, 2, ch - d, highlightColor, MetalLookAndFeel.getControlDarkShadow());
                this.paintDrag(g, cw - 1 + j, d + j, 2, ch - d, highlightColor, MetalLookAndFeel.getControlDarkShadow());
            }
            g.setColor(Color.black);
            g.drawLine(0, ch, 0, h - 2);
            g.drawLine(w - 1, ch, w - 1, h - 2);
            g.drawLine(0, ch, cw - 1, 0);
            g.drawLine(cw, 0, w - 1, ch);
            g.drawLine(1, h - 1, cw - 1, ch + 1);
            g.drawLine(w - 2, h - 1, cw, ch + 1);
            g.setColor(highlightColor);
            g.drawLine(1, ch, 1, h - 2);
            g.drawLine(1, ch, cw - 1, 1);
            g.drawLine(cw, 1, w - 2, ch);
        }
    }

    @Override
    public void paintThumbExtentInclusive(Graphics g, int i, int w, int h, boolean focused, boolean inverted) {
        Color highlightColor;
        int cw = w / 2;
        int ch = h / 2;
        Color color = highlightColor = focused ? this.getFocusColor().brighter() : this.getHighlightColor();
        if (this.slider.isEnabled()) {
            g.setColor(focused ? this.getFocusColor() : this.getThumbColor());
        } else {
            g.setColor(this.getThumbColor().darker());
        }
        if (this.slider.getOrientation() == 0) {
            if (inverted) {
                this.paintThumbValueInclusive(g, i, w, h, focused, false);
            } else {
                int j;
                g.fillRect(cw + 1, 1, cw - 1, h - 2);
                for (j = 0; j < cw; ++j) {
                    g.drawLine(cw - j, 1 + j, cw - j, h - 2 - j);
                }
                for (j = 2; j < ch; j += 2) {
                    this.paintDrag(g, 1 + j, ch + 1 - j, w - 3 - j, 2 * j - 2, highlightColor, MetalLookAndFeel.getControlDarkShadow());
                }
                g.setColor(Color.black);
                g.drawLine(w - 1, 1, w - 1, h - 2);
                g.drawLine(w - 2, 0, cw, 0);
                g.drawLine(w - 2, h - 1, cw, h - 1);
                g.drawLine(0, ch - 1, cw, 0);
                g.drawLine(0, ch, cw, h - 1);
                g.setColor(highlightColor);
                g.drawLine(1, ch - 1, cw, 1);
                g.drawLine(cw, 1, w - 2, 1);
                g.drawLine(1, ch, cw, h - 2);
            }
        } else if (inverted) {
            this.paintThumbValueInclusive(g, i, w, h, focused, false);
        } else {
            g.fillRect(1, 1, w - 2, ch - 1);
            for (int j = 0; j < cw; ++j) {
                g.drawLine(1 + j, ch + j, w - 2 - j, ch + j);
            }
            int d = 2 * ((h - 3) % 4 / 2);
            for (int j = 2; j < cw; j += 2) {
                this.paintDrag(g, cw + 1 - j, d + j % 4, 2 * j - 2, h - 1 - d - j % 4 - j, highlightColor, MetalLookAndFeel.getControlDarkShadow());
            }
            g.setColor(Color.black);
            g.drawLine(1, 0, w - 2, 0);
            g.drawLine(0, 1, 0, ch);
            g.drawLine(w - 1, 1, w - 1, ch);
            g.drawLine(0, ch, cw - 1, h - 1);
            g.drawLine(cw, h - 1, w - 1, ch);
            g.setColor(highlightColor);
            g.drawLine(1, 1, w - 2, 1);
            g.drawLine(1, 1, 1, ch);
            g.drawLine(1, ch, cw - 1, h - 2);
        }
    }

    @Override
    public void paintThumbExtentExclusive(Graphics g, int i, int w, int h, boolean focused, boolean inverted) {
        Color highlightColor;
        int cw = w / 2;
        int ch = h / 2;
        Color color = highlightColor = focused ? this.getFocusColor().brighter() : this.getHighlightColor();
        if (this.slider.isEnabled()) {
            g.setColor(focused ? this.getFocusColor() : this.getThumbColor());
        } else {
            g.setColor(this.getThumbColor().darker());
        }
        if (this.slider.getOrientation() == 0) {
            if (inverted) {
                this.paintThumbValueExclusive(g, i, w, h, focused, false);
            } else {
                for (int j = 0; j < cw; ++j) {
                    g.drawLine(cw - j, 1 + j, w - 1 - j, 1 + j);
                    g.drawLine(cw - j, h - 2 - j, w - 1 - j, h - 2 - j);
                }
                int d = 2 + cw % 4 / 2;
                for (int j = 0; j < cw - 1; j += 2) {
                    this.paintDrag(g, d + j, ch - 1 - j, cw - d, 2, highlightColor, MetalLookAndFeel.getControlDarkShadow());
                    this.paintDrag(g, d + j, ch - 1 + j, cw - d, 2, highlightColor, MetalLookAndFeel.getControlDarkShadow());
                }
                g.setColor(Color.black);
                g.drawLine(cw, 0, w - 2, 0);
                g.drawLine(cw, h - 1, w - 2, h - 1);
                g.drawLine(cw - 1, 1, 0, ch - 1);
                g.drawLine(cw - 1, h - 2, 0, ch);
                g.drawLine(w - 1, 1, cw + 1, ch - 1);
                g.drawLine(w - 1, h - 2, cw + 1, ch);
                g.setColor(highlightColor);
                g.drawLine(cw, 1, w - 2, 1);
                g.drawLine(cw, 1, 1, ch - 1);
                g.drawLine(cw, h - 2, 1, ch);
            }
        } else if (inverted) {
            this.paintThumbValueExclusive(g, i, w, h, focused, false);
        } else {
            for (int j = 0; j < cw; ++j) {
                g.drawLine(1 + j, 1 + j, 1 + j, ch + j);
                g.drawLine(w - 2 - j, 1 + j, w - 2 - j, ch + j);
            }
            int d = 2 + ch % 4 / 2;
            for (int j = 0; j < cw - 2; j += 2) {
                this.paintDrag(g, cw - 1 - j, ch + d - j, 2, ch - d, highlightColor, MetalLookAndFeel.getControlDarkShadow());
                this.paintDrag(g, cw - 1 + j, ch + d - j, 2, ch - d, highlightColor, MetalLookAndFeel.getControlDarkShadow());
            }
            g.setColor(Color.black);
            g.drawLine(0, 1, 0, ch);
            g.drawLine(w - 1, 1, w - 1, ch);
            g.drawLine(0, ch, cw - 1, h - 1);
            g.drawLine(cw, h - 1, w - 1, ch);
            g.drawLine(1, 0, cw - 1, ch - 1);
            g.drawLine(cw, ch - 1, w - 2, 0);
            g.setColor(highlightColor);
            g.drawLine(1, 1, 1, ch);
            g.drawLine(1, ch, cw - 1, h - 2);
            g.drawLine(1, 1, cw - 1, ch);
            g.drawLine(cw, ch, w - 2, 1);
        }
    }
}

