/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.ColorEditDialog;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class HueSatPanel
extends Panel
implements MouseListener,
MouseMotionListener {
    protected float currentHue = 0.0f;
    protected float currentSat = 0.0f;
    protected Image colorRampImage = null;
    protected Image offscreen = null;
    protected ColorEditDialog dialog = null;
    protected static final int DEFAULT_GRID_GRANULARITY = 3;
    protected int gridGranularity = 3;

    public HueSatPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public HueSatPanel(int granularity, ColorEditDialog d) {
        this();
        if (granularity > 0) {
            this.gridGranularity = granularity;
        }
        this.dialog = d;
    }

    @Override
    public void paint(Graphics g) {
        this.paintHueSatPanel(g);
    }

    @Override
    public void update(Graphics g) {
        this.paintHueSatPanel(g);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.recalcImage();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.recalcImage();
    }

    protected void recalcImage() {
        Rectangle bounds = this.getBounds();
        if (bounds != null && bounds.width > 0 && bounds.height > 0 && (this.colorRampImage == null || this.colorRampImage.getHeight(this) != bounds.height || this.colorRampImage.getWidth(this) != bounds.width)) {
            if (this.colorRampImage != null) {
                this.colorRampImage.flush();
            }
            this.colorRampImage = this.createImage(bounds.width, bounds.height);
            this.offscreen = this.createImage(bounds.width, bounds.height);
            if (this.colorRampImage == null) {
                return;
            }
            Graphics cig = this.colorRampImage.getGraphics();
            for (int i = 0; i < bounds.width; i += this.gridGranularity) {
                for (int j = 0; j < bounds.height; j += this.gridGranularity) {
                    float h = (float)((double)i / (double)bounds.width);
                    float s = 1.0f - (float)((double)j / (double)bounds.height);
                    float b = 1.0f - (float)((double)j / (double)bounds.height) / 2.0f;
                    cig.setColor(new Color(Color.HSBtoRGB(h, s, b)));
                    cig.fillRect(i, j, this.gridGranularity, this.gridGranularity);
                }
            }
        }
    }

    public void selectColorFromPanel(Point point) {
        Rectangle bounds = this.getBounds();
        float h = (float)point.x / (float)bounds.width;
        float s = 1.0f - (float)point.y / (float)bounds.height;
        h = Math.min(Math.max(0.0f, h), 1.0f);
        s = Math.min(Math.max(0.0f, s), 1.0f);
        this.internal_setHueSat(h, s);
        if (this.dialog != null) {
            this.dialog.setHueSat(h, s);
        }
    }

    protected void internal_setHueSat(float hue, float sat) {
        this.currentHue = hue;
        this.currentSat = sat;
        this.paintHueSatPanel();
    }

    protected void paintHueSatPanel() {
        Graphics g = this.getGraphics();
        if (g != null) {
            this.paintHueSatPanel(g);
            g.dispose();
        }
    }

    protected void paintHueSatPanel(Graphics g) {
        Rectangle bounds;
        if (this.colorRampImage != null && g != null && (bounds = this.getBounds()) != null) {
            g.drawImage(this.colorRampImage, 0, 0, this);
            g.setColor(Color.white);
            int x = (int)((double)(this.currentHue * (float)(bounds.width - 1)) + 0.5);
            int y = (int)((double)((1.0f - this.currentSat) * (float)(bounds.height - 1)) + 0.5);
            g.drawRect(x - 5, y - 5, 10, 10);
        }
    }

    public void setHueSat(float h, float s) {
        this.internal_setHueSat(h, s);
    }

    public void setBrightness(float b) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.selectColorFromPanel(e.getPoint());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.selectColorFromPanel(e.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

