/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.ColorNameTable;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;

public class HTMLColors
extends ColorNameTable {
    private static Hashtable colorTable = new Hashtable(41);
    private static HTMLColors table;

    public static HTMLColors getInstance() {
        return table;
    }

    protected HTMLColors() {
    }

    @Override
    public Color getColor(String name) {
        Color color = null;
        if (name != null && name.length() > 0 && (color = (Color)colorTable.get(name.toLowerCase())) == null) {
            color = super.getColor(name);
        }
        return color;
    }

    @Override
    public Enumeration getColorName() {
        return colorTable.keys();
    }

    @Override
    public Enumeration getColor() {
        return colorTable.elements();
    }

    @Override
    public boolean isNamedColor(String name) {
        return name != null && name.length() > 0 ? colorTable.containsKey(name.toLowerCase()) : false;
    }

    @Override
    public int size() {
        return colorTable.size();
    }

    public static String getColorString(Color c) {
        if (c == null) {
            return null;
        }
        int rgbValue = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        r = c.getRed();
        b = c.getBlue();
        g = c.getGreen();
        rgbValue = (r << 16) + (g << 8) + b;
        return "#" + Integer.toHexString(rgbValue).toUpperCase();
    }

    static {
        String name = "aliceblue";
        colorTable.put(name, new Color(240, 248, 255));
        name = "antiquewhite";
        colorTable.put(name, new Color(250, 235, 215));
        name = "aqua";
        colorTable.put(name, new Color(0, 255, 255));
        name = "aquamarine";
        colorTable.put(name, new Color(127, 255, 212));
        name = "azure";
        colorTable.put(name, new Color(240, 255, 255));
        name = "beige";
        colorTable.put(name, new Color(245, 245, 220));
        name = "bisque";
        colorTable.put(name, new Color(255, 228, 196));
        name = "black";
        colorTable.put(name, new Color(0, 0, 0));
        name = "blanchedalmond";
        colorTable.put(name, new Color(255, 235, 205));
        name = "blue";
        colorTable.put(name, new Color(0, 0, 255));
        name = "blueviolet";
        colorTable.put(name, new Color(138, 43, 226));
        name = "brown";
        colorTable.put(name, new Color(165, 42, 42));
        name = "burlywood";
        colorTable.put(name, new Color(222, 184, 135));
        name = "cadetblue";
        colorTable.put(name, new Color(95, 158, 160));
        name = "chartreuse";
        colorTable.put(name, new Color(127, 255, 0));
        name = "chocolate";
        colorTable.put(name, new Color(210, 105, 30));
        name = "coral";
        colorTable.put(name, new Color(255, 127, 80));
        name = "cornflowerblue";
        colorTable.put(name, new Color(100, 149, 237));
        name = "cornsilk";
        colorTable.put(name, new Color(255, 248, 220));
        name = "crimson";
        colorTable.put(name, new Color(220, 20, 60));
        name = "cyan";
        colorTable.put(name, new Color(0, 255, 255));
        name = "darkblue";
        colorTable.put(name, new Color(0, 0, 139));
        name = "darkcyan";
        colorTable.put(name, new Color(0, 139, 139));
        name = "darkgoldenrod";
        colorTable.put(name, new Color(184, 134, 11));
        name = "darkgray";
        colorTable.put(name, new Color(169, 169, 169));
        name = "darkgreen";
        colorTable.put(name, new Color(0, 100, 0));
        name = "darkkhaki";
        colorTable.put(name, new Color(189, 183, 107));
        name = "darkmagenta";
        colorTable.put(name, new Color(139, 0, 139));
        name = "darkolivegreen";
        colorTable.put(name, new Color(85, 107, 47));
        name = "darkorange";
        colorTable.put(name, new Color(255, 140, 0));
        name = "darkorchid";
        colorTable.put(name, new Color(153, 50, 204));
        name = "darkred";
        colorTable.put(name, new Color(139, 0, 0));
        name = "darksalmon";
        colorTable.put(name, new Color(233, 150, 122));
        name = "darkseagreen";
        colorTable.put(name, new Color(143, 188, 143));
        name = "darkslateblue";
        colorTable.put(name, new Color(72, 61, 139));
        name = "darkslategray";
        colorTable.put(name, new Color(47, 79, 79));
        name = "darkturquoise";
        colorTable.put(name, new Color(0, 206, 209));
        name = "darkviolet";
        colorTable.put(name, new Color(148, 0, 211));
        name = "deeppink";
        colorTable.put(name, new Color(255, 20, 147));
        name = "deepskyblue";
        colorTable.put(name, new Color(0, 191, 255));
        name = "dimgray";
        colorTable.put(name, new Color(105, 105, 105));
        name = "dodgerblue";
        colorTable.put(name, new Color(30, 144, 255));
        name = "firebrick";
        colorTable.put(name, new Color(178, 34, 34));
        name = "floralwhite";
        colorTable.put(name, new Color(255, 250, 240));
        name = "forestgreen";
        colorTable.put(name, new Color(34, 139, 34));
        name = "fuchsia";
        colorTable.put(name, new Color(255, 0, 255));
        name = "gainsboro";
        colorTable.put(name, new Color(220, 220, 220));
        name = "ghostwhite";
        colorTable.put(name, new Color(248, 248, 255));
        name = "gold";
        colorTable.put(name, new Color(255, 215, 0));
        name = "goldenrod";
        colorTable.put(name, new Color(218, 165, 32));
        name = "gray";
        colorTable.put(name, new Color(128, 128, 128));
        name = "green";
        colorTable.put(name, new Color(0, 128, 0));
        name = "greenyellow";
        colorTable.put(name, new Color(173, 255, 47));
        name = "honeydew";
        colorTable.put(name, new Color(240, 255, 240));
        name = "hotpink";
        colorTable.put(name, new Color(255, 105, 180));
        name = "indianred";
        colorTable.put(name, new Color(205, 92, 92));
        name = "indigo";
        colorTable.put(name, new Color(75, 0, 130));
        name = "ivory";
        colorTable.put(name, new Color(255, 255, 240));
        name = "khaki";
        colorTable.put(name, new Color(240, 230, 140));
        name = "lavender";
        colorTable.put(name, new Color(230, 230, 250));
        name = "lavenderblush";
        colorTable.put(name, new Color(255, 240, 245));
        name = "lawngreen";
        colorTable.put(name, new Color(124, 252, 0));
        name = "lemonchiffon";
        colorTable.put(name, new Color(255, 250, 205));
        name = "lightblue";
        colorTable.put(name, new Color(173, 216, 230));
        name = "lightcoral";
        colorTable.put(name, new Color(240, 128, 128));
        name = "lightcyan";
        colorTable.put(name, new Color(224, 255, 255));
        name = "lightgoldenrodyellow";
        colorTable.put(name, new Color(250, 250, 210));
        name = "lightgreen";
        colorTable.put(name, new Color(144, 238, 144));
        name = "lightgrey";
        colorTable.put(name, new Color(211, 211, 211));
        name = "lightpink";
        colorTable.put(name, new Color(255, 182, 193));
        name = "lightsalmon";
        colorTable.put(name, new Color(255, 160, 122));
        name = "lightseagreen";
        colorTable.put(name, new Color(32, 178, 170));
        name = "lightskyblue";
        colorTable.put(name, new Color(135, 206, 250));
        name = "lightslategray";
        colorTable.put(name, new Color(119, 136, 153));
        name = "lightsteelblue";
        colorTable.put(name, new Color(176, 196, 222));
        name = "lightyellow";
        colorTable.put(name, new Color(255, 255, 224));
        name = "lime";
        colorTable.put(name, new Color(0, 255, 0));
        name = "limegreen";
        colorTable.put(name, new Color(50, 205, 50));
        name = "linen";
        colorTable.put(name, new Color(250, 240, 230));
        name = "magenta";
        colorTable.put(name, new Color(255, 0, 255));
        name = "maroon";
        colorTable.put(name, new Color(128, 0, 0));
        name = "mediumblue";
        colorTable.put(name, new Color(0, 0, 205));
        name = "mediumorchid";
        colorTable.put(name, new Color(186, 85, 211));
        name = "mediumpurple";
        colorTable.put(name, new Color(147, 112, 219));
        name = "mediumseagreen";
        colorTable.put(name, new Color(60, 179, 113));
        name = "mediumslateblue";
        colorTable.put(name, new Color(123, 104, 238));
        name = "mediumspringgreen";
        colorTable.put(name, new Color(0, 250, 154));
        name = "mediumturquoise";
        colorTable.put(name, new Color(72, 209, 204));
        name = "mediumvioletred";
        colorTable.put(name, new Color(199, 21, 133));
        name = "mediumaquamarine";
        colorTable.put(name, new Color(102, 205, 170));
        name = "midnightblue";
        colorTable.put(name, new Color(25, 25, 112));
        name = "mintcream";
        colorTable.put(name, new Color(245, 255, 250));
        name = "mistyrose";
        colorTable.put(name, new Color(255, 228, 225));
        name = "moccasin";
        colorTable.put(name, new Color(255, 228, 181));
        name = "navajowhite";
        colorTable.put(name, new Color(255, 222, 173));
        name = "navy";
        colorTable.put(name, new Color(0, 0, 128));
        name = "oldlace";
        colorTable.put(name, new Color(253, 245, 230));
        name = "olive";
        colorTable.put(name, new Color(128, 128, 0));
        name = "olivedrab";
        colorTable.put(name, new Color(107, 142, 35));
        name = "orange";
        colorTable.put(name, new Color(255, 165, 0));
        name = "orangered";
        colorTable.put(name, new Color(255, 69, 0));
        name = "orchid";
        colorTable.put(name, new Color(218, 112, 214));
        name = "palegoldenrod";
        colorTable.put(name, new Color(238, 232, 170));
        name = "palegreen";
        colorTable.put(name, new Color(152, 251, 152));
        name = "paleturquoise";
        colorTable.put(name, new Color(175, 238, 238));
        name = "palevioletred";
        colorTable.put(name, new Color(219, 112, 147));
        name = "papayawhip";
        colorTable.put(name, new Color(255, 239, 213));
        name = "peachpuff";
        colorTable.put(name, new Color(255, 218, 185));
        name = "peru";
        colorTable.put(name, new Color(205, 133, 63));
        name = "pink";
        colorTable.put(name, new Color(255, 192, 203));
        name = "plum";
        colorTable.put(name, new Color(221, 160, 221));
        name = "powderblue";
        colorTable.put(name, new Color(176, 224, 230));
        name = "purple";
        colorTable.put(name, new Color(128, 0, 128));
        name = "red";
        colorTable.put(name, new Color(255, 0, 0));
        name = "rosybrown";
        colorTable.put(name, new Color(188, 143, 143));
        name = "royalblue";
        colorTable.put(name, new Color(65, 105, 225));
        name = "saddlebrown";
        colorTable.put(name, new Color(139, 69, 19));
        name = "salmon";
        colorTable.put(name, new Color(250, 128, 114));
        name = "sandybrown";
        colorTable.put(name, new Color(244, 164, 96));
        name = "seagreen";
        colorTable.put(name, new Color(46, 139, 87));
        name = "seashell";
        colorTable.put(name, new Color(255, 245, 238));
        name = "sienna";
        colorTable.put(name, new Color(160, 82, 45));
        name = "silver";
        colorTable.put(name, new Color(192, 192, 192));
        name = "skyblue";
        colorTable.put(name, new Color(135, 206, 235));
        name = "slateblue";
        colorTable.put(name, new Color(106, 90, 205));
        name = "slategray";
        colorTable.put(name, new Color(112, 128, 144));
        name = "snow";
        colorTable.put(name, new Color(255, 250, 250));
        name = "springgreen";
        colorTable.put(name, new Color(0, 255, 127));
        name = "steelblue";
        colorTable.put(name, new Color(70, 130, 180));
        name = "tan";
        colorTable.put(name, new Color(210, 180, 140));
        name = "teal";
        colorTable.put(name, new Color(0, 128, 128));
        name = "thistle";
        colorTable.put(name, new Color(216, 191, 216));
        name = "tomato";
        colorTable.put(name, new Color(255, 99, 71));
        name = "turquoise";
        colorTable.put(name, new Color(64, 224, 208));
        name = "violet";
        colorTable.put(name, new Color(238, 130, 238));
        name = "wheat";
        colorTable.put(name, new Color(245, 222, 179));
        name = "white";
        colorTable.put(name, new Color(255, 255, 255));
        name = "whitesmoke";
        colorTable.put(name, new Color(245, 245, 245));
        name = "yellow";
        colorTable.put(name, new Color(255, 255, 0));
        name = "yellowgreen";
        colorTable.put(name, new Color(154, 205, 50));
        table = new HTMLColors();
    }
}

