/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import java.lang.reflect.Method;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ComparatorFactory {
    private static Map comparatorCache = Collections.synchronizedMap(new HashMap());

    private ComparatorFactory() {
    }

    public static Comparator createComparator() {
        return ComparatorFactory.getComparatorInstance(Locale.getDefault(), false);
    }

    public static Comparator createComparator(Locale locale) {
        return ComparatorFactory.getComparatorInstance(locale, false);
    }

    public static Comparator createCaseInsensitiveComparator() {
        return ComparatorFactory.getComparatorInstance(Locale.getDefault(), true);
    }

    private static Comparator getComparatorInstance(Locale locale, boolean caseInsensitive) {
        Comparator c = null;
        c = ComparatorFactory.getCachedComparator(locale, caseInsensitive);
        if (c != null) {
            return c;
        }
        c = ComparatorFactory.loadSASComparator(locale, caseInsensitive);
        if (c == null && (c = locale == null ? Collator.getInstance() : Collator.getInstance(locale)) != null && caseInsensitive) {
            ((Collator)c).setStrength(0);
        }
        ComparatorFactory.cacheComparator(c, locale, caseInsensitive);
        return c;
    }

    private static Comparator getCachedComparator(Locale locale, boolean caseInsensitive) {
        Comparator result = null;
        Comparator[] compatorsByCaseSensitivity = (Comparator[])comparatorCache.get(locale);
        if (compatorsByCaseSensitivity != null) {
            result = compatorsByCaseSensitivity[ComparatorFactory.getComparatorIndex(caseInsensitive)];
        }
        return result;
    }

    private static int getComparatorIndex(boolean caseInsenstive) {
        return caseInsenstive ? 0 : 1;
    }

    private static void cacheComparator(Comparator comparator, Locale locale, boolean caseInsensitive) {
        Comparator[] compatorsByCaseSensitivity = (Comparator[])comparatorCache.get(locale);
        if (compatorsByCaseSensitivity == null) {
            compatorsByCaseSensitivity = new Comparator[2];
            comparatorCache.put(locale, compatorsByCaseSensitivity);
        }
        compatorsByCaseSensitivity[ComparatorFactory.getComparatorIndex((boolean)caseInsensitive)] = comparator;
    }

    private static Comparator loadSASComparator(Locale locale, boolean caseInsensitive) {
        try {
            Class<?> c = Class.forName("com.sas.nls.collator.SASCollatorFactory");
            if (c == null) {
                return null;
            }
            Method m = c.getDeclaredMethod("createCollator", Locale.class);
            Object sasCollator = m.invoke(null, locale);
            if (caseInsensitive) {
                Class<?> sasCollatorClass = Class.forName("com.sas.nls.collator.SASCollator");
                m = sasCollatorClass.getDeclaredMethod("setStrength", Integer.TYPE);
                m.invoke(sasCollator, sasCollatorClass.getField("PRIMARY").getInt(sasCollatorClass));
            }
            return (Comparator)sasCollator;
        }
        catch (Exception e) {
            return null;
        }
    }
}

