/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.BrightnessPanel;
import com.sas.graphics.util.HueSatPanel;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ColorEditDialog
extends Dialog
implements AdjustmentListener,
ItemListener,
ActionListener,
KeyListener,
WindowListener,
TextListener {
    protected float currentHue;
    protected float currentSat;
    protected float currentBrightness = 0.5f;
    protected int red;
    protected int green;
    protected int blue;
    protected Color oldColor;
    protected ResourceBundle rb = null;
    protected boolean cancelFlag = true;
    protected Dimension savedSize = null;
    protected boolean updatingSelf = false;
    protected boolean rgbFlag = false;
    protected boolean hsbFlag = false;
    protected String[] colorNames = new String[]{"Black", "Blue", "Cyan", "DarkGray", "Gray", "Green", "LightGray", "Magenta", "Orange", "Pink", "Red", "White", "Yellow"};
    protected Color[] colors = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    boolean fComponentsAdjusted = false;
    BrightnessPanel brightnessPanel;
    Button colorPanel;
    HueSatPanel hueSatPanel;
    Label label1;
    Label label2;
    Label label3;
    Label label4;
    Label label5;
    Label label6;
    Label label7;
    Scrollbar horizontalScrollbarHue;
    Label labelHue;
    Scrollbar horizontalScrollbarSat;
    Label labelSat;
    Scrollbar horizontalScrollbarBright;
    Label labelBright;
    Scrollbar horizontalScrollbarRed;
    Label labelRed;
    Scrollbar horizontalScrollbarGreen;
    Label labelGreen;
    Scrollbar horizontalScrollbarBlue;
    Label labelBlue;
    Choice choiceStandardColor;
    Label label8;
    Label label9;
    Button buttonOK;
    Button buttonCancel;
    Button buttonMore;

    public ColorEditDialog(ResourceBundle rbIn, Frame parent, boolean modal) {
        this(rbIn, parent, modal, -1, false);
        this.setTitle(this.GRS(this.rb, "ColorEditDialog.Title.txt", "Color"));
    }

    public ColorEditDialog(ResourceBundle rbIn, Frame parent, boolean modal, boolean useRBSizingIn) {
        this(rbIn, parent, modal, -1, false);
        this.setTitle(this.GRS(this.rb, "ColorEditDialog.Title.txt", "Color"));
    }

    public ColorEditDialog(ResourceBundle rbIn, Frame parent, String title, boolean modal) {
        this(rbIn, parent, modal, -1, false);
        this.setTitle(title);
    }

    public ColorEditDialog(ResourceBundle rbIn, Frame parent, String title, boolean modal, boolean useRBSizingIn) {
        this(rbIn, parent, modal, -1, false);
        this.setTitle(title);
    }

    public ColorEditDialog(ResourceBundle rbIn, Frame parent, String title, boolean modal, int colorGridGranularity) {
        this(rbIn, parent, modal, colorGridGranularity, false);
        this.setTitle(title);
    }

    public ColorEditDialog(ResourceBundle rbIn, Frame parent, String title, boolean modal, int colorGridGranularity, boolean useRBSizingIn) {
        this(rbIn, parent, modal, colorGridGranularity, false);
        this.setTitle(title);
    }

    public ColorEditDialog(ResourceBundle rbIn, Frame parent, boolean modal, int colorGridGranularity, boolean useRBSizingIn) {
        super(parent, modal);
        this.setBackground(SystemColor.control);
        this.setForeground(SystemColor.controlText);
        this.rb = rbIn;
        this.setLayout(null);
        this.setVisible(false);
        this.setSize(450, 190);
        this.brightnessPanel = new BrightnessPanel(this);
        this.brightnessPanel.setLayout(null);
        this.brightnessPanel.setBounds(180, 20, 20, 150);
        this.add(this.brightnessPanel);
        this.colorPanel = new Button();
        this.colorPanel.setEnabled(false);
        this.colorPanel.setBounds(218, 68, 114, 100);
        this.colorPanel.setBackground(new Color(0));
        this.add(this.colorPanel);
        this.hueSatPanel = new HueSatPanel(colorGridGranularity, this);
        this.hueSatPanel.setLayout(null);
        this.hueSatPanel.setBounds(5, 20, 167, 150);
        this.add(this.hueSatPanel);
        this.label1 = new Label(this.GRS(this.rb, "ColorEditDialog.Red.txt", "Red") + ":");
        this.label1.setBounds(240, 196, 70, 16);
        this.add(this.label1);
        this.label2 = new Label(this.GRS(this.rb, "ColorEditDialog.Green.txt", "Green") + ":");
        this.label2.setBounds(240, 225, 70, 16);
        this.add(this.label2);
        this.label3 = new Label(this.GRS(this.rb, "ColorEditDialog.Blue.txt", "Blue") + ":");
        this.label3.setBounds(240, 254, 70, 16);
        this.add(this.label3);
        this.label4 = new Label(this.GRS(this.rb, "ColorEditDialog.Hue.txt", "Hue") + ":");
        this.label4.setBounds(5, 196, 80, 16);
        this.add(this.label4);
        this.label5 = new Label(this.GRS(this.rb, "ColorEditDialog.Saturation.txt", "Saturation") + ":");
        this.label5.setBounds(5, 225, 80, 16);
        this.add(this.label5);
        this.label6 = new Label(this.GRS(this.rb, "ColorEditDialog.Brightness.txt", "Brightness") + ":");
        this.label6.setBounds(5, 254, 80, 16);
        this.add(this.label6);
        this.label7 = new Label(this.GRS(this.rb, "ColorEditDialog.Preview.txt", "Preview") + ":", 0);
        this.label7.setBounds(218, 52, 100, 16);
        this.add(this.label7);
        this.horizontalScrollbarHue = new Scrollbar(0, 0, 1, 0, 256);
        this.horizontalScrollbarHue.setBounds(142, 194, 75, 20);
        this.add(this.horizontalScrollbarHue);
        this.labelHue = new Label(" ");
        this.labelHue.setBounds(100, 190, 40, 28);
        this.add(this.labelHue);
        this.horizontalScrollbarSat = new Scrollbar(0, 0, 1, 0, 256);
        this.horizontalScrollbarSat.setBounds(142, 223, 75, 20);
        this.add(this.horizontalScrollbarSat);
        this.labelSat = new Label(" ");
        this.labelSat.setBounds(100, 219, 40, 28);
        this.add(this.labelSat);
        this.horizontalScrollbarBright = new Scrollbar(0, 0, 1, 0, 256);
        this.horizontalScrollbarBright.setBounds(142, 252, 75, 20);
        this.add(this.horizontalScrollbarBright);
        this.labelBright = new Label(" ");
        this.labelBright.setBounds(100, 248, 40, 28);
        this.add(this.labelBright);
        this.horizontalScrollbarRed = new Scrollbar(0, 0, 1, 0, 256);
        this.horizontalScrollbarRed.setBounds(355, 194, 75, 20);
        this.add(this.horizontalScrollbarRed);
        this.labelRed = new Label(" ");
        this.labelRed.setBounds(314, 190, 40, 28);
        this.add(this.labelRed);
        this.horizontalScrollbarGreen = new Scrollbar(0, 0, 1, 0, 256);
        this.horizontalScrollbarGreen.setBounds(355, 223, 75, 20);
        this.add(this.horizontalScrollbarGreen);
        this.labelGreen = new Label(" ");
        this.labelGreen.setBounds(314, 219, 40, 28);
        this.add(this.labelGreen);
        this.horizontalScrollbarBlue = new Scrollbar(0, 0, 1, 0, 256);
        this.horizontalScrollbarBlue.setBounds(355, 252, 75, 20);
        this.add(this.horizontalScrollbarBlue);
        this.labelBlue = new Label(" ");
        this.labelBlue.setBounds(314, 248, 40, 28);
        this.add(this.labelBlue);
        this.choiceStandardColor = new Choice();
        this.updateColorNames();
        this.add(this.choiceStandardColor);
        this.choiceStandardColor.setBounds(218, 20, 114, 27);
        this.label8 = new Label(this.GRS(this.rb, "ColorEditDialog.Custom.txt", "Custom") + ":", 0);
        this.label8.setBounds(5, 5, 167, 14);
        this.add(this.label8);
        this.label9 = new Label(this.GRS(this.rb, "ColorEditDialog.Standard.txt", "Standard") + ":", 0);
        this.label9.setBounds(218, 5, 114, 14);
        this.add(this.label9);
        this.buttonOK = new Button();
        this.buttonOK.setLabel(this.GRS(this.rb, "ColorEditDialog.OK.txt", "OK"));
        this.buttonOK.setBounds(355, 20, 80, 20);
        this.add(this.buttonOK);
        this.buttonCancel = new Button();
        this.buttonCancel.setLabel(this.GRS(this.rb, "ColorEditDialog.Cancel.txt", "Cancel"));
        this.buttonCancel.setBounds(355, 44, 80, 20);
        this.add(this.buttonCancel);
        this.buttonMore = new Button();
        this.buttonMore.setLabel(this.GRS(this.rb, "ColorEditDialog.More.txt", "More") + "...");
        this.buttonMore.setBounds(355, 148, 80, 20);
        this.add(this.buttonMore);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.addWindowListener(this);
        this.horizontalScrollbarHue.addAdjustmentListener(this);
        this.horizontalScrollbarSat.addAdjustmentListener(this);
        this.horizontalScrollbarBright.addAdjustmentListener(this);
        this.horizontalScrollbarRed.addAdjustmentListener(this);
        this.horizontalScrollbarGreen.addAdjustmentListener(this);
        this.horizontalScrollbarBlue.addAdjustmentListener(this);
        this.choiceStandardColor.addItemListener(this);
        this.buttonOK.addActionListener(this);
        this.buttonCancel.addActionListener(this);
        this.buttonMore.addActionListener(this);
        this.resetText();
        this.enableMore(false);
    }

    protected void addListeners() {
        this.horizontalScrollbarHue.addAdjustmentListener(this);
        this.horizontalScrollbarSat.addAdjustmentListener(this);
        this.horizontalScrollbarBright.addAdjustmentListener(this);
        this.horizontalScrollbarRed.addAdjustmentListener(this);
        this.horizontalScrollbarGreen.addAdjustmentListener(this);
        this.horizontalScrollbarBlue.addAdjustmentListener(this);
    }

    public void resetTitle() {
        this.setTitle(this.GRS(this.rb, "ColorEditDialog.Title.txt", "Color"));
    }

    protected void removeListeners() {
        this.horizontalScrollbarHue.removeAdjustmentListener(this);
        this.horizontalScrollbarSat.removeAdjustmentListener(this);
        this.horizontalScrollbarBright.removeAdjustmentListener(this);
        this.horizontalScrollbarRed.removeAdjustmentListener(this);
        this.horizontalScrollbarGreen.removeAdjustmentListener(this);
        this.horizontalScrollbarBlue.removeAdjustmentListener(this);
    }

    protected String GRS(ResourceBundle rb, String name, String defStrg) {
        String s = null;
        if (name == null) {
            return defStrg;
        }
        try {
            if (rb != null) {
                s = rb.getString(name);
            }
        }
        catch (MissingResourceException e) {
            System.err.println("Resource '" + name + "' not found. Using default value.");
            System.err.flush();
            s = null;
        }
        if (s == null) {
            s = defStrg;
        }
        return s;
    }

    protected void updateColorNames() {
        this.choiceStandardColor.removeAll();
        for (int i = 0; i < this.colorNames.length; ++i) {
            if (this.colors[i] == null || this.colorNames[i] == null) continue;
            this.choiceStandardColor.addItem(this.colorNames[i]);
        }
        try {
            this.choiceStandardColor.select(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.choiceStandardColor.addItem(" ");
    }

    public void setColors(String[] s, Color[] c) {
        if (s != null && c != null && s.length == c.length) {
            this.colorNames = s;
            this.colors = c;
            this.updateColorNames();
        }
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
        this.savedSize = this.getSize();
    }

    @Override
    public synchronized void show() {
        this.cancelFlag = true;
        super.show();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
        }
        super.setVisible(b);
    }

    void ColorEditDialog_WindowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    @Override
    public void paint(Graphics g) {
        this.colorPanel.setBackground(Color.getHSBColor(this.currentHue, this.currentSat, this.currentBrightness));
        super.paint(g);
    }

    public void setHueSat(float h, float s) {
        this.currentHue = h;
        this.currentSat = s;
        this.brightnessPanel.setHueSat(this.currentHue, this.currentSat);
        this.resetRGBFromHSB();
        if (!this.buttonMore.isEnabled()) {
            this.resetScrollbars();
            this.resetText();
        }
        this.repaint();
    }

    public void setBrightness(float b) {
        this.currentBrightness = b;
        this.resetRGBFromHSB();
        if (!this.buttonMore.isEnabled()) {
            this.resetScrollbars();
            this.resetText();
        }
        this.repaint();
    }

    public void setHueSatBrightness(float h, float s, float b) {
        this.currentHue = h;
        this.currentSat = s;
        this.currentBrightness = b;
        this.brightnessPanel.setHueSatBrightness(this.currentHue, this.currentSat, this.currentBrightness);
        this.hueSatPanel.setHueSat(this.currentHue, this.currentSat);
        this.resetRGBFromHSB();
        if (!this.buttonMore.isEnabled()) {
            this.resetScrollbars();
            this.resetText();
        }
        this.repaint();
    }

    protected void resetRGBFromHSB() {
        Color rgbVal = Color.getHSBColor(this.currentHue, this.currentSat, this.currentBrightness);
        this.red = rgbVal.getRed();
        this.green = rgbVal.getGreen();
        this.blue = rgbVal.getBlue();
    }

    protected void resetHSBFromRGB() {
        float[] vals = new float[3];
        Color.RGBtoHSB(this.red, this.green, this.blue, vals);
        this.currentHue = vals[0];
        this.currentSat = vals[1];
        this.currentBrightness = vals[2];
    }

    protected void resetHSBText() {
        this.labelHue.setText(Integer.toString((int)(this.currentHue * 255.0f)));
        this.labelSat.setText(Integer.toString((int)(this.currentSat * 255.0f)));
        this.labelBright.setText(Integer.toString((int)(this.currentBrightness * 255.0f)));
    }

    protected void resetRGBText() {
        this.labelRed.setText(Integer.toString(this.red));
        this.labelGreen.setText(Integer.toString(this.green));
        this.labelBlue.setText(Integer.toString(this.blue));
    }

    protected void resetHex() {
    }

    protected void resetText() {
        this.resetHSBText();
        this.resetRGBText();
        this.resetHex();
    }

    protected void resetHSBScrollbars() {
        this.horizontalScrollbarHue.setValue((int)(this.currentHue * 255.0f));
        this.horizontalScrollbarSat.setValue((int)(this.currentSat * 255.0f));
        this.horizontalScrollbarBright.setValue((int)(this.currentBrightness * 255.0f));
    }

    protected void resetRGBScrollbars() {
        this.horizontalScrollbarRed.setValue(this.red);
        this.horizontalScrollbarGreen.setValue(this.green);
        this.horizontalScrollbarBlue.setValue(this.blue);
    }

    protected void resetScrollbars() {
        this.resetHSBScrollbars();
        this.resetRGBScrollbars();
    }

    protected void resetRGB() {
        this.resetRGBText();
        this.resetRGBScrollbars();
    }

    protected void resetHSB() {
        this.resetHSBText();
        this.resetHSBScrollbars();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent event) {
        Object object = event.getSource();
        if (object == this.horizontalScrollbarHue) {
            this.currentHue = (float)event.getValue() / 255.0f;
            this.labelHue.setText(Integer.toString(event.getValue()));
            this.brightnessPanel.setHueSat(this.currentHue, this.currentSat);
            this.hueSatPanel.setHueSat(this.currentHue, this.currentSat);
            this.resetRGBFromHSB();
            this.resetRGB();
            this.resetHex();
        } else if (object == this.horizontalScrollbarSat) {
            this.currentSat = (float)event.getValue() / 255.0f;
            this.labelSat.setText(Integer.toString(event.getValue()));
            this.brightnessPanel.setHueSat(this.currentHue, this.currentSat);
            this.hueSatPanel.setHueSat(this.currentHue, this.currentSat);
            this.resetRGBFromHSB();
            this.resetRGB();
            this.resetHex();
        } else if (object == this.horizontalScrollbarBright) {
            this.labelBright.setText(Integer.toString(event.getValue()));
            this.currentBrightness = (float)event.getValue() / 255.0f;
            this.brightnessPanel.setBrightness(this.currentBrightness);
            this.resetRGBFromHSB();
            this.resetRGB();
            this.resetHex();
        } else if (object == this.horizontalScrollbarRed) {
            this.labelRed.setText(Integer.toString(event.getValue()));
            this.red = event.getValue();
            this.resetHSBFromRGB();
            this.brightnessPanel.setHueSatBrightness(this.currentHue, this.currentSat, this.currentBrightness);
            this.hueSatPanel.setHueSat(this.currentHue, this.currentSat);
            this.resetHSB();
            this.resetHex();
        } else if (object == this.horizontalScrollbarGreen) {
            this.labelGreen.setText(Integer.toString(event.getValue()));
            this.green = event.getValue();
            this.resetHSBFromRGB();
            this.brightnessPanel.setHueSatBrightness(this.currentHue, this.currentSat, this.currentBrightness);
            this.hueSatPanel.setHueSat(this.currentHue, this.currentSat);
            this.resetHSB();
            this.resetHex();
        } else if (object == this.horizontalScrollbarBlue) {
            this.labelBlue.setText(Integer.toString(event.getValue()));
            this.blue = event.getValue();
            this.resetHSBFromRGB();
            this.brightnessPanel.setHueSatBrightness(this.currentHue, this.currentSat, this.currentBrightness);
            this.hueSatPanel.setHueSat(this.currentHue, this.currentSat);
            this.resetHSB();
            this.resetHex();
        }
        this.repaint();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() != this.choiceStandardColor || this.choiceStandardColor.getSelectedIndex() == this.choiceStandardColor.getItemCount() - 1) {
            return;
        }
        float[] vals = new float[3];
        Color newColor = this.colors[this.choiceStandardColor.getSelectedIndex()];
        Color.RGBtoHSB(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), vals);
        this.currentHue = vals[0];
        this.currentSat = vals[1];
        this.currentBrightness = vals[2];
        this.red = newColor.getRed();
        this.green = newColor.getGreen();
        this.blue = newColor.getBlue();
        this.brightnessPanel.setHueSatBrightness(this.currentHue, this.currentSat, this.currentBrightness);
        this.hueSatPanel.setHueSat(this.currentHue, this.currentSat);
        if (!this.buttonMore.isEnabled()) {
            this.resetHSB();
            this.resetRGB();
            this.resetHex();
        }
        this.repaint();
    }

    public Color getColor() {
        return new Color(this.red, this.green, this.blue);
    }

    public void setColor(Color newColor) {
        this.oldColor = newColor;
        float[] vals = new float[3];
        Color.RGBtoHSB(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), vals);
        this.currentHue = vals[0];
        this.currentSat = vals[1];
        this.currentBrightness = vals[2];
        this.red = newColor.getRed();
        this.green = newColor.getGreen();
        this.blue = newColor.getBlue();
        this.brightnessPanel.setHueSatBrightness(this.currentHue, this.currentSat, this.currentBrightness);
        this.hueSatPanel.setHueSat(this.currentHue, this.currentSat);
        this.setStandardColor();
        this.resetHSB();
        this.resetRGB();
        this.resetHex();
        this.repaint();
    }

    public void setStandardColor() {
        for (int i = 0; i < this.colors.length; ++i) {
            if (!this.oldColor.equals(this.colors[i])) continue;
            this.choiceStandardColor.select(i);
            return;
        }
        this.choiceStandardColor.select(" ");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        if (object == this.buttonOK) {
            this.cancelFlag = false;
            this.setSize(this.savedSize);
            this.buttonMore.setEnabled(true);
            this.enableMore(false);
            this.setVisible(false);
        } else if (object == this.buttonCancel) {
            this.cancelFlag = true;
            this.setColor(this.oldColor);
            this.setSize(this.savedSize);
            this.buttonMore.setEnabled(true);
            this.enableMore(false);
            this.setVisible(false);
        } else if (object == this.buttonMore) {
            this.buttonMore.setEnabled(false);
            this.enableMore(true);
            this.resetScrollbars();
            this.resetText();
            this.setSize(this.savedSize.width, 360);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void updateTextValues(KeyEvent e) {
    }

    public boolean getCancelFlag() {
        return this.cancelFlag;
    }

    protected Color getColorFromText(String text) {
        Color color = Color.black;
        if (text.equals("Black")) {
            color = Color.black;
        } else if (text.equals("Blue")) {
            color = Color.blue;
        } else if (text.equals("Cyan")) {
            color = Color.cyan;
        } else if (text.equals("DarkGray")) {
            color = Color.darkGray;
        } else if (text.equals("Gray")) {
            color = Color.gray;
        } else if (text.equals("Green")) {
            color = Color.green;
        } else if (text.equals("LightGray")) {
            color = Color.lightGray;
        } else if (text.equals("Magenta")) {
            color = Color.magenta;
        } else if (text.equals("Orange")) {
            color = Color.orange;
        } else if (text.equals("Pink")) {
            color = Color.pink;
        } else if (text.equals("Red")) {
            color = Color.red;
        } else if (text.equals("White")) {
            color = Color.white;
        } else if (text.equals("Yellow")) {
            color = Color.yellow;
        }
        return color;
    }

    public void redrawRepresentation() {
        this.colorPanel.setBackground(Color.getHSBColor(this.currentHue, this.currentSat, this.currentBrightness));
        this.colorPanel.repaint();
    }

    protected void enableMore(boolean val) {
        this.labelRed.setVisible(val);
        this.labelGreen.setVisible(val);
        this.labelBlue.setVisible(val);
        this.labelHue.setVisible(val);
        this.labelSat.setVisible(val);
        this.labelBright.setVisible(val);
        this.horizontalScrollbarRed.setVisible(val);
        this.horizontalScrollbarGreen.setVisible(val);
        this.horizontalScrollbarBlue.setVisible(val);
        this.horizontalScrollbarHue.setVisible(val);
        this.horizontalScrollbarSat.setVisible(val);
        this.horizontalScrollbarBright.setVisible(val);
        this.label1.setVisible(val);
        this.label2.setVisible(val);
        this.label3.setVisible(val);
        this.label4.setVisible(val);
        this.label5.setVisible(val);
        this.label6.setVisible(val);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.cancelFlag) {
            this.setColor(this.oldColor);
            this.setSize(this.savedSize);
            this.buttonMore.setEnabled(true);
            this.enableMore(false);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void textValueChanged(TextEvent e) {
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == ColorEditDialog.this) {
                ColorEditDialog.this.setSize(ColorEditDialog.this.savedSize);
                ColorEditDialog.this.buttonMore.setEnabled(true);
                ColorEditDialog.this.enableMore(false);
                ColorEditDialog.this.ColorEditDialog_WindowClosing(event);
            }
        }
    }
}

