/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util;

import com.sas.graphics.util.SASIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class AboutFrame
extends Frame
implements WindowListener {
    protected boolean useRBSizing = true;
    protected int imgWidth = 0;
    protected int imgHeight = 0;
    protected int width = 350;
    protected int height = 500;
    protected String titleText = null;
    protected String copyrightText = null;
    protected String sasText = null;
    protected String locationText = null;
    protected String rightsText = null;
    protected String bldstrg = null;
    protected String text6 = null;
    protected String text7 = null;
    protected String text8 = null;
    protected String text9 = null;
    protected String text10 = null;
    protected String text11 = null;
    protected String text12 = null;
    protected String text13 = null;
    protected String text14 = null;
    protected String text15 = null;
    protected String text16 = null;
    protected String text17 = null;
    protected String text18 = null;
    SASIcon icon = null;
    ResourceBundle rb = null;

    public AboutFrame(Object rbIn, SASIcon iconIn, String title, String version, String buildDate, boolean useRBSizingIn) {
        super(title);
        Rectangle r = null;
        this.useRBSizing = useRBSizingIn;
        this.rb = rbIn != null && rbIn instanceof ResourceBundle ? (ResourceBundle)rbIn : null;
        this.titleText = title == null ? this.GRS(this.rb, "AboutDialog.TitleText.txt", "SAS(R) 9.1 Java Applet") : title;
        this.bldstrg = this.GRS(this.rb, "AboutDialog.BuildPrefix.txt", "Build");
        if (buildDate != null) {
            this.bldstrg = this.bldstrg.trim() + " " + buildDate.trim();
        }
        this.copyrightText = this.GRS(this.rb, "AboutDialog.CopyrightText.txt", "Copyright (c) 1998-2003");
        this.sasText = this.GRS(this.rb, "AboutDialog.SASText.txt", "SAS Institute Inc.");
        this.locationText = this.GRS(this.rb, "AboutDialog.LocationText.txt", "Cary, NC, USA");
        this.rightsText = this.GRS(this.rb, "AboutDialog.RightsText.txt", "All rights reserved");
        this.text6 = this.GRS(this.rb, "AboutDialog.Text6.txt", "This software is protected by copyright laws and");
        this.text7 = this.GRS(this.rb, "AboutDialog.Text7.txt", "international treaties.");
        this.text8 = this.GRS(this.rb, "AboutDialog.Text8.txt", "This software is being provided \"AS IS\" without");
        this.text9 = this.GRS(this.rb, "AboutDialog.Text9.txt", "any express or implied warranties. SAS Institute Inc.");
        this.text10 = this.GRS(this.rb, "AboutDialog.Text10.txt", "is not liable for any damages caused by the use of this");
        this.text11 = this.GRS(this.rb, "AboutDialog.Text11.txt", "software. This software may not be exported or reexported");
        this.text12 = this.GRS(this.rb, "AboutDialog.Text12.txt", "except in compliance with all US export laws.");
        this.text13 = this.GRS(this.rb, "AboutDialog.Text13.txt", "U.S. GOVERNMENT RESTRICTED RIGHTS");
        this.text14 = this.GRS(this.rb, "AboutDialog.Text14.txt", "Use, duplication, or disclosure of this software and related");
        this.text15 = this.GRS(this.rb, "AboutDialog.Text15.txt", "documentation by the U.S. government is subject to the");
        this.text16 = this.GRS(this.rb, "AboutDialog.Text16.txt", "Agreement with SAS Institute and the restrictions set forth");
        this.text17 = this.GRS(this.rb, "AboutDialog.Text17.txt", "in FAR 52.227-19, Commercial Computer Software");
        this.text18 = this.GRS(this.rb, "AboutDialog.Text18.txt", "- Restricted Rights (June 1987).");
        this.addWindowListener(this);
        r = this.getRBBounds(this.rb, "AboutDialog.size", 1, 1, this.width, this.height);
        if (r != null) {
            this.width = r.width;
            this.height = r.height;
        }
        this.setSize(this.width, this.height);
        this.setResizable(false);
        this.icon = iconIn;
        if (this.icon != null) {
            this.imgWidth = this.icon.getWidth();
            this.imgHeight = this.icon.getHeight();
        }
    }

    public AboutFrame(Object rbIn, SASIcon iconIn, String title, String version, boolean useRBSizingIn) {
        this(rbIn, iconIn, title, version, "0000.0000", true);
    }

    public AboutFrame(Object rbIn, SASIcon iconIn, String title, String version) {
        this(rbIn, iconIn, title, version, true);
    }

    protected Rectangle getRBBounds(ResourceBundle rb, String name, int x, int y, int width, int height) {
        String s = this.GRS(rb, name, null);
        Rectangle rect = new Rectangle(x, y, width, height);
        if (s == null || rect == null || !this.useRBSizing) {
            return rect;
        }
        try {
            int i;
            if (name.endsWith(".bounds")) {
                i = s.indexOf(",");
                rect.x = Integer.valueOf(s.substring(0, i));
                if (rect.x == -1) {
                    rect.x = x;
                }
                s = s.substring(i + 1);
                i = s.indexOf(",");
                rect.y = Integer.valueOf(s.substring(0, i));
                if (rect.y == -1) {
                    rect.y = y;
                }
                s = s.substring(i + 1);
            }
            i = s.indexOf(",");
            rect.width = Integer.valueOf(s.substring(0, i));
            if (rect.width == -1) {
                rect.width = width;
            }
            s = s.substring(i + 1);
            rect.height = Integer.valueOf(s);
            if (rect.height == -1) {
                rect.height = height;
            }
        }
        catch (NumberFormatException e) {
            rect.x = x;
            rect.y = y;
            rect.width = width;
            rect.height = height;
        }
        return rect;
    }

    protected String GRS(ResourceBundle rb, String name, String defStrg) {
        String s = null;
        if (name == null) {
            return defStrg;
        }
        try {
            if (rb != null) {
                s = rb.getString(name);
            }
        }
        catch (MissingResourceException e) {
            s = null;
        }
        if (s == null) {
            s = defStrg;
        }
        return s;
    }

    @Override
    public void paint(Graphics g) {
        int x = 0;
        int curWidth = this.width;
        int curHeight = this.height;
        FontMetrics fm = g.getFontMetrics();
        Color c = null;
        Color bColor = null;
        Color fColor = null;
        int maxDescent = fm.getMaxDescent();
        int maxAscent = fm.getMaxAscent();
        Dimension d = this.getSize();
        curWidth = d.width;
        curHeight = d.height;
        bColor = this.getBackground();
        fColor = g.getColor();
        if (bColor != null && bColor.equals(fColor)) {
            c = bColor.equals(Color.black) ? Color.white : (bColor.equals(Color.white) ? Color.black : fColor.brighter().brighter());
            g.setColor(c);
        }
        g.clearRect(0, 0, curWidth, curHeight);
        x = curWidth / 2 - this.imgWidth / 2;
        int y = curHeight / 3 - this.imgHeight / 2;
        if (this.icon != null) {
            this.icon.DrawIcon(this, g, x, y);
        }
        int strgWidth = fm.stringWidth(this.titleText);
        x = (curWidth - strgWidth) / 2;
        y = y - 6 * maxDescent - 6 * maxAscent;
        g.drawString(this.titleText, x, y);
        strgWidth = fm.stringWidth(this.copyrightText);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.copyrightText, x, y += maxDescent + maxAscent);
        strgWidth = fm.stringWidth(this.sasText);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.sasText, x, y += maxDescent + maxAscent);
        strgWidth = fm.stringWidth(this.locationText);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.locationText, x, y += maxDescent + maxAscent);
        strgWidth = fm.stringWidth(this.rightsText);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.rightsText, x, y += maxDescent + maxAscent);
        strgWidth = fm.stringWidth(this.bldstrg);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.bldstrg, x, y += maxDescent + maxAscent);
        y = curHeight / 3 - this.imgHeight / 2 + this.imgHeight;
        strgWidth = fm.stringWidth(this.text6);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.text6, x, y += 2 * maxDescent + 2 * maxAscent);
        strgWidth = fm.stringWidth(this.text7);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.text7, x, y += maxDescent + maxAscent);
        strgWidth = fm.stringWidth(this.text8);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.text8, x, y += maxDescent * 2 + maxAscent * 2);
        strgWidth = fm.stringWidth(this.text9);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.text9, x, y += maxDescent + maxAscent);
        strgWidth = fm.stringWidth(this.text10);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.text10, x, y += maxDescent + maxAscent);
        strgWidth = fm.stringWidth(this.text11);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.text11, x, y += maxDescent + maxAscent);
        strgWidth = fm.stringWidth(this.text12);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.text12, x, y += maxDescent + maxAscent);
        strgWidth = fm.stringWidth(this.text13);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.text13, x, y += maxDescent * 2 + maxAscent * 2);
        strgWidth = fm.stringWidth(this.text14);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.text14, x, y += maxDescent + maxAscent);
        strgWidth = fm.stringWidth(this.text15);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.text15, x, y += maxDescent + maxAscent);
        strgWidth = fm.stringWidth(this.text16);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.text16, x, y += maxDescent + maxAscent);
        strgWidth = fm.stringWidth(this.text17);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.text17, x, y += maxDescent + maxAscent);
        strgWidth = fm.stringWidth(this.text18);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.text18, x, y += maxDescent + maxAscent);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }
}

